/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_DATATYPE_H_
#define _GB2_DATATYPE_H_

#include <workflow/Descriptor.h>
#include <QtCore/QExplicitlySharedDataPointer>

namespace GB2 {

class DataType;
typedef QExplicitlySharedDataPointer<DataType> DataTypePtr;

class WCOREAPI_EXPORT DataType : public Descriptor, public QSharedData {
public:
    enum Kind {
        Single,
        List,
        Map
    };
    DataType(const QString& id, const QString& name, const QString& desc): Descriptor(id, name, desc) {}
    DataType(const Descriptor& d) : Descriptor(d) {}
    //virtual bool equals(DataTypePtr t) const {return t == this;}
    virtual Kind kind() const {return Single;}
    virtual ~DataType() {}

    inline bool isSingle() const {return kind() == Single;}
    inline bool isMap() const {return kind() == Map;}
    inline bool isList() const {return kind() == List;}

    virtual DataTypePtr getElement(const Descriptor& idd=Descriptor(QString())) const { Q_UNUSED(idd); return DataTypePtr();}
    virtual QList<Descriptor> getElements() const {return QList<Descriptor>();}
    virtual QMap<Descriptor, DataTypePtr> getElementsMap() const {return QMap<Descriptor, DataTypePtr>();}
    Descriptor getElementDescriptor(const QString& id) const {
        QList<Descriptor> lst = getElements();
        int idx = lst.indexOf(id);
        return idx == -1 ? "" : lst.at(idx);
    }
};

class DataTypeRegistry {
public:
    virtual DataTypePtr getById(const QString& id) {return registry.value(id);}
    virtual bool registerEntry(DataTypePtr t) {
        if (registry.contains(t->getId())) {
            return false;
        } else {
            registry.insert(t->getId(), t);
            return true;
        } 
    }
    virtual DataTypePtr unregisterEntry(const QString& id) {return registry.take(id);}

    virtual QList<DataTypePtr> getAllEntries() const {return registry.values();}
    virtual QList<QString> getAllIds() const {return registry.uniqueKeys();}

    virtual ~DataTypeRegistry() {registry.clear();}

protected:
    QMap<QString, DataTypePtr> registry;
};

} //namespace
#endif
