/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_WORKFLOW_URL_H_
#define _GB2_WORKFLOW_URL_H_

#include <workflow/ConfigurationEditor.h>

#include <QtCore/QModelIndex>
#include <QtGui/QLineEdit>

namespace GB2 {

class WCOREAPI_EXPORT DelegateEditor : public ConfigurationEditor {
public:
    DelegateEditor(const QMap<QString, PropertyDelegate*>& map) : delegates(map) {}
    DelegateEditor(const QString& s, PropertyDelegate* d) {delegates.insert(s,d);}
    virtual ~DelegateEditor() {qDeleteAll(delegates.values());}
    virtual PropertyDelegate* getDelegate(const QString& name) {return delegates.value(name);}
    virtual void commit() {}
protected:
    QMap<QString, PropertyDelegate*> delegates;
};

class WCOREAPI_EXPORT URLLineEdit : public QLineEdit {
    Q_OBJECT
public:
    URLLineEdit(const QString& filter, const QString& type, bool multi, QWidget *parent) 
        : QLineEdit(parent), FileFilter(filter), type(type), multi(multi) {}
private slots:
    void sl_onBrowse();
private:
    QString FileFilter;
    QString type;
    bool    multi;
};

class WCOREAPI_EXPORT URLDelegate : public PropertyDelegate {
    
public:
    URLDelegate(const QString& filter, const QString& type, bool multi = false, QObject *parent = 0) 
        : PropertyDelegate(parent), FileFilter(filter), type(type), multi(multi) {}
    virtual ~URLDelegate() {}

    QWidget *createEditor(QWidget *parent, const QStyleOptionViewItem &option,
        const QModelIndex &index) const;

    void setEditorData(QWidget *editor, const QModelIndex &index) const;
    void setModelData(QWidget *editor, QAbstractItemModel *model,
        const QModelIndex &index) const;

protected:
    QString FileFilter;
    QString type;
    bool    multi;
};

class WCOREAPI_EXPORT SpinBoxDelegate : public PropertyDelegate {
public:
    SpinBoxDelegate(const QVariantMap& props = QVariantMap(), QObject *parent = 0) : 
      PropertyDelegate(parent), spinProperties(props) {}
    virtual ~SpinBoxDelegate() {}

    QWidget *createEditor(QWidget *parent, const QStyleOptionViewItem &option,
        const QModelIndex &index) const;

    void setEditorData(QWidget *editor, const QModelIndex &index) const;
    void setModelData(QWidget *editor, QAbstractItemModel *model,
        const QModelIndex &index) const;
    QVariant getDisplayValue(const QVariant&) const;

private:
    QVariantMap spinProperties;
};

class WCOREAPI_EXPORT DoubleSpinBoxDelegate : public PropertyDelegate {
public:
    DoubleSpinBoxDelegate(const QVariantMap& props = QVariantMap(), QObject *parent = 0) : 
      PropertyDelegate(parent), spinProperties(props) {}
    virtual ~DoubleSpinBoxDelegate() {}

    QWidget *createEditor(QWidget *parent, const QStyleOptionViewItem &option,
          const QModelIndex &index) const;

    void setEditorData(QWidget *editor, const QModelIndex &index) const;
    void setModelData(QWidget *editor, QAbstractItemModel *model,
          const QModelIndex &index) const;
    QVariant getDisplayValue(const QVariant&) const;

private:
    QVariantMap spinProperties;
};

class WCOREAPI_EXPORT ComboBoxDelegate : public PropertyDelegate {
public:
    ComboBoxDelegate(const QVariantMap& items, QObject *parent = 0) : PropertyDelegate(parent), items(items) {}
    virtual ~ComboBoxDelegate() {}

      QWidget *createEditor(QWidget *parent, const QStyleOptionViewItem &option,
          const QModelIndex &index) const;

      void setEditorData(QWidget *editor, const QModelIndex &index) const;
      void setModelData(QWidget *editor, QAbstractItemModel *model,
          const QModelIndex &index) const;
      QVariant getDisplayValue(const QVariant&) const;
protected:
    QVariantMap items;
};

class WCOREAPI_EXPORT FileModeDelegate : public ComboBoxDelegate {
public:
    FileModeDelegate(bool appendSupported, QObject *parent = 0);
    virtual ~FileModeDelegate() {}
};

class WCOREAPI_EXPORT ScreenedParamValidator : public ConfigurationValidator {
public:
    ScreenedParamValidator(const QString& id, const QString& port, const QString& slot);
    virtual ~ScreenedParamValidator() {}
    virtual bool validate(const Configuration*, QStringList& output) const;
protected:
    QString id, port, slot;
};



}//namespace GB2
#endif
