/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_FLOWTASK_H_
#define _GB2_FLOWTASK_H_

#include <core_api/Task.h>
#include <workflow/Schema.h>
#include <workflow/WorkflowManager.h>

namespace GB2 {

namespace Workflow {
    class CommunicationChannel;
}
using namespace Workflow;

class GB2_COREAPI_EXPORT WorkflowRunTask : public Task {
    Q_OBJECT
public:
    WorkflowRunTask(const Schema&, QList<Iteration>);
    virtual QString generateReport() const;
    virtual ReportResult report(); 

signals:
    void si_ticked();
public:
    QList<WorkerState> getState(Actor*);
    int getMsgNum(Link*);
};

class WorkflowIterationRunTask : public Task {
	Q_OBJECT
public:
	WorkflowIterationRunTask(const Schema&, const Iteration&);
    ~WorkflowIterationRunTask();
    virtual void prepare();
	virtual ReportResult report(); 

signals:
    void si_ticked();
public:
    WorkerState getState(Actor*);
    int getMsgNum(Link*);

protected:
    virtual QList<Task*> onSubTaskFinished(Task* subTask);

private:
    Schema* schema;
    Scheduler* scheduler;
    QMap<ActorId, ActorId> rmap;
    QMap<QString, CommunicationChannel*> lmap;
};

} //namespace

#endif
