/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_WORKFLOW_TESTS_H_
#define _GB2_WORKFLOW_TESTS_H_

#include <test_framework/xmltest/XMLTestUtils.h>
#include <workflow/Schema.h>
#include <QtXml/QDomElement>

namespace GB2 {
using namespace Workflow;

class LoadWorkflowTask;
class SaveWorkflowTask;

class SchemaHandle : public QObject {
    Q_OBJECT
public:
    SchemaHandle(Schema* s): schema(s) {}
    ~SchemaHandle() {delete schema;}
    Schema* schema;
    QMap<ActorId, ActorId> remapping;
};

class GTest_LoadWorkflow : public GTest {
    Q_OBJECT
public:
    SIMPLE_XML_TEST_BODY_WITH_FACTORY(GTest_LoadWorkflow, "load-workflow");
    ReportResult report();
    virtual void cleanup();

private:
    QString             docContextName;
    LoadWorkflowTask*   loadTask;
    bool                contextAdded;
    bool                tempFile;
    QString             url;
};

class GTest_SaveWorkflow : public GTest {
    Q_OBJECT
public:
    SIMPLE_XML_TEST_BODY_WITH_FACTORY(GTest_SaveWorkflow, "save-workflow");
    void prepare();

private:
    QString             url;
    QString             docContextName;
    SaveWorkflowTask*   saveTask;
};

class GTest_LoadBrokenWorkflow : public GTest {
    Q_OBJECT
public:
    SIMPLE_XML_TEST_BODY_WITH_FACTORY_EXT(GTest_LoadBrokenWorkflow, "load-broken-workflow", 
        TaskFlags(TaskFlag_NoRun)| TaskFlag_FailOnSubtaskCancel);
    ReportResult report();
    void cleanup();
private:
    LoadWorkflowTask*   loadTask;
};

class GTest_RunWorkflow : public GTest {
    Q_OBJECT
public:
    SIMPLE_XML_TEST_BODY_WITH_FACTORY(GTest_RunWorkflow, "run-workflow");
    void prepare();
    //ReportResult report();
private:
    QString docContextName;
};

typedef QMap<int,QVariant> RefMap;
class GTest_ValidateWorkflow : public GTest {
    Q_OBJECT
public:
    SIMPLE_XML_TEST_BODY_WITH_FACTORY_EXT(GTest_ValidateWorkflow, "validate-workflow", TaskFlag_NoRun);
    ReportResult report();
private:
    QString docContextName;
    QList<RefMap> expectedErrors;
};

typedef QMap<ActorId, QVariantMap> CfgMap;
class GTest_ConfigureWorkflow : public GTest {
    Q_OBJECT
public:
    SIMPLE_XML_TEST_BODY_WITH_FACTORY_EXT(GTest_ConfigureWorkflow, "configure-workflow", TaskFlag_NoRun);
    ReportResult report();
private:
    QVariant getValue(const QDomElement& el);
    QString docContextName;
    QMap<int, CfgMap> iparams;
    CfgMap dparams;
};

class GB2_COREAPI_EXPORT WorkflowTests {
public:
    static QList<XMLTestFactory*> createTestFactories();
};
}//namespace
#endif
