/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_DNA_EXPORT_PLUGIN_H_
#define _GB2_DNA_EXPORT_PLUGIN_H_

#include <core_api/PluginModel.h>
#include <core_api/ServiceModel.h>
#include <core_api/ObjectViewModel.h>

#include <QtCore/QMap>
#include <QtGui/QAction>

namespace GB2 {

class DNAExportPlugin : public Plugin {
    Q_OBJECT
public:
    DNAExportPlugin();

};

class DNAExportService: public Service {
    Q_OBJECT
public:
    DNAExportService();
protected:
    virtual void serviceStateChangedCallback(ServiceState oldState, bool enabledStateChanged);

private slots:
    void sl_addToProjectViewMenu(QMenu&);
    
    void sl_saveSequencesToFasta();
    void sl_saveSequencesToClustal();
    void sl_saveAlignmentToFasta();

private:

    QAction* exportSequencesToFastaAction;
    QAction* exportSequencesToClustalAction;
    QAction* exportAlignmentToFastaAction;
    
    GObjectViewWindowContext* viewContext;

};

class DNAExportViewContext : public GObjectViewWindowContext {
    Q_OBJECT
public:
    DNAExportViewContext(QObject* p);

protected slots:
    void sl_saveAnnotationsToFasta();
    void sl_saveSequenceToFasta();
    void sl_saveAnnotationsToCSV();

protected:
    virtual void initViewContext(GObjectView* view);
    virtual void buildMenu(GObjectView* v, QMenu* m);

};

} //namespace

#endif
