/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef DNAEXPORTTOCSVTASK_H
#define DNAEXPORTTOCSVTASK_H

#include <core_api/Task.h>
#include <core_api/DNATranslation.h>
#include <gobjects/AnnotationTableObject.h>

namespace GB2 {

class DNAExportToCSVTask : public Task
{
    Q_OBJECT
public:
    DNAExportToCSVTask(QList<Annotation> annotations, QByteArray sequence, DNATranslation *complementTranslation, bool exportSequence, QString url);

    void run();
private:
    QList<Annotation> annotations;
    QByteArray sequence;
    DNATranslation *complementTranslation;
    bool exportSequence;
    QString url;
};

} // namespace GB2

#endif // DNAEXPORTTOCSVTASK_H
