/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_RF_SARRAYWK_ALG_H_
#define _GB2_RF_SARRAYWK_ALG_H_

#include "SArrayIndex.h"
#include "BitsTable.h"
#include "RFBase.h"

#include <QtCore/QVector>

namespace GB2 {

class SArrayIndex;
class RFSArrayWKSubtask;
class RFRollingArray;

class RFSArrayWKAlgorithm : public RFAlgorithmBase  {
    Q_OBJECT
    friend class RFSArrayWKSubtask;
public:
    RFSArrayWKAlgorithm(RFResultsListener* rl, const char* seqX, int sizeX, const char* seqY, int sizeY, 
                        DNAAlphabetType seqType, int w, int k);

    ~RFSArrayWKAlgorithm() {cleanup();}

    void prepare();
    QList<Task*> onSubTaskFinished(Task* subTask);

    void cleanup();

private:
    void addResult(int a, int s, int l);
    void calculate(RFSArrayWKSubtask* t);
    
public:	
    QVector<int>    diagOffsets; //holds start position for the last checked window
    int             ARRAY_SIZE;
    int             SEARCH_SIZE;

    const char      *arraySeq;
    const char      *searchSeq;
    bool            arrayIsX;
    
    quint32         q;

    CreateSArrayIndexTask*  indexTask;
    int                     nThreads;

};

class RFSArrayWKSubtask : public Task, public SArrayIndex::SAISearchContext {
    Q_OBJECT
    friend class RFSArrayWKAlgorithm;
public:
    RFSArrayWKSubtask(RFSArrayWKAlgorithm* owner, int _tid);
    virtual ~RFSArrayWKSubtask(){}
    void run();

    RFSArrayWKAlgorithm*    owner;

    const int   tid;
};

} //namespace

#endif 
