/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

//#ifdef SW2_BUILD_WITH_CUDA

typedef int ScoreType;

__global__ void calculateMatrix(const char * seqLib, int seqLibLength, ScoreType* queryProfile, 
								int queryLength, ScoreType gapOpen, ScoreType gapExtension, 
								ScoreType* g_HdataPrev, ScoreType* g_HdataCur, ScoreType* g_HdataRec,
								ScoreType* g_EdataCur, ScoreType* g_EdataRec,
								ScoreType* g_Fdata, ScoreType* g_directionsPrev, 
								ScoreType* g_directionsCur, ScoreType* g_directionsRec,
								int maxScore, bool * g_isActual, int iteration) {

	int i = blockIdx.x * blockDim.x + threadIdx.x;

	int j = iteration - i;	

	ScoreType substScore = 0;
	if (j >= 0 && j < seqLibLength)
		substScore = queryProfile[seqLib[j] * queryLength + i];

	ScoreType r_H = g_HdataCur[i - 1];
	ScoreType r_He = g_HdataPrev[i - 1];
	ScoreType r_Hf = g_HdataPrev[i];
	ScoreType r_E = g_EdataCur[i - 1];
	ScoreType r_F = g_Fdata[i];	

	r_E = max(r_E - gapExtension, r_He - gapOpen);				

	r_F = max(r_F - gapExtension, r_Hf - gapOpen);				

	r_H += substScore;
	r_H = max(r_H, 0);				
	r_H = max(r_H, r_E);		
	r_H = max(r_H, r_F);		

	if (i == 0) g_directionsCur[-1] = iteration;	

	g_EdataRec[i] = r_E;
	g_Fdata[i] = r_F;
	g_HdataRec[i] = r_H;		

	ScoreType direction = -1;

	if (r_H == 0) {		 
		direction = j + 1;
	}
	else if (r_H == r_E) {
		direction = g_directionsPrev[i - 1];
	}
	else if (r_H == r_F) {
		direction = g_directionsPrev[i];	
	}
	else {
		direction = g_directionsCur[i - 1];
	}			

	g_directionsRec[i]  = direction;	

	if (r_H >= maxScore && j < seqLibLength) {
		*g_isActual  = true;
	}	
}


void calculateMatrix_wrap(int blockSize, int threadNum, const char * seqLib, int seqLibLength, ScoreType* queryProfile, 
                          int queryLength, ScoreType gapOpen, ScoreType gapExtension, 
                          ScoreType* g_HdataPrev, ScoreType* g_HdataCur, ScoreType* g_HdataRec,
                          ScoreType* g_EdataCur, ScoreType* g_EdataRec,
                          ScoreType* g_Fdata, ScoreType* g_directionsPrev, 
                          ScoreType* g_directionsCur, ScoreType* g_directionsRec,
                          int maxScore, bool * g_isActual, int iteration) {

                              calculateMatrix<<<blockSize, threadNum>>>(seqLib, seqLibLength, 
                                  queryProfile, queryLength, gapOpen, 
                                  gapExtension, g_HdataPrev, g_HdataCur, 
                                  g_HdataRec,	g_EdataCur, g_EdataRec, g_Fdata, 
                                  g_directionsPrev, g_directionsCur,
                                  g_directionsRec, maxScore, g_isActual, iteration);
}

//#endif //SW2_BUILD_WITH_CUDA
