/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "WorkflowSceneTasks.h"
#include "SceneSerializer.h"
#include "WorkflowViewController.h"

//#include <core_api/Log.h>
//#include <util_gui/GUIUtils.h>

#include <QtXml/qdom.h>

namespace GB2 {
using namespace Workflow;

//static LogCategory log(ULOG_CAT_WD);

SaveWorkflowSceneTask::SaveWorkflowSceneTask(WorkflowScene* _scene, const Metadata& meta)
: SaveWorkflowTask(NULL, meta), scene(_scene)
{
    QDomDocument xmlDoc(SchemaSerializer::WORKFLOW_DOC);
    SceneSerializer::scene2xml(scene, xmlDoc);
    QDomElement elem = xmlDoc.documentElement();
    SchemaSerializer::saveIterations(scene->getIterations(), elem);
    SchemaSerializer::saveMeta(&meta, elem);
    rawData = xmlDoc.toByteArray();
}

Task::ReportResult SaveWorkflowSceneTask::report()
{
    if (!stateInfo.hasErrors() && !scene.isNull()) {
        scene->setModified(false);
    }
    return ReportResult_Finished;
}

LoadWorkflowSceneTask::LoadWorkflowSceneTask(WorkflowScene* scene, Workflow::Metadata* meta, 
                                             const QString& url):
LoadWorkflowTask(NULL, meta, url), scene(scene) {}

Task::ReportResult LoadWorkflowSceneTask::report() {
    if (!stateInfo.hasErrors()) {
        scene->sl_reset();
        QMap<ActorId, ActorId> remapping;
        stateInfo.setError(SceneSerializer::xml2scene(xml->documentElement(), scene, remapping));
        if (stateInfo.hasErrors()) {
            scene->sl_reset();
            meta->reset();
        } else {
            SchemaSerializer::readMeta(meta, xml->documentElement());
            QList<Iteration> lst;
            SchemaSerializer::readIterations(lst, xml->documentElement(), remapping);
            scene->setIterations(lst);
            scene->setModified(false);
            meta->url = url;
        }
    }
    delete xml;

    return Task::ReportResult_Finished;
}

}//namespace
