/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_WORKFLOW_CORE_LIB_LIB_H_
#define _GB2_WORKFLOW_CORE_LIB_LIB_H_

#include <workflow/Datatype.h>

namespace GB2 {

namespace Workflow {

class CoreLib : public QObject {
    Q_OBJECT
public:

    static const QString READ_FASTA_ACTOR;
    static const QString WRITE_FASTA_ACTOR;
    static const QString READ_TEXT_ACTOR;
    static const QString WRITE_TEXT_ACTOR;
    static const QString READ_GENBANK_ACTOR;
    static const QString WRITE_GENBANK_ACTOR;

    static const QString GENERIC_MA_ACTOR;
    static const QString GENERIC_SEQ_ACTOR;

    static const QString READ_CLUSTAL_ACTOR;
    static const QString WRITE_CLUSTAL_ACTOR;

    static const QString READ_STOCKHOLM_ACTOR;
    static const QString WRITE_STOCKHOLM_ACTOR;

    /*static const Descriptor READ_EMBL;
    static const Descriptor PLAIN_ABI;
    static const Descriptor PLAIN_SCF;
    */

    static const QString DATA_PORT_ID;

    static const QString URL_ATTR_ID;
    static const QString APPEND_ATTR_ID;
    static const QString URL_SLOT_ID;
    static const QString FASTA_HEADER_SLOT_ID;
    static const QString GENBANK_ACN_SLOT_ID;

    static const QString FASTA_TYPESET_ID;
    static const QString GENBANK_TYPESET_ID;
    static const QString TEXT_TYPESET_ID;
    static const QString MA_TYPESET_ID;

    static const Descriptor URL_ATTR();
    static const Descriptor READ_URL_SLOT();
    static const Descriptor WRITE_URL_SLOT();

    static void init();
};

}//Workflow namespace
}//GB2 namespace

#endif
