/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_HMM_IO_WORKER_H_
#define _GB2_HMM_IO_WORKER_H_

#include <workflow_library/LocalDomain.h>
#include <workflow_support/WorkflowUtils.h>

#include <util_gui/DialogUtils.h>

struct plan7_s;
struct msa_struct;

Q_DECLARE_METATYPE(plan7_s*);

namespace GB2 {
namespace LocalWorkflow {

class HMMLib : public QObject {
    Q_OBJECT
public:
    static const Descriptor HMM_CATEGORY();
    static DataTypePtr HMM_PROFILE_TYPE();
    static const QString HMM_PROFILE_TYPE_ID;
    static void init();
    static void cleanup();
};

class HMMIOProto : public BusActorPrototype {
public:
    HMMIOProto(const Descriptor& desc, const QList<PortDescriptor*>& ports, 
        const QList<Attribute*>& attrs = QList<Attribute*>());
    virtual bool isAcceptableDrop(const QMimeData*, QVariantMap*) const;
};

class HMMReadPrompter : public PrompterBase<HMMReadPrompter> {
    Q_OBJECT
public:
    HMMReadPrompter(Actor* p = 0) : PrompterBase<HMMReadPrompter>(p) {}
protected:
    QString composeRichDoc();
};

class HMMWritePrompter : public PrompterBase<HMMWritePrompter> {
    Q_OBJECT
public:
    HMMWritePrompter(Actor* p = 0) : PrompterBase<HMMWritePrompter>(p) {}
protected:
    QString composeRichDoc();
};


class HMMReader : public BaseWorker {
    Q_OBJECT
public:
    static const QString ACTOR;
    HMMReader(Actor* a) : BaseWorker(a), output(NULL) {}
    virtual void init() ;
    virtual bool isReady() {return !urls.isEmpty();}
    virtual Task* tick() ;
    virtual bool isDone() {return urls.isEmpty();}
    virtual void cleanup() {}
private slots:
    void sl_taskFinished();

protected:
    CommunicationChannel *output;
    QStringList urls;
}; 

class HMMWriter : public BaseWorker {
    Q_OBJECT
public:
    static const QString ACTOR;
    HMMWriter(Actor* a) : BaseWorker(a), input(NULL), done(false), fileMode(SaveDoc_Overwrite) {}
    virtual void init() ;
    virtual bool isReady() {return input && input->hasMessage();}
    virtual Task* tick() ;
    virtual bool isDone() {return !input || input->isEnded();}
    virtual void cleanup() {}

protected:
    CommunicationChannel *input;
    QString url;
    QMap<QString,int> counter;
    bool done;
    uint fileMode;
}; 

class HMMIOWorkerFactory : public DomainFactory {
public:
    static void init();
    static void cleanup();
    HMMIOWorkerFactory(const Descriptor& d) : DomainFactory(d) {}
    virtual Worker* createWorker(Actor* a);
};

}//Workflow namespace
}//GB2 namespace

#endif

