/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_HMM_BUILD_WORKER_H_
#define _GB2_HMM_BUILD_WORKER_H_

#include <workflow_library/LocalDomain.h>
#include <workflow_support/WorkflowUtils.h>

#include "uhmmbuild.h"
#include "u_calibrate/uhmmcalibrate.h"

namespace GB2 {

namespace LocalWorkflow {

class HMMBuildPrompter : public PrompterBase<HMMBuildPrompter> {
    Q_OBJECT
public:
    HMMBuildPrompter(Actor* p = 0) : PrompterBase<HMMBuildPrompter>(p) {}
protected:
    QString composeRichDoc();
};

class HMMBuildWorker : public BaseWorker {
    Q_OBJECT
public:
    HMMBuildWorker(Actor* a) : BaseWorker(a), input(NULL), output(NULL), nextTick(NULL) {}
    virtual void init() ;
    virtual bool isReady();
    virtual Task* tick() ;
    virtual bool isDone() ;
    virtual void cleanup() {}
private slots:
    void sl_taskFinished(Task*);

protected:
    CommunicationChannel *input, *output;
    UHMMBuildSettings cfg;
    UHMMCalibrateSettings calSettings;
    bool calibrate;
    Task* nextTick;
}; 

class HMMBuildWorkerFactory : public DomainFactory {
public:
    static const QString ACTOR;
    static void init();
    static void cleanup();
    HMMBuildWorkerFactory() : DomainFactory(ACTOR) {}
    virtual Worker* createWorker(Actor* a) {return new HMMBuildWorker(a);}
};

}//Workflow namespace
}//GB2 namespace

#endif
