/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_HMMSEARCH_TASK_H_
#define _GB2_HMMSEARCH_TASK_H_

#include "uhmmsearch.h"
#include <QtCore/QMutex>
#include <core_api/LRegion.h>
#include <core_api/Task.h>
#include <datatype/DNASequence.h>
#include <datatype/AnnotationData.h>
#include <util_tasks/SequenceWalkerTask.h>

struct plan7_s;

namespace GB2 {

class DNATranslation;

class HMMSearchTaskResult {
public:
    HMMSearchTaskResult() : evalue(0), score(0), onCompl(false), onAmino(false), borderResult(false), filtered(false){} 
    float   evalue;
    float   score;
    bool    onCompl;
    bool    onAmino;
    bool    borderResult;
    bool    filtered;
    LRegion r;

};


class HMMSearchTask: public Task, SequenceWalkerCallback {
    Q_OBJECT
public:
    HMMSearchTask(plan7_s* hmm, const DNASequence& seq, const UHMMSearchSettings& s);

    virtual void prepare();
    
    const QList<HMMSearchTaskResult>& getResults() const {return results;}

    virtual void onRegion(SequenceWalkerSubtask* t, TaskStateInfo& stateInfo);

	Task::ReportResult report();

    QList<SharedAnnotationData> getResultsAsAnnotations(const QString& name) const;

private:
    bool checkAlphabets(int hmmAl, DNAAlphabet* seqAl, DNATranslation*& complTrans, DNATranslation*& aminoTrans);
private:
    plan7_s*                            hmm;
    DNASequence                         seq;
    UHMMSearchSettings                  settings;
    DNATranslation*                     complTrans;
    DNATranslation*                     aminoTrans;
    QList<HMMSearchTaskResult>          results;
	QList<HMMSearchTaskResult>    overlaps;
    QMutex                              lock;
};



}//namespace
#endif
