/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "myutils.h"
#include "mx.h"
#include "seqdb.h"
#include "Muscle4TaskLocalStorage.h"

//#define _CRTDBG_MAP_ALLOC
//#include <crtdbg.h>
//#include <stdlib.h>

char ProbToChar(float p);

//list<MxBase *> *MxBase::m_Matrices = 0;

void MxBase::OnCtor(MxBase *Mx)
	{
	GB2::MatrixContainer* mtx = getMatrixContainer();
		if (mtx->m_Matrices == 0)
			mtx->m_Matrices = new list<MxBase *>;
		asserta(mtx->m_Matrices != 0);
		mtx->m_Matrices->push_front(Mx);
	
}

void MxBase::OnDtor(MxBase *Mx)
	{
	GB2::MatrixContainer* mtx = getMatrixContainer();

	if (mtx->m_Matrices == 0)
		{
		Warning("MxBase::OnDtor, m_Matrices = 0");
		return;
		}
	for (list<MxBase*>::iterator p = mtx->m_Matrices->begin();
	  p != mtx->m_Matrices->end(); ++p)
		{
		if (*p == Mx)
			{
			mtx->m_Matrices->erase(p);
			if (mtx->m_Matrices->empty())
				delete mtx->m_Matrices;
			return;
			}
		}
	Warning("MxBase::OnDtor, not found"); 
	}

MxBase *MxBase::Get(const string &Name)
	{
	GB2::MatrixContainer* mtx = getMatrixContainer();
	if (mtx->m_Matrices == 0)
		Die("MxBase::Get, m_Matrices=0");
	for (list<MxBase*>::iterator p = mtx->m_Matrices->begin();
	  p != mtx->m_Matrices->end(); ++p)
		{
		MxBase *m = *p;
		if (m != 0 && m->m_Name == Name)
			return m;
		}
	Die("MxBase::Get(%s), not found", Name.c_str());
	ureturn(0);
	}

float **MxBase::Getf(const string &Name)
	{
	Mx<float> *m = (Mx<float> *) Get(Name);
	asserta(m->GetTypeSize() == sizeof(float));
	return m->GetData();
	}

char **MxBase::Getc(const string &Name)
	{
	Mx<char> *m = (Mx<char> *) Get(Name);
	asserta(m->GetTypeSize() == sizeof(char));
	return m->GetData();
	}

void MxBase::Alloc(const string &Name, unsigned RowCount, unsigned ColCount,
  SeqDB *DB, unsigned IdA, unsigned IdB)
	{
	if (DB != 0)
		{
		asserta(IdA != UINT_MAX);
		asserta(IdB != UINT_MAX);
		asserta(RowCount == DB->GetSeqLength(IdA) + 1);
		asserta(ColCount == DB->GetSeqLength(IdB) + 1);
		}
	if (RowCount > m_AllocatedRowCount || ColCount > m_AllocatedColCount)
		{
		FreeData();
		AllocData(RowCount, ColCount);
		}
	
	m_Name = Name;
	m_RowCount = RowCount;
	m_ColCount = ColCount;
	m_SeqDB = DB;
	m_IdA = IdA;
	m_IdB = IdB;
	}

void MxBase::LogMe(bool WithData) const
	{
	}
//static unsigned g_MatrixFileCount;

void WriteSMx(const string &Name, SparseMx &SM)
	{
	/*Log("\n");
	Log("Posterior:\n");
	Log("Type=%s\n", Name.c_str());
	unsigned LA = SM.m_RowCount - 1;
	unsigned LB = SM.m_ColCount - 1;
	Log("nrows=%u\n", LA);
	Log("ncols=%u\n", LB);
	Log("rows=%s\n", SM.GetRowLabel());
	Log("cols=%s\n", SM.GetColLabel());
	Log("probs=\n");
	for (unsigned i = 0; i < LA; ++i)
		{
		float *Values;
		unsigned *ColIndexes;
		unsigned EntryCount = SM.GetRow(i+1, &Values, &ColIndexes);
		if (EntryCount == 0)
			continue;
		Log("%u:", i+1);
		for (unsigned k = 0; k < EntryCount; ++k)
			Log(" %u=%.5f", ColIndexes[k], Values[k]);
		Log("\n");
		}
	Log("//\n");
	Log("\n");*/
	}

void WriteMx(const string &Name, Mx<float> &Mxf)
	{
	/*GB2::Muscle4Context *ctx = getMuscle4Context();
	Log("\n");
	Log("Posterior:\n");
	Log("Type=%s\n", Name.c_str());
	Log("Subtype=%s\n", Mxf.m_Name.c_str());
	unsigned LA = Mxf.m_RowCount - 1;
	unsigned LB = Mxf.m_ColCount - 1;
	Log("nrows=%u\n", LA);
	Log("ncols=%u\n", LB);

	if (Mxf.m_SeqDB != 0)
		{
		const SeqDB &DB = *Mxf.m_SeqDB;
		unsigned IdA = Mxf.m_IdA;
		unsigned IdB = Mxf.m_IdB;
		Log("rows=%s\n", DB.GetLabel(IdA).c_str());
		Log("cols=%s\n", DB.GetLabel(IdB).c_str());
		}

	Log("probs=\n");
	for (unsigned i = 0; i < LA; ++i)
		{
		bool Any = false;
		for (unsigned j = 0; j < LB; ++j)
			{
			float p = Mxf.Get(i+1, j+1);
			if (p >= ctx->opt_minsparseprob)
				{
				if (!Any)
					{
					Any = true;
					Log("%u:", i+1);
					}
				Log(" %u=%.5f", j+1, p);
				}
			}
		if (Any)
			Log("\n");
		}
	Log("//\n");
	Log("\n");*/
	}

void LogSmallDotPlot(const Mx<float> &Mx, const string &Name, unsigned MaxL)
	{
	/*Log("\n");
	if (Name != "")
		Log("%s:\n", Name.c_str());

	const unsigned RowCount = Mx.m_RowCount;
	const unsigned ColCount = Mx.m_ColCount;
	unsigned RowN = RowCount;
	unsigned ColN = ColCount;
	unsigned RowInc = 1;
	unsigned ColInc = 1;

	if (RowN > MaxL)
		{
		RowInc = RowN/MaxL + 1;
		RowN = RowCount/RowInc;
		}
	if (ColN > MaxL)
		{
		ColInc = ColN/MaxL + 1;
		ColN = ColCount/ColInc;
		}

	for (unsigned i = 1; i < RowCount; i += RowInc)
		{
		for (unsigned j = 1; j < ColCount; j += ColInc)
			{
			float maxp = 0;
			for (unsigned ki = 0; ki < RowInc; ++ki)
				{
				for (unsigned kj = 0; kj < ColInc; ++kj)
					{
					unsigned ii = i - 1 + ki;
					if (ii >= RowCount)
						continue;
					unsigned jj = j - 1 +kj;
					if (jj >= ColCount)
						continue;
					float p = Mx.Get(ii, jj);
					if (p > maxp)
						maxp = p;
					}
				}
			char c = ProbToChar(maxp);
			Log("%c", c);
			}
		Log("\n");
		}*/
	}


