/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "myutils.h"
#include "params.h"
#include "mx.h"

//#define _CRTDBG_MAP_ALLOC
//#include <crtdbg.h>
//#include <stdlib.h>

static const char Alphabet[] = "ARNDCQEGHILKMFPSTWYV*";

static const float PCCRFMX[25][25] =
	{
//                  A             R             N             D             C             Q             E             G             H             I             L             K             M             F             P             S             T             W             Y             V             *
/* A */ {     1.35317f,     -0.5189f,     -0.5016f,     -0.5862f,     -0.1642f,     -0.2481f,     -0.2805f,    -0.01925f,     -0.5773f,     -0.4695f,     -0.5262f,     -0.3275f,     -0.2488f,     -0.7506f,     -0.2911f,     0.32139f,    -0.02678f,     -0.8793f,     -0.6184f,    -0.07551f,     -2.1441f},  // A
/* R */ {     -0.5189f,     1.86410f,     -0.1127f,     -0.5098f,     -0.9438f,     0.29846f,    -0.09142f,     -0.7397f,    -0.03239f,     -0.9053f,     -0.7253f,     0.65854f,     -0.5109f,     -0.9476f,     -0.6653f,     -0.3124f,     -0.3663f,     -0.7732f,     -0.4999f,     -0.8218f,     -2.1441f},  // R
/* N */ {     -0.5016f,     -0.1127f,     1.87522f,     0.44110f,     -0.8265f,   -0.004686f,     -0.1024f,     -0.1777f,     0.20256f,      -1.018f,     -0.9887f,     -0.0125f,     -0.5335f,      -0.849f,     -0.5549f,     0.15028f,    -0.02968f,     -0.9322f,     -0.6141f,     -0.8684f,     -2.1441f},  // N
/* D */ {     -0.5862f,     -0.5098f,     0.44110f,     1.98254f,      -1.116f,     -0.0398f,     0.54485f,     -0.5291f,     -0.3182f,      -1.154f,      -1.124f,     -0.1773f,     -0.9618f,      -1.199f,     -0.4776f,     -0.0509f,     -0.3743f,      -1.349f,     -0.8874f,       -1.08f,     -2.1441f},  // D
/* C */ {     -0.1642f,     -0.9438f,     -0.8265f,      -1.116f,     3.05102f,     -0.8944f,      -1.176f,     -0.8728f,     -0.7681f,     -0.4162f,     -0.4293f,      -1.008f,     -0.3553f,     -0.6257f,     -0.9089f,     -0.3003f,     -0.4173f,     -0.9045f,     -0.6249f,     -0.2998f,     -2.1441f},  // C
/* Q */ {     -0.2481f,     0.29846f,   -0.004686f,     -0.0398f,     -0.8944f,     1.77231f,     0.53878f,     -0.6727f,     0.19984f,     -0.8392f,     -0.6574f,     0.39337f,      -0.146f,     -0.9937f,     -0.4497f,     -0.0929f,     -0.1714f,     -0.7399f,     -0.4677f,     -0.6842f,     -2.1441f},  // Q
/* E */ {     -0.2805f,    -0.09142f,     -0.1024f,     0.54485f,      -1.176f,     0.53878f,     1.67076f,     -0.7102f,     -0.1031f,       -1.08f,      -0.899f,     0.26088f,     -0.5873f,      -1.157f,     -0.3785f,     -0.1114f,     -0.2816f,      -1.043f,     -0.6398f,     -0.8363f,     -2.1441f},  // E
/* G */ {    -0.01925f,     -0.7397f,     -0.1777f,     -0.5291f,     -0.8728f,     -0.6727f,     -0.7102f,     1.90307f,      -0.669f,      -1.269f,      -1.268f,     -0.5676f,      -1.049f,      -1.104f,     -0.6785f,     -0.1757f,     -0.6169f,     -0.8818f,      -1.002f,      -1.078f,     -2.1441f},  // G
/* H */ {     -0.5773f,    -0.03239f,     0.20256f,     -0.3182f,     -0.7681f,     0.19984f,     -0.1031f,      -0.669f,     2.55174f,      -1.043f,      -0.816f,     -0.2307f,     -0.4064f,     -0.4702f,     -0.7363f,     -0.2677f,     -0.5373f,     -0.4942f,     0.47762f,     -0.9819f,     -2.1441f},  // H
/* I */ {     -0.4695f,     -0.9053f,      -1.018f,      -1.154f,     -0.4162f,     -0.8392f,       -1.08f,      -1.269f,      -1.043f,     1.43362f,     0.52712f,     -0.8856f,     0.34468f,    -0.03745f,     -0.9052f,     -0.7861f,     -0.2911f,     -0.6839f,     -0.4646f,     0.84927f,     -2.1441f},  // I
/* L */ {     -0.5262f,     -0.7253f,     -0.9887f,      -1.124f,     -0.4293f,     -0.6574f,      -0.899f,      -1.268f,      -0.816f,     0.52712f,     1.33398f,     -0.7882f,     0.66780f,     0.20693f,     -0.8894f,     -0.8175f,     -0.4973f,     -0.4213f,     -0.3234f,     0.24812f,     -2.1441f},  // L
/* K */ {     -0.3275f,     0.65854f,     -0.0125f,     -0.1773f,      -1.008f,     0.39337f,     0.26088f,     -0.5676f,     -0.2307f,     -0.8856f,     -0.7882f,     1.54067f,     -0.3993f,      -1.101f,     -0.4025f,    -0.09504f,      -0.181f,     -0.9108f,     -0.5997f,     -0.7161f,     -2.1441f},  // K
/* M */ {     -0.2488f,     -0.5109f,     -0.5335f,     -0.9618f,     -0.3553f,      -0.146f,     -0.5873f,      -1.049f,     -0.4064f,     0.34468f,     0.66780f,     -0.3993f,     1.92995f,     0.06486f,     -0.7209f,     -0.4853f,     -0.2895f,     -0.5908f,     -0.3422f,     0.09792f,     -2.1441f},  // M
/* F */ {     -0.7506f,     -0.9476f,      -0.849f,      -1.199f,     -0.6257f,     -0.9937f,      -1.157f,      -1.104f,     -0.4702f,    -0.03745f,     0.20693f,      -1.101f,     0.06486f,     2.12087f,      -1.064f,     -0.7855f,     -0.7523f,     0.46774f,     0.97229f,     -0.2465f,     -2.1441f},  // F
/* P */ {     -0.2911f,     -0.6653f,     -0.5549f,     -0.4776f,     -0.9089f,     -0.4497f,     -0.3785f,     -0.6785f,     -0.7363f,     -0.9052f,     -0.8894f,     -0.4025f,     -0.7209f,      -1.064f,     2.47580f,     -0.2471f,     -0.3089f,      -1.107f,     -0.9501f,     -0.7566f,     -2.1441f},  // P
/* S */ {     0.32139f,     -0.3124f,     0.15028f,     -0.0509f,     -0.3003f,     -0.0929f,     -0.1114f,     -0.1757f,     -0.2677f,     -0.7861f,     -0.8175f,    -0.09504f,     -0.4853f,     -0.7855f,     -0.2471f,     1.36991f,     0.48762f,     -0.9762f,     -0.5771f,     -0.5755f,     -2.1441f},  // S
/* T */ {    -0.02678f,     -0.3663f,    -0.02968f,     -0.3743f,     -0.4173f,     -0.1714f,     -0.2816f,     -0.6169f,     -0.5373f,     -0.2911f,     -0.4973f,      -0.181f,     -0.2895f,     -0.7523f,     -0.3089f,     0.48762f,     1.60263f,     -0.9028f,     -0.5228f,    -0.08958f,     -2.1441f},  // T
/* W */ {     -0.8793f,     -0.7732f,     -0.9322f,      -1.349f,     -0.9045f,     -0.7399f,      -1.043f,     -0.8818f,     -0.4942f,     -0.6839f,     -0.4213f,     -0.9108f,     -0.5908f,     0.46774f,      -1.107f,     -0.9762f,     -0.9028f,     3.66130f,     0.61019f,       -0.83f,     -2.1441f},  // W
/* Y */ {     -0.6184f,     -0.4999f,     -0.6141f,     -0.8874f,     -0.6249f,     -0.4677f,     -0.6398f,      -1.002f,     0.47762f,     -0.4646f,     -0.3234f,     -0.5997f,     -0.3422f,     0.97229f,     -0.9501f,     -0.5771f,     -0.5228f,     0.61019f,     2.32579f,     -0.4385f,     -2.1441f},  // Y
/* V */ {    -0.07551f,     -0.8218f,     -0.8684f,       -1.08f,     -0.2998f,     -0.6842f,     -0.8363f,      -1.078f,     -0.9819f,     0.84927f,     0.24812f,     -0.7161f,     0.09792f,     -0.2465f,     -0.7566f,     -0.5755f,    -0.08958f,       -0.83f,     -0.4385f,     1.34760f,     -2.1441f},  // V
/* * */ {     -2.1441f,     -2.1441f,     -2.1441f,     -2.1441f,     -2.1441f,     -2.1441f,     -2.1441f,     -2.1441f,     -2.1441f,     -2.1441f,     -2.1441f,     -2.1441f,     -2.1441f,     -2.1441f,     -2.1441f,     -2.1441f,     -2.1441f,     -2.1441f,     -2.1441f,     1.34760f,     -2.1441f},  // *
    };

void SetPCCRFMX()
	{
	unsigned N = unsigned(strlen(Alphabet));
	Mx<float> &SubstMxf = GetSubstMxf();
	SubstMxf.Alloc("PCCRFMX", 256, 256);
	SubstMxf.m_Alpha = string(Alphabet);
	SubstMxf.Init(0);
	float **Mx = SubstMxf.GetData();
	for (unsigned i = 0; i < N; ++i)
		{
		for (unsigned j = 0; j < N; ++j)
			{
			float v = PCCRFMX[i][j];
			
			byte ui = (byte) toupper(Alphabet[i]);
			byte uj = (byte) toupper(Alphabet[j]);
			byte li = (byte) tolower(ui);
			byte lj = (byte) tolower(uj);
			ui = (byte) toupper(ui);
			uj = (byte) toupper(uj);

			Mx[ui][uj] = v;
			Mx[uj][ui] = v;

			Mx[ui][lj] = v;
			Mx[uj][li] = v;

			Mx[li][uj] = v;
			Mx[lj][ui] = v;

			Mx[li][lj] = v;
			Mx[lj][li] = v;
			}
		}
	}
