/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef sumlog_h
#define sumlog_h

#include <math.h>
#define EXACT	0

#ifdef _MSC_VER
#pragma warning(disable: 4244) // double->float conversion
#endif

//////////////////////////////////////////////////////////////////////
// Fast polynomial approximations to some maths functions.
// The important stuff here is "borrowed" from the PROBCONS sources.
// Thanks Tom!
//////////////////////////////////////////////////////////////////////

const float LOG_ZERO_FLOAT = -2e20f;
const float LOG_ONE_FLOAT = 0.0f;
const float LOG_ZERO = -2e20f;

inline float EXP (float x)
	{
#if	EXACT
	return exp(x);
#else
	if (x > -2){
	if (x > -0.5){
	  if (x > 0)
	return exp(x);
	  return (((0.03254409303190190000*x + 0.16280432765779600000)*x + 0.49929760485974900000)*x + 0.99995149601363700000)*x + 0.99999925508501600000;
	}
	if (x > -1)
	  return (((0.01973899026052090000*x + 0.13822379685007000000)*x + 0.48056651562365000000)*x + 0.99326940370383500000)*x + 0.99906756856399500000;
	return (((0.00940528203591384000*x + 0.09414963667859410000)*x + 0.40825793595877300000)*x + 0.93933625499130400000)*x + 0.98369508190545300000;
	}
	if (x > -8){
	if (x > -4)
	  return (((0.00217245711583303000*x + 0.03484829428350620000)*x + 0.22118199801337800000)*x + 0.67049462206469500000)*x + 0.83556950223398500000;
	return (((0.00012398771025456900*x + 0.00349155785951272000)*x + 0.03727721426017900000)*x + 0.17974997741536900000)*x + 0.33249299994217400000;
	}
	if (x > -16)
	return (((0.00000051741713416603*x + 0.00002721456879608080)*x + 0.00053418601865636800)*x + 0.00464101989351936000)*x + 0.01507447981459420000;
	return 0;
#endif
	}


//////////////////////////////////////////////////////////////////////
// Compute log (x)
//////////////////////////////////////////////////////////////////////

inline float LOG_FLOAT (float x){
#if EXACT
  return log(x);
#else
  float value;

  if (x <= 0) return LOG_ZERO_FLOAT;
  if (x > 1) return log (x);
  value = 0;

  while (x < 0.5f){
    x += x;
    value += -0.6931471806f;
  }
  
  return value + (((-0.8921177528f*x + 3.5313113007f)*x - 5.8206844725f)*x + 5.6098099262f)*x - 2.4284166653f;
#endif
}

//////////////////////////////////////////////////////////////////////
// Compute exp (x)
//////////////////////////////////////////////////////////////////////

inline float EXP_FLOAT (float x){

#if EXACT
  return exp(x);
#else
  if (x > -2){
    if (x > -0.5){
      if (x > 0)
	return exp(x);
      return (((0.03254409303190190000*x + 0.16280432765779600000)*x + 0.49929760485974900000)*x + 0.99995149601363700000)*x + 0.99999925508501600000;
    }
    if (x > -1)
      return (((0.01973899026052090000*x + 0.13822379685007000000)*x + 0.48056651562365000000)*x + 0.99326940370383500000)*x + 0.99906756856399500000;
    return (((0.00940528203591384000*x + 0.09414963667859410000)*x + 0.40825793595877300000)*x + 0.93933625499130400000)*x + 0.98369508190545300000;
  }
  if (x > -8){
    if (x > -4)
      return (((0.00217245711583303000*x + 0.03484829428350620000)*x + 0.22118199801337800000)*x + 0.67049462206469500000)*x + 0.83556950223398500000;
    return (((0.00012398771025456900*x + 0.00349155785951272000)*x + 0.03727721426017900000)*x + 0.17974997741536900000)*x + 0.33249299994217400000;
  }
  if (x > -16)
    return (((0.00000051741713416603*x + 0.00002721456879608080)*x + 0.00053418601865636800)*x + 0.00464101989351936000)*x + 0.01507447981459420000;
  return 0;
  #endif
}

//////////////////////////////////////////////////////////////////////
// Computes log (exp (x) + 1)
//////////////////////////////////////////////////////////////////////

inline float LOOKUP_FLOAT (float x){
#if EXACT
  return log(exp(x)+1);
#else
  if (x < 2){
    if (x < 0.5){
      if (x < 0)
	return log (exp(x) + 1);
      return (((-0.00486373205785640000*x - 0.00020245408813934800)*x + 0.12504222666029800000)*x + 0.49999685320563000000)*x + 0.69314723138948900000;
    }
    if (x < 1)
      return (((-0.00278634205460548000*x - 0.00458097251248546000)*x + 0.12865849880472500000)*x + 0.49862228499205200000)*x + 0.69334810088688000000;
    return (((0.00059633755154209200*x - 0.01918996666063320000)*x + 0.15288232492093800000)*x + 0.48039958825756900000)*x + 0.69857578503189200000;
  }
  if (x < 8){
    if (x < 4)
      return (((0.00135958539181047000*x - 0.02329807659316430000)*x + 0.15885799609532100000)*x + 0.48167498563270800000)*x + 0.69276185058669200000;
    return (((0.00011992394456683500*x - 0.00338464503306568000)*x + 0.03622746366545470000)*x + 0.82481250248383700000)*x + 0.32507892994863100000;
  }
  if (x < 16)
    return (((0.00000051726300753785*x - 0.00002720671238876090)*x + 0.00053403733818413500)*x + 0.99536021775747900000)*x + 0.01507065715532010000;
  return x;
#endif
}

//////////////////////////////////////////////////////////////////////
// Computes sum of two numbers in log space
//////////////////////////////////////////////////////////////////////

inline float LOG_ADD_FLOAT (float x, float y){
  if (x < y){ float t = x; x = y; y = t; }
  if (y <= LOG_ZERO_FLOAT) return x;
  return LOOKUP_FLOAT(x-y) + y;
}

inline float SumLog2(float x, float y)
	{
	return LOG_ADD_FLOAT(x, y);
	}

inline float SumLog2Exact(float x, float y)
	{
	if (x < y)
		{
		float t = x;
		x = y;
		y = t;
		}
	if (y <= LOG_ZERO_FLOAT)
		return x;
	return log(exp(x-y)+1) + y;
	}

inline float SumLog3(float x, float y, float z)
	{
	return SumLog2(x, SumLog2(y, z));
	}

inline float SumLog4(float w, float x, float y, float z)
	{
	return SumLog2(w, SumLog2(x, SumLog2(y, z)));
	}

inline float SumLog5(float v, float w, float x, float y, float z)
	{
	return SumLog3(v, SumLog2(w, x), SumLog2(y, z));
	}

#endif // sumlog_h
