/* this is included from filename.c, do not include directly */
#ifndef XADMASTER_CS_MACROMAN_TO_UNICODE_C
#define XADMASTER_CS_MACROMAN_TO_UNICODE_C

/*  $Id: cs_macroman_to_unicode.c,v 1.4 2005/06/23 14:54:37 stoecker Exp $
    Character set conversion from Mac Roman to Unicode

    XAD library system for archive handling
    Copyright (C) 1998 and later by Dirk Stcker <soft@dstoecker.de>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

static const xadUINT16 macroman[] = {
0x00C4, /* LATIN CAPITAL LETTER A WITH DIAERESIS */
0x00C5, /* LATIN CAPITAL LETTER A WITH RING ABOVE */
0x00C7, /* LATIN CAPITAL LETTER C WITH CEDILLA */
0x00C9, /* LATIN CAPITAL LETTER E WITH ACUTE */
0x00D1, /* LATIN CAPITAL LETTER N WITH TILDE */
0x00D6, /* LATIN CAPITAL LETTER O WITH DIAERESIS */
0x00DC, /* LATIN CAPITAL LETTER U WITH DIAERESIS */
0x00E1, /* LATIN SMALL LETTER A WITH ACUTE */
0x00E0, /* LATIN SMALL LETTER A WITH GRAVE */
0x00E2, /* LATIN SMALL LETTER A WITH CIRCUMFLEX */
0x00E4, /* LATIN SMALL LETTER A WITH DIAERESIS */
0x00E3, /* LATIN SMALL LETTER A WITH TILDE */
0x00E5, /* LATIN SMALL LETTER A WITH RING ABOVE */
0x00E7, /* LATIN SMALL LETTER C WITH CEDILLA */
0x00E9, /* LATIN SMALL LETTER E WITH ACUTE */
0x00E8, /* LATIN SMALL LETTER E WITH GRAVE */
0x00EA, /* LATIN SMALL LETTER E WITH CIRCUMFLEX */
0x00EB, /* LATIN SMALL LETTER E WITH DIAERESIS */
0x00ED, /* LATIN SMALL LETTER I WITH ACUTE */
0x00EC, /* LATIN SMALL LETTER I WITH GRAVE */
0x00EE, /* LATIN SMALL LETTER I WITH CIRCUMFLEX */
0x00EF, /* LATIN SMALL LETTER I WITH DIAERESIS */
0x00F1, /* LATIN SMALL LETTER N WITH TILDE */
0x00F3, /* LATIN SMALL LETTER O WITH ACUTE */
0x00F2, /* LATIN SMALL LETTER O WITH GRAVE */
0x00F4, /* LATIN SMALL LETTER O WITH CIRCUMFLEX */
0x00F6, /* LATIN SMALL LETTER O WITH DIAERESIS */
0x00F5, /* LATIN SMALL LETTER O WITH TILDE */
0x00FA, /* LATIN SMALL LETTER U WITH ACUTE */
0x00F9, /* LATIN SMALL LETTER U WITH GRAVE */
0x00FB, /* LATIN SMALL LETTER U WITH CIRCUMFLEX */
0x00FC, /* LATIN SMALL LETTER U WITH DIAERESIS */
0x2020, /* DAGGER */
0x00B0, /* DEGREE SIGN */
0x00A2, /* CENT SIGN */
0x00A3, /* POUND SIGN */
0x00A7, /* SECTION SIGN */
0x2022, /* BULLET */
0x00B6, /* PILCROW SIGN */
0x00DF, /* LATIN SMALL LETTER SHARP S */
0x00AE, /* REGISTERED SIGN */
0x00A9, /* COPYRIGHT SIGN */
0x2122, /* TRADE MARK SIGN */
0x00B4, /* ACUTE ACCENT */
0x00A8, /* DIAERESIS */
0x2260, /* NOT EQUAL TO */
0x00C6, /* LATIN CAPITAL LETTER AE */
0x00D8, /* LATIN CAPITAL LETTER O WITH STROKE */
0x221E, /* INFINITY */
0x00B1, /* PLUS-MINUS SIGN */
0x2264, /* LESS-THAN OR EQUAL TO */
0x2265, /* GREATER-THAN OR EQUAL TO */
0x00A5, /* YEN SIGN */
0x00B5, /* MICRO SIGN */
0x2202, /* PARTIAL DIFFERENTIAL */
0x2211, /* N-ARY SUMMATION */
0x220F, /* N-ARY PRODUCT */
0x03C0, /* GREEK SMALL LETTER PI */
0x222B, /* INTEGRAL */
0x00AA, /* FEMININE ORDINAL INDICATOR */
0x00BA, /* MASCULINE ORDINAL INDICATOR */
0x03A9, /* GREEK CAPITAL LETTER OMEGA */
0x00E6, /* LATIN SMALL LETTER AE */
0x00F8, /* LATIN SMALL LETTER O WITH STROKE */
0x00BF, /* INVERTED QUESTION MARK */
0x00A1, /* INVERTED EXCLAMATION MARK */
0x00AC, /* NOT SIGN */
0x221A, /* SQUARE ROOT */
0x0192, /* LATIN SMALL LETTER F WITH HOOK */
0x2248, /* ALMOST EQUAL TO */
0x2206, /* INCREMENT */
0x00AB, /* LEFT-POINTING DOUBLE ANGLE QUOTATION MARK */
0x00BB, /* RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK */
0x2026, /* HORIZONTAL ELLIPSIS */
0x00A0, /* NO-BREAK SPACE */
0x00C0, /* LATIN CAPITAL LETTER A WITH GRAVE */
0x00C3, /* LATIN CAPITAL LETTER A WITH TILDE */
0x00D5, /* LATIN CAPITAL LETTER O WITH TILDE */
0x0152, /* LATIN CAPITAL LIGATURE OE */
0x0153, /* LATIN SMALL LIGATURE OE */
0x2013, /* EN DASH */
0x2014, /* EM DASH */
0x201C, /* LEFT DOUBLE QUOTATION MARK */
0x201D, /* RIGHT DOUBLE QUOTATION MARK */
0x2018, /* LEFT SINGLE QUOTATION MARK */
0x2019, /* RIGHT SINGLE QUOTATION MARK */
0x00F7, /* DIVISION SIGN */
0x25CA, /* LOZENGE */
0x00FF, /* LATIN SMALL LETTER Y WITH DIAERESIS */
0x0178, /* LATIN CAPITAL LETTER Y WITH DIAERESIS */
0x2044, /* FRACTION SLASH */
0x20AC, /* EURO SIGN */
0x2039, /* SINGLE LEFT-POINTING ANGLE QUOTATION MARK */
0x203A, /* SINGLE RIGHT-POINTING ANGLE QUOTATION MARK */
0xFB01, /* LATIN SMALL LIGATURE FI */
0xFB02, /* LATIN SMALL LIGATURE FL */
0x2021, /* DOUBLE DAGGER */
0x00B7, /* MIDDLE DOT */
0x201A, /* SINGLE LOW-9 QUOTATION MARK */
0x201E, /* DOUBLE LOW-9 QUOTATION MARK */
0x2030, /* PER MILLE SIGN */
0x00C2, /* LATIN CAPITAL LETTER A WITH CIRCUMFLEX */
0x00CA, /* LATIN CAPITAL LETTER E WITH CIRCUMFLEX */
0x00C1, /* LATIN CAPITAL LETTER A WITH ACUTE */
0x00CB, /* LATIN CAPITAL LETTER E WITH DIAERESIS */
0x00C8, /* LATIN CAPITAL LETTER E WITH GRAVE */
0x00CD, /* LATIN CAPITAL LETTER I WITH ACUTE */
0x00CE, /* LATIN CAPITAL LETTER I WITH CIRCUMFLEX */
0x00CF, /* LATIN CAPITAL LETTER I WITH DIAERESIS */
0x00CC, /* LATIN CAPITAL LETTER I WITH GRAVE */
0x00D3, /* LATIN CAPITAL LETTER O WITH ACUTE */
0x00D4, /* LATIN CAPITAL LETTER O WITH CIRCUMFLEX */
0xF8FF, /* Apple logo */
0x00D2, /* LATIN CAPITAL LETTER O WITH GRAVE */
0x00DA, /* LATIN CAPITAL LETTER U WITH ACUTE */
0x00DB, /* LATIN CAPITAL LETTER U WITH CIRCUMFLEX */
0x00D9, /* LATIN CAPITAL LETTER U WITH GRAVE */
0x0131, /* LATIN SMALL LETTER DOTLESS I */
0x02C6, /* MODIFIER LETTER CIRCUMFLEX ACCENT */
0x02DC, /* SMALL TILDE */
0x00AF, /* MACRON */
0x02D8, /* BREVE */
0x02D9, /* DOT ABOVE */
0x02DA, /* RING ABOVE */
0x00B8, /* CEDILLA */
0x02DD, /* DOUBLE ACUTE ACCENT */
0x02DB, /* OGONEK */
0x02C7  /* CARON */
};

static xadUINT16 macroman_to_unicode(xadUINT16 i)
{
    if (i > 0x7F)
        i = macroman[i-0x80];

    return i;
}

#endif /* XADMASTER_CS_MACROMAN_TO_UNICODE_C */
