/* banshee-collection.c generated by valac 0.14.2, the Vala compiler
 * generated from banshee-collection.vala, do not modify */

/*
 * Copyright (C) 2011 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Alex Launi <alex.launi@canonical.com>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <sqlite3.h>
#include <stdlib.h>
#include <string.h>
#include <unity.h>
#include <dee.h>
#include <gee.h>
#include <gio/gio.h>


#define UNITY_MUSIC_LENS_TYPE_BANSHEE_COLLECTION (unity_music_lens_banshee_collection_get_type ())
#define UNITY_MUSIC_LENS_BANSHEE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_MUSIC_LENS_TYPE_BANSHEE_COLLECTION, UnityMusicLensBansheeCollection))
#define UNITY_MUSIC_LENS_BANSHEE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_MUSIC_LENS_TYPE_BANSHEE_COLLECTION, UnityMusicLensBansheeCollectionClass))
#define UNITY_MUSIC_LENS_IS_BANSHEE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_MUSIC_LENS_TYPE_BANSHEE_COLLECTION))
#define UNITY_MUSIC_LENS_IS_BANSHEE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_MUSIC_LENS_TYPE_BANSHEE_COLLECTION))
#define UNITY_MUSIC_LENS_BANSHEE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_MUSIC_LENS_TYPE_BANSHEE_COLLECTION, UnityMusicLensBansheeCollectionClass))

typedef struct _UnityMusicLensBansheeCollection UnityMusicLensBansheeCollection;
typedef struct _UnityMusicLensBansheeCollectionClass UnityMusicLensBansheeCollectionClass;
typedef struct _UnityMusicLensBansheeCollectionPrivate UnityMusicLensBansheeCollectionPrivate;
#define _sqlite3_close0(var) ((var == NULL) ? NULL : (var = (sqlite3_close (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define UNITY_MUSIC_LENS_TYPE_FILTER_PARSER (unity_music_lens_filter_parser_get_type ())
#define UNITY_MUSIC_LENS_FILTER_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_MUSIC_LENS_TYPE_FILTER_PARSER, UnityMusicLensFilterParser))
#define UNITY_MUSIC_LENS_FILTER_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_MUSIC_LENS_TYPE_FILTER_PARSER, UnityMusicLensFilterParserClass))
#define UNITY_MUSIC_LENS_IS_FILTER_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_MUSIC_LENS_TYPE_FILTER_PARSER))
#define UNITY_MUSIC_LENS_IS_FILTER_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_MUSIC_LENS_TYPE_FILTER_PARSER))
#define UNITY_MUSIC_LENS_FILTER_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_MUSIC_LENS_TYPE_FILTER_PARSER, UnityMusicLensFilterParserClass))

typedef struct _UnityMusicLensFilterParser UnityMusicLensFilterParser;
typedef struct _UnityMusicLensFilterParserClass UnityMusicLensFilterParserClass;
#define _sqlite3_finalize0(var) ((var == NULL) ? NULL : (var = (sqlite3_finalize (var), NULL)))

#define UNITY_MUSIC_LENS_TYPE_TRACK (unity_music_lens_track_get_type ())
#define UNITY_MUSIC_LENS_TRACK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_MUSIC_LENS_TYPE_TRACK, UnityMusicLensTrack))
#define UNITY_MUSIC_LENS_TRACK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_MUSIC_LENS_TYPE_TRACK, UnityMusicLensTrackClass))
#define UNITY_MUSIC_LENS_IS_TRACK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_MUSIC_LENS_TYPE_TRACK))
#define UNITY_MUSIC_LENS_IS_TRACK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_MUSIC_LENS_TYPE_TRACK))
#define UNITY_MUSIC_LENS_TRACK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_MUSIC_LENS_TYPE_TRACK, UnityMusicLensTrackClass))

typedef struct _UnityMusicLensTrack UnityMusicLensTrack;
typedef struct _UnityMusicLensTrackClass UnityMusicLensTrackClass;

#define UNITY_MUSIC_LENS_TYPE_ALBUM (unity_music_lens_album_get_type ())
#define UNITY_MUSIC_LENS_ALBUM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_MUSIC_LENS_TYPE_ALBUM, UnityMusicLensAlbum))
#define UNITY_MUSIC_LENS_ALBUM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_MUSIC_LENS_TYPE_ALBUM, UnityMusicLensAlbumClass))
#define UNITY_MUSIC_LENS_IS_ALBUM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_MUSIC_LENS_TYPE_ALBUM))
#define UNITY_MUSIC_LENS_IS_ALBUM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_MUSIC_LENS_TYPE_ALBUM))
#define UNITY_MUSIC_LENS_ALBUM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_MUSIC_LENS_TYPE_ALBUM, UnityMusicLensAlbumClass))

typedef struct _UnityMusicLensAlbum UnityMusicLensAlbum;
typedef struct _UnityMusicLensAlbumClass UnityMusicLensAlbumClass;

#define UNITY_MUSIC_LENS_TYPE_CATEGORY (unity_music_lens_category_get_type ())
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

#define UNITY_MUSIC_LENS_TYPE_BANSHEE_FILTER_PARSER (unity_music_lens_banshee_filter_parser_get_type ())
#define UNITY_MUSIC_LENS_BANSHEE_FILTER_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_MUSIC_LENS_TYPE_BANSHEE_FILTER_PARSER, UnityMusicLensBansheeFilterParser))
#define UNITY_MUSIC_LENS_IS_BANSHEE_FILTER_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_MUSIC_LENS_TYPE_BANSHEE_FILTER_PARSER))
#define UNITY_MUSIC_LENS_BANSHEE_FILTER_PARSER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), UNITY_MUSIC_LENS_TYPE_BANSHEE_FILTER_PARSER, UnityMusicLensBansheeFilterParserIface))

typedef struct _UnityMusicLensBansheeFilterParser UnityMusicLensBansheeFilterParser;
typedef struct _UnityMusicLensBansheeFilterParserIface UnityMusicLensBansheeFilterParserIface;

#define UNITY_MUSIC_LENS_TYPE_GENRE_FILTER_PARSER (unity_music_lens_genre_filter_parser_get_type ())
#define UNITY_MUSIC_LENS_GENRE_FILTER_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_MUSIC_LENS_TYPE_GENRE_FILTER_PARSER, UnityMusicLensGenreFilterParser))
#define UNITY_MUSIC_LENS_GENRE_FILTER_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_MUSIC_LENS_TYPE_GENRE_FILTER_PARSER, UnityMusicLensGenreFilterParserClass))
#define UNITY_MUSIC_LENS_IS_GENRE_FILTER_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_MUSIC_LENS_TYPE_GENRE_FILTER_PARSER))
#define UNITY_MUSIC_LENS_IS_GENRE_FILTER_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_MUSIC_LENS_TYPE_GENRE_FILTER_PARSER))
#define UNITY_MUSIC_LENS_GENRE_FILTER_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_MUSIC_LENS_TYPE_GENRE_FILTER_PARSER, UnityMusicLensGenreFilterParserClass))

typedef struct _UnityMusicLensGenreFilterParser UnityMusicLensGenreFilterParser;
typedef struct _UnityMusicLensGenreFilterParserClass UnityMusicLensGenreFilterParserClass;

#define UNITY_MUSIC_LENS_TYPE_BANSHEE_GENRE_FILTER_PARSER (unity_music_lens_banshee_genre_filter_parser_get_type ())
#define UNITY_MUSIC_LENS_BANSHEE_GENRE_FILTER_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_MUSIC_LENS_TYPE_BANSHEE_GENRE_FILTER_PARSER, UnityMusicLensBansheeGenreFilterParser))
#define UNITY_MUSIC_LENS_BANSHEE_GENRE_FILTER_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_MUSIC_LENS_TYPE_BANSHEE_GENRE_FILTER_PARSER, UnityMusicLensBansheeGenreFilterParserClass))
#define UNITY_MUSIC_LENS_IS_BANSHEE_GENRE_FILTER_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_MUSIC_LENS_TYPE_BANSHEE_GENRE_FILTER_PARSER))
#define UNITY_MUSIC_LENS_IS_BANSHEE_GENRE_FILTER_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_MUSIC_LENS_TYPE_BANSHEE_GENRE_FILTER_PARSER))
#define UNITY_MUSIC_LENS_BANSHEE_GENRE_FILTER_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_MUSIC_LENS_TYPE_BANSHEE_GENRE_FILTER_PARSER, UnityMusicLensBansheeGenreFilterParserClass))

typedef struct _UnityMusicLensBansheeGenreFilterParser UnityMusicLensBansheeGenreFilterParser;
typedef struct _UnityMusicLensBansheeGenreFilterParserClass UnityMusicLensBansheeGenreFilterParserClass;

#define UNITY_MUSIC_LENS_TYPE_DECADE_FILTER_PARSER (unity_music_lens_decade_filter_parser_get_type ())
#define UNITY_MUSIC_LENS_DECADE_FILTER_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_MUSIC_LENS_TYPE_DECADE_FILTER_PARSER, UnityMusicLensDecadeFilterParser))
#define UNITY_MUSIC_LENS_DECADE_FILTER_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_MUSIC_LENS_TYPE_DECADE_FILTER_PARSER, UnityMusicLensDecadeFilterParserClass))
#define UNITY_MUSIC_LENS_IS_DECADE_FILTER_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_MUSIC_LENS_TYPE_DECADE_FILTER_PARSER))
#define UNITY_MUSIC_LENS_IS_DECADE_FILTER_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_MUSIC_LENS_TYPE_DECADE_FILTER_PARSER))
#define UNITY_MUSIC_LENS_DECADE_FILTER_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_MUSIC_LENS_TYPE_DECADE_FILTER_PARSER, UnityMusicLensDecadeFilterParserClass))

typedef struct _UnityMusicLensDecadeFilterParser UnityMusicLensDecadeFilterParser;
typedef struct _UnityMusicLensDecadeFilterParserClass UnityMusicLensDecadeFilterParserClass;

#define UNITY_MUSIC_LENS_TYPE_BANSHEE_DECADE_FILTER_PARSER (unity_music_lens_banshee_decade_filter_parser_get_type ())
#define UNITY_MUSIC_LENS_BANSHEE_DECADE_FILTER_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_MUSIC_LENS_TYPE_BANSHEE_DECADE_FILTER_PARSER, UnityMusicLensBansheeDecadeFilterParser))
#define UNITY_MUSIC_LENS_BANSHEE_DECADE_FILTER_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_MUSIC_LENS_TYPE_BANSHEE_DECADE_FILTER_PARSER, UnityMusicLensBansheeDecadeFilterParserClass))
#define UNITY_MUSIC_LENS_IS_BANSHEE_DECADE_FILTER_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_MUSIC_LENS_TYPE_BANSHEE_DECADE_FILTER_PARSER))
#define UNITY_MUSIC_LENS_IS_BANSHEE_DECADE_FILTER_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_MUSIC_LENS_TYPE_BANSHEE_DECADE_FILTER_PARSER))
#define UNITY_MUSIC_LENS_BANSHEE_DECADE_FILTER_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_MUSIC_LENS_TYPE_BANSHEE_DECADE_FILTER_PARSER, UnityMusicLensBansheeDecadeFilterParserClass))

typedef struct _UnityMusicLensBansheeDecadeFilterParser UnityMusicLensBansheeDecadeFilterParser;
typedef struct _UnityMusicLensBansheeDecadeFilterParserClass UnityMusicLensBansheeDecadeFilterParserClass;

typedef enum  {
	UNITY_MUSIC_LENS_DATABASE_ERROR_FAILED_TO_OPEN
} UnityMusicLensDatabaseError;
#define UNITY_MUSIC_LENS_DATABASE_ERROR unity_music_lens_database_error_quark ()
struct _UnityMusicLensBansheeCollection {
	GObject parent_instance;
	UnityMusicLensBansheeCollectionPrivate * priv;
};

struct _UnityMusicLensBansheeCollectionClass {
	GObjectClass parent_class;
};

struct _UnityMusicLensBansheeCollectionPrivate {
	sqlite3* db;
};

typedef enum  {
	UNITY_MUSIC_LENS_CATEGORY_SONGS,
	UNITY_MUSIC_LENS_CATEGORY_ALBUMS,
	UNITY_MUSIC_LENS_CATEGORY_PURCHASE,
	UNITY_MUSIC_LENS_CATEGORY_MUSIC
} UnityMusicLensCategory;

struct _UnityMusicLensBansheeFilterParserIface {
	GTypeInterface parent_iface;
};


static gpointer unity_music_lens_banshee_collection_parent_class = NULL;

GQuark unity_music_lens_database_error_quark (void);
GType unity_music_lens_banshee_collection_get_type (void) G_GNUC_CONST;
#define UNITY_MUSIC_LENS_BANSHEE_COLLECTION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), UNITY_MUSIC_LENS_TYPE_BANSHEE_COLLECTION, UnityMusicLensBansheeCollectionPrivate))
enum  {
	UNITY_MUSIC_LENS_BANSHEE_COLLECTION_DUMMY_PROPERTY
};
#define UNITY_MUSIC_LENS_BANSHEE_COLLECTION_MAX_RESULTS 100
UnityMusicLensBansheeCollection* unity_music_lens_banshee_collection_new (GError** error);
UnityMusicLensBansheeCollection* unity_music_lens_banshee_collection_construct (GType object_type, GError** error);
GType unity_music_lens_filter_parser_get_type (void) G_GNUC_CONST;
void unity_music_lens_banshee_collection_search (UnityMusicLensBansheeCollection* self, UnityLensSearch* search, UnitySearchType search_type, GList* filters, gint max_results, gint category_override);
static gchar* unity_music_lens_banshee_collection_build_sql_from_filters (UnityMusicLensBansheeCollection* self, GList* filters);
static gint unity_music_lens_banshee_collection_execute_sql (UnityMusicLensBansheeCollection* self, const gchar* sql, sqlite3_stmt** stmt);
UnityMusicLensTrack* unity_music_lens_track_new (void);
UnityMusicLensTrack* unity_music_lens_track_construct (GType object_type);
GType unity_music_lens_track_get_type (void) G_GNUC_CONST;
void unity_music_lens_track_set_title (UnityMusicLensTrack* self, const gchar* value);
void unity_music_lens_track_set_artist (UnityMusicLensTrack* self, const gchar* value);
void unity_music_lens_track_set_uri (UnityMusicLensTrack* self, const gchar* value);
void unity_music_lens_track_set_mime_type (UnityMusicLensTrack* self, const gchar* value);
void unity_music_lens_track_set_artwork_path (UnityMusicLensTrack* self, const gchar* value);
UnityMusicLensAlbum* unity_music_lens_album_new (void);
UnityMusicLensAlbum* unity_music_lens_album_construct (GType object_type);
GType unity_music_lens_album_get_type (void) G_GNUC_CONST;
void unity_music_lens_album_set_title (UnityMusicLensAlbum* self, const gchar* value);
void unity_music_lens_album_set_artist (UnityMusicLensAlbum* self, const gchar* value);
const gchar* unity_music_lens_album_get_artist (UnityMusicLensAlbum* self);
const gchar* unity_music_lens_album_get_title (UnityMusicLensAlbum* self);
void unity_music_lens_album_set_uri (UnityMusicLensAlbum* self, const gchar* value);
void unity_music_lens_album_set_artwork_path (UnityMusicLensAlbum* self, const gchar* value);
GType unity_music_lens_category_get_type (void) G_GNUC_CONST;
const gchar* unity_music_lens_track_get_uri (UnityMusicLensTrack* self);
const gchar* unity_music_lens_track_get_artwork_path (UnityMusicLensTrack* self);
const gchar* unity_music_lens_track_get_mime_type (UnityMusicLensTrack* self);
const gchar* unity_music_lens_track_get_title (UnityMusicLensTrack* self);
const gchar* unity_music_lens_track_get_artist (UnityMusicLensTrack* self);
gchar** unity_music_lens_banshee_collection_get_track_uris (UnityMusicLensBansheeCollection* self, UnityMusicLensAlbum* album, int* result_length1);
const gchar* unity_music_lens_album_get_uri (UnityMusicLensAlbum* self);
const gchar* unity_music_lens_album_get_artwork_path (UnityMusicLensAlbum* self);
GType unity_music_lens_banshee_filter_parser_get_type (void) G_GNUC_CONST;
GType unity_music_lens_genre_filter_parser_get_type (void) G_GNUC_CONST;
UnityMusicLensBansheeGenreFilterParser* unity_music_lens_banshee_genre_filter_parser_new (UnityMusicLensGenreFilterParser* parser);
UnityMusicLensBansheeGenreFilterParser* unity_music_lens_banshee_genre_filter_parser_construct (GType object_type, UnityMusicLensGenreFilterParser* parser);
GType unity_music_lens_banshee_genre_filter_parser_get_type (void) G_GNUC_CONST;
GType unity_music_lens_decade_filter_parser_get_type (void) G_GNUC_CONST;
UnityMusicLensBansheeDecadeFilterParser* unity_music_lens_banshee_decade_filter_parser_new (UnityMusicLensDecadeFilterParser* parser);
UnityMusicLensBansheeDecadeFilterParser* unity_music_lens_banshee_decade_filter_parser_construct (GType object_type, UnityMusicLensDecadeFilterParser* parser);
GType unity_music_lens_banshee_decade_filter_parser_get_type (void) G_GNUC_CONST;
gchar* unity_music_lens_filter_parser_parse (UnityMusicLensFilterParser* self);
static void unity_music_lens_banshee_collection_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


GQuark unity_music_lens_database_error_quark (void) {
	return g_quark_from_static_string ("unity_music_lens_database_error-quark");
}


UnityMusicLensBansheeCollection* unity_music_lens_banshee_collection_construct (GType object_type, GError** error) {
	UnityMusicLensBansheeCollection * self = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	sqlite3* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_;
	gint rc;
	gint _tmp6_;
	GError * _inner_error_ = NULL;
	self = (UnityMusicLensBansheeCollection*) g_object_new (object_type, NULL);
	_tmp0_ = g_get_user_config_dir ();
	_tmp1_ = g_strdup_printf ("%s/banshee-1/banshee.db", _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp4_ = sqlite3_open (_tmp2_, &_tmp3_);
	_sqlite3_close0 (self->priv->db);
	self->priv->db = _tmp3_;
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp2_);
	rc = _tmp5_;
	_tmp6_ = rc;
	if (_tmp6_ != SQLITE_OK) {
		gint _tmp7_;
		sqlite3* _tmp8_;
		const gchar* _tmp9_ = NULL;
		GError* _tmp10_;
		_tmp7_ = rc;
		_tmp8_ = self->priv->db;
		_tmp9_ = sqlite3_errmsg (_tmp8_);
		g_printerr ("failed to open db, %d, %s\n", _tmp7_, _tmp9_);
		_tmp10_ = g_error_new_literal (UNITY_MUSIC_LENS_DATABASE_ERROR, UNITY_MUSIC_LENS_DATABASE_ERROR_FAILED_TO_OPEN, "Failed to open banshee database");
		_inner_error_ = _tmp10_;
		if (_inner_error_->domain == UNITY_MUSIC_LENS_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	return self;
}


UnityMusicLensBansheeCollection* unity_music_lens_banshee_collection_new (GError** error) {
	return unity_music_lens_banshee_collection_construct (UNITY_MUSIC_LENS_TYPE_BANSHEE_COLLECTION, error);
}


/**
     * Performs a search on the banshee db
     */
static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void unity_music_lens_banshee_collection_search (UnityMusicLensBansheeCollection* self, UnityLensSearch* search, UnitySearchType search_type, GList* filters, gint max_results, gint category_override) {
	static const gint TRACK_TITLE = 0;
	static const gint TRACK_URI = 1;
	static const gint TRACK_MIMETYPE = 2;
	static const gint ALBUM_TITLE = 3;
	static const gint ALBUM_ARTWORKID = 4;
	static const gint ARTIST_NAME = 5;
	gint rc;
	sqlite3_stmt* stmt = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* album_art_dir;
	UnityLensSearch* _tmp2_;
	DeeSerializableModel* _tmp3_;
	DeeSerializableModel* _tmp4_;
	DeeSerializableModel* _tmp5_;
	DeeSerializableModel* results_model;
	DeeSerializableModel* _tmp6_;
	DeeSerializableModel* _tmp7_;
	DeeSerializableModel* helper_model;
	gint _tmp8_;
	GeeTreeSet* _tmp14_;
	GeeTreeSet* albums;
	GList* _tmp15_;
	gchar* _tmp16_ = NULL;
	gchar* filters_sql;
	gint _tmp17_ = 0;
	gint _tmp18_;
	UnityLensSearch* _tmp20_;
	const gchar* _tmp21_;
	const gchar* _tmp22_;
	UnityLensSearch* _tmp23_;
	const gchar* _tmp24_;
	const gchar* _tmp25_;
	UnityLensSearch* _tmp26_;
	const gchar* _tmp27_;
	const gchar* _tmp28_;
	const gchar* _tmp29_;
	gint _tmp30_;
	gchar* _tmp31_ = NULL;
	gchar* sql;
	const gchar* _tmp32_;
	sqlite3_stmt* _tmp33_ = NULL;
	gint _tmp34_ = 0;
	sqlite3_stmt* _tmp35_;
	DeeSerializableModel* _tmp144_;
	DeeSerializableModel* _tmp145_;
	DeeSerializableModel* _tmp146_;
	DeeModelIter* _tmp147_ = NULL;
	DeeModelIter* iter;
	DeeSerializableModel* _tmp148_;
	DeeModelIter* _tmp149_ = NULL;
	DeeModelIter* last;
	g_return_if_fail (self != NULL);
	g_return_if_fail (search != NULL);
	rc = 0;
	_tmp0_ = g_get_user_cache_dir ();
	_tmp1_ = g_strdup_printf ("%s/media-art/", _tmp0_);
	album_art_dir = _tmp1_;
	_tmp2_ = search;
	_tmp3_ = unity_lens_search_get_results_model (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	results_model = _tmp5_;
	_tmp6_ = results_model;
	_tmp7_ = _g_object_ref0 (_tmp6_);
	helper_model = _tmp7_;
	_tmp8_ = category_override;
	if (_tmp8_ >= 0) {
		DeeSequenceModel* _tmp9_;
		DeeSerializableModel* _tmp10_;
		DeeSerializableModel* _tmp11_;
		guint _tmp12_;
		gchar** _tmp13_ = NULL;
		_tmp9_ = (DeeSequenceModel*) dee_sequence_model_new ();
		_g_object_unref0 (helper_model);
		helper_model = (DeeSerializableModel*) _tmp9_;
		_tmp10_ = helper_model;
		_tmp11_ = results_model;
		_tmp13_ = dee_model_get_schema ((DeeModel*) _tmp11_, &_tmp12_);
		dee_model_set_schema_full ((DeeModel*) _tmp10_, _tmp13_, (guint) _tmp12_);
	}
	_tmp14_ = gee_tree_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
	albums = _tmp14_;
	_tmp15_ = filters;
	_tmp16_ = unity_music_lens_banshee_collection_build_sql_from_filters (self, _tmp15_);
	filters_sql = _tmp16_;
	_tmp18_ = max_results;
	if (_tmp18_ == (-1)) {
		_tmp17_ = UNITY_MUSIC_LENS_BANSHEE_COLLECTION_MAX_RESULTS;
	} else {
		gint _tmp19_;
		_tmp19_ = max_results;
		_tmp17_ = _tmp19_;
	}
	_tmp20_ = search;
	_tmp21_ = unity_lens_search_get_search_string (_tmp20_);
	_tmp22_ = _tmp21_;
	_tmp23_ = search;
	_tmp24_ = unity_lens_search_get_search_string (_tmp23_);
	_tmp25_ = _tmp24_;
	_tmp26_ = search;
	_tmp27_ = unity_lens_search_get_search_string (_tmp26_);
	_tmp28_ = _tmp27_;
	_tmp29_ = filters_sql;
	_tmp30_ = _tmp17_;
	_tmp31_ = g_strdup_printf ("SELECT CoreTracks.Title, CoreTracks.Uri, CoreTracks.MimeType, CoreAlbu" \
"ms.Title, CoreAlbums.ArtworkID, CoreArtists.Name                      " \
"FROM CoreTracks \n" \
"                      CROSS JOIN CoreArtists, CoreAlbums \n" \
"                      WHERE CoreArtists.ArtistID = CoreTracks.ArtistID" \
" \n" \
"                                                   AND CoreAlbums.Albu" \
"mID = CoreTracks.AlbumID \n" \
"                                                   AND CoreTracks.Prim" \
"arySourceID = 1 \n" \
"\t\t\t\t\t\t   AND ((CoreArtists.NameLowered LIKE '%%%s%%' ESCAPE '\\'" \
" \n" \
"\t\t\t\t\t\t  \t AND CoreArtists.NameLowered IS NOT NULL) \n" \
"\t\t\t\t\t\t        OR (CoreAlbums.TitleLowered LIKE '%%%s%%' ESCAPE '" \
"\\' \n" \
"\t\t\t\t\t\t  \t    AND CoreAlbums.TitleLowered IS NOT NULL) \n" \
"\t\t\t\t\t\t  \tOR (CoreTracks.TitleLowered LIKE '%%%s%%' ESCAPE '\\' " \
"\n" \
"\t\t\t\t\t\t  \t    AND CoreTracks.TitleLowered IS NOT NULL)\n" \
"                                                       )\n" \
"                                 %s\n" \
"                      ORDER BY CoreTracks.Score DESC\n" \
"                      LIMIT 0, %d;", _tmp22_, _tmp25_, _tmp28_, _tmp29_, _tmp30_);
	sql = _tmp31_;
	_tmp32_ = sql;
	_tmp34_ = unity_music_lens_banshee_collection_execute_sql (self, _tmp32_, &_tmp33_);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp33_;
	rc = _tmp34_;
	_tmp35_ = stmt;
	if (_tmp35_ == NULL) {
		_g_free0 (sql);
		_g_free0 (filters_sql);
		_g_object_unref0 (albums);
		_g_object_unref0 (helper_model);
		_g_object_unref0 (results_model);
		_g_free0 (album_art_dir);
		_sqlite3_finalize0 (stmt);
		return;
	}
	{
		gboolean _tmp36_;
		_tmp36_ = TRUE;
		while (TRUE) {
			gboolean _tmp37_;
			sqlite3_stmt* _tmp39_;
			gint _tmp40_ = 0;
			gint _tmp41_;
			_tmp37_ = _tmp36_;
			if (!_tmp37_) {
				gint _tmp38_;
				_tmp38_ = rc;
				if (!(_tmp38_ == SQLITE_ROW)) {
					break;
				}
			}
			_tmp36_ = FALSE;
			_tmp39_ = stmt;
			_tmp40_ = sqlite3_step (_tmp39_);
			rc = _tmp40_;
			_tmp41_ = rc;
			switch (_tmp41_) {
				case SQLITE_DONE:
				{
					break;
				}
				case SQLITE_ROW:
				{
					const gchar* _tmp42_;
					sqlite3_stmt* _tmp43_;
					const gchar* _tmp44_ = NULL;
					gchar* _tmp45_ = NULL;
					gchar* artwork_path;
					const gchar* _tmp46_;
					GFile* _tmp47_ = NULL;
					GFile* artwork_file;
					GFile* _tmp48_;
					gboolean _tmp49_ = FALSE;
					UnityMusicLensTrack* _tmp51_;
					UnityMusicLensTrack* track;
					UnityMusicLensTrack* _tmp52_;
					sqlite3_stmt* _tmp53_;
					const gchar* _tmp54_ = NULL;
					UnityMusicLensTrack* _tmp55_;
					sqlite3_stmt* _tmp56_;
					const gchar* _tmp57_ = NULL;
					UnityMusicLensTrack* _tmp58_;
					sqlite3_stmt* _tmp59_;
					const gchar* _tmp60_ = NULL;
					UnityMusicLensTrack* _tmp61_;
					sqlite3_stmt* _tmp62_;
					const gchar* _tmp63_ = NULL;
					UnityMusicLensTrack* _tmp64_;
					const gchar* _tmp65_;
					UnityMusicLensAlbum* _tmp66_;
					UnityMusicLensAlbum* album;
					UnityMusicLensAlbum* _tmp67_;
					sqlite3_stmt* _tmp68_;
					const gchar* _tmp69_ = NULL;
					UnityMusicLensAlbum* _tmp70_;
					sqlite3_stmt* _tmp71_;
					const gchar* _tmp72_ = NULL;
					UnityMusicLensAlbum* _tmp73_;
					UnityMusicLensAlbum* _tmp74_;
					const gchar* _tmp75_;
					const gchar* _tmp76_;
					UnityMusicLensAlbum* _tmp77_;
					const gchar* _tmp78_;
					const gchar* _tmp79_;
					gchar* _tmp80_ = NULL;
					gchar* _tmp81_;
					UnityMusicLensAlbum* _tmp82_;
					const gchar* _tmp83_;
					guint category_id;
					gint _tmp84_;
					DeeSerializableModel* _tmp86_;
					UnityMusicLensTrack* _tmp87_;
					const gchar* _tmp88_;
					const gchar* _tmp89_;
					UnityMusicLensTrack* _tmp90_;
					const gchar* _tmp91_;
					const gchar* _tmp92_;
					guint _tmp93_;
					UnityMusicLensTrack* _tmp94_;
					const gchar* _tmp95_;
					const gchar* _tmp96_;
					UnityMusicLensTrack* _tmp97_;
					const gchar* _tmp98_;
					const gchar* _tmp99_;
					UnityMusicLensTrack* _tmp100_;
					const gchar* _tmp101_;
					const gchar* _tmp102_;
					UnityMusicLensTrack* _tmp103_;
					const gchar* _tmp104_;
					const gchar* _tmp105_;
					GeeTreeSet* _tmp106_;
					UnityMusicLensAlbum* _tmp107_;
					const gchar* _tmp108_;
					const gchar* _tmp109_;
					UnityMusicLensAlbum* _tmp110_;
					const gchar* _tmp111_;
					const gchar* _tmp112_;
					gchar* _tmp113_;
					gchar* _tmp114_;
					gboolean _tmp115_ = FALSE;
					gboolean _tmp116_;
					_tmp42_ = album_art_dir;
					_tmp43_ = stmt;
					_tmp44_ = sqlite3_column_text (_tmp43_, ALBUM_ARTWORKID);
					_tmp45_ = g_strdup_printf ("%s/%s.jpg", _tmp42_, _tmp44_);
					artwork_path = _tmp45_;
					_tmp46_ = artwork_path;
					_tmp47_ = g_file_new_for_path (_tmp46_);
					artwork_file = _tmp47_;
					_tmp48_ = artwork_file;
					_tmp49_ = g_file_query_exists (_tmp48_, NULL);
					if (!_tmp49_) {
						gchar* _tmp50_;
						_tmp50_ = g_strdup ("audio-x-generic");
						_g_free0 (artwork_path);
						artwork_path = _tmp50_;
					}
					_tmp51_ = unity_music_lens_track_new ();
					track = _tmp51_;
					_tmp52_ = track;
					_tmp53_ = stmt;
					_tmp54_ = sqlite3_column_text (_tmp53_, TRACK_TITLE);
					unity_music_lens_track_set_title (_tmp52_, _tmp54_);
					_tmp55_ = track;
					_tmp56_ = stmt;
					_tmp57_ = sqlite3_column_text (_tmp56_, ARTIST_NAME);
					unity_music_lens_track_set_artist (_tmp55_, _tmp57_);
					_tmp58_ = track;
					_tmp59_ = stmt;
					_tmp60_ = sqlite3_column_text (_tmp59_, TRACK_URI);
					unity_music_lens_track_set_uri (_tmp58_, _tmp60_);
					_tmp61_ = track;
					_tmp62_ = stmt;
					_tmp63_ = sqlite3_column_text (_tmp62_, TRACK_MIMETYPE);
					unity_music_lens_track_set_mime_type (_tmp61_, _tmp63_);
					_tmp64_ = track;
					_tmp65_ = artwork_path;
					unity_music_lens_track_set_artwork_path (_tmp64_, _tmp65_);
					_tmp66_ = unity_music_lens_album_new ();
					album = _tmp66_;
					_tmp67_ = album;
					_tmp68_ = stmt;
					_tmp69_ = sqlite3_column_text (_tmp68_, ALBUM_TITLE);
					unity_music_lens_album_set_title (_tmp67_, _tmp69_);
					_tmp70_ = album;
					_tmp71_ = stmt;
					_tmp72_ = sqlite3_column_text (_tmp71_, ARTIST_NAME);
					unity_music_lens_album_set_artist (_tmp70_, _tmp72_);
					_tmp73_ = album;
					_tmp74_ = album;
					_tmp75_ = unity_music_lens_album_get_artist (_tmp74_);
					_tmp76_ = _tmp75_;
					_tmp77_ = album;
					_tmp78_ = unity_music_lens_album_get_title (_tmp77_);
					_tmp79_ = _tmp78_;
					_tmp80_ = g_strdup_printf ("album://%s/%s", _tmp76_, _tmp79_);
					_tmp81_ = _tmp80_;
					unity_music_lens_album_set_uri (_tmp73_, _tmp81_);
					_g_free0 (_tmp81_);
					_tmp82_ = album;
					_tmp83_ = artwork_path;
					unity_music_lens_album_set_artwork_path (_tmp82_, _tmp83_);
					category_id = (guint) UNITY_MUSIC_LENS_CATEGORY_SONGS;
					_tmp84_ = category_override;
					if (_tmp84_ >= 0) {
						gint _tmp85_;
						_tmp85_ = category_override;
						category_id = (guint) _tmp85_;
					}
					_tmp86_ = helper_model;
					_tmp87_ = track;
					_tmp88_ = unity_music_lens_track_get_uri (_tmp87_);
					_tmp89_ = _tmp88_;
					_tmp90_ = track;
					_tmp91_ = unity_music_lens_track_get_artwork_path (_tmp90_);
					_tmp92_ = _tmp91_;
					_tmp93_ = category_id;
					_tmp94_ = track;
					_tmp95_ = unity_music_lens_track_get_mime_type (_tmp94_);
					_tmp96_ = _tmp95_;
					_tmp97_ = track;
					_tmp98_ = unity_music_lens_track_get_title (_tmp97_);
					_tmp99_ = _tmp98_;
					_tmp100_ = track;
					_tmp101_ = unity_music_lens_track_get_artist (_tmp100_);
					_tmp102_ = _tmp101_;
					_tmp103_ = track;
					_tmp104_ = unity_music_lens_track_get_uri (_tmp103_);
					_tmp105_ = _tmp104_;
					dee_model_append ((DeeModel*) _tmp86_, _tmp89_, _tmp92_, _tmp93_, _tmp96_, _tmp99_, _tmp102_, _tmp105_, NULL);
					_tmp106_ = albums;
					_tmp107_ = album;
					_tmp108_ = unity_music_lens_album_get_artist (_tmp107_);
					_tmp109_ = _tmp108_;
					_tmp110_ = album;
					_tmp111_ = unity_music_lens_album_get_title (_tmp110_);
					_tmp112_ = _tmp111_;
					_tmp113_ = g_strconcat (_tmp109_, _tmp112_, NULL);
					_tmp114_ = _tmp113_;
					_tmp115_ = gee_abstract_collection_add ((GeeAbstractCollection*) _tmp106_, _tmp114_);
					_tmp116_ = _tmp115_;
					_g_free0 (_tmp114_);
					if (_tmp116_) {
						GString* _tmp117_;
						GString* uri_list_builder;
						UnityMusicLensAlbum* _tmp118_;
						gint _tmp119_ = 0;
						gchar** _tmp120_ = NULL;
						gint _tmp126_;
						DeeSerializableModel* _tmp128_;
						UnityMusicLensAlbum* _tmp129_;
						const gchar* _tmp130_;
						const gchar* _tmp131_;
						UnityMusicLensAlbum* _tmp132_;
						const gchar* _tmp133_;
						const gchar* _tmp134_;
						guint _tmp135_;
						UnityMusicLensAlbum* _tmp136_;
						const gchar* _tmp137_;
						const gchar* _tmp138_;
						UnityMusicLensAlbum* _tmp139_;
						const gchar* _tmp140_;
						const gchar* _tmp141_;
						GString* _tmp142_;
						const gchar* _tmp143_;
						_tmp117_ = g_string_new ("");
						uri_list_builder = _tmp117_;
						_tmp118_ = album;
						_tmp120_ = unity_music_lens_banshee_collection_get_track_uris (self, _tmp118_, &_tmp119_);
						{
							gchar** uri_collection = NULL;
							gint uri_collection_length1 = 0;
							gint _uri_collection_size_ = 0;
							gint uri_it = 0;
							uri_collection = _tmp120_;
							uri_collection_length1 = _tmp119_;
							for (uri_it = 0; uri_it < _tmp119_; uri_it = uri_it + 1) {
								gchar* _tmp121_;
								gchar* uri = NULL;
								_tmp121_ = g_strdup (uri_collection[uri_it]);
								uri = _tmp121_;
								{
									GString* _tmp122_;
									GString* _tmp123_;
									const gchar* _tmp124_;
									GString* _tmp125_;
									_tmp122_ = uri_list_builder;
									g_string_append (_tmp122_, "'");
									_tmp123_ = uri_list_builder;
									_tmp124_ = uri;
									g_string_append (_tmp123_, _tmp124_);
									_tmp125_ = uri_list_builder;
									g_string_append (_tmp125_, "' ");
									_g_free0 (uri);
								}
							}
							uri_collection = (_vala_array_free (uri_collection, uri_collection_length1, (GDestroyNotify) g_free), NULL);
						}
						category_id = (guint) UNITY_MUSIC_LENS_CATEGORY_ALBUMS;
						_tmp126_ = category_override;
						if (_tmp126_ >= 0) {
							gint _tmp127_;
							_tmp127_ = category_override;
							category_id = (guint) _tmp127_;
						}
						_tmp128_ = results_model;
						_tmp129_ = album;
						_tmp130_ = unity_music_lens_album_get_uri (_tmp129_);
						_tmp131_ = _tmp130_;
						_tmp132_ = album;
						_tmp133_ = unity_music_lens_album_get_artwork_path (_tmp132_);
						_tmp134_ = _tmp133_;
						_tmp135_ = category_id;
						_tmp136_ = album;
						_tmp137_ = unity_music_lens_album_get_title (_tmp136_);
						_tmp138_ = _tmp137_;
						_tmp139_ = album;
						_tmp140_ = unity_music_lens_album_get_artist (_tmp139_);
						_tmp141_ = _tmp140_;
						_tmp142_ = uri_list_builder;
						_tmp143_ = _tmp142_->str;
						dee_model_append ((DeeModel*) _tmp128_, _tmp131_, _tmp134_, _tmp135_, "audio/mp3", _tmp138_, _tmp141_, _tmp143_, NULL);
						_g_string_free0 (uri_list_builder);
					}
					_g_object_unref0 (album);
					_g_object_unref0 (track);
					_g_object_unref0 (artwork_file);
					_g_free0 (artwork_path);
					break;
				}
				default:
				{
					break;
				}
			}
		}
	}
	_tmp144_ = helper_model;
	_tmp145_ = results_model;
	if (_tmp144_ == _tmp145_) {
		_g_free0 (sql);
		_g_free0 (filters_sql);
		_g_object_unref0 (albums);
		_g_object_unref0 (helper_model);
		_g_object_unref0 (results_model);
		_g_free0 (album_art_dir);
		_sqlite3_finalize0 (stmt);
		return;
	}
	_tmp146_ = helper_model;
	_tmp147_ = dee_model_get_first_iter ((DeeModel*) _tmp146_);
	iter = _tmp147_;
	_tmp148_ = helper_model;
	_tmp149_ = dee_model_get_last_iter ((DeeModel*) _tmp148_);
	last = _tmp149_;
	while (TRUE) {
		DeeModelIter* _tmp150_;
		DeeModelIter* _tmp151_;
		DeeSerializableModel* _tmp152_;
		DeeModelIter* _tmp153_;
		GVariant** _tmp154_;
		GVariant** _tmp155_ = NULL;
		GVariant** row;
		gint row_length1;
		gint _row_size_;
		DeeSerializableModel* _tmp156_;
		GVariant** _tmp157_;
		gint _tmp157__length1;
		DeeSerializableModel* _tmp158_;
		DeeModelIter* _tmp159_;
		DeeModelIter* _tmp160_ = NULL;
		_tmp150_ = iter;
		_tmp151_ = last;
		if (!(_tmp150_ != _tmp151_)) {
			break;
		}
		_tmp152_ = helper_model;
		_tmp153_ = iter;
		_tmp155_ = _tmp154_ = dee_model_get_row ((DeeModel*) _tmp152_, _tmp153_, NULL);
		row = _tmp155_;
		row_length1 = _vala_array_length (_tmp154_);
		_row_size_ = row_length1;
		_tmp156_ = results_model;
		_tmp157_ = row;
		_tmp157__length1 = row_length1;
		dee_model_append_row ((DeeModel*) _tmp156_, _tmp157_);
		_tmp158_ = helper_model;
		_tmp159_ = iter;
		_tmp160_ = dee_model_next ((DeeModel*) _tmp158_, _tmp159_);
		iter = _tmp160_;
		row = (_vala_array_free (row, row_length1, (GDestroyNotify) g_variant_unref), NULL);
	}
	_g_free0 (sql);
	_g_free0 (filters_sql);
	_g_object_unref0 (albums);
	_g_object_unref0 (helper_model);
	_g_object_unref0 (results_model);
	_g_free0 (album_art_dir);
	_sqlite3_finalize0 (stmt);
}


/**
     * returns an array like {uri://, uri://, ...}
     */
gchar** unity_music_lens_banshee_collection_get_track_uris (UnityMusicLensBansheeCollection* self, UnityMusicLensAlbum* album, int* result_length1) {
	gchar** result = NULL;
	static const gint URI_COLUMN = 0;
	gint rc = 0;
	sqlite3_stmt* stmt = NULL;
	UnityMusicLensAlbum* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	UnityMusicLensAlbum* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* sql;
	const gchar* _tmp7_;
	sqlite3_stmt* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	GeeArrayList* _tmp10_;
	GeeArrayList* uris;
	GeeArrayList* _tmp20_;
	gint _tmp21_ = 0;
	gpointer* _tmp22_ = NULL;
	gchar** _tmp23_;
	gint _tmp23__length1;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (album != NULL, NULL);
	_tmp0_ = album;
	_tmp1_ = unity_music_lens_album_get_title (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = album;
	_tmp4_ = unity_music_lens_album_get_artist (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strdup_printf ("SELECT CoreTracks.Uri \n" \
"                    FROM CoreTracks \n" \
"                    CROSS JOIN CoreAlbums, CoreArtists \n" \
"                    WHERE CoreArtists.ArtistID = CoreTracks.ArtistID \n" \
"                          AND CoreAlbums.AlbumID = CoreTracks.AlbumID " \
"\n" \
"                          AND CoreAlbums.Title IS '%s'\n" \
"                          AND CoreArtists.Name IS '%s'\n" \
"                          AND CoreTracks.URI IS NOT NULL\n" \
"                    ORDER BY CoreTracks.TrackNumber ASC", _tmp2_, _tmp5_);
	sql = _tmp6_;
	_tmp7_ = sql;
	_tmp9_ = unity_music_lens_banshee_collection_execute_sql (self, _tmp7_, &_tmp8_);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp8_;
	rc = _tmp9_;
	_tmp10_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
	uris = _tmp10_;
	{
		gboolean _tmp11_;
		_tmp11_ = TRUE;
		while (TRUE) {
			gboolean _tmp12_;
			sqlite3_stmt* _tmp14_;
			gint _tmp15_ = 0;
			gint _tmp16_;
			_tmp12_ = _tmp11_;
			if (!_tmp12_) {
				gint _tmp13_;
				_tmp13_ = rc;
				if (!(_tmp13_ == SQLITE_ROW)) {
					break;
				}
			}
			_tmp11_ = FALSE;
			_tmp14_ = stmt;
			_tmp15_ = sqlite3_step (_tmp14_);
			rc = _tmp15_;
			_tmp16_ = rc;
			switch (_tmp16_) {
				case SQLITE_DONE:
				{
					break;
				}
				case SQLITE_ROW:
				{
					GeeArrayList* _tmp17_;
					sqlite3_stmt* _tmp18_;
					const gchar* _tmp19_ = NULL;
					_tmp17_ = uris;
					_tmp18_ = stmt;
					_tmp19_ = sqlite3_column_text (_tmp18_, URI_COLUMN);
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp17_, _tmp19_);
					break;
				}
				default:
				{
					break;
				}
			}
		}
	}
	_tmp20_ = uris;
	_tmp22_ = gee_abstract_collection_to_array ((GeeAbstractCollection*) _tmp20_, &_tmp21_);
	_tmp23_ = _tmp22_;
	_tmp23__length1 = _tmp21_;
	if (result_length1) {
		*result_length1 = _tmp23__length1;
	}
	result = _tmp23_;
	_g_object_unref0 (uris);
	_g_free0 (sql);
	_sqlite3_finalize0 (stmt);
	return result;
}


/**
     * returns a string like "AND (Table.Column IS filter OR Table.OtherCol IS filter2) 
     * AND (Table.OtherColAgain IS AnotherFilter)" 
     */
static gchar* unity_music_lens_banshee_collection_build_sql_from_filters (UnityMusicLensBansheeCollection* self, GList* filters) {
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	GList* _tmp1_;
	gboolean _tmp4_;
	GString* _tmp6_;
	GString* builder;
	GList* _tmp7_;
	GString* _tmp24_;
	GString* _tmp25_;
	const gchar* _tmp26_;
	gchar* _tmp27_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = filters;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		GList* _tmp2_;
		guint _tmp3_ = 0U;
		_tmp2_ = filters;
		_tmp3_ = g_list_length (_tmp2_);
		_tmp0_ = _tmp3_ == ((guint) 0);
	}
	_tmp4_ = _tmp0_;
	if (_tmp4_) {
		gchar* _tmp5_;
		_tmp5_ = g_strdup ("");
		result = _tmp5_;
		return result;
	}
	_tmp6_ = g_string_new ("");
	builder = _tmp6_;
	_tmp7_ = filters;
	{
		GList* parser_collection = NULL;
		GList* parser_it = NULL;
		parser_collection = _tmp7_;
		for (parser_it = parser_collection; parser_it != NULL; parser_it = parser_it->next) {
			UnityMusicLensFilterParser* _tmp8_;
			UnityMusicLensFilterParser* parser = NULL;
			_tmp8_ = _g_object_ref0 ((UnityMusicLensFilterParser*) parser_it->data);
			parser = _tmp8_;
			{
				UnityMusicLensBansheeFilterParser* bparser = NULL;
				UnityMusicLensFilterParser* _tmp9_;
				UnityMusicLensBansheeFilterParser* _tmp15_;
				gchar* _tmp16_ = NULL;
				gchar* parsed;
				gboolean _tmp17_ = FALSE;
				const gchar* _tmp18_;
				gboolean _tmp20_;
				GString* _tmp21_;
				GString* _tmp22_;
				const gchar* _tmp23_;
				_tmp9_ = parser;
				if (UNITY_MUSIC_LENS_IS_GENRE_FILTER_PARSER (_tmp9_)) {
					UnityMusicLensFilterParser* _tmp10_;
					UnityMusicLensBansheeGenreFilterParser* _tmp11_;
					_tmp10_ = parser;
					_tmp11_ = unity_music_lens_banshee_genre_filter_parser_new (UNITY_MUSIC_LENS_IS_GENRE_FILTER_PARSER (_tmp10_) ? ((UnityMusicLensGenreFilterParser*) _tmp10_) : NULL);
					_g_object_unref0 (bparser);
					bparser = (UnityMusicLensBansheeFilterParser*) _tmp11_;
				} else {
					UnityMusicLensFilterParser* _tmp12_;
					_tmp12_ = parser;
					if (UNITY_MUSIC_LENS_IS_DECADE_FILTER_PARSER (_tmp12_)) {
						UnityMusicLensFilterParser* _tmp13_;
						UnityMusicLensBansheeDecadeFilterParser* _tmp14_;
						_tmp13_ = parser;
						_tmp14_ = unity_music_lens_banshee_decade_filter_parser_new (UNITY_MUSIC_LENS_IS_DECADE_FILTER_PARSER (_tmp13_) ? ((UnityMusicLensDecadeFilterParser*) _tmp13_) : NULL);
						_g_object_unref0 (bparser);
						bparser = (UnityMusicLensBansheeFilterParser*) _tmp14_;
					} else {
						g_warning ("banshee-collection.vala:236: Recieved an unimplemented filter type");
						_g_object_unref0 (bparser);
						_g_object_unref0 (parser);
						continue;
					}
				}
				_tmp15_ = bparser;
				_tmp16_ = unity_music_lens_filter_parser_parse ((UnityMusicLensFilterParser*) _tmp15_);
				parsed = _tmp16_;
				_tmp18_ = parsed;
				if (_tmp18_ == NULL) {
					_tmp17_ = TRUE;
				} else {
					const gchar* _tmp19_;
					_tmp19_ = parsed;
					_tmp17_ = g_strcmp0 (_tmp19_, "") == 0;
				}
				_tmp20_ = _tmp17_;
				if (_tmp20_) {
					_g_free0 (parsed);
					_g_object_unref0 (bparser);
					_g_object_unref0 (parser);
					continue;
				}
				_tmp21_ = builder;
				g_string_append (_tmp21_, " AND ");
				_tmp22_ = builder;
				_tmp23_ = parsed;
				g_string_append (_tmp22_, _tmp23_);
				_g_free0 (parsed);
				_g_object_unref0 (bparser);
				_g_object_unref0 (parser);
			}
		}
	}
	_tmp24_ = builder;
	g_string_append (_tmp24_, " ");
	_tmp25_ = builder;
	_tmp26_ = _tmp25_->str;
	_tmp27_ = g_strdup (_tmp26_);
	result = _tmp27_;
	_g_string_free0 (builder);
	return result;
}


static gint unity_music_lens_banshee_collection_execute_sql (UnityMusicLensBansheeCollection* self, const gchar* sql, sqlite3_stmt** stmt) {
	sqlite3_stmt* _vala_stmt = NULL;
	gint result = 0;
	gint rc = 0;
	const gchar* _tmp0_;
	sqlite3* _tmp1_;
	const gchar* _tmp2_;
	sqlite3_stmt* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (sql != NULL, 0);
	_tmp0_ = sql;
	g_debug ("banshee-collection.vala:256: preparing to execute sql %s\n", _tmp0_);
	_tmp1_ = self->priv->db;
	_tmp2_ = sql;
	_tmp4_ = sqlite3_prepare_v2 (_tmp1_, _tmp2_, -1, &_tmp3_, NULL);
	_sqlite3_finalize0 (_vala_stmt);
	_vala_stmt = _tmp3_;
	rc = _tmp4_;
	_tmp5_ = rc;
	if (_tmp5_ == 1) {
		gint _tmp6_;
		sqlite3* _tmp7_;
		const gchar* _tmp8_ = NULL;
		_tmp6_ = rc;
		_tmp7_ = self->priv->db;
		_tmp8_ = sqlite3_errmsg (_tmp7_);
		g_warning ("banshee-collection.vala:260: SQL Error: %d, %s\n", _tmp6_, _tmp8_);
	}
	result = rc;
	if (stmt) {
		*stmt = _vala_stmt;
	} else {
		_sqlite3_finalize0 (_vala_stmt);
	}
	return result;
}


static void unity_music_lens_banshee_collection_class_init (UnityMusicLensBansheeCollectionClass * klass) {
	unity_music_lens_banshee_collection_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UnityMusicLensBansheeCollectionPrivate));
	G_OBJECT_CLASS (klass)->finalize = unity_music_lens_banshee_collection_finalize;
}


static void unity_music_lens_banshee_collection_instance_init (UnityMusicLensBansheeCollection * self) {
	self->priv = UNITY_MUSIC_LENS_BANSHEE_COLLECTION_GET_PRIVATE (self);
}


static void unity_music_lens_banshee_collection_finalize (GObject* obj) {
	UnityMusicLensBansheeCollection * self;
	self = UNITY_MUSIC_LENS_BANSHEE_COLLECTION (obj);
	_sqlite3_close0 (self->priv->db);
	G_OBJECT_CLASS (unity_music_lens_banshee_collection_parent_class)->finalize (obj);
}


/**
   * Abstracts talking to the banshee collection database
   */
GType unity_music_lens_banshee_collection_get_type (void) {
	static volatile gsize unity_music_lens_banshee_collection_type_id__volatile = 0;
	if (g_once_init_enter (&unity_music_lens_banshee_collection_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnityMusicLensBansheeCollectionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_music_lens_banshee_collection_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityMusicLensBansheeCollection), 0, (GInstanceInitFunc) unity_music_lens_banshee_collection_instance_init, NULL };
		GType unity_music_lens_banshee_collection_type_id;
		unity_music_lens_banshee_collection_type_id = g_type_register_static (G_TYPE_OBJECT, "UnityMusicLensBansheeCollection", &g_define_type_info, 0);
		g_once_init_leave (&unity_music_lens_banshee_collection_type_id__volatile, unity_music_lens_banshee_collection_type_id);
	}
	return unity_music_lens_banshee_collection_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



