/* main.c generated by valac 0.11.2, the Vala compiler
 * generated from main.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*- */
/*
    © 2010 Canonical Ltd
    Authors:
      Michael Terry <michael.terry@canonical.com>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, version 3 of the License.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <config.h>
#include <vala.h>
#include <valagee.h>
#include <float.h>
#include <math.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))

#define TYPE_VAPI_INFO (vapi_info_get_type ())
#define VAPI_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VAPI_INFO, VapiInfo))
#define VAPI_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VAPI_INFO, VapiInfoClass))
#define IS_VAPI_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VAPI_INFO))
#define IS_VAPI_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VAPI_INFO))
#define VAPI_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VAPI_INFO, VapiInfoClass))

typedef struct _VapiInfo VapiInfo;
typedef struct _VapiInfoClass VapiInfoClass;

#define TYPE_SYMBOL_CATCHER (symbol_catcher_get_type ())
#define SYMBOL_CATCHER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SYMBOL_CATCHER, SymbolCatcher))
#define SYMBOL_CATCHER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SYMBOL_CATCHER, SymbolCatcherClass))
#define IS_SYMBOL_CATCHER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SYMBOL_CATCHER))
#define IS_SYMBOL_CATCHER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SYMBOL_CATCHER))
#define SYMBOL_CATCHER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SYMBOL_CATCHER, SymbolCatcherClass))

typedef struct _SymbolCatcher SymbolCatcher;
typedef struct _SymbolCatcherClass SymbolCatcherClass;
typedef struct _SymbolCatcherPrivate SymbolCatcherPrivate;
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define __g_list_free__g_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_free0_ (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_visitor_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_visitor_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))
typedef struct _VapiInfoPrivate VapiInfoPrivate;
#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))
#define _g_dir_close0(var) ((var == NULL) ? NULL : (var = (g_dir_close (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))

struct _SymbolCatcher {
	ValaCodeVisitor parent_instance;
	SymbolCatcherPrivate * priv;
	ValaSet* packages;
};

struct _SymbolCatcherClass {
	ValaCodeVisitorClass parent_class;
};

struct _VapiInfo {
	GObject parent_instance;
	VapiInfoPrivate * priv;
};

struct _VapiInfoClass {
	GObjectClass parent_class;
};

struct _VapiInfoPrivate {
	ValaCodeContext* _ctx;
	ValaMap* symbols;
	ValaSet* namespaces;
};

struct _SymbolCatcherPrivate {
	ValaCodeContext* ctx;
	VapiInfo* vinfo;
};


extern gchar* mode;
gchar* mode = NULL;
extern gboolean show_version;
gboolean show_version = FALSE;
extern gboolean verbose;
gboolean verbose = FALSE;
extern gchar** forces;
extern gint forces_length1;
gchar** forces = NULL;
gint forces_length1 = 0;
static gint _forces_size_ = 0;
extern gchar** filenames;
extern gint filenames_length1;
gchar** filenames = NULL;
gint filenames_length1 = 0;
static gint _filenames_size_ = 0;
static gpointer vapi_info_parent_class = NULL;
static gpointer symbol_catcher_parent_class = NULL;

gint _vala_main (gchar** args, int args_length1);
VapiInfo* vapi_info_new (ValaCodeContext* ctx);
VapiInfo* vapi_info_construct (GType object_type, ValaCodeContext* ctx);
GType vapi_info_get_type (void) G_GNUC_CONST;
SymbolCatcher* symbol_catcher_new (void);
SymbolCatcher* symbol_catcher_construct (GType object_type);
GType symbol_catcher_get_type (void) G_GNUC_CONST;
void symbol_catcher_catch (SymbolCatcher* self, ValaCodeContext* ctx, VapiInfo* vinfo);
ValaSet* choose_best_pkgs (ValaSet* pkgs);
static void _g_free0_ (gpointer var);
static void _g_list_free__g_free0_ (GList* self);
gint compare_pkgs (const gchar* one, const gchar* two);
#define VAPI_INFO_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_VAPI_INFO, VapiInfoPrivate))
enum  {
	VAPI_INFO_DUMMY_PROPERTY,
	VAPI_INFO_CTX
};
gboolean vapi_info_is_namespace (VapiInfo* self, const gchar* symbol);
ValaSet* vapi_info_pkgs_for_symbol (VapiInfo* self, const gchar* symbol, ValaSet* usings);
static void vapi_info_get_pkg_list_for_dir (VapiInfo* self, const gchar* vapidir, ValaSet** pkgs, const gchar* suffix);
static ValaSet* vapi_info_get_pkg_list (VapiInfo* self);
static gboolean vapi_info_is_symbol_from_pkg (VapiInfo* self, ValaSymbol* symbol, const gchar* pkg);
static void vapi_info_add_symbol (VapiInfo* self, ValaHashSet* symbols, ValaSymbol* symbol, const gchar* pkg);
static void vapi_info_process_pkg (VapiInfo* self, const gchar* pkg);
static void vapi_info_add_package (VapiInfo* self, ValaCodeContext* ctx, const gchar* pkg);
ValaCodeContext* vapi_info_get_ctx (VapiInfo* self);
static void vapi_info_set_ctx (VapiInfo* self, ValaCodeContext* value);
static GObject * vapi_info_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void vapi_info_finalize (GObject* obj);
static void _vala_vapi_info_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_vapi_info_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
#define SYMBOL_CATCHER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SYMBOL_CATCHER, SymbolCatcherPrivate))
enum  {
	SYMBOL_CATCHER_DUMMY_PROPERTY
};
static void symbol_catcher_descend (SymbolCatcher* self, ValaCodeNode* n);
static void symbol_catcher_add_symbol (SymbolCatcher* self, const gchar* name, const gchar* prev, ValaList* usings);
static void symbol_catcher_real_visit_data_type (ValaCodeVisitor* base, ValaDataType* data_type);
static void symbol_catcher_real_visit_member_access (ValaCodeVisitor* base, ValaMemberAccess* expr);
static void symbol_catcher_real_visit_binary_expression (ValaCodeVisitor* base, ValaBinaryExpression* expr);
static void symbol_catcher_real_visit_unary_expression (ValaCodeVisitor* base, ValaUnaryExpression* expr);
static void symbol_catcher_real_visit_array_creation_expression (ValaCodeVisitor* base, ValaArrayCreationExpression* e);
static void symbol_catcher_real_visit_assignment (ValaCodeVisitor* base, ValaAssignment* a);
static void symbol_catcher_real_visit_block (ValaCodeVisitor* base, ValaBlock* b);
static void symbol_catcher_real_visit_catch_clause (ValaCodeVisitor* base, ValaCatchClause* clause);
static void symbol_catcher_real_visit_class (ValaCodeVisitor* base, ValaClass* cl);
static void symbol_catcher_real_visit_constant (ValaCodeVisitor* base, ValaConstant* c);
static void symbol_catcher_real_visit_constructor (ValaCodeVisitor* base, ValaConstructor* c);
static void symbol_catcher_real_visit_creation_method (ValaCodeVisitor* base, ValaCreationMethod* m);
static void symbol_catcher_real_visit_declaration_statement (ValaCodeVisitor* base, ValaDeclarationStatement* stmt);
static void symbol_catcher_real_visit_delegate (ValaCodeVisitor* base, ValaDelegate* cb);
static void symbol_catcher_real_visit_destructor (ValaCodeVisitor* base, ValaDestructor* d);
static void symbol_catcher_real_visit_do_statement (ValaCodeVisitor* base, ValaDoStatement* stmt);
static void symbol_catcher_real_visit_element_access (ValaCodeVisitor* base, ValaElementAccess* expr);
static void symbol_catcher_real_visit_enum (ValaCodeVisitor* base, ValaEnum* en);
static void symbol_catcher_real_visit_error_domain (ValaCodeVisitor* base, ValaErrorDomain* ed);
static void symbol_catcher_real_visit_expression_statement (ValaCodeVisitor* base, ValaExpressionStatement* stmt);
static void symbol_catcher_real_visit_field (ValaCodeVisitor* base, ValaField* f);
static void symbol_catcher_real_visit_for_statement (ValaCodeVisitor* base, ValaForStatement* stmt);
static void symbol_catcher_real_visit_foreach_statement (ValaCodeVisitor* base, ValaForeachStatement* stmt);
static void symbol_catcher_real_visit_formal_parameter (ValaCodeVisitor* base, ValaParameter* p);
static void symbol_catcher_real_visit_if_statement (ValaCodeVisitor* base, ValaIfStatement* stmt);
static void symbol_catcher_real_visit_initializer_list (ValaCodeVisitor* base, ValaInitializerList* list);
static void symbol_catcher_real_visit_interface (ValaCodeVisitor* base, ValaInterface* iface);
static void symbol_catcher_real_visit_lambda_expression (ValaCodeVisitor* base, ValaLambdaExpression* l);
static void symbol_catcher_real_visit_list_literal (ValaCodeVisitor* base, ValaListLiteral* lit);
static void symbol_catcher_real_visit_local_variable (ValaCodeVisitor* base, ValaLocalVariable* local);
static void symbol_catcher_real_visit_loop (ValaCodeVisitor* base, ValaLoop* stmt);
static void symbol_catcher_real_visit_map_literal (ValaCodeVisitor* base, ValaMapLiteral* lit);
static void symbol_catcher_real_visit_method (ValaCodeVisitor* base, ValaMethod* m);
static void symbol_catcher_real_visit_method_call (ValaCodeVisitor* base, ValaMethodCall* expr);
static void symbol_catcher_real_visit_namespace (ValaCodeVisitor* base, ValaNamespace* ns);
static void symbol_catcher_real_visit_object_creation_expression (ValaCodeVisitor* base, ValaObjectCreationExpression* expr);
static void symbol_catcher_real_visit_property (ValaCodeVisitor* base, ValaProperty* prop);
static void symbol_catcher_real_visit_property_accessor (ValaCodeVisitor* base, ValaPropertyAccessor* acc);
static void symbol_catcher_real_visit_reference_transfer_expression (ValaCodeVisitor* base, ValaReferenceTransferExpression* expr);
static void symbol_catcher_real_visit_return_statement (ValaCodeVisitor* base, ValaReturnStatement* stmt);
static void symbol_catcher_real_visit_set_literal (ValaCodeVisitor* base, ValaSetLiteral* lit);
static void symbol_catcher_real_visit_signal (ValaCodeVisitor* base, ValaSignal* sig);
static void symbol_catcher_real_visit_slice_expression (ValaCodeVisitor* base, ValaSliceExpression* expr);
static void symbol_catcher_real_visit_struct (ValaCodeVisitor* base, ValaStruct* st);
static void symbol_catcher_real_visit_switch_label (ValaCodeVisitor* base, ValaSwitchLabel* label);
static void symbol_catcher_real_visit_switch_section (ValaCodeVisitor* base, ValaSwitchSection* section);
static void symbol_catcher_real_visit_switch_statement (ValaCodeVisitor* base, ValaSwitchStatement* stmt);
static void symbol_catcher_real_visit_template (ValaCodeVisitor* base, ValaTemplate* tmpl);
static void symbol_catcher_real_visit_throw_statement (ValaCodeVisitor* base, ValaThrowStatement* stmt);
static void symbol_catcher_real_visit_try_statement (ValaCodeVisitor* base, ValaTryStatement* stmt);
static void symbol_catcher_real_visit_tuple (ValaCodeVisitor* base, ValaTuple* tuple);
static void symbol_catcher_real_visit_using_directive (ValaCodeVisitor* base, ValaUsingDirective* ns);
static void symbol_catcher_real_visit_while_statement (ValaCodeVisitor* base, ValaWhileStatement* stmt);
static void symbol_catcher_real_visit_yield_statement (ValaCodeVisitor* base, ValaYieldStatement* stmt);
static void symbol_catcher_finalize (ValaCodeVisitor* obj);

const GOptionEntry options[6] = {{"mode", (gchar) 0, 0, G_OPTION_ARG_STRING, &mode, "gir (default) or vapi", NULL}, {"verbose", (gchar) 0, 0, G_OPTION_ARG_NONE, &verbose, "Show verbose information", NULL}, {"version", (gchar) 0, 0, G_OPTION_ARG_NONE, &show_version, "Show version", NULL}, {"force-pkg", (gchar) 0, 0, G_OPTION_ARG_STRING_ARRAY, &forces, "Force the use of certain packages", NULL}, {"", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &filenames, NULL, NULL}, {NULL}};

static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_list_free__g_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_free0_, NULL);
	g_list_free (self);
}


gint _vala_main (gchar** args, int args_length1) {
	gint result = 0;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	GOptionContext* _tmp4_ = NULL;
	GOptionContext* _tmp5_;
	GOptionContext* context;
	gboolean _tmp11_ = FALSE;
	ValaCodeContext* _tmp14_ = NULL;
	ValaCodeContext* ctx;
	ValaParser* _tmp17_ = NULL;
	ValaParser* parser;
	VapiInfo* _tmp18_ = NULL;
	VapiInfo* vinfo;
	SymbolCatcher* _tmp19_ = NULL;
	SymbolCatcher* catcher;
	ValaSet* _tmp20_ = NULL;
	ValaSet* best_pkgs;
	GList* pkg_list;
	GError * _inner_error_ = NULL;
	textdomain (GETTEXT_PACKAGE);
	bindtextdomain (GETTEXT_PACKAGE, LOCALE_DIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	_tmp0_ = _ ("Vala Dependency Scanner");
	g_set_application_name (_tmp0_);
	_tmp1_ = _ ("FILES");
	_tmp2_ = g_strdup_printf ("[%s]", _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_option_context_new (_tmp3_);
	context = (_tmp5_ = _tmp4_, _g_free0 (_tmp3_), _tmp5_);
	g_option_context_add_main_entries (context, options, GETTEXT_PACKAGE);
	g_option_context_parse (context, &args_length1, &args, &_inner_error_);
	if (_inner_error_ != NULL) {
		goto __catch0_g_error;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError * e;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp6_ = g_option_context_get_help (context, TRUE, NULL);
		_tmp7_ = _tmp6_;
		g_printerr ("%s\n\n%s", e->message, _tmp7_);
		_g_free0 (_tmp7_);
		result = 1;
		_g_error_free0 (e);
		_g_option_context_free0 (context);
		return result;
	}
	__finally0:
	if (_inner_error_ != NULL) {
		_g_option_context_free0 (context);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	if (show_version) {
		const gchar* _tmp8_ = NULL;
		_tmp8_ = g_get_application_name ();
		g_print ("%s %s\n", _tmp8_, VERSION);
		result = 0;
		_g_option_context_free0 (context);
		return result;
	}
	if (mode == NULL) {
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp9_ = g_strdup ("vapi");
		_tmp10_ = _tmp9_;
		_g_free0 (mode);
		mode = _tmp10_;
	}
	if (g_strcmp0 (mode, "gir") != 0) {
		_tmp11_ = g_strcmp0 (mode, "vapi") != 0;
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		const gchar* _tmp12_ = NULL;
		_tmp12_ = _ ("Mode must be either gir or vapi");
		g_printerr ("%s\n", _tmp12_);
		result = 1;
		_g_option_context_free0 (context);
		return result;
	}
	if (filenames == NULL) {
		const gchar* _tmp13_ = NULL;
		_tmp13_ = _ ("No filenames provided");
		g_printerr ("%s\n", _tmp13_);
		result = 1;
		_g_option_context_free0 (context);
		return result;
	}
	_tmp14_ = vala_code_context_new ();
	ctx = _tmp14_;
	vala_code_context_push (ctx);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp15_;
			_tmp15_ = TRUE;
			while (TRUE) {
				ValaSourceFile* _tmp16_ = NULL;
				ValaSourceFile* file;
				if (!_tmp15_) {
					i = i + 1;
				}
				_tmp15_ = FALSE;
				if (!(filenames[i] != NULL)) {
					break;
				}
				_tmp16_ = vala_source_file_new (ctx, VALA_SOURCE_FILE_TYPE_SOURCE, filenames[i], NULL);
				file = _tmp16_;
				vala_code_context_add_source_file (ctx, file);
				_vala_source_file_unref0 (file);
			}
		}
	}
	_tmp17_ = vala_parser_new ();
	parser = _tmp17_;
	vala_parser_parse (parser, ctx);
	_tmp18_ = vapi_info_new (ctx);
	vinfo = _tmp18_;
	_tmp19_ = symbol_catcher_new ();
	catcher = _tmp19_;
	symbol_catcher_catch (catcher, ctx, vinfo);
	_tmp20_ = choose_best_pkgs (catcher->packages);
	best_pkgs = _tmp20_;
	vala_collection_remove ((ValaCollection*) best_pkgs, "glib-2.0");
	pkg_list = NULL;
	{
		ValaIterator* _tmp21_ = NULL;
		ValaIterator* _p_it;
		_tmp21_ = vala_iterable_iterator ((ValaIterable*) best_pkgs);
		_p_it = _tmp21_;
		while (TRUE) {
			gboolean _tmp22_;
			gpointer _tmp23_ = NULL;
			gchar* p;
			gchar* _tmp24_;
			_tmp22_ = vala_iterator_next (_p_it);
			if (!_tmp22_) {
				break;
			}
			_tmp23_ = vala_iterator_get (_p_it);
			p = (gchar*) _tmp23_;
			_tmp24_ = g_strdup (p);
			pkg_list = g_list_insert_sorted (pkg_list, _tmp24_, (GCompareFunc) g_strcmp0);
			_g_free0 (p);
		}
		_vala_iterator_unref0 (_p_it);
	}
	{
		GList* pkg_collection;
		GList* pkg_it;
		pkg_collection = pkg_list;
		for (pkg_it = pkg_collection; pkg_it != NULL; pkg_it = pkg_it->next) {
			const gchar* pkg;
			pkg = (const gchar*) pkg_it->data;
			{
				g_print ("%s\n", pkg);
			}
		}
	}
	result = 0;
	__g_list_free__g_free0_0 (pkg_list);
	_vala_iterable_unref0 (best_pkgs);
	_vala_code_visitor_unref0 (catcher);
	_g_object_unref0 (vinfo);
	_vala_code_visitor_unref0 (parser);
	_vala_code_context_unref0 (ctx);
	_g_option_context_free0 (context);
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return _vala_main (argv, argc);
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	result = ((gchar*) self)[index];
	return result;
}


static const gchar* string_offset (const gchar* self, glong offset) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = (const gchar*) (((gchar*) self) + offset);
	return result;
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong _tmp0_;
	glong string_length;
	const gchar* _tmp1_ = NULL;
	const gchar* start;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	string_length = _tmp0_;
	if (offset < 0) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= 0, NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < 0) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp1_ = string_offset (self, offset);
	start = _tmp1_;
	_tmp2_ = string_offset (start, len);
	_tmp3_ = g_strndup (start, ((gchar*) _tmp2_) - ((gchar*) start));
	result = _tmp3_;
	return result;
}


gint compare_pkgs (const gchar* one, const gchar* two) {
	gint result = 0;
	gint i = 0;
	gchar* suffix1;
	gchar* suffix2;
	gchar _tmp8_;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp12_ = FALSE;
	gdouble _tmp15_;
	gdouble num1;
	gdouble _tmp16_;
	gdouble num2;
	g_return_val_if_fail (one != NULL, 0);
	g_return_val_if_fail (two != NULL, 0);
	suffix1 = NULL;
	suffix2 = NULL;
	{
		gboolean _tmp0_;
		i = 0;
		_tmp0_ = TRUE;
		while (TRUE) {
			gchar _tmp1_;
			gchar _tmp2_;
			gchar _tmp3_;
			if (!_tmp0_) {
				i = i + 1;
			}
			_tmp0_ = FALSE;
			_tmp1_ = string_get (one, (glong) i);
			if (!(_tmp1_ != 0)) {
				break;
			}
			_tmp2_ = string_get (one, (glong) i);
			_tmp3_ = string_get (two, (glong) i);
			if (_tmp2_ != _tmp3_) {
				gchar* _tmp4_ = NULL;
				gchar* _tmp5_;
				gchar* _tmp6_ = NULL;
				gchar* _tmp7_;
				_tmp4_ = string_substring (one, (glong) i, (glong) (-1));
				_tmp5_ = _tmp4_;
				_g_free0 (suffix1);
				suffix1 = _tmp5_;
				_tmp6_ = string_substring (two, (glong) i, (glong) (-1));
				_tmp7_ = _tmp6_;
				_g_free0 (suffix2);
				suffix2 = _tmp7_;
				break;
			}
		}
	}
	_tmp8_ = string_get (one, (glong) i);
	if (_tmp8_ == 0) {
		result = 0;
		_g_free0 (suffix2);
		_g_free0 (suffix1);
		return result;
	}
	if (suffix1 != NULL) {
		gchar _tmp10_;
		gboolean _tmp11_;
		_tmp10_ = string_get (suffix1, (glong) 0);
		_tmp11_ = g_ascii_isdigit (_tmp10_);
		_tmp9_ = !_tmp11_;
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		result = 0;
		_g_free0 (suffix2);
		_g_free0 (suffix1);
		return result;
	}
	if (suffix2 != NULL) {
		gchar _tmp13_;
		gboolean _tmp14_;
		_tmp13_ = string_get (suffix2, (glong) 0);
		_tmp14_ = g_ascii_isdigit (_tmp13_);
		_tmp12_ = !_tmp14_;
	} else {
		_tmp12_ = FALSE;
	}
	if (_tmp12_) {
		result = 0;
		_g_free0 (suffix2);
		_g_free0 (suffix1);
		return result;
	}
	_tmp15_ = g_ascii_strtod (suffix1, NULL);
	num1 = _tmp15_;
	_tmp16_ = g_ascii_strtod (suffix2, NULL);
	num2 = _tmp16_;
	if (num1 < num2) {
		result = -1;
		_g_free0 (suffix2);
		_g_free0 (suffix1);
		return result;
	} else {
		if (num1 > num2) {
			result = 1;
			_g_free0 (suffix2);
			_g_free0 (suffix1);
			return result;
		} else {
			result = 0;
			_g_free0 (suffix2);
			_g_free0 (suffix1);
			return result;
		}
	}
	_g_free0 (suffix2);
	_g_free0 (suffix1);
}


ValaSet* choose_best_pkgs (ValaSet* pkgs) {
	ValaSet* result = NULL;
	ValaHashSet* _tmp0_ = NULL;
	ValaHashSet* rv;
	g_return_val_if_fail (pkgs != NULL, NULL);
	_tmp0_ = vala_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_str_hash, g_str_equal);
	rv = _tmp0_;
	{
		ValaIterator* _tmp1_ = NULL;
		ValaIterator* _pkg_it;
		_tmp1_ = vala_iterable_iterator ((ValaIterable*) pkgs);
		_pkg_it = _tmp1_;
		while (TRUE) {
			gboolean _tmp2_;
			gpointer _tmp3_ = NULL;
			gchar* pkg;
			gboolean add;
			_tmp2_ = vala_iterator_next (_pkg_it);
			if (!_tmp2_) {
				break;
			}
			_tmp3_ = vala_iterator_get (_pkg_it);
			pkg = (gchar*) _tmp3_;
			add = TRUE;
			{
				ValaIterator* _tmp4_ = NULL;
				ValaIterator* _rvpkg_it;
				_tmp4_ = vala_iterable_iterator ((ValaIterable*) rv);
				_rvpkg_it = _tmp4_;
				while (TRUE) {
					gboolean _tmp5_;
					gpointer _tmp6_ = NULL;
					gchar* rvpkg;
					gint _tmp7_;
					gint cmp;
					_tmp5_ = vala_iterator_next (_rvpkg_it);
					if (!_tmp5_) {
						break;
					}
					_tmp6_ = vala_iterator_get (_rvpkg_it);
					rvpkg = (gchar*) _tmp6_;
					_tmp7_ = compare_pkgs (pkg, rvpkg);
					cmp = _tmp7_;
					if (cmp != 0) {
						if (cmp < 0) {
							add = FALSE;
							_g_free0 (rvpkg);
							break;
						} else {
							vala_collection_remove ((ValaCollection*) rv, rvpkg);
							_g_free0 (rvpkg);
							break;
						}
					}
					_g_free0 (rvpkg);
				}
				_vala_iterator_unref0 (_rvpkg_it);
			}
			if (add) {
				vala_collection_add ((ValaCollection*) rv, pkg);
			}
			_g_free0 (pkg);
		}
		_vala_iterator_unref0 (_pkg_it);
	}
	if (forces != NULL) {
		{
			gint i;
			i = 0;
			{
				gboolean _tmp8_;
				_tmp8_ = TRUE;
				while (TRUE) {
					gboolean add;
					if (!_tmp8_) {
						i = i + 1;
					}
					_tmp8_ = FALSE;
					if (!(forces[i] != NULL)) {
						break;
					}
					add = TRUE;
					{
						ValaIterator* _tmp9_ = NULL;
						ValaIterator* _rvpkg_it;
						_tmp9_ = vala_iterable_iterator ((ValaIterable*) rv);
						_rvpkg_it = _tmp9_;
						while (TRUE) {
							gboolean _tmp10_;
							gpointer _tmp11_ = NULL;
							gchar* rvpkg;
							gint _tmp12_;
							gint cmp;
							_tmp10_ = vala_iterator_next (_rvpkg_it);
							if (!_tmp10_) {
								break;
							}
							_tmp11_ = vala_iterator_get (_rvpkg_it);
							rvpkg = (gchar*) _tmp11_;
							if (g_strcmp0 (rvpkg, forces[i]) == 0) {
								add = FALSE;
								_g_free0 (rvpkg);
								break;
							}
							_tmp12_ = compare_pkgs (forces[i], rvpkg);
							cmp = _tmp12_;
							if (cmp != 0) {
								vala_collection_remove ((ValaCollection*) rv, rvpkg);
								_g_free0 (rvpkg);
								break;
							}
							_g_free0 (rvpkg);
						}
						_vala_iterator_unref0 (_rvpkg_it);
					}
					if (add) {
						vala_collection_add ((ValaCollection*) rv, forces[i]);
					}
				}
			}
		}
	}
	result = (ValaSet*) rv;
	return result;
}


VapiInfo* vapi_info_construct (GType object_type, ValaCodeContext* ctx) {
	VapiInfo * self = NULL;
	g_return_val_if_fail (ctx != NULL, NULL);
	self = (VapiInfo*) g_object_new (object_type, "ctx", ctx, NULL);
	return self;
}


VapiInfo* vapi_info_new (ValaCodeContext* ctx) {
	return vapi_info_construct (TYPE_VAPI_INFO, ctx);
}


gboolean vapi_info_is_namespace (VapiInfo* self, const gchar* symbol) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (symbol != NULL, FALSE);
	_tmp0_ = vala_collection_contains ((ValaCollection*) self->priv->namespaces, symbol);
	result = _tmp0_;
	return result;
}


ValaSet* vapi_info_pkgs_for_symbol (VapiInfo* self, const gchar* symbol, ValaSet* usings) {
	ValaSet* result = NULL;
	ValaHashSet* _tmp0_ = NULL;
	ValaHashSet* rv;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (symbol != NULL, NULL);
	g_return_val_if_fail (usings != NULL, NULL);
	_tmp0_ = vala_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_str_hash, g_str_equal);
	rv = _tmp0_;
	{
		ValaSet* _tmp1_ = NULL;
		ValaSet* _tmp2_;
		ValaIterator* _tmp3_ = NULL;
		ValaIterator* _tmp4_;
		ValaIterator* _pkg_it;
		_tmp1_ = vala_map_get_keys (self->priv->symbols);
		_tmp2_ = _tmp1_;
		_tmp3_ = vala_iterable_iterator ((ValaIterable*) _tmp2_);
		_pkg_it = (_tmp4_ = _tmp3_, _vala_iterable_unref0 (_tmp2_), _tmp4_);
		while (TRUE) {
			gboolean _tmp5_;
			gpointer _tmp6_ = NULL;
			gchar* pkg;
			gpointer _tmp7_ = NULL;
			ValaMap* map;
			_tmp5_ = vala_iterator_next (_pkg_it);
			if (!_tmp5_) {
				break;
			}
			_tmp6_ = vala_iterator_get (_pkg_it);
			pkg = (gchar*) _tmp6_;
			_tmp7_ = vala_map_get (self->priv->symbols, pkg);
			map = (ValaMap*) _tmp7_;
			{
				ValaSet* _tmp8_ = NULL;
				ValaSet* _tmp9_;
				ValaIterator* _tmp10_ = NULL;
				ValaIterator* _tmp11_;
				ValaIterator* _ns_it;
				_tmp8_ = vala_map_get_keys (map);
				_tmp9_ = _tmp8_;
				_tmp10_ = vala_iterable_iterator ((ValaIterable*) _tmp9_);
				_ns_it = (_tmp11_ = _tmp10_, _vala_iterable_unref0 (_tmp9_), _tmp11_);
				while (TRUE) {
					gboolean _tmp12_;
					gpointer _tmp13_ = NULL;
					gchar* ns;
					gboolean _tmp14_;
					gpointer _tmp15_ = NULL;
					ValaSet* syms;
					gboolean _tmp16_;
					_tmp12_ = vala_iterator_next (_ns_it);
					if (!_tmp12_) {
						break;
					}
					_tmp13_ = vala_iterator_get (_ns_it);
					ns = (gchar*) _tmp13_;
					_tmp14_ = vala_collection_contains ((ValaCollection*) usings, ns);
					if (!_tmp14_) {
						_g_free0 (ns);
						continue;
					}
					_tmp15_ = vala_map_get (map, ns);
					syms = (ValaSet*) _tmp15_;
					_tmp16_ = vala_collection_contains ((ValaCollection*) syms, symbol);
					if (_tmp16_) {
						if (verbose) {
							const gchar* _tmp17_ = NULL;
							_tmp17_ = _ ("Symbol '%s' found in package '%s'\n");
							g_printerr (_tmp17_, symbol, pkg);
						}
						vala_collection_add ((ValaCollection*) rv, pkg);
						_vala_iterable_unref0 (syms);
						_g_free0 (ns);
						break;
					}
					_vala_iterable_unref0 (syms);
					_g_free0 (ns);
				}
				_vala_iterator_unref0 (_ns_it);
			}
			_vala_map_unref0 (map);
			_g_free0 (pkg);
		}
		_vala_iterator_unref0 (_pkg_it);
	}
	result = (ValaSet*) rv;
	return result;
}


static void vapi_info_get_pkg_list_for_dir (VapiInfo* self, const gchar* vapidir, ValaSet** pkgs, const gchar* suffix) {
	gchar* name;
	GDir* _tmp0_ = NULL;
	GDir* dir;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (vapidir != NULL);
	g_return_if_fail (pkgs != NULL);
	g_return_if_fail (suffix != NULL);
	name = NULL;
	_tmp0_ = g_dir_open (vapidir, (guint) 0, &_inner_error_);
	dir = _tmp0_;
	if (_inner_error_ != NULL) {
		_g_free0 (name);
		goto __catch1_g_error;
	}
	while (TRUE) {
		const gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gboolean _tmp4_;
		_tmp1_ = g_dir_read_name (dir);
		_tmp2_ = g_strdup (_tmp1_);
		_tmp3_ = _tmp2_;
		_g_free0 (name);
		name = _tmp3_;
		if (!(name != NULL)) {
			break;
		}
		_tmp4_ = g_str_has_suffix (name, suffix);
		if (_tmp4_) {
			glong _tmp5_;
			glong _tmp6_;
			gchar* _tmp7_ = NULL;
			gchar* _tmp8_;
			_tmp5_ = strlen (name);
			_tmp6_ = strlen (suffix);
			_tmp7_ = string_substring (name, (glong) 0, _tmp5_ - _tmp6_);
			_tmp8_ = _tmp7_;
			vala_collection_add ((ValaCollection*) (*pkgs), _tmp8_);
			_g_free0 (_tmp8_);
		}
	}
	_g_dir_close0 (dir);
	_g_free0 (name);
	goto __finally1;
	__catch1_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("main.vala:231: %s\n", e->message);
		_g_error_free0 (e);
	}
	__finally1:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static ValaSet* vapi_info_get_pkg_list (VapiInfo* self) {
	ValaSet* result = NULL;
	ValaHashSet* _tmp0_ = NULL;
	ValaSet* rv;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = vala_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_str_hash, g_str_equal);
	rv = (ValaSet*) _tmp0_;
	if (g_strcmp0 (mode, "vapi") == 0) {
		gchar* _tmp1_ = NULL;
		gchar* specific;
		gchar* _tmp2_ = NULL;
		gchar* generic;
		_tmp1_ = g_build_filename (DATA_DIR, "vala-0.12", "vapi", NULL);
		specific = _tmp1_;
		_tmp2_ = g_build_filename (DATA_DIR, "vala", "vapi", NULL);
		generic = _tmp2_;
		vapi_info_get_pkg_list_for_dir (self, specific, &rv, ".vapi");
		vapi_info_get_pkg_list_for_dir (self, generic, &rv, ".vapi");
		_g_free0 (generic);
		_g_free0 (specific);
	} else {
		if (g_strcmp0 (mode, "gir") == 0) {
			gchar* _tmp3_ = NULL;
			gchar* girdir;
			_tmp3_ = g_build_filename (DATA_DIR, "gir-1.0", NULL);
			girdir = _tmp3_;
			vapi_info_get_pkg_list_for_dir (self, girdir, &rv, ".gir");
			_g_free0 (girdir);
		}
	}
	result = rv;
	return result;
}


static gboolean vapi_info_is_symbol_from_pkg (VapiInfo* self, ValaSymbol* symbol, const gchar* pkg) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (symbol != NULL, FALSE);
	g_return_val_if_fail (pkg != NULL, FALSE);
	if (g_strcmp0 (mode, "gir") == 0) {
		ValaSourceReference* _tmp0_ = NULL;
		ValaSourceFile* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		ValaSourceReference* _tmp3_ = NULL;
		ValaSourceFile* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gchar* sym_pkgname;
		_tmp0_ = vala_code_node_get_source_reference ((ValaCodeNode*) symbol);
		_tmp1_ = vala_source_reference_get_file (_tmp0_);
		_tmp2_ = vala_source_file_get_gir_namespace (_tmp1_);
		_tmp3_ = vala_code_node_get_source_reference ((ValaCodeNode*) symbol);
		_tmp4_ = vala_source_reference_get_file (_tmp3_);
		_tmp5_ = vala_source_file_get_gir_version (_tmp4_);
		_tmp6_ = g_strdup_printf ("%s-%s", _tmp2_, _tmp5_);
		sym_pkgname = _tmp6_;
		result = g_strcmp0 (sym_pkgname, pkg) == 0;
		_g_free0 (sym_pkgname);
		return result;
	} else {
		result = TRUE;
		return result;
	}
}


static void vapi_info_add_symbol (VapiInfo* self, ValaHashSet* symbols, ValaSymbol* symbol, const gchar* pkg) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (symbols != NULL);
	g_return_if_fail (symbol != NULL);
	g_return_if_fail (pkg != NULL);
	_tmp0_ = vapi_info_is_symbol_from_pkg (self, symbol, pkg);
	if (_tmp0_) {
		const gchar* _tmp1_ = NULL;
		_tmp1_ = vala_symbol_get_name (symbol);
		vala_collection_add ((ValaCollection*) symbols, _tmp1_);
	}
}


static void vapi_info_process_pkg (VapiInfo* self, const gchar* pkg) {
	ValaHashMap* _tmp0_ = NULL;
	ValaHashMap* pkgmap;
	ValaCodeContext* _tmp1_ = NULL;
	ValaCodeContext* ctx;
	g_return_if_fail (self != NULL);
	g_return_if_fail (pkg != NULL);
	_tmp0_ = vala_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, VALA_TYPE_SET, (GBoxedCopyFunc) vala_iterable_ref, vala_iterable_unref, g_str_hash, g_str_equal, g_direct_equal);
	pkgmap = _tmp0_;
	_tmp1_ = vala_code_context_new ();
	ctx = _tmp1_;
	vala_code_context_push (ctx);
	vala_code_context_set_profile (ctx, VALA_PROFILE_GOBJECT);
	vala_code_context_add_external_package (ctx, "glib-2.0");
	vala_code_context_add_external_package (ctx, "gobject-2.0");
	vapi_info_add_package (self, ctx, pkg);
	if (g_strcmp0 (mode, "vapi") == 0) {
		ValaParser* _tmp2_ = NULL;
		ValaParser* parser;
		_tmp2_ = vala_parser_new ();
		parser = _tmp2_;
		vala_parser_parse (parser, ctx);
		_vala_code_visitor_unref0 (parser);
	} else {
		if (g_strcmp0 (mode, "gir") == 0) {
			ValaGirParser* _tmp3_ = NULL;
			ValaGirParser* parser;
			_tmp3_ = vala_gir_parser_new ();
			parser = _tmp3_;
			vala_gir_parser_parse (parser, ctx);
			_vala_code_visitor_unref0 (parser);
		}
	}
	{
		ValaNamespace* _tmp4_ = NULL;
		ValaList* _tmp5_ = NULL;
		ValaList* _ns_list;
		gint _tmp6_;
		gint _ns_size;
		gint _ns_index;
		_tmp4_ = vala_code_context_get_root (ctx);
		_tmp5_ = vala_namespace_get_namespaces (_tmp4_);
		_ns_list = _tmp5_;
		_tmp6_ = vala_collection_get_size ((ValaCollection*) _ns_list);
		_ns_size = _tmp6_;
		_ns_index = -1;
		while (TRUE) {
			gpointer _tmp7_ = NULL;
			ValaNamespace* ns;
			ValaHashSet* _tmp8_ = NULL;
			ValaHashSet* symbolset;
			const gchar* _tmp9_ = NULL;
			const gchar* _tmp10_ = NULL;
			_ns_index = _ns_index + 1;
			if (!(_ns_index < _ns_size)) {
				break;
			}
			_tmp7_ = vala_list_get (_ns_list, _ns_index);
			ns = (ValaNamespace*) _tmp7_;
			_tmp8_ = vala_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_str_hash, g_str_equal);
			symbolset = _tmp8_;
			_tmp9_ = vala_symbol_get_name ((ValaSymbol*) ns);
			vala_collection_add ((ValaCollection*) self->priv->namespaces, _tmp9_);
			_tmp10_ = vala_symbol_get_name ((ValaSymbol*) ns);
			vala_map_set ((ValaMap*) pkgmap, _tmp10_, (ValaSet*) symbolset);
			if (verbose) {
				const gchar* _tmp11_ = NULL;
				ValaSourceReference* _tmp12_ = NULL;
				ValaSourceFile* _tmp13_ = NULL;
				const gchar* _tmp14_ = NULL;
				_tmp11_ = vala_symbol_get_name ((ValaSymbol*) ns);
				_tmp12_ = vala_code_node_get_source_reference ((ValaCodeNode*) ns);
				_tmp13_ = vala_source_reference_get_file (_tmp12_);
				_tmp14_ = vala_source_file_get_gir_namespace (_tmp13_);
				g_printerr ("Reading namespace %s %s in package %s\n", _tmp11_, _tmp14_, pkg);
			}
			{
				ValaList* _tmp15_ = NULL;
				ValaList* _c_list;
				gint _tmp16_;
				gint _c_size;
				gint _c_index;
				_tmp15_ = vala_namespace_get_classes (ns);
				_c_list = _tmp15_;
				_tmp16_ = vala_collection_get_size ((ValaCollection*) _c_list);
				_c_size = _tmp16_;
				_c_index = -1;
				while (TRUE) {
					gpointer _tmp17_ = NULL;
					ValaClass* c;
					_c_index = _c_index + 1;
					if (!(_c_index < _c_size)) {
						break;
					}
					_tmp17_ = vala_list_get (_c_list, _c_index);
					c = (ValaClass*) _tmp17_;
					vapi_info_add_symbol (self, symbolset, (ValaSymbol*) c, pkg);
					_vala_code_node_unref0 (c);
				}
				_vala_iterable_unref0 (_c_list);
			}
			{
				ValaList* _tmp18_ = NULL;
				ValaList* _c_list;
				gint _tmp19_;
				gint _c_size;
				gint _c_index;
				_tmp18_ = vala_namespace_get_constants (ns);
				_c_list = _tmp18_;
				_tmp19_ = vala_collection_get_size ((ValaCollection*) _c_list);
				_c_size = _tmp19_;
				_c_index = -1;
				while (TRUE) {
					gpointer _tmp20_ = NULL;
					ValaConstant* c;
					_c_index = _c_index + 1;
					if (!(_c_index < _c_size)) {
						break;
					}
					_tmp20_ = vala_list_get (_c_list, _c_index);
					c = (ValaConstant*) _tmp20_;
					vapi_info_add_symbol (self, symbolset, (ValaSymbol*) c, pkg);
					_vala_code_node_unref0 (c);
				}
				_vala_iterable_unref0 (_c_list);
			}
			{
				ValaList* _tmp21_ = NULL;
				ValaList* _d_list;
				gint _tmp22_;
				gint _d_size;
				gint _d_index;
				_tmp21_ = vala_namespace_get_delegates (ns);
				_d_list = _tmp21_;
				_tmp22_ = vala_collection_get_size ((ValaCollection*) _d_list);
				_d_size = _tmp22_;
				_d_index = -1;
				while (TRUE) {
					gpointer _tmp23_ = NULL;
					ValaDelegate* d;
					_d_index = _d_index + 1;
					if (!(_d_index < _d_size)) {
						break;
					}
					_tmp23_ = vala_list_get (_d_list, _d_index);
					d = (ValaDelegate*) _tmp23_;
					vapi_info_add_symbol (self, symbolset, (ValaSymbol*) d, pkg);
					_vala_code_node_unref0 (d);
				}
				_vala_iterable_unref0 (_d_list);
			}
			{
				ValaList* _tmp24_ = NULL;
				ValaList* _e_list;
				gint _tmp25_;
				gint _e_size;
				gint _e_index;
				_tmp24_ = vala_namespace_get_enums (ns);
				_e_list = _tmp24_;
				_tmp25_ = vala_collection_get_size ((ValaCollection*) _e_list);
				_e_size = _tmp25_;
				_e_index = -1;
				while (TRUE) {
					gpointer _tmp26_ = NULL;
					ValaEnum* e;
					_e_index = _e_index + 1;
					if (!(_e_index < _e_size)) {
						break;
					}
					_tmp26_ = vala_list_get (_e_list, _e_index);
					e = (ValaEnum*) _tmp26_;
					vapi_info_add_symbol (self, symbolset, (ValaSymbol*) e, pkg);
					_vala_code_node_unref0 (e);
				}
				_vala_iterable_unref0 (_e_list);
			}
			{
				ValaList* _tmp27_ = NULL;
				ValaList* _e_list;
				gint _tmp28_;
				gint _e_size;
				gint _e_index;
				_tmp27_ = vala_namespace_get_error_domains (ns);
				_e_list = _tmp27_;
				_tmp28_ = vala_collection_get_size ((ValaCollection*) _e_list);
				_e_size = _tmp28_;
				_e_index = -1;
				while (TRUE) {
					gpointer _tmp29_ = NULL;
					ValaErrorDomain* e;
					_e_index = _e_index + 1;
					if (!(_e_index < _e_size)) {
						break;
					}
					_tmp29_ = vala_list_get (_e_list, _e_index);
					e = (ValaErrorDomain*) _tmp29_;
					vapi_info_add_symbol (self, symbolset, (ValaSymbol*) e, pkg);
					_vala_code_node_unref0 (e);
				}
				_vala_iterable_unref0 (_e_list);
			}
			{
				ValaList* _tmp30_ = NULL;
				ValaList* _f_list;
				gint _tmp31_;
				gint _f_size;
				gint _f_index;
				_tmp30_ = vala_namespace_get_fields (ns);
				_f_list = _tmp30_;
				_tmp31_ = vala_collection_get_size ((ValaCollection*) _f_list);
				_f_size = _tmp31_;
				_f_index = -1;
				while (TRUE) {
					gpointer _tmp32_ = NULL;
					ValaField* f;
					_f_index = _f_index + 1;
					if (!(_f_index < _f_size)) {
						break;
					}
					_tmp32_ = vala_list_get (_f_list, _f_index);
					f = (ValaField*) _tmp32_;
					vapi_info_add_symbol (self, symbolset, (ValaSymbol*) f, pkg);
					_vala_code_node_unref0 (f);
				}
				_vala_iterable_unref0 (_f_list);
			}
			{
				ValaList* _tmp33_ = NULL;
				ValaList* _i_list;
				gint _tmp34_;
				gint _i_size;
				gint _i_index;
				_tmp33_ = vala_namespace_get_interfaces (ns);
				_i_list = _tmp33_;
				_tmp34_ = vala_collection_get_size ((ValaCollection*) _i_list);
				_i_size = _tmp34_;
				_i_index = -1;
				while (TRUE) {
					gpointer _tmp35_ = NULL;
					ValaInterface* i;
					_i_index = _i_index + 1;
					if (!(_i_index < _i_size)) {
						break;
					}
					_tmp35_ = vala_list_get (_i_list, _i_index);
					i = (ValaInterface*) _tmp35_;
					vapi_info_add_symbol (self, symbolset, (ValaSymbol*) i, pkg);
					_vala_code_node_unref0 (i);
				}
				_vala_iterable_unref0 (_i_list);
			}
			{
				ValaList* _tmp36_ = NULL;
				ValaList* _m_list;
				gint _tmp37_;
				gint _m_size;
				gint _m_index;
				_tmp36_ = vala_namespace_get_methods (ns);
				_m_list = _tmp36_;
				_tmp37_ = vala_collection_get_size ((ValaCollection*) _m_list);
				_m_size = _tmp37_;
				_m_index = -1;
				while (TRUE) {
					gpointer _tmp38_ = NULL;
					ValaMethod* m;
					_m_index = _m_index + 1;
					if (!(_m_index < _m_size)) {
						break;
					}
					_tmp38_ = vala_list_get (_m_list, _m_index);
					m = (ValaMethod*) _tmp38_;
					vapi_info_add_symbol (self, symbolset, (ValaSymbol*) m, pkg);
					_vala_code_node_unref0 (m);
				}
				_vala_iterable_unref0 (_m_list);
			}
			{
				ValaList* _tmp39_ = NULL;
				ValaList* _s_list;
				gint _tmp40_;
				gint _s_size;
				gint _s_index;
				_tmp39_ = vala_namespace_get_structs (ns);
				_s_list = _tmp39_;
				_tmp40_ = vala_collection_get_size ((ValaCollection*) _s_list);
				_s_size = _tmp40_;
				_s_index = -1;
				while (TRUE) {
					gpointer _tmp41_ = NULL;
					ValaStruct* s;
					_s_index = _s_index + 1;
					if (!(_s_index < _s_size)) {
						break;
					}
					_tmp41_ = vala_list_get (_s_list, _s_index);
					s = (ValaStruct*) _tmp41_;
					vapi_info_add_symbol (self, symbolset, (ValaSymbol*) s, pkg);
					_vala_code_node_unref0 (s);
				}
				_vala_iterable_unref0 (_s_list);
			}
			_vala_iterable_unref0 (symbolset);
			_vala_code_node_unref0 (ns);
		}
		_vala_iterable_unref0 (_ns_list);
	}
	vala_map_set (self->priv->symbols, pkg, (ValaMap*) pkgmap);
	vala_code_context_pop ();
	_vala_code_context_unref0 (ctx);
	_vala_map_unref0 (pkgmap);
}


static void vapi_info_add_package (VapiInfo* self, ValaCodeContext* ctx, const gchar* pkg) {
	gboolean _tmp0_;
	gchar* package_path;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ctx != NULL);
	g_return_if_fail (pkg != NULL);
	_tmp0_ = vala_code_context_has_package (ctx, pkg);
	if (_tmp0_) {
		return;
	}
	vala_code_context_add_package (ctx, pkg);
	package_path = NULL;
	if (g_strcmp0 (mode, "vapi") == 0) {
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		_tmp1_ = vala_code_context_get_vapi_path (ctx, pkg);
		_tmp2_ = _tmp1_;
		_g_free0 (package_path);
		package_path = _tmp2_;
	} else {
		if (g_strcmp0 (mode, "gir") == 0) {
			gchar* _tmp3_ = NULL;
			gchar* _tmp4_;
			_tmp3_ = vala_code_context_get_gir_path (ctx, pkg);
			_tmp4_ = _tmp3_;
			_g_free0 (package_path);
			package_path = _tmp4_;
		}
	}
	if (package_path != NULL) {
		ValaSourceFile* _tmp5_ = NULL;
		ValaSourceFile* _tmp6_;
		_tmp5_ = vala_source_file_new (ctx, VALA_SOURCE_FILE_TYPE_PACKAGE, package_path, NULL);
		_tmp6_ = _tmp5_;
		vala_code_context_add_source_file (ctx, _tmp6_);
		_vala_source_file_unref0 (_tmp6_);
	}
	_g_free0 (package_path);
}


ValaCodeContext* vapi_info_get_ctx (VapiInfo* self) {
	ValaCodeContext* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_ctx;
	return result;
}


static gpointer _vala_code_context_ref0 (gpointer self) {
	return self ? vala_code_context_ref (self) : NULL;
}


static void vapi_info_set_ctx (VapiInfo* self, ValaCodeContext* value) {
	ValaCodeContext* _tmp0_;
	ValaCodeContext* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_context_ref0 (value);
	_tmp1_ = _tmp0_;
	_vala_code_context_unref0 (self->priv->_ctx);
	self->priv->_ctx = _tmp1_;
	g_object_notify ((GObject *) self, "ctx");
}


static GObject * vapi_info_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	VapiInfo * self;
	ValaHashMap* _tmp0_ = NULL;
	ValaMap* _tmp1_;
	ValaHashSet* _tmp2_ = NULL;
	ValaSet* _tmp3_;
	parent_class = G_OBJECT_CLASS (vapi_info_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = VAPI_INFO (obj);
	_tmp0_ = vala_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, VALA_TYPE_MAP, (GBoxedCopyFunc) vala_map_ref, vala_map_unref, g_str_hash, g_str_equal, g_direct_equal);
	_tmp1_ = (ValaMap*) _tmp0_;
	_vala_map_unref0 (self->priv->symbols);
	self->priv->symbols = _tmp1_;
	_tmp2_ = vala_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_str_hash, g_str_equal);
	_tmp3_ = (ValaSet*) _tmp2_;
	_vala_iterable_unref0 (self->priv->namespaces);
	self->priv->namespaces = _tmp3_;
	{
		ValaSet* _tmp4_ = NULL;
		ValaSet* _tmp5_;
		ValaIterator* _tmp6_ = NULL;
		ValaIterator* _tmp7_;
		ValaIterator* _pkg_it;
		_tmp4_ = vapi_info_get_pkg_list (self);
		_tmp5_ = _tmp4_;
		_tmp6_ = vala_iterable_iterator ((ValaIterable*) _tmp5_);
		_pkg_it = (_tmp7_ = _tmp6_, _vala_iterable_unref0 (_tmp5_), _tmp7_);
		while (TRUE) {
			gboolean _tmp8_;
			gpointer _tmp9_ = NULL;
			gchar* pkg;
			_tmp8_ = vala_iterator_next (_pkg_it);
			if (!_tmp8_) {
				break;
			}
			_tmp9_ = vala_iterator_get (_pkg_it);
			pkg = (gchar*) _tmp9_;
			vapi_info_process_pkg (self, pkg);
			_g_free0 (pkg);
		}
		_vala_iterator_unref0 (_pkg_it);
	}
	return obj;
}


static void vapi_info_class_init (VapiInfoClass * klass) {
	vapi_info_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (VapiInfoPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_vapi_info_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_vapi_info_set_property;
	G_OBJECT_CLASS (klass)->constructor = vapi_info_constructor;
	G_OBJECT_CLASS (klass)->finalize = vapi_info_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VAPI_INFO_CTX, vala_param_spec_code_context ("ctx", "ctx", "ctx", VALA_TYPE_CODE_CONTEXT, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void vapi_info_instance_init (VapiInfo * self) {
	self->priv = VAPI_INFO_GET_PRIVATE (self);
}


static void vapi_info_finalize (GObject* obj) {
	VapiInfo * self;
	self = VAPI_INFO (obj);
	_vala_code_context_unref0 (self->priv->_ctx);
	_vala_map_unref0 (self->priv->symbols);
	_vala_iterable_unref0 (self->priv->namespaces);
	G_OBJECT_CLASS (vapi_info_parent_class)->finalize (obj);
}


GType vapi_info_get_type (void) {
	static volatile gsize vapi_info_type_id__volatile = 0;
	if (g_once_init_enter (&vapi_info_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (VapiInfoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vapi_info_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (VapiInfo), 0, (GInstanceInitFunc) vapi_info_instance_init, NULL };
		GType vapi_info_type_id;
		vapi_info_type_id = g_type_register_static (G_TYPE_OBJECT, "VapiInfo", &g_define_type_info, 0);
		g_once_init_leave (&vapi_info_type_id__volatile, vapi_info_type_id);
	}
	return vapi_info_type_id__volatile;
}


static void _vala_vapi_info_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	VapiInfo * self;
	self = VAPI_INFO (object);
	switch (property_id) {
		case VAPI_INFO_CTX:
		vala_value_set_code_context (value, vapi_info_get_ctx (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_vapi_info_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	VapiInfo * self;
	self = VAPI_INFO (object);
	switch (property_id) {
		case VAPI_INFO_CTX:
		vapi_info_set_ctx (self, vala_value_get_code_context (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void symbol_catcher_catch (SymbolCatcher* self, ValaCodeContext* ctx, VapiInfo* vinfo) {
	ValaHashSet* _tmp0_ = NULL;
	ValaSet* _tmp1_;
	ValaCodeContext* _tmp2_;
	ValaCodeContext* _tmp3_;
	VapiInfo* _tmp4_;
	VapiInfo* _tmp5_;
	ValaNamespace* _tmp6_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ctx != NULL);
	g_return_if_fail (vinfo != NULL);
	_tmp0_ = vala_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_str_hash, g_str_equal);
	_tmp1_ = (ValaSet*) _tmp0_;
	_vala_iterable_unref0 (self->packages);
	self->packages = _tmp1_;
	_tmp2_ = _vala_code_context_ref0 (ctx);
	_tmp3_ = _tmp2_;
	_vala_code_context_unref0 (self->priv->ctx);
	self->priv->ctx = _tmp3_;
	_tmp4_ = _g_object_ref0 (vinfo);
	_tmp5_ = _tmp4_;
	_g_object_unref0 (self->priv->vinfo);
	self->priv->vinfo = _tmp5_;
	_tmp6_ = vala_code_context_get_root (self->priv->ctx);
	vala_code_node_accept ((ValaCodeNode*) _tmp6_, (ValaCodeVisitor*) self);
}


static void symbol_catcher_descend (SymbolCatcher* self, ValaCodeNode* n) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (n != NULL);
	vala_code_node_accept_children (n, (ValaCodeVisitor*) self);
}


static gpointer _vala_iterable_ref0 (gpointer self) {
	return self ? vala_iterable_ref (self) : NULL;
}


static void symbol_catcher_add_symbol (SymbolCatcher* self, const gchar* name, const gchar* prev, ValaList* usings) {
	ValaSet* usings_set;
	gboolean _tmp0_ = FALSE;
	ValaSet* _tmp11_ = NULL;
	ValaSet* pkgs;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	usings_set = NULL;
	if (prev != NULL) {
		gboolean _tmp1_;
		_tmp1_ = vapi_info_is_namespace (self->priv->vinfo, name);
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		ValaHashSet* _tmp2_ = NULL;
		ValaSet* _tmp3_;
		_tmp2_ = vala_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_str_hash, g_str_equal);
		_tmp3_ = (ValaSet*) _tmp2_;
		_vala_iterable_unref0 (usings_set);
		usings_set = _tmp3_;
		vala_collection_add ((ValaCollection*) usings_set, name);
		name = prev;
	} else {
		ValaHashSet* _tmp4_ = NULL;
		ValaSet* _tmp5_;
		_tmp4_ = vala_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_str_hash, g_str_equal);
		_tmp5_ = (ValaSet*) _tmp4_;
		_vala_iterable_unref0 (usings_set);
		usings_set = _tmp5_;
		{
			ValaList* _tmp6_;
			ValaList* _u_list;
			gint _tmp7_;
			gint _u_size;
			gint _u_index;
			_tmp6_ = _vala_iterable_ref0 (usings);
			_u_list = _tmp6_;
			_tmp7_ = vala_collection_get_size ((ValaCollection*) _u_list);
			_u_size = _tmp7_;
			_u_index = -1;
			while (TRUE) {
				gpointer _tmp8_ = NULL;
				ValaUsingDirective* u;
				ValaSymbol* _tmp9_ = NULL;
				const gchar* _tmp10_ = NULL;
				_u_index = _u_index + 1;
				if (!(_u_index < _u_size)) {
					break;
				}
				_tmp8_ = vala_list_get (_u_list, _u_index);
				u = (ValaUsingDirective*) _tmp8_;
				_tmp9_ = vala_using_directive_get_namespace_symbol (u);
				_tmp10_ = vala_symbol_get_name (_tmp9_);
				vala_collection_add ((ValaCollection*) usings_set, _tmp10_);
				_vala_code_node_unref0 (u);
			}
			_vala_iterable_unref0 (_u_list);
		}
	}
	_tmp11_ = vapi_info_pkgs_for_symbol (self->priv->vinfo, name, usings_set);
	pkgs = _tmp11_;
	{
		ValaIterator* _tmp12_ = NULL;
		ValaIterator* _pkg_it;
		_tmp12_ = vala_iterable_iterator ((ValaIterable*) pkgs);
		_pkg_it = _tmp12_;
		while (TRUE) {
			gboolean _tmp13_;
			gpointer _tmp14_ = NULL;
			gchar* pkg;
			_tmp13_ = vala_iterator_next (_pkg_it);
			if (!_tmp13_) {
				break;
			}
			_tmp14_ = vala_iterator_get (_pkg_it);
			pkg = (gchar*) _tmp14_;
			vala_collection_add ((ValaCollection*) self->packages, pkg);
			_g_free0 (pkg);
		}
		_vala_iterator_unref0 (_pkg_it);
	}
	_vala_iterable_unref0 (pkgs);
	_vala_iterable_unref0 (usings_set);
}


static gpointer _vala_code_node_ref0 (gpointer self) {
	return self ? vala_code_node_ref (self) : NULL;
}


static void symbol_catcher_real_visit_data_type (ValaCodeVisitor* base, ValaDataType* data_type) {
	SymbolCatcher * self;
	self = (SymbolCatcher*) base;
	g_return_if_fail (data_type != NULL);
	if (VALA_IS_UNRESOLVED_TYPE (data_type)) {
		ValaDataType* _tmp0_;
		ValaUnresolvedSymbol* _tmp1_ = NULL;
		ValaUnresolvedSymbol* _tmp2_;
		ValaUnresolvedSymbol* unsymbol;
		ValaUnresolvedSymbol* prev;
		const gchar* _tmp9_;
		const gchar* _tmp11_ = NULL;
		ValaSourceReference* _tmp12_ = NULL;
		ValaList* _tmp13_ = NULL;
		_tmp1_ = vala_unresolved_type_get_unresolved_symbol ((_tmp0_ = data_type, VALA_IS_UNRESOLVED_TYPE (_tmp0_) ? ((ValaUnresolvedType*) _tmp0_) : NULL));
		_tmp2_ = _vala_code_node_ref0 (_tmp1_);
		unsymbol = _tmp2_;
		prev = NULL;
		while (TRUE) {
			ValaUnresolvedSymbol* _tmp3_ = NULL;
			ValaUnresolvedSymbol* _tmp4_;
			ValaUnresolvedSymbol* _tmp5_;
			ValaUnresolvedSymbol* _tmp6_ = NULL;
			ValaUnresolvedSymbol* _tmp7_;
			ValaUnresolvedSymbol* _tmp8_;
			_tmp3_ = vala_unresolved_symbol_get_inner (unsymbol);
			if (!(_tmp3_ != NULL)) {
				break;
			}
			_tmp4_ = _vala_code_node_ref0 (unsymbol);
			_tmp5_ = _tmp4_;
			_vala_code_node_unref0 (prev);
			prev = _tmp5_;
			_tmp6_ = vala_unresolved_symbol_get_inner (unsymbol);
			_tmp7_ = _vala_code_node_ref0 (_tmp6_);
			_tmp8_ = _tmp7_;
			_vala_code_node_unref0 (unsymbol);
			unsymbol = _tmp8_;
		}
		_tmp9_ = NULL;
		if (prev == NULL) {
			_tmp9_ = NULL;
		} else {
			const gchar* _tmp10_ = NULL;
			_tmp10_ = vala_symbol_get_name ((ValaSymbol*) prev);
			_tmp9_ = _tmp10_;
		}
		_tmp11_ = vala_symbol_get_name ((ValaSymbol*) unsymbol);
		_tmp12_ = vala_code_node_get_source_reference ((ValaCodeNode*) data_type);
		_tmp13_ = vala_source_reference_get_using_directives (_tmp12_);
		symbol_catcher_add_symbol (self, _tmp11_, _tmp9_, _tmp13_);
		_vala_code_node_unref0 (prev);
		_vala_code_node_unref0 (unsymbol);
	}
	symbol_catcher_descend (self, (ValaCodeNode*) data_type);
}


static void symbol_catcher_real_visit_member_access (ValaCodeVisitor* base, ValaMemberAccess* expr) {
	SymbolCatcher * self;
	ValaMemberAccess* _tmp0_;
	ValaMemberAccess* inner;
	ValaMemberAccess* prev;
	const gchar* _tmp10_;
	const gchar* _tmp12_ = NULL;
	ValaSourceReference* _tmp13_ = NULL;
	ValaList* _tmp14_ = NULL;
	self = (SymbolCatcher*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = _vala_code_node_ref0 (expr);
	inner = _tmp0_;
	prev = NULL;
	while (TRUE) {
		gboolean _tmp1_ = FALSE;
		ValaExpression* _tmp2_ = NULL;
		ValaMemberAccess* _tmp4_;
		ValaMemberAccess* _tmp5_;
		ValaExpression* _tmp6_ = NULL;
		ValaExpression* _tmp7_;
		ValaMemberAccess* _tmp8_;
		ValaMemberAccess* _tmp9_;
		_tmp2_ = vala_member_access_get_inner (inner);
		if (_tmp2_ != NULL) {
			ValaExpression* _tmp3_ = NULL;
			_tmp3_ = vala_member_access_get_inner (inner);
			_tmp1_ = VALA_IS_MEMBER_ACCESS (_tmp3_);
		} else {
			_tmp1_ = FALSE;
		}
		if (!_tmp1_) {
			break;
		}
		_tmp4_ = _vala_code_node_ref0 (inner);
		_tmp5_ = _tmp4_;
		_vala_code_node_unref0 (prev);
		prev = _tmp5_;
		_tmp6_ = vala_member_access_get_inner (inner);
		_tmp8_ = _vala_code_node_ref0 ((_tmp7_ = _tmp6_, VALA_IS_MEMBER_ACCESS (_tmp7_) ? ((ValaMemberAccess*) _tmp7_) : NULL));
		_tmp9_ = _tmp8_;
		_vala_code_node_unref0 (inner);
		inner = _tmp9_;
	}
	_tmp10_ = NULL;
	if (prev == NULL) {
		_tmp10_ = NULL;
	} else {
		const gchar* _tmp11_ = NULL;
		_tmp11_ = vala_member_access_get_member_name (prev);
		_tmp10_ = _tmp11_;
	}
	_tmp12_ = vala_member_access_get_member_name (inner);
	_tmp13_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
	_tmp14_ = vala_source_reference_get_using_directives (_tmp13_);
	symbol_catcher_add_symbol (self, _tmp12_, _tmp10_, _tmp14_);
	_vala_code_node_unref0 (prev);
	_vala_code_node_unref0 (inner);
}


static void symbol_catcher_real_visit_binary_expression (ValaCodeVisitor* base, ValaBinaryExpression* expr) {
	SymbolCatcher * self;
	self = (SymbolCatcher*) base;
	g_return_if_fail (expr != NULL);
}


static void symbol_catcher_real_visit_unary_expression (ValaCodeVisitor* base, ValaUnaryExpression* expr) {
	SymbolCatcher * self;
	self = (SymbolCatcher*) base;
	g_return_if_fail (expr != NULL);
}


static void symbol_catcher_real_visit_array_creation_expression (ValaCodeVisitor* base, ValaArrayCreationExpression* e) {
	SymbolCatcher * self;
	self = (SymbolCatcher*) base;
	g_return_if_fail (e != NULL);
	symbol_catcher_descend (self, (ValaCodeNode*) e);
}


static void symbol_catcher_real_visit_assignment (ValaCodeVisitor* base, ValaAssignment* a) {
	SymbolCatcher * self;
	self = (SymbolCatcher*) base;
	g_return_if_fail (a != NULL);
	symbol_catcher_descend (self, (ValaCodeNode*) a);
}


static void symbol_catcher_real_visit_block (ValaCodeVisitor* base, ValaBlock* b) {
	SymbolCatcher * self;
	self = (SymbolCatcher*) base;
	g_return_if_fail (b != NULL);
	symbol_catcher_descend (self, (ValaCodeNode*) b);
}


static void symbol_catcher_real_visit_catch_clause (ValaCodeVisitor* base, ValaCatchClause* clause) {
	SymbolCatcher * self;
	self = (SymbolCatcher*) base;
	g_return_if_fail (clause != NULL);
	symbol_catcher_descend (self, (ValaCodeNode*) clause);
}


static void symbol_catcher_real_visit_class (ValaCodeVisitor* base, ValaClass* cl) {
	SymbolCatcher * self;
	self = (SymbolCatcher*) base;
	g_return_if_fail (cl != NULL);
	symbol_catcher_descend (self, (ValaCodeNode*) cl);
}


static void symbol_catcher_real_visit_constant (ValaCodeVisitor* base, ValaConstant* c) {
	SymbolCatcher * self;
	self = (SymbolCatcher*) base;
	g_return_if_fail (c != NULL);
	symbol_catcher_descend (self, (ValaCodeNode*) c);
}


static void symbol_catcher_real_visit_constructor (ValaCodeVisitor* base, ValaConstructor* c) {
	SymbolCatcher * self;
	self = (SymbolCatcher*) base;
	g_return_if_fail (c != NULL);
	symbol_catcher_descend (self, (ValaCodeNode*) c);
}


static void symbol_catcher_real_visit_creation_method (ValaCodeVisitor* base, ValaCreationMethod* m) {
	SymbolCatcher * self;
	self = (SymbolCatcher*) base;
	g_return_if_fail (m != NULL);
	symbol_catcher_descend (self, (ValaCodeNode*) m);
}


static void symbol_catcher_real_visit_declaration_statement (ValaCodeVisitor* base, ValaDeclarationStatement* stmt) {
	SymbolCatcher * self;
	self = (SymbolCatcher*) base;
	g_return_if_fail (stmt != NULL);
	symbol_catcher_descend (self, (ValaCodeNode*) stmt);
}


static void symbol_catcher_real_visit_delegate (ValaCodeVisitor* base, ValaDelegate* cb) {
	SymbolCatcher * self;
	self = (SymbolCatcher*) base;
	g_return_if_fail (cb != NULL);
	symbol_catcher_descend (self, (ValaCodeNode*) cb);
}


static void symbol_catcher_real_visit_destructor (ValaCodeVisitor* base, ValaDestructor* d) {
	SymbolCatcher * self;
	self = (SymbolCatcher*) base;
	g_return_if_fail (d != NULL);
	symbol_catcher_descend (self, (ValaCodeNode*) d);
}


static void symbol_catcher_real_visit_do_statement (ValaCodeVisitor* base, ValaDoStatement* stmt) {
	SymbolCatcher * self;
	self = (SymbolCatcher*) base;
	g_return_if_fail (stmt != NULL);
	symbol_catcher_descend (self, (ValaCodeNode*) stmt);
}


static void symbol_catcher_real_visit_element_access (ValaCodeVisitor* base, ValaElementAccess* expr) {
	SymbolCatcher * self;
	self = (SymbolCatcher*) base;
	g_return_if_fail (expr != NULL);
	symbol_catcher_descend (self, (ValaCodeNode*) expr);
}


static void symbol_catcher_real_visit_enum (ValaCodeVisitor* base, ValaEnum* en) {
	SymbolCatcher * self;
	self = (SymbolCatcher*) base;
	g_return_if_fail (en != NULL);
	symbol_catcher_descend (self, (ValaCodeNode*) en);
}


static void symbol_catcher_real_visit_error_domain (ValaCodeVisitor* base, ValaErrorDomain* ed) {
	SymbolCatcher * self;
	self = (SymbolCatcher*) base;
	g_return_if_fail (ed != NULL);
	symbol_catcher_descend (self, (ValaCodeNode*) ed);
}


static void symbol_catcher_real_visit_expression_statement (ValaCodeVisitor* base, ValaExpressionStatement* stmt) {
	SymbolCatcher * self;
	self = (SymbolCatcher*) base;
	g_return_if_fail (stmt != NULL);
	symbol_catcher_descend (self, (ValaCodeNode*) stmt);
}


static void symbol_catcher_real_visit_field (ValaCodeVisitor* base, ValaField* f) {
	SymbolCatcher * self;
	self = (SymbolCatcher*) base;
	g_return_if_fail (f != NULL);
	symbol_catcher_descend (self, (ValaCodeNode*) f);
}


static void symbol_catcher_real_visit_for_statement (ValaCodeVisitor* base, ValaForStatement* stmt) {
	SymbolCatcher * self;
	self = (SymbolCatcher*) base;
	g_return_if_fail (stmt != NULL);
	symbol_catcher_descend (self, (ValaCodeNode*) stmt);
}


static void symbol_catcher_real_visit_foreach_statement (ValaCodeVisitor* base, ValaForeachStatement* stmt) {
	SymbolCatcher * self;
	self = (SymbolCatcher*) base;
	g_return_if_fail (stmt != NULL);
	symbol_catcher_descend (self, (ValaCodeNode*) stmt);
}


static void symbol_catcher_real_visit_formal_parameter (ValaCodeVisitor* base, ValaParameter* p) {
	SymbolCatcher * self;
	self = (SymbolCatcher*) base;
	g_return_if_fail (p != NULL);
	symbol_catcher_descend (self, (ValaCodeNode*) p);
}


static void symbol_catcher_real_visit_if_statement (ValaCodeVisitor* base, ValaIfStatement* stmt) {
	SymbolCatcher * self;
	self = (SymbolCatcher*) base;
	g_return_if_fail (stmt != NULL);
	symbol_catcher_descend (self, (ValaCodeNode*) stmt);
}


static void symbol_catcher_real_visit_initializer_list (ValaCodeVisitor* base, ValaInitializerList* list) {
	SymbolCatcher * self;
	self = (SymbolCatcher*) base;
	g_return_if_fail (list != NULL);
	symbol_catcher_descend (self, (ValaCodeNode*) list);
}


static void symbol_catcher_real_visit_interface (ValaCodeVisitor* base, ValaInterface* iface) {
	SymbolCatcher * self;
	self = (SymbolCatcher*) base;
	g_return_if_fail (iface != NULL);
	symbol_catcher_descend (self, (ValaCodeNode*) iface);
}


static void symbol_catcher_real_visit_lambda_expression (ValaCodeVisitor* base, ValaLambdaExpression* l) {
	SymbolCatcher * self;
	self = (SymbolCatcher*) base;
	g_return_if_fail (l != NULL);
	symbol_catcher_descend (self, (ValaCodeNode*) l);
}


static void symbol_catcher_real_visit_list_literal (ValaCodeVisitor* base, ValaListLiteral* lit) {
	SymbolCatcher * self;
	self = (SymbolCatcher*) base;
	g_return_if_fail (lit != NULL);
	symbol_catcher_descend (self, (ValaCodeNode*) lit);
}


static void symbol_catcher_real_visit_local_variable (ValaCodeVisitor* base, ValaLocalVariable* local) {
	SymbolCatcher * self;
	self = (SymbolCatcher*) base;
	g_return_if_fail (local != NULL);
	symbol_catcher_descend (self, (ValaCodeNode*) local);
}


static void symbol_catcher_real_visit_loop (ValaCodeVisitor* base, ValaLoop* stmt) {
	SymbolCatcher * self;
	self = (SymbolCatcher*) base;
	g_return_if_fail (stmt != NULL);
	symbol_catcher_descend (self, (ValaCodeNode*) stmt);
}


static void symbol_catcher_real_visit_map_literal (ValaCodeVisitor* base, ValaMapLiteral* lit) {
	SymbolCatcher * self;
	self = (SymbolCatcher*) base;
	g_return_if_fail (lit != NULL);
	symbol_catcher_descend (self, (ValaCodeNode*) lit);
}


static void symbol_catcher_real_visit_method (ValaCodeVisitor* base, ValaMethod* m) {
	SymbolCatcher * self;
	self = (SymbolCatcher*) base;
	g_return_if_fail (m != NULL);
	symbol_catcher_descend (self, (ValaCodeNode*) m);
}


static void symbol_catcher_real_visit_method_call (ValaCodeVisitor* base, ValaMethodCall* expr) {
	SymbolCatcher * self;
	self = (SymbolCatcher*) base;
	g_return_if_fail (expr != NULL);
	symbol_catcher_descend (self, (ValaCodeNode*) expr);
}


static void symbol_catcher_real_visit_namespace (ValaCodeVisitor* base, ValaNamespace* ns) {
	SymbolCatcher * self;
	self = (SymbolCatcher*) base;
	g_return_if_fail (ns != NULL);
	symbol_catcher_descend (self, (ValaCodeNode*) ns);
}


static void symbol_catcher_real_visit_object_creation_expression (ValaCodeVisitor* base, ValaObjectCreationExpression* expr) {
	SymbolCatcher * self;
	self = (SymbolCatcher*) base;
	g_return_if_fail (expr != NULL);
	symbol_catcher_descend (self, (ValaCodeNode*) expr);
}


static void symbol_catcher_real_visit_property (ValaCodeVisitor* base, ValaProperty* prop) {
	SymbolCatcher * self;
	self = (SymbolCatcher*) base;
	g_return_if_fail (prop != NULL);
	symbol_catcher_descend (self, (ValaCodeNode*) prop);
}


static void symbol_catcher_real_visit_property_accessor (ValaCodeVisitor* base, ValaPropertyAccessor* acc) {
	SymbolCatcher * self;
	self = (SymbolCatcher*) base;
	g_return_if_fail (acc != NULL);
	symbol_catcher_descend (self, (ValaCodeNode*) acc);
}


static void symbol_catcher_real_visit_reference_transfer_expression (ValaCodeVisitor* base, ValaReferenceTransferExpression* expr) {
	SymbolCatcher * self;
	self = (SymbolCatcher*) base;
	g_return_if_fail (expr != NULL);
	symbol_catcher_descend (self, (ValaCodeNode*) expr);
}


static void symbol_catcher_real_visit_return_statement (ValaCodeVisitor* base, ValaReturnStatement* stmt) {
	SymbolCatcher * self;
	self = (SymbolCatcher*) base;
	g_return_if_fail (stmt != NULL);
	symbol_catcher_descend (self, (ValaCodeNode*) stmt);
}


static void symbol_catcher_real_visit_set_literal (ValaCodeVisitor* base, ValaSetLiteral* lit) {
	SymbolCatcher * self;
	self = (SymbolCatcher*) base;
	g_return_if_fail (lit != NULL);
	symbol_catcher_descend (self, (ValaCodeNode*) lit);
}


static void symbol_catcher_real_visit_signal (ValaCodeVisitor* base, ValaSignal* sig) {
	SymbolCatcher * self;
	self = (SymbolCatcher*) base;
	g_return_if_fail (sig != NULL);
	symbol_catcher_descend (self, (ValaCodeNode*) sig);
}


static void symbol_catcher_real_visit_slice_expression (ValaCodeVisitor* base, ValaSliceExpression* expr) {
	SymbolCatcher * self;
	self = (SymbolCatcher*) base;
	g_return_if_fail (expr != NULL);
	symbol_catcher_descend (self, (ValaCodeNode*) expr);
}


static void symbol_catcher_real_visit_struct (ValaCodeVisitor* base, ValaStruct* st) {
	SymbolCatcher * self;
	self = (SymbolCatcher*) base;
	g_return_if_fail (st != NULL);
	symbol_catcher_descend (self, (ValaCodeNode*) st);
}


static void symbol_catcher_real_visit_switch_label (ValaCodeVisitor* base, ValaSwitchLabel* label) {
	SymbolCatcher * self;
	self = (SymbolCatcher*) base;
	g_return_if_fail (label != NULL);
	symbol_catcher_descend (self, (ValaCodeNode*) label);
}


static void symbol_catcher_real_visit_switch_section (ValaCodeVisitor* base, ValaSwitchSection* section) {
	SymbolCatcher * self;
	self = (SymbolCatcher*) base;
	g_return_if_fail (section != NULL);
	symbol_catcher_descend (self, (ValaCodeNode*) section);
}


static void symbol_catcher_real_visit_switch_statement (ValaCodeVisitor* base, ValaSwitchStatement* stmt) {
	SymbolCatcher * self;
	self = (SymbolCatcher*) base;
	g_return_if_fail (stmt != NULL);
	symbol_catcher_descend (self, (ValaCodeNode*) stmt);
}


static void symbol_catcher_real_visit_template (ValaCodeVisitor* base, ValaTemplate* tmpl) {
	SymbolCatcher * self;
	self = (SymbolCatcher*) base;
	g_return_if_fail (tmpl != NULL);
	symbol_catcher_descend (self, (ValaCodeNode*) tmpl);
}


static void symbol_catcher_real_visit_throw_statement (ValaCodeVisitor* base, ValaThrowStatement* stmt) {
	SymbolCatcher * self;
	self = (SymbolCatcher*) base;
	g_return_if_fail (stmt != NULL);
	symbol_catcher_descend (self, (ValaCodeNode*) stmt);
}


static void symbol_catcher_real_visit_try_statement (ValaCodeVisitor* base, ValaTryStatement* stmt) {
	SymbolCatcher * self;
	self = (SymbolCatcher*) base;
	g_return_if_fail (stmt != NULL);
	symbol_catcher_descend (self, (ValaCodeNode*) stmt);
}


static void symbol_catcher_real_visit_tuple (ValaCodeVisitor* base, ValaTuple* tuple) {
	SymbolCatcher * self;
	self = (SymbolCatcher*) base;
	g_return_if_fail (tuple != NULL);
	symbol_catcher_descend (self, (ValaCodeNode*) tuple);
}


static void symbol_catcher_real_visit_using_directive (ValaCodeVisitor* base, ValaUsingDirective* ns) {
	SymbolCatcher * self;
	self = (SymbolCatcher*) base;
	g_return_if_fail (ns != NULL);
	symbol_catcher_descend (self, (ValaCodeNode*) ns);
}


static void symbol_catcher_real_visit_while_statement (ValaCodeVisitor* base, ValaWhileStatement* stmt) {
	SymbolCatcher * self;
	self = (SymbolCatcher*) base;
	g_return_if_fail (stmt != NULL);
	symbol_catcher_descend (self, (ValaCodeNode*) stmt);
}


static void symbol_catcher_real_visit_yield_statement (ValaCodeVisitor* base, ValaYieldStatement* stmt) {
	SymbolCatcher * self;
	self = (SymbolCatcher*) base;
	g_return_if_fail (stmt != NULL);
	symbol_catcher_descend (self, (ValaCodeNode*) stmt);
}


SymbolCatcher* symbol_catcher_construct (GType object_type) {
	SymbolCatcher* self = NULL;
	self = (SymbolCatcher*) vala_code_visitor_construct (object_type);
	return self;
}


SymbolCatcher* symbol_catcher_new (void) {
	return symbol_catcher_construct (TYPE_SYMBOL_CATCHER);
}


static void symbol_catcher_class_init (SymbolCatcherClass * klass) {
	symbol_catcher_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_VISITOR_CLASS (klass)->finalize = symbol_catcher_finalize;
	g_type_class_add_private (klass, sizeof (SymbolCatcherPrivate));
	VALA_CODE_VISITOR_CLASS (klass)->visit_data_type = symbol_catcher_real_visit_data_type;
	VALA_CODE_VISITOR_CLASS (klass)->visit_member_access = symbol_catcher_real_visit_member_access;
	VALA_CODE_VISITOR_CLASS (klass)->visit_binary_expression = symbol_catcher_real_visit_binary_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_unary_expression = symbol_catcher_real_visit_unary_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_array_creation_expression = symbol_catcher_real_visit_array_creation_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_assignment = symbol_catcher_real_visit_assignment;
	VALA_CODE_VISITOR_CLASS (klass)->visit_block = symbol_catcher_real_visit_block;
	VALA_CODE_VISITOR_CLASS (klass)->visit_catch_clause = symbol_catcher_real_visit_catch_clause;
	VALA_CODE_VISITOR_CLASS (klass)->visit_class = symbol_catcher_real_visit_class;
	VALA_CODE_VISITOR_CLASS (klass)->visit_constant = symbol_catcher_real_visit_constant;
	VALA_CODE_VISITOR_CLASS (klass)->visit_constructor = symbol_catcher_real_visit_constructor;
	VALA_CODE_VISITOR_CLASS (klass)->visit_creation_method = symbol_catcher_real_visit_creation_method;
	VALA_CODE_VISITOR_CLASS (klass)->visit_declaration_statement = symbol_catcher_real_visit_declaration_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_delegate = symbol_catcher_real_visit_delegate;
	VALA_CODE_VISITOR_CLASS (klass)->visit_destructor = symbol_catcher_real_visit_destructor;
	VALA_CODE_VISITOR_CLASS (klass)->visit_do_statement = symbol_catcher_real_visit_do_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_element_access = symbol_catcher_real_visit_element_access;
	VALA_CODE_VISITOR_CLASS (klass)->visit_enum = symbol_catcher_real_visit_enum;
	VALA_CODE_VISITOR_CLASS (klass)->visit_error_domain = symbol_catcher_real_visit_error_domain;
	VALA_CODE_VISITOR_CLASS (klass)->visit_expression_statement = symbol_catcher_real_visit_expression_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_field = symbol_catcher_real_visit_field;
	VALA_CODE_VISITOR_CLASS (klass)->visit_for_statement = symbol_catcher_real_visit_for_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_foreach_statement = symbol_catcher_real_visit_foreach_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_formal_parameter = symbol_catcher_real_visit_formal_parameter;
	VALA_CODE_VISITOR_CLASS (klass)->visit_if_statement = symbol_catcher_real_visit_if_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_initializer_list = symbol_catcher_real_visit_initializer_list;
	VALA_CODE_VISITOR_CLASS (klass)->visit_interface = symbol_catcher_real_visit_interface;
	VALA_CODE_VISITOR_CLASS (klass)->visit_lambda_expression = symbol_catcher_real_visit_lambda_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_list_literal = symbol_catcher_real_visit_list_literal;
	VALA_CODE_VISITOR_CLASS (klass)->visit_local_variable = symbol_catcher_real_visit_local_variable;
	VALA_CODE_VISITOR_CLASS (klass)->visit_loop = symbol_catcher_real_visit_loop;
	VALA_CODE_VISITOR_CLASS (klass)->visit_map_literal = symbol_catcher_real_visit_map_literal;
	VALA_CODE_VISITOR_CLASS (klass)->visit_method = symbol_catcher_real_visit_method;
	VALA_CODE_VISITOR_CLASS (klass)->visit_method_call = symbol_catcher_real_visit_method_call;
	VALA_CODE_VISITOR_CLASS (klass)->visit_namespace = symbol_catcher_real_visit_namespace;
	VALA_CODE_VISITOR_CLASS (klass)->visit_object_creation_expression = symbol_catcher_real_visit_object_creation_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_property = symbol_catcher_real_visit_property;
	VALA_CODE_VISITOR_CLASS (klass)->visit_property_accessor = symbol_catcher_real_visit_property_accessor;
	VALA_CODE_VISITOR_CLASS (klass)->visit_reference_transfer_expression = symbol_catcher_real_visit_reference_transfer_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_return_statement = symbol_catcher_real_visit_return_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_set_literal = symbol_catcher_real_visit_set_literal;
	VALA_CODE_VISITOR_CLASS (klass)->visit_signal = symbol_catcher_real_visit_signal;
	VALA_CODE_VISITOR_CLASS (klass)->visit_slice_expression = symbol_catcher_real_visit_slice_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_struct = symbol_catcher_real_visit_struct;
	VALA_CODE_VISITOR_CLASS (klass)->visit_switch_label = symbol_catcher_real_visit_switch_label;
	VALA_CODE_VISITOR_CLASS (klass)->visit_switch_section = symbol_catcher_real_visit_switch_section;
	VALA_CODE_VISITOR_CLASS (klass)->visit_switch_statement = symbol_catcher_real_visit_switch_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_template = symbol_catcher_real_visit_template;
	VALA_CODE_VISITOR_CLASS (klass)->visit_throw_statement = symbol_catcher_real_visit_throw_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_try_statement = symbol_catcher_real_visit_try_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_tuple = symbol_catcher_real_visit_tuple;
	VALA_CODE_VISITOR_CLASS (klass)->visit_using_directive = symbol_catcher_real_visit_using_directive;
	VALA_CODE_VISITOR_CLASS (klass)->visit_while_statement = symbol_catcher_real_visit_while_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_yield_statement = symbol_catcher_real_visit_yield_statement;
}


static void symbol_catcher_instance_init (SymbolCatcher * self) {
	self->priv = SYMBOL_CATCHER_GET_PRIVATE (self);
}


static void symbol_catcher_finalize (ValaCodeVisitor* obj) {
	SymbolCatcher * self;
	self = SYMBOL_CATCHER (obj);
	_vala_iterable_unref0 (self->packages);
	_vala_code_context_unref0 (self->priv->ctx);
	_g_object_unref0 (self->priv->vinfo);
	VALA_CODE_VISITOR_CLASS (symbol_catcher_parent_class)->finalize (obj);
}


GType symbol_catcher_get_type (void) {
	static volatile gsize symbol_catcher_type_id__volatile = 0;
	if (g_once_init_enter (&symbol_catcher_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SymbolCatcherClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) symbol_catcher_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SymbolCatcher), 0, (GInstanceInitFunc) symbol_catcher_instance_init, NULL };
		GType symbol_catcher_type_id;
		symbol_catcher_type_id = g_type_register_static (VALA_TYPE_CODE_VISITOR, "SymbolCatcher", &g_define_type_info, 0);
		g_once_init_leave (&symbol_catcher_type_id__volatile, symbol_catcher_type_id);
	}
	return symbol_catcher_type_id__volatile;
}



