/* This file is automatically generated by sql_to_c.awk */

#include "sqlnode.h"
#include "sqlfn.h"
#include "sqltype.h"

/* replddk.sql */

static const char *tbl0 = 
"create table SYS_TP_ITEM (\n"
"TI_SERVER 	varchar,\n"
"TI_ACCT 		varchar,\n"
"TI_TYPE 		integer,\n"
"TI_ITEM 		varchar,\n"
"TI_OPTIONS 	any,\n"
"TI_IS_COPY 	integer,\n"
"TI_DAV_USER	varchar,\n"
"TI_DAV_GROUP	varchar,\n"
"primary key (TI_SERVER, TI_ACCT, TI_TYPE, TI_ITEM)\n"
")\n";

static const char *view0 = 
"create view TP_ITEM as select * from SYS_TP_ITEM where TI_SERVER = repl_this_server ()\n";

static const char *other0 = 
"exec (\'grant select on TP_ITEM to PUBLIC\')\n";
static const char *view1 = 
"create view REPL_ACCOUNTS as select SERVER, ACCOUNT from SYS_REPL_ACCOUNTS\n"
"where SERVER = repl_this_server () and ACCOUNT <> repl_this_server ()\n";

static const char *other1 = 
"exec (\'grant select on REPL_ACCOUNTS to PUBLIC\')\n";
static const char *tbl1 = 
"create table SYS_TP_GRANT (\n"
"TPG_ACCT 	varchar,\n"
"TPG_GRANTEE 	varchar,\n"
"primary key (TPG_ACCT, TPG_GRANTEE)\n"
")\n";

static const char *tbl2 = 
"create table SYS_REPL_CR (\n"
"CR_ID         integer,\n"
"CR_TABLE_NAME varchar,\n"
"CR_TYPE       char,\n"
"CR_PROC       varchar,\n"
"CR_ORDER      integer,\n"
"\n"
"primary key (CR_ID)\n"
")\n";

static const char *other2 = 
"exec (\'grant select on SYS_REPL_CR to PUBLIC\')\n";
/* davddk.sql */

static const char *tbl3 = 
"create table WS.WS.SYS_DAV_COL (\n"
"COL_ID              integer,\n"
"COL_NAME            varchar (256),\n"
"COL_OWNER           integer,\n"
"COL_GROUP           integer,\n"
"COL_PARENT          integer,\n"
"COL_CR_TIME         datetime,\n"
"COL_MOD_TIME        datetime,\n"
"COL_PERMS           char (11),\n"
"COL_DET             varchar,\n"
"COL_ACL             long varbinary,\n"
"COL_IID 		IRI_ID,\n"
"COL_AUTO_VERSIONING char(1),\n"
"COL_FORK 		integer not null default 0,\n"
"COL_INHERIT		char(1) default \'N\',\n"
"primary key (COL_NAME, COL_PARENT)\n"
")\n"
"alter index SYS_DAV_COL on WS.WS.SYS_DAV_COL partition (COL_PARENT int)\n"
"create index SYS_DAV_COL_PARENT_ID on WS.WS.SYS_DAV_COL (COL_PARENT) partition (COL_PARENT int)\n"
"create unique index SYS_DAV_COL_ID on WS.WS.SYS_DAV_COL (COL_ID) partition (COL_ID int)\n"
"create index SYS_DAV_COL_IID on WS.WS.SYS_DAV_COL (COL_IID) partition (COL_IID int (0hexffff00))\n";

static const char *tbl4 = 
"create table WS.WS.SYS_DAV_RES (\n"
"RES_ID              integer,\n"
"RES_NAME            varchar (256),\n"
"RES_OWNER           integer,\n"
"RES_GROUP           integer,\n"
"RES_COL             integer,\n"
"RES_CONTENT         long varbinary IDENTIFIED BY RES_FULL_PATH,\n"
"RES_TYPE            varchar,\n"
"RES_CR_TIME         datetime,\n"
"RES_MOD_TIME        datetime,\n"
"RES_PERMS           char (11),\n"
"RES_FULL_PATH       varchar,\n"
"ROWGUID             varchar,\n"
"RES_ACL             long varbinary,\n"
"RES_IID 		IRI_ID,\n"
"RES_STATUS 		varchar,\n"
"RES_VCR_ID 		integer,\n"
"RES_VCR_CO_VERSION 	integer,\n"
"RES_VCR_STATE 	integer,\n"
"primary key (RES_ID)\n"
")\n"
"create unique index SYS_DAV_RES_COL on WS.WS.SYS_DAV_RES (RES_COL, RES_NAME) partition (RES_COL int)\n"
"create index SYS_DAV_RES_FULL_PATH on WS.WS.SYS_DAV_RES (RES_FULL_PATH) partition (RES_FULL_PATH varchar (-10, 0hexffff))\n"
"alter index SYS_DAV_RES on WS.WS.SYS_DAV_RES partition (RES_ID int)\n"
"create index SYS_DAV_RES_IID on WS.WS.SYS_DAV_RES (RES_IID) partition (RES_IID int (0hexffff00))\n";

static const char *proc0 = 
"create procedure\n"
"WS.WS.SYS_DAV_RES_RES_CONTENT_INDEX_HOOK (inout vtb any, inout d_id integer)\n"
"{\n"
"return 0;\n"
"}\n"
"--src davddk.sql:112\n";

static const char *proc1 = 
"create procedure\n"
"WS.WS.SYS_DAV_RES_RES_CONTENT_UNINDEX_HOOK (inout vtb any, inout d_id integer)\n"
"{\n"
"return 0;\n"
"}\n"
"--src davddk.sql:119\n";

static const char *other3 = 
"DB.DBA.vt_create_text_index (\'WS.WS.SYS_DAV_RES\', \'RES_CONTENT\', \'RES_ID\', 2, 0, vector (\'RES_FULL_PATH\', \'RES_OWNER\', \'RES_MOD_TIME\', \'RES_TYPE\'), 1, \'*ini*\', \'*ini*\')\n";
static const char *other4 = 
"DB.DBA.vt_create_ftt (\'WS.WS.SYS_DAV_RES\', \'RES_ID\', \'RES_CONTENT\', 2)\n";
static const char *tbl5 = 
"create table WS.WS.SYS_DAV_PROP (\n"
"PROP_ID             integer,\n"
"PROP_NAME           char (256),\n"
"PROP_TYPE           char (1),\n"
"PROP_PARENT_ID      integer,\n"
"PROP_VALUE          long varchar,\n"
"primary key (PROP_PARENT_ID, PROP_TYPE, PROP_NAME)\n"
")\n"
"alter index SYS_DAV_PROP on WS.WS.SYS_DAV_PROP partition (PROP_PARENT_ID int)\n"
"\n"
"create unique index SYS_DAV_PROP_ID on WS.WS.SYS_DAV_PROP (PROP_ID) partition (PROP_ID int)\n";

static const char *tbl6 = 
"create table WS.WS.SYS_DAV_LOCK (\n"
"LOCK_TYPE           char (1),\n"
"LOCK_SCOPE          char (1),\n"
"LOCK_TOKEN          char (256),\n"
"LOCK_PARENT_TYPE    char (1),\n"
"LOCK_PARENT_ID      integer,\n"
"LOCK_TIME           datetime not null,\n"
"LOCK_TIMEOUT        integer not null,\n"
"LOCK_OWNER          integer,\n"
"LOCK_OWNER_INFO     varchar,\n"
"primary key (LOCK_PARENT_ID, LOCK_PARENT_TYPE, LOCK_TOKEN)\n"
")\n"
"alter index SYS_DAV_LOCK on WS.WS.SYS_DAV_LOCK partition (LOCK_PARENT_ID int)\n"
"create unique index SYS_DAV_LOCKTOKEN on WS.WS.SYS_DAV_LOCK (LOCK_TOKEN) partition (LOCK_TOKEN varchar)\n";

static const char *view2 = 
"create view WS.WS.SYS_DAV_USER (U_ID, U_NAME, U_FULL_NAME, U_E_MAIL, U_PWD,\n"
"U_GROUP, U_LOGIN_TIME, U_ACCOUNT_DISABLED, U_METHODS, U_DEF_PERMS, U_HOME)\n"
"as select U_ID, U_NAME, U_FULL_NAME, U_E_MAIL, U_PASSWORD as U_PWD,\n"
"U_GROUP, U_LOGIN_TIME, U_ACCOUNT_DISABLED, U_METHODS, U_DEF_PERMS, U_HOME\n"
"from DB.DBA.SYS_USERS where U_IS_ROLE = 0 and U_DAV_ENABLE = 1\n";

static const char *view3 = 
"create view WS.WS.SYS_DAV_GROUP (G_ID, G_NAME)\n"
"as select U_ID as G_ID, U_NAME as G_NAME\n"
"from DB.DBA.SYS_USERS where U_IS_ROLE = 1 and U_DAV_ENABLE = 1\n";

static const char *view4 = 
"create view WS.WS.SYS_DAV_USER_GROUP (UG_UID, UG_GID) as select GI_SUPER, GI_SUB from DB.DBA.SYS_ROLE_GRANTS\n";

static const char *tbl7 = 
"create table WS.WS.SYS_DAV_RES_TYPES (\n"
"T_EXT               varchar not null,\n"
"T_TYPE              varchar not null,\n"
"T_DESCRIPTION       varchar,\n"
"primary key (T_EXT)\n"
")\n"
"alter index SYS_DAV_RES_TYPES on WS.WS.SYS_DAV_RES_TYPES partition cluster replicated\n";

static const char *tbl8 = 
"create table WS.WS.SYS_MIME_TYPES (\n"
"MT_IDENT              varchar not null,\n"
"MT_DESCRIPTION        varchar not null,\n"
"MT_DEFAULT_EXT        varchar not null,\n"
"MT_BADMAGIC_IDENT     varchar,\n"
"primary key (MT_IDENT)\n"
")\n"
"alter index SYS_MIME_TYPES on WS.WS.SYS_MIME_TYPES partition cluster replicated\n";

static const char *tbl9 = 
"create table WS.WS.SYS_RDF_SCHEMAS (\n"
"RS_URI                varchar not null,\n"
"RS_LOCATION           varchar,\n"
"RS_LOCAL_ADDONS       varchar,\n"
"RS_PRECOMPILED        long xml,\n"
"RS_COMPILATION_DATE   datetime,\n"
"RS_CATNAME            varchar,\n"
"RS_PROP_CATNAMES      long varchar,\n"
"RS_DEPRECATED         integer,\n"
"primary key (RS_URI)\n"
")\n"
"alter index SYS_RDF_SCHEMAS on WS.WS.SYS_RDF_SCHEMAS partition cluster replicated\n"
"create unique index SYS_RDF_SCHEMAS_CATNAME on WS.WS.SYS_RDF_SCHEMAS (RS_CATNAME) partition cluster replicated\n";

static const char *tbl10 = 
"create table WS.WS.SYS_MIME_RDFS (\n"
"MR_MIME_IDENT         varchar not null,\n"
"MR_RDF_URI            varchar not null,\n"
"MR_DEPRECATED         integer,\n"
"primary key (MR_MIME_IDENT, MR_RDF_URI)\n"
")\n"
"alter index SYS_MIME_RDFS on WS.WS.SYS_MIME_RDFS partition cluster replicated\n";

static const char *tbl11 = 
"create table WS.WS.SYS_RDF_PROP_NAME (\n"
"RPN_URI      varchar not null primary key,\n"
"RPN_CATID    integer\n"
")\n"
"alter index SYS_RDF_PROP_NAME on WS.WS.SYS_RDF_PROP_NAME partition cluster replicated\n"
"create unique index SYS_RDF_PROP_NAME_CATID on WS.WS.SYS_RDF_PROP_NAME (RPN_CATID) partition cluster replicated\n";

static const char *tbl12 = 
"create table WS.WS.SYS_DAV_CATFILTER\n"
"(\n"
"CF_ID integer not null primary key,\n"
"CF_SEARCH_PATH varchar not null\n"
")\n"
"alter index SYS_DAV_CATFILTER on WS.WS.SYS_DAV_CATFILTER partition cluster replicated\n"
"create unique index SYS_DAV_CATFILTER_SEARCH_PATH on WS.WS.SYS_DAV_CATFILTER (CF_SEARCH_PATH) partition cluster replicated\n";

static const char *tbl13 = 
"create table WS.WS.SYS_DAV_CATFILTER_DETS\n"
"(\n"
"CFD_CF_ID integer not null,\n"
"CFD_DET_SUBCOL_ID integer not null,\n"
"CFD_DET varchar not null,\n"
"primary key (CFD_CF_ID, CFD_DET_SUBCOL_ID)\n"
")\n"
"alter index SYS_DAV_CATFILTER_DETS on WS.WS.SYS_DAV_CATFILTER_DETS partition (CFD_CF_ID int)\n";

static const char *tbl14 = 
"create table WS.WS.SYS_DAV_RDF_INVERSE\n"
"(\n"
"DRI_CATF_ID integer not null,\n"
"DRI_PROP_CATID integer not null,\n"
"DRI_CATVALUE varchar not null,\n"
"DRI_RES_ID integer not null,\n"
"primary key (DRI_CATF_ID, DRI_PROP_CATID, DRI_CATVALUE, DRI_RES_ID)\n"
")\n"
"alter index SYS_DAV_RDF_INVERSE on WS.WS.SYS_DAV_RDF_INVERSE partition (DRI_CATF_ID int)\n";

static const char *tbl15 = 
"create table WS.WS.SYS_DAV_ACL_INVERSE (\n"
"AI_FLAG        char(1) not null,\n"
"AI_PARENT_ID   integer not null,\n"
"AI_PARENT_TYPE char(1) not null,\n"
"AI_GRANTEE_ID  integer not null,\n"
"\n"
"primary key (AI_FLAG, AI_PARENT_ID, AI_PARENT_TYPE, AI_GRANTEE_ID)\n"
")\n"
"alter index SYS_DAV_ACL_INVERSE on WS.WS.SYS_DAV_ACL_INVERSE partition (AI_PARENT_ID int)\n";

static const char *view5 = 
"create view WS.WS.SYS_DAV_ACL_GRANTS (GI_SUPER, GI_SUB)\n"
"as\n"
"select U_ID as GI_SUPER, U_ID as GI_SUB from WS.WS.SYS_DAV_USER\n"
"union\n"
"select GI_SUPER, GI_SUB from DB.DBA.SYS_ROLE_GRANTS\n";

static const char *tbl16 = 
"create table WS.WS.SYS_DAV_SPACE_QUOTA\n"
"(\n"
"DSQ_HOME_PATH         varchar not null primary key,\n"
"DSQ_U_ID              integer,\n"
"DSQ_DAV_USE           numeric not null,\n"
"DSQ_APP_USE           numeric not null,\n"
"DSQ_TOTAL_USE         numeric not null,\n"
"DSQ_MAX_DAV_USE       numeric not null,\n"
"DSQ_MAX_APP_USE       numeric not null,\n"
"DSQ_MAX_TOTAL_USE     numeric not null,\n"
"DSQ_QUOTA             numeric not null,\n"
"DSQ_ABOVE_HI_YELLOW   datetime,\n"
"DSQ_LAST_WARNING      datetime\n"
")\n"
"alter index SYS_DAV_SPACE_QUOTA on WS.WS.SYS_DAV_SPACE_QUOTA partition (DSQ_HOME_PATH varchar (-10, 0hexffff))\n"
"create index SYS_DAV_SPACE_QUOTA_U_ID on WS.WS.SYS_DAV_SPACE_QUOTA (DSQ_U_ID) partition (DSQ_U_ID int)\n";

static const char *tbl17 = 
"create table WS.WS.SYS_DAV_TAG (\n"
"DT_RES_ID     integer not null,\n"
"DT_U_ID       integer not null,\n"
"DT_FT_ID      integer not null,\n"
"DT_TAGS       varchar not null,\n"
"\n"
"\n"
"primary key (DT_RES_ID, DT_U_ID)\n"
")\n"
"alter index SYS_DAV_TAG on WS.WS.SYS_DAV_TAG partition (DT_RES_ID int)\n"
"create unique index SYS_DAV_TAG_FT_ID on WS.WS.SYS_DAV_TAG (DT_FT_ID) partition (DT_FT_ID int)\n"
"create index SYS_DAV_TAG_U_ID on WS.WS.SYS_DAV_TAG (DT_U_ID) partition (DT_U_ID int)\n";

static const char *proc2 = 
" create function WS.WS.DAV_TAG_NORMALIZE (in strg varchar) returns varchar\n"
"{\n"
"declare words any;\n"
"declare norm varchar;\n"
"words := split_and_decode (cast (strg as varchar), 0, \'\\0\\0,\');\n"
"if (words is null)\n"
"return \'\';\n"
"norm := \'\';\n"
"foreach (varchar word in words) do\n"
"{\n"
"declare nword varchar;\n"
"\n"
"word := trim (replace (replace (replace (replace (word, \'\\t\', \' \'), \'\'\'\', \'\'), \'\"\', \'\'), \'\\\\\', \'\'));\n"
"if (word <> \'\')\n"
"{\n"
"again:\n"
"nword := replace (word, \'  \', \' \');\n"
"if (nword <> word)\n"
"{\n"
"word := nword;\n"
"goto again;\n"
"}\n"
"nword := replace (nword, \' \', \'_\');\n"
"if (norm <> \'\')\n"
"norm := norm || \' \' || nword;\n"
"else\n"
"norm := nword;\n"
"}\n"
"\n"
"}\n"
"return norm;\n"
"}\n"
"--src davddk.sql:362\n";

static const char *proc3 = 
"create procedure\n"
"WS.WS.SYS_DAV_TAG_DT_TAGS_INDEX_HOOK (inout vtb any, inout d_id integer)\n"
"{\n"
"for select DT_RES_ID, DT_U_ID, DT_TAGS from WS.WS.SYS_DAV_TAG where DT_FT_ID = d_id do\n"
"{\n"
"vt_batch_feed (vtb, WS.WS.DAV_TAG_NORMALIZE (DT_TAGS), 0, 0, \'x-ViDoc\');\n"
"vt_batch_feed (vtb, sprintf (\'UID%d\', DT_U_ID), 0, 0, \'x-ViDoc\');\n"
"return 1;\n"
"}\n"
"return 1;\n"
"}\n"
"--src davddk.sql:396\n";

static const char *proc4 = 
"create procedure\n"
"WS.WS.SYS_DAV_TAG_DT_TAGS_UNINDEX_HOOK (inout vtb any, inout d_id integer)\n"
"{\n"
"for select DT_RES_ID, DT_U_ID, DT_TAGS from WS.WS.SYS_DAV_TAG where DT_FT_ID = d_id do\n"
"{\n"
"vt_batch_feed (vtb, WS.WS.DAV_TAG_NORMALIZE (DT_TAGS), 1, 0, \'x-ViDoc\');\n"
"vt_batch_feed (vtb, sprintf (\'UID%d\', DT_U_ID), 1, 0, \'x-ViDoc\');\n"
"return 1;\n"
"}\n"
"return 1;\n"
"}\n"
"--src davddk.sql:409\n";

static const char *other5 = 
"DB.DBA.vt_create_text_index (\'WS.WS.SYS_DAV_TAG\', \'DT_TAGS\', \'DT_FT_ID\', 2, 0, vector (\'DT_U_ID\', \'DT_RES_ID\'), 1, \'x-ViDoc\', \'*ini*\')\n";
static const char *proc5 = 
"create procedure WS.WS.GETID (in type varchar)\n"
"{\n"
"declare id, nid integer;\n"
"declare c_cur cursor for select top 1 COL_ID from WS.WS.SYS_DAV_COL order by COL_ID desc;\n"
"declare r_cur cursor for select top 1 RES_ID from WS.WS.SYS_DAV_RES order by RES_ID desc;\n"
"declare p_cur cursor for select top 1 PROP_ID from WS.WS.SYS_DAV_PROP order by PROP_ID desc;\n"
"declare rpn_cur cursor for select top 1 RPN_CATID from WS.WS.SYS_RDF_PROP_NAME order by RPN_CATID desc;\n"
"declare cf_cur cursor for select top 1 CF_ID from WS.WS.SYS_DAV_CATFILTER order by CF_ID desc;\n"
"declare t_cur cursor for select top 1 DT_FT_ID from WS.WS.SYS_DAV_TAG order by DT_FT_ID desc;\n"
"\n"
"type := upper (type);\n"
"\n"
"set isolation = \'serializable\';\n"
"\n"
"again:\n"
"\n"
"id := 1;\n"
"whenever not found goto not_found;\n"
"\n"
"if (type = \'C\')\n"
"{\n"
"open c_cur (exclusive, prefetch 1);\n"
"fetch c_cur into id;\n"
"if (not isnull(id))\n"
"id := id + 1;\n"
"}\n"
"else if (type = \'R\')\n"
"{\n"
"open r_cur (exclusive, prefetch 1);\n"
"fetch r_cur into id;\n"
"if (not isnull(id))\n"
"id := id + 1;\n"
"}\n"
"else if (type = \'P\')\n"
"{\n"
"open p_cur (exclusive, prefetch 1);\n"
"fetch p_cur into id;\n"
"if (not isnull(id))\n"
"id := id + 1;\n"
"}\n"
"else if (type = \'RPN\')\n"
"{\n"
"open rpn_cur (exclusive, prefetch 1);\n"
"fetch rpn_cur into id;\n"
"if (not isnull(id))\n"
"id := id + 1;\n"
"}\n"
"else if (type = \'CF\')\n"
"{\n"
"open cf_cur (exclusive, prefetch 1);\n"
"fetch cf_cur into id;\n"
"if (not isnull(id))\n"
"id := id + 1;\n"
"}\n"
"else if (type = \'T\')\n"
"{\n"
"open t_cur (exclusive, prefetch 1);\n"
"fetch t_cur into id;\n"
"if (not isnull(id))\n"
"id := id + 1;\n"
"}\n"
"else\n"
"id := 0;\n"
"\n"
"not_found:\n"
"if (isnull(id))\n"
"id := 1;\n"
"\n"
"whenever not found goto return_id;\n"
"if (type = \'C\')\n"
"{\n"
"close c_cur;\n"
"select COL_ID into nid from WS.WS.SYS_DAV_COL where COL_ID = id;\n"
"goto again;\n"
"}\n"
"else if (type = \'R\')\n"
"{\n"
"close r_cur;\n"
"select RES_ID into nid from WS.WS.SYS_DAV_RES where RES_ID = id;\n"
"goto again;\n"
"}\n"
"else if (type = \'P\')\n"
"{\n"
"close p_cur;\n"
"select PROP_ID into nid from WS.WS.SYS_DAV_PROP where PROP_ID = id;\n"
"goto again;\n"
"}\n"
"else if (type = \'RPN\')\n"
"{\n"
"close rpn_cur;\n"
"select RPN_CATID into nid from WS.WS.SYS_RDF_PROP_NAME where RPN_CATID = id;\n"
"goto again;\n"
"}\n"
"else if (type = \'CF\')\n"
"{\n"
"close cf_cur;\n"
"select CF_ID into nid from WS.WS.SYS_DAV_CATFILTER where CF_ID = id;\n"
"goto again;\n"
"}\n"
"else if (type = \'T\')\n"
"{\n"
"close t_cur;\n"
"select DT_FT_ID into nid from WS.WS.SYS_DAV_TAG where DT_FT_ID = id;\n"
"goto again;\n"
"}\n"
"return_id:\n"
"return id;\n"
"}\n"
"--src davddk.sql:429\n";

static const char *proc6 = 
"create procedure WS.WS.COL_PATH (in _id any)\n"
"{\n"
"declare _path, _name varchar;\n"
"declare _p_id integer;\n"
"_path := \'/\';\n"
"if (isarray (_id))\n"
"return call (cast (_id[0] as varchar) || \'_DAV_SEARCH_PATH\')(_id, \'C\');\n"
"whenever not found goto nf;\n"
"while (_id > 0)\n"
"{\n"
"select COL_NAME, COL_PARENT into _name, _p_id from WS.WS.SYS_DAV_COL where COL_ID = _id;\n"
"_id := _p_id;\n"
"_path := concat (\'/\', _name, _path);\n"
"}\n"
"return _path;\n"
"nf:\n"
"return NULL;\n"
"}\n"
"--src davddk.sql:540\n";

static const char *proc7 = 
"create function DB.DBA.DAV_CHANGED_FUNCTIONS () returns any\n"
"{\n"
"return vector (\n"
"\'DAV_ADD_USER_INT\',\n"
"\'DAV_ADD_USER\',\n"
"\'DAV_DELETE_USER\',\n"
"\'DAV_PERM_D2U\',\n"
"\'DAV_PERM_U2D\',\n"
"\'DAV_CHECK_AUTH\',\n"
"\'DAV_HOME_DIR\',\n"
"\'DAV_ADD_GROUP_INT\',\n"
"\'DAV_ADD_GROUP\',\n"
"\'DAV_DELETE_GROUP\',\n"
"\'DAV_DIR_LIST\',\n"
"\'DAV_DIR_FILTER\',\n"
"\'DAV_GET_PARENT\',\n"
"\'DAV_DIR_SINGLE_INT\',\n"
"\'DAV_DIR_LIST_INT\',\n"
"\'DAV_DIR_FILTER_INT\',\n"
"\'DAV_SEARCH_PATH\',\n"
"\'DAV_SEARCH_ID\',\n"
"\'DAV_SEARCH_SOME_ID\',\n"
"\'DAV_HIDE_ERROR\',\n"
"\'DAV_SEARCH_SOME_ID_OR_DET\',\n"
"\'DAV_SEARCH_ID_OR_DET\',\n"
"\'DAV_OWNER_ID\',\n"
"\'DAV_IS_LOCKED\',\n"
"\'DAV_LIST_LOCKS\',\n"
"\'DAV_LIST_LOCKS_INT\',\n"
"\'DAV_REQ_CHARS_TO_BITMASK\',\n"
"\'DAV_AUTHENTICATE\',\n"
"\'DAV_AUTHENTICATE_HTTP\',\n"
"\'DAV_COL_CREATE\',\n"
"\'DAV_COL_CREATE_INT\',\n"
"\'DAV_RES_UPLOAD\',\n"
"\'DAV_RES_UPLOAD_STRSES\',\n"
"\'DAV_RES_UPLOAD_STRSES_INT\',\n"
"\'DAV_DELETE\',\n"
"\'DAV_DELETE_INT\',\n"
"\'DAV_COPY\',\n"
"\'DAV_COPY_INT\',\n"
"\'DAV_COPY_SUBTREE\',\n"
"\'DAV_MOVE\',\n"
"\'DAV_MOVE_INT\',\n"
"\'DAV_PROP_SET\',\n"
"\'DAV_PROP_SET_INT\',\n"
"\'DAV_PROP_SET_RAW\',\n"
"\'DAV_PROP_REMOVE\',\n"
"\'DAV_PROP_REMOVE_INT\',\n"
"\'DAV_PROP_GET\',\n"
"\'DAV_PROP_GET_INT\',\n"
"\'DAV_PROP_LIST\',\n"
"\'DAV_PROP_LIST_INT\',\n"
"\'DAV_DIR_P\',\n"
"\'DAV_MAKE_DIR\',\n"
"\'DAV_CHECK_PERM\',\n"
"\'DAV_CHECK_USER\',\n"
"\'DAV_RES_CONTENT\',\n"
"\'DAV_RES_CONTENT_STRSES\',\n"
"\'DAV_RES_CONTENT_INT\',\n"
"\'DAV_COL_IS_ANCESTOR_OF\',\n"
"\'DAV_COL_PATH_BOUNDARY\',\n"
"\'WS.WS.ACL_CONTAINS_GRANTEE_AND_FLAG\',\n"
"\'WS.WS.ACL_UPDATE\',\n"
"\'WS.WS.ACL_MAKE_INHERITED\',\n"
"\'WS.WS.ACL_IS_VALID\',\n"
"\'DAV_CAST_STRING_TO_INTEGER\',\n"
"\'DAV_CAST_STRING_TO_DATETIME\',\n"
"\'DAV_CAST_TEXT_TO_VARCHAR\',\n"
"\'DAV_CAST_TEXT_TO_INTEGER\',\n"
"\'DAV_CAST_TEXT_TO_DATETIME\',\n"
"\'DAV_FC_CONST_AS_SQL\',\n"
"\'DAV_FC_PRED_METAS\',\n"
"\'DAV_FC_CMP_METAS\',\n"
"\'DAV_FC_TABLE_METAS\',\n"
"\'DAV_FC_PRINT_COMPARISON\',\n"
"\'DAV_FC_PRINT_WHERE\',\n"
"\'DAV_FC_PRINT_WHERE_INT\',\n"
"\'DAV_REGISTER_RDF_SCHEMA\',\n"
"\'DAV_RDF_SCHEMA_N3_LIST_PROPERTIES\',\n"
"\'DAV_CROP_URI_TO_CATNAME\',\n"
"\'DAV_GET_RDF_SCHEMA_N3\',\n"
"\'DAV_DEPRECATE_RDF_SCHEMA\',\n"
"\'DAV_REGISTER_MIME_TYPE\',\n"
"\'DAV_REGISTER_MIME_RDF\',\n"
"\'DAV_DEPRECATE_MIME_RDF\',\n"
"\'DAV_RDF_PROP_SET\',\n"
"\'DAV_RDF_PROP_GET\',\n"
"\'DAV_RDF_PREPROCESS_RDFXML_SUB\',\n"
"\'DAV_RDF_PREPROCESS_RDFXML\',\n"
"\'DAV_RDF_PROP_SET_INT\',\n"
"\'DAV_RDF_PROP_GET_INT\',\n"
"\'DAV_RDF_MERGE\',\n"
"\'DAV_EXTRACT_AND_SAVE_RDF\',\n"
"\'DAV_EXTRACT_AND_SAVE_RDF_INT\',\n"
"\'DAV_GUESS_MIME_TYPE\',\n"
"\'DAV_EXTRACT_RDF_application/rss+xml\',\n"
"\'DAV_EXTRACT_RDF_application/atom+xml\',\n"
"\'DAV_EXTRACT_RDF_application/xbel+xml\',\n"
"\'DAV_EXTRACT_RDF_application/foaf+xml\',\n"
"\'DAV_EXTRACT_RDF_application/mods+xml\',\n"
"\'DAV_EXTRACT_RDF_application/opml+xml\',\n"
"\'DAV_EXTRACT_RDF_text/html\',\n"
"\'DAV_EXTRACT_RDF_application/x-openlinksw-vsp\',\n"
"\'DAV_EXTRACT_RDF_application/x-openlinksw-vspx+xml\',\n"
"\'DAV_EXTRACT_RDF_application/bpel+xml\',\n"
"\'DAV_EXTRACT_RDF_application/wsdl+xml\',\n"
"\'DAV_EXTRACT_RDF_application/x-openlinksw-vad\',\n"
"\'DAV_EXTRACT_RDF_application/msword+xml\',\n"
"\'IMC_TO_XML\',\n"
"\'DAV_EXTRACT_RDF_text/directory\',\n"
"\'DAV_EXTRACT_RDF_BY_METAS\',\n"
"\'UNIX_DATETIME_PARSER\',\n"
"\'UNIX_DATE_PARSER\',\n"
"\'BPEL_SPLIT_LIST\',\n"
"\'WS.WS.SYS_DAV_RES_RES_CONTENT_INDEX_HOOK\',\n"
"\'WS.WS.SYS_DAV_RES_RES_CONTENT_UNINDEX_HOOK\',\n"
"\'WS.WS.SYS_DAV_PROP_PROP_VALUE_INDEX_HOOK\',\n"
"\'WS.WS.SYS_DAV_PROP_PROP_VALUE_UNINDEX_HOOK\',\n"
"\'WS.WS.OPTIONS\',\n"
"\'WS.WS.PROPFIND\',\n"
"\'WS.WS.PROPFIND_RESPONSE\',\n"
"\'WS.WS.PROPFIND_RESPONSE_FORMAT\',\n"
"\'WS.WS.PROPNAMES\',\n"
"\'WS.WS.CUSTOM_PROP\',\n"
"\'WS.WS.PROPPATCH\',\n"
"\'WS.WS.FINDPARAM\',\n"
"\'WS.WS.MKCOL\',\n"
"\'WS.WS.FINDCOL\',\n"
"\'WS.WS.FINDRES\',\n"
"\'WS.WS.DELCHILDREN\',\n"
"\'WS.WS.DELETE\',\n"
"\'WS.WS.ISCOL\',\n"
"\'WS.WS.ISRES\',\n"
"\'WS.WS.ETAG\',\n"
"\'WS.WS.HEAD\',\n"
"\'WS.WS.PUT\',\n"
"\'WS.WS.HEX_TO_DEC\',\n"
"\'WS.WS.HEX_DIGIT\',\n"
"\'WS.WS.STR_TO_URI\',\n"
"\'WS.WS.STR_SQL_APOS\',\n"
"\'WS.WS.STR_FT_QUOT\',\n"
"\'WS.WS.PATHREF\',\n"
"\'WS.WS.IS_ACTIVE_CONTENT\',\n"
"\'WS.WS.GET_DAV_DEFAULT_PAGE\',\n"
"\'WS.WS.GET_DAV_CHUNKED_QUOTA\',\n"
"\'WS.WS.GET\',\n"
"\'WS.WS.POST\',\n"
"\'WS.WS.LOCK\',\n"
"\'WS.WS.UNLOCK\',\n"
"\'WS.WS.OPLOCKTOKEN\',\n"
"\'WS.WS.PARENT_PATH\',\n"
"\'WS.WS.HREF_TO_ARRAY\',\n"
"\'WS.WS.HREF_TO_PATH_ARRAY\',\n"
"\'WS.WS.DSTIS\',\n"
"\'WS.WS.MOVE\',\n"
"\'WS.WS.COPY\',\n"
"\'WS.WS.COPY_OR_MOVE\',\n"
"\'WS.WS.GETID\',\n"
"\'WS.WS.ISLOCKED\',\n"
"\'WS.WS.CHECK_AUTH\',\n"
"\'WS.WS.GET_IF_AUTH\',\n"
"\'WS.WS.GET_DAV_AUTH\',\n"
"\'WS.WS.PERM_COMP\',\n"
"\'WS.WS.CHECKPERM\',\n"
"\'WS.WS.ISPUBLIC\',\n"
"\'WS.WS.DAV_VSP_DEF_REMOVE\',\n"
"\'WS.WS.UPDCHILD\',\n"
"\'WS.WS.DAV_VSP_INCLUDES_CHANGED\',\n"
"\'WS.WS.EXPAND_INCLUDES\',\n"
"\'WS.WS.XML_VIEW_HEADER\',\n"
"\'WS.WS.XML_VIEW_EXTERNAL_META\',\n"
"\'WS.WS.XML_VIEW_UPDATE\',\n"
"\'WS.WS.FIXPATH\',\n"
"\'WS.WS.COL_PATH\',\n"
"\'WS.WS.ISPUBL\',\n"
"\'WS.WS.BODY_ARR\',\n"
"\'WS.WS.XML_AUTO_SCHED\',\n"
"\'WS.WS.DAV_LOGIN\',\n"
"\'WS.WS.HTTP_RESP\',\n"
"\'WS.WS.COPY_TO_OTHER\',\n"
"\'WS.WS.CHECK_READ_ACCESS\',\n"
"\'WS.WS.IS_REDIRECT_REF\',\n"
"\'WS.WS.DAV_DIR_LIST\',\n"
"\'WS.WS.DAV_CHECK_QUOTA\',\n"
"\'WS.WS.DAV_CHECK_ASMX\',\n"
"\'WS.WS.DAV_REMOVE_ASMX\',\n"
"\'WS.WS.XMLSQL_TO_STRSES\',\n"
"\'CatFilter_DAV_AUTHENTICATE\',\n"
"\'CatFilter_GET_CONDITION\',\n"
"\'CatFilter_ENCODE_CATVALUE\',\n"
"\'CatFilter_DECODE_CATVALUE\',\n"
"\'CatFilter_PATH_PARTS_TO_FILTER\',\n"
"\'CatFilter_ACC_FILTER_DATA\',\n"
"\'CatFilter_DAV_SEARCH_ID_IMPL\',\n"
"\'CatFilter_DAV_AUTHENTICATE_HTTP\',\n"
"\'CatFilter_DAV_GET_PARENT\',\n"
"\'CatFilter_DAV_COL_CREATE\',\n"
"\'CatFilter_DAV_COL_MOUNT\',\n"
"\'CatFilter_DAV_COL_MOUNT_HERE\',\n"
"\'CatFilter_DAV_DELETE\',\n"
"\'CatFilter_FILTER_TO_CONDITION\',\n"
"\'CatFilter_DAV_RES_UPLOAD\',\n"
"\'CatFilter_DAV_PROP_REMOVE\',\n"
"\'CatFilter_DAV_PROP_SET\',\n"
"\'CatFilter_DAV_PROP_GET\',\n"
"\'CatFilter_DAV_PROP_LIST\',\n"
"\'CatFilter_DAV_DIR_SINGLE\',\n"
"\'CatFilter_LIST_SCHEMAS\',\n"
"\'CatFilter_LIST_SCHEMA_PROPS\',\n"
"\'CatFilter_GET_RDF_INVERSE_HITS_DISTVALS\',\n"
"\'CatFilter_GET_RDF_INVERSE_HITS_RES_IDS\',\n"
"\'CatFilter_LIST_PROP_DISTVALS_AUX\',\n"
"\'CatFilter_LIST_PROP_DISTVALS\',\n"
"\'CatFilter_DAV_DIR_LIST\',\n"
"\'CatFilter_DAV_DIR_FILTER\',\n"
"\'CatFilter_DAV_SEARCH_ID\',\n"
"\'CatFilter_DAV_SEARCH_PATH\',\n"
"\'CatFilter_DAV_RES_UPLOAD_COPY\',\n"
"\'CatFilter_DAV_RES_UPLOAD_MOVE\',\n"
"\'CatFilter_DAV_RES_CONTENT\',\n"
"\'CatFilter_DAV_SYMLINK\',\n"
"\'CatFilter_DAV_LOCK\',\n"
"\'CatFilter_DAV_UNLOCK\',\n"
"\'CatFilter_DAV_IS_LOCKED\',\n"
"\'CatFilter_DAV_LIST_LOCKS\',\n"
"\'CatFilter_CONFIGURE\',\n"
"\'CatFilter_FEED_DAV_RDF_INVERSE\',\n"
"\'CatFilter_INIT_SYS_DAV_RDF_INVERSE\',\n"
"\'WS.WS.HOSTFS_RES_CACHE_RESC_DATA_INDEX_HOOK\',\n"
"\'WS.WS.HOSTFS_RES_CACHE_RESC_DATA_UNINDEX_HOOK\',\n"
"\'WS.WS.HOSTFS_FIND_COL\',\n"
"\'WS.WS.HOSTFS_COL_DISAPPEARS\',\n"
"\'WS.WS.HOSTFS_HANDLE_RES_SCAN\',\n"
"\'WS.WS.HOSTFS_RES_DISAPPEARS\',\n"
"\'WS.WS.HOSTFS_TOUCH_RES\',\n"
"\'WS.WS.HOSTFS_GLOBAL_RESET\',\n"
"\'WS.WS.HOSTFS_PATH_STAT\',\n"
"\'WS.WS.HOSTFS_READ_TYPEINFO\',\n"
"\'HostFs_DAV_AUTHENTICATE\',\n"
"\'HostFs_DAV_AUTHENTICATE_HTTP\',\n"
"\'HostFs_DAV_GET_PARENT\',\n"
"\'HostFs_DAV_COL_CREATE\',\n"
"\'HostFs_DAV_COL_MOUNT\',\n"
"\'HostFs_DAV_COL_MOUNT_HERE\',\n"
"\'HostFs_DAV_DELETE\',\n"
"\'createtableHostFs_DAV_RES_UPLOAD\',\n"
"\'HostFs_DAV_RES_UPLOAD\',\n"
"\'HostFs_DAV_PROP_REMOVE\',\n"
"\'HostFs_DAV_PROP_SET\',\n"
"\'HostFs_DAV_PROP_GET\',\n"
"\'HostFs_DAV_PROP_LIST\',\n"
"\'HostFs_ID_TO_OSPATH\',\n"
"\'HostFs_DAV_DIR_SINGLE\',\n"
"\'HostFs_DAV_DIR_LIST\',\n"
"\'HostFs_DAV_DIR_FILTER\',\n"
"\'HostFs_DAV_SEARCH_ID\',\n"
"\'HostFs_DAV_SEARCH_PATH\',\n"
"\'HostFs_DAV_RES_UPLOAD_COPY\',\n"
"\'HostFs_DAV_RES_UPLOAD_MOVE\',\n"
"\'HostFs_DAV_RES_CONTENT\',\n"
"\'HostFs_DAV_SYMLINK\',\n"
"\'HostFs_DAV_LOCK\',\n"
"\'HostFs_DAV_UNLOCK\',\n"
"\'HostFs_DAV_IS_LOCKED\',\n"
"\'HostFs_DAV_LIST_LOCKS\',\n"
"\'oMail_DAV_AUTHENTICATE\',\n"
"\'oMail_NORM\',\n"
"\'oMail_GET_CONFIG\',\n"
"\'oMail_FNMERGE\',\n"
"\'oMail_FNSPLIT\',\n"
"\'oMail_FIXNAME\',\n"
"\'oMail_COMPOSE_NAME\',\n"
"\'oMail_DAV_SEARCH_ID_IMPL\',\n"
"\'oMail_DAV_AUTHENTICATE_HTTP\',\n"
"\'oMail_DAV_GET_PARENT\',\n"
"\'oMail_DAV_COL_CREATE\',\n"
"\'oMail_DAV_COL_MOUNT\',\n"
"\'oMail_DAV_COL_MOUNT_HERE\',\n"
"\'oMail_DAV_DELETE\',\n"
"\'oMail_DAV_RES_UPLOAD\',\n"
"\'oMail_DAV_PROP_REMOVE\',\n"
"\'oMail_DAV_PROP_SET\',\n"
"\'oMail_DAV_PROP_GET\',\n"
"\'oMail_DAV_PROP_LIST\',\n"
"\'oMail_COLNAME_OF_FOLDER\',\n"
"\'oMail_RESNAME_OF_MAIL\',\n"
"\'oMail_DAV_DIR_SINGLE\',\n"
"\'oMail_DAV_DIR_LIST\',\n"
"\'oMail_DAV_DIR_FILTER\',\n"
"\'oMail_DAV_SEARCH_ID\',\n"
"\'oMail_DAV_SEARCH_PATH\',\n"
"\'oMail_DAV_RES_UPLOAD_COPY\',\n"
"\'oMail_DAV_RES_UPLOAD_MOVE\',\n"
"\'oMail_DAV_RES_CONTENT\',\n"
"\'oMail_DAV_SYMLINK\',\n"
"\'oMail_DAV_LOCK\',\n"
"\'oMail_DAV_UNLOCK\',\n"
"\'oMail_DAV_IS_LOCKED\',\n"
"\'oMail_DAV_LIST_LOCKS\',\n"
"\'PropFilter_DAV_AUTHENTICATE\',\n"
"\'PropFilter_NORM\',\n"
"\'PropFilter_GET_CONDITION\',\n"
"\'PropFilter_FIT_INTO_CONDITION\',\n"
"\'PropFilter_LEAVE_CONDITION\',\n"
"\'PropFilter_FNMERGE\',\n"
"\'PropFilter_FNSPLIT\',\n"
"\'PropFilter_DAV_SEARCH_ID_IMPL\',\n"
"\'PropFilter_DAV_AUTHENTICATE_HTTP\',\n"
"\'PropFilter_DAV_GET_PARENT\',\n"
"\'PropFilter_DAV_COL_CREATE\',\n"
"\'PropFilter_DAV_COL_MOUNT\',\n"
"\'PropFilter_DAV_COL_MOUNT_HERE\',\n"
"\'PropFilter_DAV_DELETE\',\n"
"\'PropFilter_DAV_RES_UPLOAD\',\n"
"\'PropFilter_DAV_PROP_REMOVE\',\n"
"\'PropFilter_DAV_PROP_SET\',\n"
"\'PropFilter_DAV_PROP_GET\',\n"
"\'PropFilter_DAV_PROP_LIST\',\n"
"\'PropFilter_DAV_DIR_SINGLE\',\n"
"\'PropFilter_DAV_DIR_LIST\',\n"
"\'PropFilter_DAV_DIR_FILTER\',\n"
"\'PropFilter_DAV_SEARCH_ID\',\n"
"\'PropFilter_DAV_SEARCH_PATH\',\n"
"\'PropFilter_DAV_RES_UPLOAD_COPY\',\n"
"\'PropFilter_DAV_RES_UPLOAD_MOVE\',\n"
"\'PropFilter_DAV_RES_CONTENT\',\n"
"\'PropFilter_DAV_SYMLINK\',\n"
"\'PropFilter_DAV_LOCK\',\n"
"\'PropFilter_DAV_UNLOCK\',\n"
"\'PropFilter_DAV_IS_LOCKED\',\n"
"\'PropFilter_DAV_LIST_LOCKS\',\n"
"\'ResFilter_DAV_AUTHENTICATE\',\n"
"\'ResFilter_NORM\',\n"
"\'ResFilter_ENCODE_FILTER\',\n"
"\'ResFilter_DECODE_FILTER\',\n"
"\'ResFilter_GET_CONDITION\',\n"
"\'ResFilter_FIT_INTO_CONDITION\',\n"
"\'ResFilter_MAKE_DEL_ACTION_FROM_CONDITION\',\n"
"\'ResFilter_LEAVE_CONDITION\',\n"
"\'ResFilter_FNMERGE\',\n"
"\'ResFilter_FNSPLIT\',\n"
"\'ResFilter_DAV_SEARCH_ID_IMPL\',\n"
"\'ResFilter_DAV_AUTHENTICATE_HTTP\',\n"
"\'ResFilter_DAV_GET_PARENT\',\n"
"\'ResFilter_DAV_COL_CREATE\',\n"
"\'ResFilter_DAV_COL_MOUNT\',\n"
"\'ResFilter_DAV_COL_MOUNT_HERE\',\n"
"\'ResFilter_DAV_DELETE\',\n"
"\'ResFilter_DAV_RES_UPLOAD\',\n"
"\'ResFilter_DAV_PROP_REMOVE\',\n"
"\'ResFilter_DAV_PROP_SET\',\n"
"\'ResFilter_DAV_PROP_GET\',\n"
"\'ResFilter_DAV_PROP_LIST\',\n"
"\'ResFilter_DAV_DIR_SINGLE\',\n"
"\'ResFilter_DAV_DIR_LIST\',\n"
"\'ResFilter_DAV_DIR_FILTER\',\n"
"\'ResFilter_DAV_SEARCH_ID\',\n"
"\'ResFilter_DAV_SEARCH_PATH\',\n"
"\'ResFilter_DAV_RES_UPLOAD_COPY\',\n"
"\'ResFilter_DAV_RES_UPLOAD_MOVE\',\n"
"\'ResFilter_DAV_RES_CONTENT\',\n"
"\'ResFilter_DAV_SYMLINK\',\n"
"\'ResFilter_DAV_LOCK\',\n"
"\'ResFilter_DAV_UNLOCK\',\n"
"\'ResFilter_DAV_IS_LOCKED\',\n"
"\'ResFilter_DAV_LIST_LOCKS\',\n"
"\'ResFilter_CONFIGURE\',\n"
"\'Stub_DAV_AUTHENTICATE\',\n"
"\'Stub_DAV_AUTHENTICATE_HTTP\',\n"
"\'Stub_DAV_GET_PARENT\',\n"
"\'Stub_DAV_COL_CREATE\',\n"
"\'Stub_DAV_COL_MOUNT\',\n"
"\'Stub_DAV_COL_MOUNT_HERE\',\n"
"\'Stub_DAV_DELETE\',\n"
"\'Stub_DAV_RES_UPLOAD\',\n"
"\'Stub_DAV_PROP_REMOVE\',\n"
"\'Stub_DAV_PROP_SET\',\n"
"\'Stub_DAV_PROP_GET\',\n"
"\'Stub_DAV_PROP_LIST\',\n"
"\'Stub_DAV_DIR_SINGLE\',\n"
"\'Stub_DAV_DIR_LIST\',\n"
"\'CatFilter_DAV_DIR_FILTER\',\n"
"\'Stub_DAV_SEARCH_ID\',\n"
"\'Stub_DAV_SEARCH_PATH\',\n"
"\'Stub_DAV_RES_UPLOAD_COPY\',\n"
"\'Stub_DAV_RES_UPLOAD_MOVE\',\n"
"\'Stub_DAV_RES_CONTENT\',\n"
"\'Stub_DAV_SYMLINK\',\n"
"\'Stub_DAV_DEREFERENCE_LIST\',\n"
"\'Stub_DAV_RESOLVE_PATH\',\n"
"\'Stub_DAV_LOCK\',\n"
"\'Stub_DAV_UNLOCK\',\n"
"\'Stub_DAV_IS_LOCKED\',\n"
"\'Stub_DAV_LIST_LOCKS\',\n"
"\'TEST_CATFILTER_MAKE_SCHEMA\',\n"
"\'TEST_CATFILTER_MAKE_SCHEMAS\',\n"
"\'TEST_CATFILTER_MAKE_USER\',\n"
"\'TEST_CATFILTER_SINGLE_FILE\',\n"
"\'TEST_CATFILTER_INIT\',\n"
"\'WebMail_DAV_AUTHENTICATE\',\n"
"\'WebMail_NORM\',\n"
"\'WebMail_GET_CONFIG\',\n"
"\'WebMail_FNMERGE\',\n"
"\'WebMail_FNSPLIT\',\n"
"\'WebMail_FIXNAME\',\n"
"\'WebMail_COMPOSE_NAME\',\n"
"\'WebMail_DAV_SEARCH_ID_IMPL\',\n"
"\'WebMail_DAV_AUTHENTICATE_HTTP\',\n"
"\'WebMail_DAV_COL_CREATE\',\n"
"\'WebMail_DAV_COL_MOUNT\',\n"
"\'WebMail_DAV_COL_MOUNT_HERE\',\n"
"\'WebMail_DAV_DELETE\',\n"
"\'WebMail_DAV_RES_UPLOAD\',\n"
"\'WebMail_DAV_PROP_REMOVE\',\n"
"\'WebMail_DAV_PROP_SET\',\n"
"\'WebMail_DAV_PROP_GET\',\n"
"\'WebMail_DAV_PROP_LIST\',\n"
"\'WebMail_COLNAME_OF_FOLDER\',\n"
"\'WebMail_RESNAME_OF_MAIL\',\n"
"\'WebMail_DAV_DIR_SINGLE\',\n"
"\'WebMail_DAV_DIR_LIST\',\n"
"\'WebMail_DAV_DIR_FILTER\',\n"
"\'WebMail_DAV_SEARCH_ID\',\n"
"\'WebMail_DAV_SEARCH_PATH\',\n"
"\'WebMail_DAV_RES_UPLOAD_COPY\',\n"
"\'WebMail_DAV_RES_UPLOAD_MOVE\',\n"
"\'WebMail_DAV_RES_CONTENT\',\n"
"\'WebMail_DAV_SYMLINK\',\n"
"\'WebMail_DAV_DIR_LIST_FT\',\n"
"\'WebMail_DAV_LOCK\',\n"
"\'WebMail_DAV_UNLOCK\',\n"
"\'WebMail_DAV_IS_LOCKED\',\n"
"\'WebMail_DAV_LIST_LOCKS\',\n"
"\'WS.WS.SYS_DAV_COL_INIT\'\n"
");\n"
"}\n"
"--src davddk.sql:561\n";

static const char *proc8 = 
"create procedure WS.WS.SYS_DAV_INIT ()\n"
"{\n"
"declare dav_status varchar;\n"
"declare nobody_name varchar;\n"
"__atomic (1);\n"
"declare exit handler for sqlstate \'*\'\n"
"{\n"
"\n"
"result (__SQL_STATE, __SQL_MESSAGE);\n"
"log_message (\'The error occurred during execution of procedure WS.WS.SYS_DAV_INIT().\');\n"
"log_message (\'This procedure has failed to upgrade WebDAV to Virtuoso 4.0 format.\');\n"
"log_message (\'The content of data stored in DAV resources remain changed, but access\');\n"
"log_message (\'permissions may become invalid. To guard your database installation from\');\n"
"log_message (\'potential security problems, remove the transaction log before restarting\');\n"
"log_message (\'the server.\');\n"
"log_message (\'The following error has terminated the upgrade:\');\n"
"log_message(concat(cast(__SQL_STATE as varchar), \' \', cast(__SQL_MESSAGE as varchar)));\n"
"raw_exit(-1);\n"
"return;\n"
"};\n"
"set triggers off;\n"
"insert soft WS.WS.SYS_DAV_COL (COL_ID, COL_NAME, COL_PARENT, COL_CR_TIME, COL_MOD_TIME, COL_OWNER, COL_GROUP, COL_PERMS) values (1, \'DAV\', 0, now (), now (), http_dav_uid (), http_admin_gid (), \'110100000R\');\n"
"nobody_name := coalesce ((select U_NAME from DB.DBA.SYS_USERS where U_ID = http_nobody_uid ()));\n"
"if (nobody_name is null)\n"
"{\n"
"declare uid, gid, ctr integer;\n"
"declare procnames any;\n"
"whenever not found goto resources_done;\n"
"declare resc cursor for select RES_OWNER, RES_GROUP from WS.WS.SYS_DAV_RES where RES_OWNER = 0 or RES_GROUP = 0 for update;\n"
"declare colc cursor for select COL_OWNER, COL_GROUP from WS.WS.SYS_DAV_COL where COL_OWNER = 0 or COL_GROUP = 0 for update;\n"
"more_resources:\n"
"ctr := 0;\n"
"open resc;\n"
"for (ctr := 0; ctr < 50000; ctr := ctr + 1)\n"
"{\n"
"fetch resc into uid, gid;\n"
"update WS.WS.SYS_DAV_RES set\n"
"RES_OWNER = case (uid) when 0 then http_nobody_uid () else uid end,\n"
"RES_GROUP = case (gid) when 0 then http_nogroup_gid () else gid end\n"
"where current of resc;\n"
"}\n"
"commit work;\n"
"goto more_resources;\n"
"resources_done:\n"
"commit work;\n"
"whenever not found goto collections_done;\n"
"more_collections:\n"
"ctr := 0;\n"
"open colc;\n"
"for (ctr := 0; ctr < 50000; ctr := ctr + 1)\n"
"{\n"
"fetch colc into uid, gid;\n"
"update WS.WS.SYS_DAV_COL set\n"
"COL_OWNER = case (uid) when 0 then http_nobody_uid () else uid end,\n"
"COL_GROUP = case (gid) when 0 then http_nogroup_gid () else gid end\n"
"where current of colc;\n"
"}\n"
"commit work;\n"
"goto more_collections;\n"
"collections_done:\n"
"commit work;\n"
"procnames := DB.DBA.DAV_CHANGED_FUNCTIONS ();\n"
"foreach (varchar procname in procnames) do\n"
"{\n"
"if (strchr (procname, \'.\'))\n"
"delete from DB.DBA.SYS_PROCEDURES where upper (P_NAME) = upper (procname);\n"
"else\n"
"delete from DB.DBA.SYS_PROCEDURES where upper (P_NAME) = upper (\'DB.DBA.\' || procname);\n"
"}\n"
"commit work;\n"
"}\n"
"else if (nobody_name <> \'nobody\')\n"
"{\n"
"log_message (sprintf (\'The user ID %d is reserved for user \"nobody\" but used by \"%s\"\', http_nobody_uid (), nobody_name));\n"
"log_message (\'The database can not be used with this version of server.\');\n"
"log_message (\'To fix the problem, drop account \"%s\" using Virtuoso 3.x server.\');\n"
"raw_exit (-1);\n"
"}\n"
"if (exists (select top 1 1 from WS.WS.SYS_DAV_PROP where PROP_ID is null))\n"
"{\n"
"declare propid, ctr integer;\n"
"whenever not found goto props_done;\n"
"declare propc cursor for select PROP_ID from WS.WS.SYS_DAV_PROP for update;\n"
"more_props:\n"
"ctr := 0;\n"
"open propc;\n"
"while (ctr < 50000)\n"
"{\n"
"fetch propc into propid;\n"
"if (propid is null)\n"
"{\n"
"ctr := ctr + 1;\n"
"propid := WS.WS.GETID (\'P\');\n"
"update WS.WS.SYS_DAV_PROP set PROP_ID = propid where current of propc;\n"
"}\n"
"}\n"
"commit work;\n"
"goto more_props;\n"
"props_done:\n"
"commit work;\n"
"}\n"
"dav_status := registry_get (\'WS.WS.SYS_DAV_INIT-status\');\n"
"if (not isstring (dav_status))\n"
"dav_status := \'\';\n"
"\n"
"if (strstr (dav_status, \'(WS.WS.SYS_DAV_CATFILTER)\') is null)\n"
"{\n"
"for (select COL_ID, COL_DET, WS.WS.COL_PATH (COL_ID) as _c_path from WS.WS.SYS_DAV_COL where COL_DET is not null and not (COL_DET like \'%Filter\')) do\n"
"{\n"
"for select CF_ID from WS.WS.SYS_DAV_CATFILTER where \"LEFT\" (_c_path, length (CF_SEARCH_PATH)) = CF_SEARCH_PATH do\n"
"{\n"
"insert replacing WS.WS.SYS_DAV_CATFILTER_DETS (CFD_CF_ID, CFD_DET_SUBCOL_ID, CFD_DET)\n"
"values (CF_ID, COL_ID, COL_DET);\n"
"}\n"
"}\n"
"dav_status := dav_status || \' (WS.WS.SYS_DAV_CATFILTER)\';\n"
"registry_set (\'WS.WS.SYS_DAV_INIT-status\', dav_status);\n"
"\n"
"commit work;\n"
"}\n"
"set triggers on;\n"
"insert soft DB.DBA.SYS_USERS (U_ID, U_NAME, U_FULL_NAME, U_E_MAIL, U_PASSWORD, U_GROUP, U_DEF_PERMS, U_ACCOUNT_DISABLED, U_SQL_ENABLE, U_DAV_ENABLE)\n"
"values (http_dav_uid (), \'dav\',\'WebDAV System Administrator\',\'somebody@example.domain\', pwd_magic_calc (\'dav\', \'dav\'), http_admin_gid (), \'110100000\', 0, 0, 1);\n"
"insert soft DB.DBA.SYS_USERS (U_ID, U_NAME, U_FULL_NAME, U_E_MAIL, U_PASSWORD, U_GROUP, U_DEF_PERMS, U_ACCOUNT_DISABLED, U_SQL_ENABLE, U_DAV_ENABLE, U_IS_ROLE)\n"
"values (http_admin_gid (), \'administrators\',\'WebDAV Administrators\',\'admins@example.domain\', \'\', NULL, \'110100000\', 0, 0, 1, 1);\n"
"insert soft DB.DBA.SYS_USERS (U_ID, U_NAME, U_FULL_NAME, U_E_MAIL, U_PASSWORD, U_GROUP, U_DEF_PERMS, U_ACCOUNT_DISABLED, U_SQL_ENABLE, U_DAV_ENABLE)\n"
"values (http_nobody_uid (), \'nobody\',\'Special account\', \'nobody@example.domain\', pwd_magic_calc (\'nobody\', uuid()), http_admin_gid (), \'110100000\', 1, 0, 1);\n"
"insert soft DB.DBA.SYS_USERS (U_ID, U_NAME, U_FULL_NAME, U_E_MAIL, U_PASSWORD, U_GROUP, U_DEF_PERMS, U_ACCOUNT_DISABLED, U_SQL_ENABLE, U_DAV_ENABLE, U_IS_ROLE)\n"
"values (http_nogroup_gid (), \'nogroup\',\'Special group\', \'nobody@example.domain\', \'\', NULL, \'110100000\', 0, 0, 1, 1);\n"
"__atomic (0);\n"
"return;\n"
"}\n"
"--src davddk.sql:1002\n";

static const char *proc9 = 
"create procedure WS.WS.SYS_DAV_INIT_1 ()\n"
"{\n"
"if (sys_stat (\'cl_run_local_only\') <> 1)\n"
"return;\n"
"WS.WS.SYS_DAV_INIT ();\n"
"}\n"
"--src davddk.sql:1136\n";

static const char *other6 = 
"WS.WS.SYS_DAV_INIT_1 ()\n";
static const char *proc10 = 
"create procedure\n"
"WS.WS.SYS_DAV_PROP_PROP_VALUE_INDEX_HOOK (inout vtb any, inout d_id integer)\n"
"{\n"
"for select PROP_NAME as pn, PROP_VALUE as pv from WS.WS.SYS_DAV_PROP where PROP_ID = d_id do\n"
"{\n"
"declare doc any;\n"
"if (126 = __tag (pv))\n"
"pv := blob_to_string (pv);\n"
"if ((not isstring (pv)) or (pv = \'\'))\n"
"return 1;\n"
"if (193 <> pv[0])\n"
"{\n"
"vt_batch_feed (vtb, pv, 0, 0);\n"
"return 1;\n"
"}\n"
"doc := deserialize (pv);\n"
"if (0 = length (doc))\n"
"return 1;\n"
"doc := xml_tree_doc (doc);\n"
"vt_batch_feed (vtb, doc, 0, 1);\n"
"return 1;\n"
"}\n"
"return 1;\n"
"}\n"
"--src davddk.sql:1147\n";

static const char *proc11 = 
"create procedure\n"
"WS.WS.SYS_DAV_PROP_PROP_VALUE_UNINDEX_HOOK (inout vtb any, inout d_id integer)\n"
"{\n"
"for select PROP_NAME as pn, PROP_VALUE as pv from WS.WS.SYS_DAV_PROP where PROP_ID = d_id do\n"
"{\n"
"declare doc any;\n"
"if (126 = __tag (pv))\n"
"pv := blob_to_string (pv);\n"
"if ((not isstring (pv)) or (pv = \'\'))\n"
"return 1;\n"
"if (193 <> pv[0])\n"
"{\n"
"vt_batch_feed (vtb, pv, 1, 0);\n"
"return 1;\n"
"}\n"
"doc := deserialize (pv);\n"
"if (0 = length (doc))\n"
"return 1;\n"
"doc := xml_tree_doc (doc);\n"
"vt_batch_feed (vtb, doc, 1, 1);\n"
"return 1;\n"
"}\n"
"return 1;\n"
"}\n"
"--src davddk.sql:1173\n";

static const char *other7 = 
"DB.DBA.vt_create_text_index (\'WS.WS.SYS_DAV_PROP\', \'PROP_VALUE\', \'PROP_ID\', 2, 0, vector (), 1, \'*ini*\', \'*ini*\')\n";
static const char *other8 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'application/andrew-inset\',\'ez\')\n";
static const char *other9 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'application/bpel+xml\',\'bpel\')\n";
static const char *other10 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'application/foaf+xml\',\'foaf\')\n";
static const char *other11 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'application/mac-binhex40\',\'hqx\')\n";
static const char *other12 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'application/mac-compactpro\',\'cpt\')\n";
static const char *other13 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'application/mods+xml\',\'mods\')\n";
static const char *other14 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'application/msexcel\',\'xls\')\n";
static const char *other15 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'application/msaccess\',\'mdb\')\n";
static const char *other16 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'application/msexcel\',\'csv\')\n";
static const char *other17 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'application/vnd.oasis.opendocument.text\',\'odt\')\n";
static const char *other18 = 
"insert replacing WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'application/vnd.oasis.opendocument.database\',\'odb\')\n";
static const char *other19 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'application/vnd.oasis.opendocument.graphics\', \'odg\')\n";
static const char *other20 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'application/vnd.oasis.opendocument.presentation\', \'odp\')\n";
static const char *other21 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'application/vnd.oasis.opendocument.spreadsheet\', \'ods\')\n";
static const char *other22 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'application/vnd.oasis.opendocument.chart\', \'odc\')\n";
static const char *other23 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'application/vnd.oasis.opendocument.formula\', \'odf\')\n";
static const char *other24 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'application/vnd.oasis.opendocument.image\', \'odi\')\n";
static const char *other25 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'application/mspowerpoint\',\'ppt\')\n";
static const char *other26 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'application/msproject\',\'mpp\')\n";
static const char *other27 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'application/msword\',\'doc\')\n";
static const char *other28 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'application/octet-stream\',\'bin\')\n";
static const char *other29 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'application/xddl+xml\',\'xddl\')\n";
static const char *other30 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'application/octet-stream\',\'dms\')\n";
static const char *other31 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'application/octet-stream\',\'lha\')\n";
static const char *other32 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'application/octet-stream\',\'lzh\')\n";
static const char *other33 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'application/octet-stream\',\'exe\')\n";
static const char *other34 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'application/octet-stream\',\'class\')\n";
static const char *other35 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'application/oda\',\'oda\')\n";
static const char *other36 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'application/ogg\',\'ogg\')\n";
static const char *other37 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'application/opml+xml\',\'opml\')\n";
static const char *other38 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'application/rdf+xml\',\'rdf\')\n";
static const char *other39 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'application/annotea+xml\',\'annotea\')\n";
static const char *other40 = 
"update WS.WS.SYS_DAV_RES_TYPES set T_TYPE=\'application/rdf+xml\' where T_TYPE <> \'application/rdf+xml\' and T_EXT = \'rdf\'\n";
static const char *other41 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'application/pdf\',\'pdf\')\n";
static const char *other42 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'application/postscript\',\'ai\')\n";
static const char *other43 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'application/postscript\',\'eps\')\n";
static const char *other44 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'application/postscript\',\'ps\')\n";
static const char *other45 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'application/rss+xml\',\'rss\')\n";
static const char *other46 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'application/smil\',\'smil\')\n";
static const char *other47 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'application/smil\',\'smi\')\n";
static const char *other48 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'application/wsdl+xml\',\'wsdl\')\n";
static const char *other49 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'application/xbel+xml\',\'xbel\')\n";
static const char *other50 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'application/x-bcpio\',\'bcpio\')\n";
static const char *other51 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'application/x-cdlink\',\'vcd\')\n";
static const char *other52 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'application/x-chess-pgn\',\'pgn\')\n";
static const char *other53 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'application/x-cpio\',\'cpio\')\n";
static const char *other54 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'application/x-csh\',\'csh\')\n";
static const char *other55 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'application/x-director\',\'dcr\')\n";
static const char *other56 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'application/x-director\',\'dir\')\n";
static const char *other57 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'application/x-director\',\'dxr\')\n";
static const char *other58 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'application/x-dvi\',\'dvi\')\n";
static const char *other59 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'application/x-futuresplash\',\'spl\')\n";
static const char *other60 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'application/x-gtar\',\'gtar\')\n";
static const char *other61 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'application/x-hdf\',\'hdf\')\n";
static const char *other62 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'application/x-javascript\',\'js\')\n";
static const char *other63 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'application/x-koan\',\'skp\')\n";
static const char *other64 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'application/x-koan\',\'skd\')\n";
static const char *other65 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'application/x-koan\',\'skt\')\n";
static const char *other66 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'application/x-koan\',\'skm\')\n";
static const char *other67 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'application/x-latex\',\'latex\')\n";
static const char *other68 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'application/x-netcdf\',\'cdf\')\n";
static const char *other69 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'application/x-netcdf\',\'nc\')\n";
static const char *other70 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'application/x-openlinksw-vspx+xml\',\'vspx\')\n";
static const char *other71 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'application/x-rpm\',\'rpm\')\n";
static const char *other72 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'application/x-sh\',\'sh\')\n";
static const char *other73 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'application/x-shar\',\'shar\')\n";
static const char *other74 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'application/x-shockwave-flash\',\'swf\')\n";
static const char *other75 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'application/x-stuffit\',\'sit\')\n";
static const char *other76 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'application/x-sv4cpio\',\'sv4cpio\')\n";
static const char *other77 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'application/x-sv4crc\',\'sv4crc\')\n";
static const char *other78 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'application/x-tar\',\'tar\')\n";
static const char *other79 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'application/x-tcl\',\'tcl\')\n";
static const char *other80 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'application/x-tex\',\'tex\')\n";
static const char *other81 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'application/x-texinfo\',\'texinfo\')\n";
static const char *other82 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'application/x-texinfo\',\'texi\')\n";
static const char *other83 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'application/x-troff\',\'t\')\n";
static const char *other84 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'application/x-troff\',\'tr\')\n";
static const char *other85 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'application/x-troff\',\'roff\')\n";
static const char *other86 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'application/x-troff-man\',\'man\')\n";
static const char *other87 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'application/x-troff-me\',\'me\')\n";
static const char *other88 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'application/x-troff-ms\',\'ms\')\n";
static const char *other89 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'application/x-ustar\',\'ustar\')\n";
static const char *other90 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'application/x-wais-source\',\'src\')\n";
static const char *other91 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'application/zip\',\'zip\')\n";
static const char *other92 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'audio/basic\',\'au\')\n";
static const char *other93 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'audio/basic\',\'snd\')\n";
static const char *other94 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'audio/midi\',\'mid\')\n";
static const char *other95 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'audio/midi\',\'kar\')\n";
static const char *other96 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'audio/midi\',\'midi\')\n";
static const char *other97 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'audio/mpeg\',\'mpga\')\n";
static const char *other98 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'audio/mpeg\',\'mp2\')\n";
static const char *other99 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'audio/mpeg\',\'mp3\')\n";
static const char *other100 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'audio/x-aiff\',\'aif\')\n";
static const char *other101 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'audio/x-aiff\',\'aiff\')\n";
static const char *other102 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'audio/x-aiff\',\'aifc\')\n";
static const char *other103 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'audio/x-flac\',\'flac\')\n";
static const char *other104 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'audio/x-mp3\',\'mp3\')\n";
static const char *other105 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'audio/x-m4a\',\'m4a\')\n";
static const char *other106 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'audio/x-m4p\',\'m4p\')\n";
static const char *other107 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'audio/x-pn-realaudio\',\'ram\')\n";
static const char *other108 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'audio/x-pn-realaudio\',\'rm\')\n";
static const char *other109 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'audio/x-realaudio\',\'ra\')\n";
static const char *other110 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'audio/x-wav\',\'wav\')\n";
static const char *other111 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'chemical/x-pdb\',\'pdb\')\n";
static const char *other112 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'chemical/x-pdb\',\'xyz\')\n";
static const char *other113 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'image/gif\',\'gif\')\n";
static const char *other114 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'image/ief\',\'ief\')\n";
static const char *other115 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'image/jpeg\',\'jpeg\')\n";
static const char *other116 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'image/jpeg\',\'jpg\')\n";
static const char *other117 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'image/jpeg\',\'jpe\')\n";
static const char *other118 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'image/png\',\'png\')\n";
static const char *other119 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'image/svg+xml\',\'svg\')\n";
static const char *other120 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'image/tiff\',\'tif\')\n";
static const char *other121 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'image/tiff\',\'tiff\')\n";
static const char *other122 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'image/x-cmu-raster\',\'ras\')\n";
static const char *other123 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'image/x-portable-anymap\',\'pnm\')\n";
static const char *other124 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'image/x-portable-bitmap\',\'pbm\')\n";
static const char *other125 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'image/x-portable-graymap\',\'pgm\')\n";
static const char *other126 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'image/x-portable-pixmap\',\'ppm\')\n";
static const char *other127 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'image/x-rgb\',\'rgb\')\n";
static const char *other128 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'image/x-xbitmap\',\'xbm\')\n";
static const char *other129 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'image/x-xpixmap\',\'xpm\')\n";
static const char *other130 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'image/x-xwindowdump\',\'xwd\')\n";
static const char *other131 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'model/iges\',\'iges\')\n";
static const char *other132 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'model/iges\',\'igs\')\n";
static const char *other133 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'model/mesh\',\'silo\')\n";
static const char *other134 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'model/mesh\',\'mesh\')\n";
static const char *other135 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'model/mesh\',\'msh\')\n";
static const char *other136 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'model/vrml\',\'vrml\')\n";
static const char *other137 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'model/vrml\',\'wrl\')\n";
static const char *other138 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'text/directory\',\'ical\')\n";
static const char *other139 = 
"insert replacing WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'text/calendar\',\'ics\')\n";
static const char *other140 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'text/directory\',\'vcard\')\n";
static const char *other141 = 
"insert replacing WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'text/x-vCard\',\'vcf\')\n";
static const char *other142 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'text/css\',\'css\')\n";
static const char *other143 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'text/plain\',\'txt\')\n";
static const char *other144 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'text/plain\',\'asc\')\n";
static const char *other145 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'text/richtext\',\'rtx\')\n";
static const char *other146 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'text/rtf\',\'rtf\')\n";
static const char *other147 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'text/sgml\',\'sgm\')\n";
static const char *other148 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'text/sgml\',\'sgml\')\n";
static const char *other149 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'text/tab-separated-values\',\'tsv\')\n";
static const char *other150 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'text/x-setext\',\'etx\')\n";
static const char *other151 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'text/xml\',\'xml\')\n";
static const char *other152 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'text/xml\',\'xmltxt\')\n";
static const char *other153 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'video/mpeg\',\'mpe\')\n";
static const char *other154 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'video/mpeg\',\'mpeg\')\n";
static const char *other155 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'video/mpeg\',\'mpg\')\n";
static const char *other156 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'video/quicktime\',\'mov\')\n";
static const char *other157 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'video/quicktime\',\'qt\')\n";
static const char *other158 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'video/x-msvideo\',\'avi\')\n";
static const char *other159 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'video/x-sgi-movie\',\'movie\')\n";
static const char *other160 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'x-conference/x-cooltalk\',\'ice\')\n";
static const char *other161 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'text/html\',\'htm\')\n";
static const char *other162 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'text/html\',\'html\')\n";
static const char *other163 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'text/xsl\',\'xsl\')\n";
static const char *other164 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'text/html\',\'asp\')\n";
static const char *other165 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'text/html\',\'php\')\n";
static const char *other166 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'text/html\',\'php3\')\n";
static const char *other167 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'text/plain\',\'sql\')\n";
static const char *other168 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'text/xml\',\'xsd\')\n";
static const char *other169 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'text/xml\',\'dtd\')\n";
static const char *other170 = 
"insert replacing WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'application/ocs+xml\',\'ocs\')\n";
static const char *other171 = 
"insert replacing WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'application/opml+xml\',\'opml\')\n";
static const char *other172 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'text/xml\',\'rss\')\n";
static const char *other173 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'image/bmp\',\'bmp\')\n";
static const char *other174 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'video/mp4\',\'mp4\')\n";
static const char *other175 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'video/3gpp\',\'3gp\')\n";
static const char *other176 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'audio/amr\',\'amr\')\n";
static const char *other177 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'text/rdf+ttl\',\'ttl\')\n";
static const char *other178 = 
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (\'text/rdf+n3\',\'n3\')\n";
static const char *other179 = 
"select count(*) from WS.WS.SYS_DAV_RES_TYPES where http_mime_type_add (T_EXT, T_TYPE)\n";
static const char *proc12 = 
"create procedure\n"
"DB.DBA.DAV_PLAIN_SUBCOLS_P (in root_id integer, in root_path varchar := null, in recursive integer := 1, in subcol_auth_uid varchar, in subcol_auth_pwd varchar)\n"
"{\n"
"declare SUBCOL_FULL_PATH, SUBCOL_NAME, SUBCOL_DET varchar;\n"
"declare SUBCOL_PARENT, SUBCOL_ID, SUBCOL_DEPTH integer;\n"
"\n"
"result_names (SUBCOL_FULL_PATH, SUBCOL_NAME, SUBCOL_PARENT, SUBCOL_ID, SUBCOL_DEPTH, SUBCOL_DET);\n"
"if (root_id is null)\n"
"root_id := DB.DBA.DAV_SEARCH_ID (root_path, \'C\');\n"
"if (not isinteger (root_id))\n"
"return;\n"
"if (root_id <= 0)\n"
"return;\n"
"if (root_path is null)\n"
"root_path := DB.DBA.DAV_SEARCH_PATH (root_id, \'C\');\n"
"if (isinteger (root_path))\n"
"return;\n"
"for (select COL_NAME, COL_PARENT, COL_ID, COL_DET from WS.WS.SYS_DAV_COL where COL_ID = root_id) do\n"
"{\n"
"result (root_path, COL_NAME, COL_PARENT, COL_ID, 0, COL_DET);\n"
"if (recursive and COL_DET is null)\n"
"{\n"
"DB.DBA.DAV_PLAIN_SUBCOLS_P_INT (root_id, root_path, 1, subcol_auth_uid, subcol_auth_pwd);\n"
"}\n"
"}\n"
"}\n"
"--src davddk.sql:1552\n";

static const char *proc13 = 
"create procedure\n"
"DB.DBA.DAV_PLAIN_SUBCOLS_P_INT (in root_id integer, in root_path varchar, in depth integer, in subcol_auth_uid varchar, in subcol_auth_pwd varchar)\n"
"{\n"
"for (select COL_NAME, COL_ID, root_path || COL_NAME || \'/\' as full_path, COL_DET from WS.WS.SYS_DAV_COL where COL_PARENT = root_id) do\n"
"{\n"
"result (full_path, COL_NAME, root_id, COL_ID, depth, COL_DET);\n"
"if (COL_DET is null)\n"
"DB.DBA.DAV_PLAIN_SUBCOLS_P_INT (COL_ID, full_path, depth + 1, subcol_auth_uid, subcol_auth_pwd);\n"
"}\n"
"}\n"
"--src davddk.sql:1580\n";

static const char *view6 = 
"create procedure view DB.DBA.DAV_PLAIN_SUBCOLS as DB.DBA.DAV_PLAIN_SUBCOLS_P (root_id,root_path,recursive,subcol_auth_uid,subcol_auth_pwd) (SUBCOL_FULL_PATH varchar, SUBCOL_NAME varchar, SUBCOL_PARENT integer, SUBCOL_ID integer, SUBCOL_DEPTH integer, SUBCOL_DET varchar)\n";

static const char *proc14 = 
"create procedure\n"
"DB.DBA.DAV_PLAIN_SUBMOUNTS_P (in root_id integer, in root_path varchar := null, in recursive integer := 1, in subcol_auth_uid varchar, in subcol_auth_pwd varchar)\n"
"{\n"
"declare SUBCOL_FULL_PATH, SUBCOL_NAME, SUBCOL_DET varchar;\n"
"declare SUBCOL_PARENT, SUBCOL_ID, SUBCOL_DEPTH integer;\n"
"result_names (SUBCOL_FULL_PATH, SUBCOL_NAME, SUBCOL_PARENT, SUBCOL_ID, SUBCOL_DEPTH, SUBCOL_DET);\n"
"if (root_id is null)\n"
"root_id := DB.DBA.DAV_SEARCH_ID (root_path, \'C\');\n"
"if (not isinteger (root_id))\n"
"return;\n"
"if (root_id <= 0)\n"
"return;\n"
"if (root_path is null)\n"
"root_path := DB.DBA.DAV_SEARCH_PATH (root_id, \'C\');\n"
"if (not isstring (root_path))\n"
"return;\n"
"for (select COL_NAME, COL_PARENT, COL_ID, COL_DET from WS.WS.SYS_DAV_COL where COL_ID = root_id) do\n"
"{\n"
"if (COL_DET is not null)\n"
"result (root_path, COL_NAME, COL_PARENT, COL_ID, 0, COL_DET);\n"
"if (recursive and COL_DET is null)\n"
"{\n"
"DB.DBA.DAV_PLAIN_SUBMOUNTS_P_INT (root_id, root_path, 1, subcol_auth_uid, subcol_auth_pwd);\n"
"}\n"
"}\n"
"}\n"
"--src davddk.sql:1597\n";

static const char *proc15 = 
"create procedure\n"
"DB.DBA.DAV_PLAIN_SUBMOUNTS_P_INT (in root_id integer, in root_path varchar, in depth integer, in subcol_auth_uid varchar, in subcol_auth_pwd varchar)\n"
"{\n"
"for (select COL_NAME, COL_ID, root_path || COL_NAME || \'/\' as full_path, COL_DET from WS.WS.SYS_DAV_COL where COL_PARENT = root_id) do\n"
"{\n"
"if (COL_DET is not null)\n"
"result (full_path, COL_NAME, root_id, COL_ID, depth, COL_DET);\n"
"if (COL_DET is null)\n"
"DB.DBA.DAV_PLAIN_SUBMOUNTS_P_INT (COL_ID, full_path, depth + 1, subcol_auth_uid, subcol_auth_pwd);\n"
"}\n"
"}\n"
"--src davddk.sql:1625\n";

static const char *view7 = 
"create procedure view DB.DBA.DAV_PLAIN_SUBMOUNTS as DB.DBA.DAV_PLAIN_SUBMOUNTS_P (root_id,root_path,recursive,subcol_auth_uid,subcol_auth_pwd) (SUBCOL_FULL_PATH varchar, SUBCOL_NAME varchar, SUBCOL_PARENT integer, SUBCOL_ID integer, SUBCOL_DEPTH integer, SUBCOL_DET varchar)\n";

static const char *proc16 = 
" create procedure\n"
"DB.DBA.DAV_DIR_P (in path varchar := \'/DAV/\', in recursive integer := 0, in auth_uid varchar, in auth_pwd varchar)\n"
"{\n"
"declare arr any;\n"
"declare i, l integer;\n"
"declare FULL_PATH, PERMS, MIME_TYPE, NAME varchar;\n"
"declare TYPE char(1);\n"
"declare RLENGTH, ID, GRP, OWNER integer;\n"
"declare MOD_TIME, CR_TIME datetime;\n"
"result_names (FULL_PATH, TYPE, RLENGTH, MOD_TIME, ID, PERMS, GRP, OWNER, CR_TIME, MIME_TYPE, NAME);\n"
"arr := DB.DBA.DAV_DIR_LIST (path, recursive, auth_uid, auth_pwd);\n"
"i := 0; l := length (arr);\n"
"while (i < l)\n"
"{\n"
"result (arr[i][0],\n"
"arr[i][1],\n"
"arr[i][2],\n"
"arr[i][3],\n"
"arr[i][4],\n"
"arr[i][5],\n"
"arr[i][6],\n"
"arr[i][7],\n"
"arr[i][8],\n"
"arr[i][9],\n"
"arr[i][10]);\n"
"i := i + 1;\n"
"}\n"
"}\n"
"--src davddk.sql:1644\n";

static const char *view8 = 
"create procedure view DB.DBA.DAV_DIR as DB.DBA.DAV_DIR_P (path,recursive,auth_uid,auth_pwd) (FULL_PATH varchar, TYPE varchar, RLENGTH integer, MOD_TIME datetime, ID integer, PERMS varchar, GRP integer, OWNER integer, CR_TIME datetime, MIME_TYPE varchar, NAME varchar)\n";

static const char *other180 = 
"exec (\'grant select on DB.DBA.DAV_DIR to PUBLIC\')\n";
/* mail_cli.sql */

static const char *tbl18 = 
"create table MAIL_MESSAGE (\n"
"MM_ID		integer,\n"
"MM_OWN		varchar (128),\n"
"MM_FLD		varchar (128),\n"
"MM_FROM		varchar (512),\n"
"MM_TO		varchar (512),\n"
"MM_CC		varchar (512),\n"
"MM_BCC		varchar (512),\n"
"MM_SUBJ		varchar (512),\n"
"MM_REC_DATE		varchar (50),\n"
"MM_SND_TIME		varchar (50),\n"
"MM_IS_READED	integer,\n"
"MM_BODY		long varchar,\n"
"MM_BODY_ID		integer identity,\n"
"MM_MOBLOG		varchar(50) default NULL,\n"
"MM_MSG_ID		varchar default NULL,\n"
"primary key (MM_OWN, MM_FLD, MM_ID))\n"
"create index MAIL_MESSAGE_MSG_ID on MAIL_MESSAGE (MM_MSG_ID, MM_OWN)\n";

static const char *tbl19 = 
"create table MAIL_ATTACHMENT (\n"
"MA_ID integer identity,\n"
"MA_M_ID	integer,\n"
"MA_M_OWN varchar (128),\n"
"MA_M_FLD varchar (128),\n"
"MA_PUBLISHED int default 0,\n"
"MA_NAME varchar,\n"
"MA_MIME varchar,\n"
"MA_CONTENT long varbinary,\n"
"MA_BLOG_ID varchar,\n"
"primary key (MA_M_OWN, MA_M_FLD, MA_M_ID, MA_ID)\n"
")\n";

static const char *trig0 = 
"create trigger MAIL_MESSAGE_I after insert on DB.DBA.MAIL_MESSAGE\n"
"{\n"
"if (__proc_exists (\'BLOG.DBA.BLOG_MOBLOG_PROCESS_MSG\'))\n"
"BLOG.DBA.BLOG_MOBLOG_PROCESS_MSG (MM_OWN, MM_ID, MM_FLD, MM_BODY, MM_MOBLOG);\n"
"}\n"
"--src mail_cli.sql:98\n";

static const char *trig1 = 
"create trigger MAIL_MESSAGE_U after update on DB.DBA.MAIL_MESSAGE referencing old as O, new as N\n"
"{\n"
"if (__proc_exists (\'BLOG.DBA.BLOG_MOBLOG_PROCESS_MSG\'))\n"
"BLOG.DBA.BLOG_MOBLOG_PROCESS_MSG (N.MM_OWN, N.MM_ID, N.MM_FLD, N.MM_BODY, N.MM_MOBLOG);\n"
"}\n"
"--src mail_cli.sql:108\n";

static const char *trig2 = 
"create trigger MAIL_MESSAGE_D after delete on DB.DBA.MAIL_MESSAGE\n"
"{\n"
"delete from MAIL_ATTACHMENT where MA_M_ID = MM_ID and MA_M_OWN = MM_OWN and MA_M_FLD = MM_FLD;\n"
"}\n"
"--src mail_cli.sql:115\n";

static const char *proc17 = 
"create procedure DB.DBA.MAIL_MESSAGE_MM_BODY_INDEX_HOOK (inout vtb any, inout d_id integer)\n"
"{\n"
"declare data, own, offset any;\n"
"declare _subj, _from, _to, _trf varchar;\n"
"declare cr cursor for select blob_to_string (MM_BODY), MM_OWN from DB.DBA.MAIL_MESSAGE where MM_BODY_ID = d_id;\n"
"whenever not found goto err_exit;\n"
"open cr (prefetch 1);\n"
"fetch cr into data, own;\n"
"if (data is not null)\n"
"{\n"
"offset := aref (aref (mime_tree (data), 1), 0);\n"
"if (offset > 1)\n"
"offset := offset - 1;\n"
"_trf := lower (substring (mail_header (data, \'Content-Transfer-Encoding\'), 1, 512));\n"
"if (_trf <> \'base64\')\n"
"{\n"
"declare mtree  any;\n"
"mtree := mime_tree (data);\n"
"DB.DBA.MM_FEED_PART (vtb, mtree, data, d_id, 0);\n"
"}\n"
"\n"
"_subj := substring (mail_header (data, \'Subject\'), 1, 512);\n"
"_from := substring (mail_header (data, \'From\'), 1, 512);\n"
"_to := substring (mail_header (data, \'To\'), 1, 512);\n"
"vt_batch_feed (vtb, _subj, 0);\n"
"vt_batch_feed (vtb, _from, 0);\n"
"vt_batch_feed (vtb, _to, 0);\n"
"}\n"
"if (own is not null)\n"
"vt_batch_feed (vtb, own, 0);\n"
"close cr;\n"
"return 1;\n"
"err_exit:\n"
"close cr;\n"
"return 0;\n"
"}\n"
"--src mail_cli.sql:122\n";

static const char *proc18 = 
"create procedure DB.DBA.MAIL_MESSAGE_MM_BODY_UNINDEX_HOOK (inout vtb any, inout d_id integer)\n"
"{\n"
"declare data, own, offset any;\n"
"declare _subj, _from, _to, _trf varchar;\n"
"declare cr cursor for select blob_to_string (MM_BODY), MM_OWN, MM_SUBJ, MM_TO, MM_FROM from DB.DBA.MAIL_MESSAGE where MM_BODY_ID = d_id;\n"
"whenever not found goto err_exit;\n"
"open cr (prefetch 1);\n"
"fetch cr into data, own, _subj, _from, _to;\n"
"if (data is not null)\n"
"{\n"
"offset := aref (aref (mime_tree (data), 1), 0);\n"
"if (offset > 1)\n"
"offset := offset - 1;\n"
"_trf := lower (substring (mail_header (data, \'Content-Transfer-Encoding\'), 1, 512));\n"
"if (_trf <> \'base64\')\n"
"{\n"
"declare mtree  any;\n"
"mtree := mime_tree (data);\n"
"DB.DBA.MM_FEED_PART (vtb, mtree, data, d_id, 1);\n"
"\n"
"}\n"
"}\n"
"if (own is not null)\n"
"vt_batch_feed (vtb, own, 1);\n"
"vt_batch_feed (vtb, _subj, 1);\n"
"vt_batch_feed (vtb, _from, 1);\n"
"vt_batch_feed (vtb, _to,   1);\n"
"close cr;\n"
"return 1;\n"
"err_exit:\n"
"close cr;\n"
"return 0;\n"
"}\n"
"--src mail_cli.sql:160\n";

static const char *proc19 = 
"create procedure\n"
"MM_FEED_PART (inout vb any, inout mb any, inout body varchar, inout id integer, in flag int)\n"
"{\n"
"declare txt varchar;\n"
"declare tp, enc, disp varchar;\n"
"declare i, l integer;\n"
"if (not isarray (mb[0]))\n"
"return;\n"
"tp := get_keyword_ucase (\'CONTENT-TYPE\', mb[0], \'application/octet-stream\');\n"
"enc := get_keyword_ucase (\'CONTENT-TRANSFER-ENCODING\', mb[0], \'\');\n"
"\n"
"if (tp like \'text/%\' and (mb[1][0] < mb[1][1]))\n"
"{\n"
"txt := subseq (body, mb[1][0], mb[1][1]);\n"
"if (lower (enc) = \'base64\')\n"
"txt := decode_base64(txt);\n"
"vt_batch_feed (vb, txt, flag);\n"
"}\n"
"\n"
"if (not isarray (mb[2]))\n"
"return;\n"
"\n"
"i := 0; l := length (mb[2]);\n"
"while (i < l)\n"
"{\n"
"DB.DBA.MM_FEED_PART (vb, mb[2][i], body, id, flag);\n"
"i := i + 1;\n"
"}\n"
"}\n"
"--src mail_cli.sql:195\n";

static const char *other181 = 
"DB.DBA.vt_create_text_index (\'DB.DBA.MAIL_MESSAGE\', \'MM_BODY\', \'MM_BODY_ID\', 2, 0, null, 1, \'*ini*\', \'*ini*\')\n";
static const char *other182 = 
"DB.DBA.vt_create_ftt (\'DB.DBA.MAIL_MESSAGE\', null, null, 2)\n";
static const char *tbl20 = 
"create table MAIL_PARTS (\n"
"MP_ID 		integer,\n"
"MP_PART 		long varbinary,\n"
"MP_ATTRS 		long varbinary,\n"
"MP_OWN 		varchar (128),\n"
"primary key (MP_OWN, MP_ID)\n"
")\n";

static const char *proc20 = 
" create procedure MIME_PART (in _cont_type varchar, in _content_disp varchar,\n"
"in _transfer_enc varchar, in _data varchar)\n"
"{\n"
"declare _headers, _body, _disp, _content_type, _trf_enc varchar;\n"
"declare _result any;\n"
"\n"
"if (_data is null)\n"
"return NULL;\n"
"_content_type := _cont_type;\n"
"_trf_enc := _transfer_enc;\n"
"if (_content_type is null)\n"
"_content_type := \'text/plain\';\n"
"if (_trf_enc is null and _content_type not like \'text/%\')\n"
"_trf_enc := \'base64\';\n"
"if (_trf_enc is null)\n"
"_trf_enc := \'8bit\';\n"
"if (_content_disp is not null)\n"
"_disp := concat (\'\\r\\nContent-Disposition: \', _content_disp, \'\\r\\n\');\n"
"else\n"
"_disp := \'\\r\\n\';\n"
"_headers := concat (\'Content-Type: \', _content_type, \'\\r\\nContent-Transfer-Encoding: \', _trf_enc, _disp);\n"
"if (_trf_enc = \'base64\')\n"
"_body := encode_base64 (_data);\n"
"else\n"
"_body := _data;\n"
"_result := make_array (2, \'any\');\n"
"aset (_result, 0, _headers);\n"
"aset (_result, 1, _body);\n"
"return (_result);\n"
"}\n"
"--src mail_cli.sql:252\n";

static const char *proc21 = 
" create procedure MIME_BODY (in _parts any)\n"
"{\n"
"declare _inx, _len integer;\n"
"declare _res, _bnd, _c_type varchar;\n"
"declare _part any;\n"
"\n"
"_bnd := concat (\'-\',\'-\',\'-\',\'-\', md5 (cast (now () as varchar)));\n"
"if (__tag (_parts) = 193)\n"
"_c_type := sprintf (\'multipart/mixed; boundary=\"%s\"\', _bnd);\n"
"else if (isstring (_parts))\n"
"_c_type := \'text/plain\';\n"
"else\n"
"return \'\';\n"
"\n"
"_res := concat (\'Date: \', soap_print_box (now (), \'\', 1), \'\\r\\n\');\n"
"_res := concat (_res, \'Content-Type: \', _c_type, \'\\r\\n\');\n"
"_res := concat (_res, \'Mime-Version: 1.0\\r\\nX-Mailer: Virtuoso\\r\\n\\r\\n\');\n"
"if (__tag (_parts) = 193)\n"
"{\n"
"_res := concat (_res, \'This is a multi-part message in MIME format.\\r\\n\\r\\n\');\n"
"_inx := 0;\n"
"_len := length (_parts);\n"
"while (_inx < _len)\n"
"{\n"
"_part := aref (_parts, _inx);\n"
"if (__tag (_part) = 193)\n"
"{\n"
"_res := concat (_res, \'-\',\'-\', _bnd, \'\\r\\n\');\n"
"_res := concat (_res, aref (_part, 0), \'\\r\\n\');\n"
"_res := concat (_res, aref (_part, 1), \'\\r\\n\');\n"
"}\n"
"else\n"
"{\n"
"if (_inx = 0)\n"
"_res := concat (_res, \'-\',\'-\', _bnd, \'\\r\\n\');\n"
"_res := concat (_res, _part, \'\\r\\n\');\n"
"}\n"
"_inx := _inx + 1;\n"
"}\n"
"_res := concat (_res, \'-\',\'-\', _bnd, \'-\',\'-\\r\\n\');\n"
"}\n"
"else\n"
"{\n"
"_res := concat (_res, _parts);\n"
"}\n"
"return _res;\n"
"}\n"
"--src mail_cli.sql:286\n";

static const char *proc22 = 
"create procedure NEW_MAIL (in _uid varchar, in __msg any)\n"
"{\n"
"declare _id, dummy integer;\n"
"declare _subj, _cc, _bcc, _sent, _to, _from, _msg, _mid varchar;\n"
"declare ___msg any;\n"
"declare m cursor for select MM_ID from MAIL_MESSAGE where MM_OWN = _uid and MM_FLD = \'Inbox\'\n"
"order by MM_OWN desc, MM_FLD desc, MM_ID desc;\n"
"set isolation=\'serializable\';\n"
"again:;\n"
"_id := 0;\n"
"whenever not found goto nf;\n"
"open m (exclusive, prefetch 1);\n"
"fetch m into _id;\n"
"nf:\n"
"\n"
"\n"
"\n"
"_id := coalesce (_id, 0) + 1;\n"
"\n"
"{\n"
"whenever not found goto ins;\n"
"select  MM_ID into dummy from MAIL_MESSAGE where MM_OWN = _uid and MM_FLD = \'Inbox\' and MM_ID = _id;\n"
"close m;\n"
"goto again;\n"
"}\n"
"\n"
"ins:;\n"
"\n"
"insert into MAIL_MESSAGE (MM_ID, MM_OWN, MM_FLD, MM_BODY, MM_REC_DATE,\n"
"MM_SUBJ, MM_CC, MM_BCC, MM_SND_TIME, MM_TO, MM_FROM)\n"
"values (_id, _uid, \'Inbox\', __msg, cast (now () as varchar),\n"
"_subj, _cc, _bcc, _sent, _to, _from);\n"
"select blob_to_string (MM_BODY) into _msg from MAIL_MESSAGE where\n"
"MM_ID = _id and MM_OWN = _uid and MM_FLD = \'Inbox\';\n"
"_subj := substring (mail_header (_msg, \'Subject\'), 1, 512);\n"
"_cc := substring (mail_header (_msg, \'Cc\'), 1, 512);\n"
"_bcc := substring (mail_header (_msg, \'Bcc\'), 1, 512);\n"
"_sent := substring (mail_header (_msg, \'Date\'), 1, 50);\n"
"_to := substring (mail_header (_msg, \'To\'), 1, 512);\n"
"_from := substring (mail_header (_msg, \'From\'), 1, 512);\n"
"_mid := substring (mail_header (_msg, \'Message-Id\'), 1, 512);\n"
"update MAIL_MESSAGE set MM_SUBJ = _subj, MM_CC = _cc, MM_BCC = _bcc,\n"
"MM_SND_TIME = _sent, MM_TO = _to, MM_FROM = _from, MM_MSG_ID = _mid\n"
"where MM_ID = _id and MM_OWN = _uid and MM_FLD = \'Inbox\';\n"
"close m;\n"
"return NULL;\n"
"}\n"
"--src mail_cli.sql:338\n";

static const char *proc23 = 
"create procedure MAIL_GET_NEXT_ID (in str varchar, inout offset integer)\n"
"{\n"
"while (1 = 1)\n"
"{\n"
"declare chunk varchar;\n"
"chunk := subseq (str, offset);\n"
"declare colon_inx integer;\n"
"colon_inx := strchr (chunk, \',\');\n"
"if (colon_inx is not null)\n"
"chunk := subseq (chunk, 0, colon_inx);\n"
"declare left_inx integer;\n"
"left_inx := strchr (chunk, \'<\');\n"
"if (left_inx is not null)\n"
"chunk := subseq (chunk, left_inx);\n"
"declare at_inx integer;\n"
"at_inx := strrchr (chunk, \'@\');\n"
"if (at_inx is not null)\n"
"{\n"
"if ((chr (aref (chunk, at_inx - 1)) not in (\'\\n\', \' \', \'\\t\', \'<\')))\n"
"{\n"
"declare at_start_inx integer;\n"
"at_start_inx := at_inx;\n"
"while (at_start_inx > 0 and (chr (aref (chunk, at_start_inx - 1)) not in (\'\\n\', \' \', \'\\t\', \'<\')))\n"
"{\n"
"at_start_inx := at_start_inx - 1;\n"
"}\n"
"if (colon_inx)\n"
"offset := offset + colon_inx + 1;\n"
"else\n"
"offset := offset + coalesce (left_inx, 0) + at_inx + 1;\n"
"return subseq (chunk, at_start_inx, at_inx);\n"
"}\n"
"else\n"
"{\n"
"if (colon_inx)\n"
"offset := offset + colon_inx + 1;\n"
"else\n"
"offset := offset + coalesce (left_inx, 0) + at_inx + 1;\n"
"}\n"
"}\n"
"else if (left_inx is not null)\n"
"{\n"
"declare right_inx integer;\n"
"right_inx := strchr (chunk, \'>\');\n"
"offset := offset + left_inx + 1;\n"
"if (right_inx is not null)\n"
"return subseq (chunk, 1, right_inx);\n"
"else\n"
"return NULL;\n"
"}\n"
"else\n"
"return NULL;\n"
"}\n"
"}\n"
"--src mail_cli.sql:387\n";

static const char *proc24 = 
"create procedure BARE_NEW_MAIL (in _uid varchar,\n"
"in _subj varchar, in _cc varchar, in _bcc varchar, in _sent varchar,\n"
"in _to varchar, in _from varchar, in __msg any)\n"
"{\n"
"declare _id, _id1 integer;\n"
"declare offset integer;\n"
"declare __uid varchar;\n"
"set isolation=\'serializable\';\n"
"\n"
"if (_uid is null)\n"
"signal (\'22023\', \'Sender can not be empty\', \'SM006\');\n"
"again:\n"
"offset := 0;\n"
"if ((__uid := MAIL_GET_NEXT_ID (_uid, offset)) is not null)\n"
"{\n"
"_id := 0;\n"
"_id1 := 1;\n"
"declare cr1 cursor for\n"
"select MM_ID\n"
"from MAIL_MESSAGE\n"
"where MM_OWN = __uid and MM_FLD = \'Inbox\'\n"
"order by MM_OWN desc, MM_FLD desc, MM_ID desc;\n"
"whenever not found goto nf1;\n"
"open cr1 (exclusive);\n"
"fetch cr1 into _id;\n"
"nf1:\n"
"select max (MM_ID) into _id1\n"
"from MAIL_MESSAGE\n"
"where MM_OWN = __uid and MM_FLD = \'Inbox\' and MM_ID >= _id;\n"
"_id1 := coalesce (_id1, 0) + 1;\n"
"insert into MAIL_MESSAGE (MM_ID, MM_OWN, MM_FLD, MM_BODY, MM_REC_DATE,\n"
"MM_SUBJ, MM_CC, MM_BCC, MM_SND_TIME, MM_TO, MM_FROM)\n"
"values (_id1, __uid, \'Inbox\', __msg, cast (now () as varchar),\n"
"_subj, _cc, _bcc, _sent, _to, _from);\n"
"select MM_BODY into __msg from MAIL_MESSAGE where MM_ID = _id1 and MM_OWN = __uid and MM_FLD = \'Inbox\';\n"
"close cr1;\n"
"while ((__uid := MAIL_GET_NEXT_ID (_uid, offset)) is not null)\n"
"{\n"
"_id := 0;\n"
"_id1 := 1;\n"
"declare cr2 cursor for\n"
"select MM_ID\n"
"from MAIL_MESSAGE\n"
"where MM_OWN = __uid and MM_FLD = \'Inbox\'\n"
"order by MM_OWN desc, MM_FLD desc, MM_ID desc;\n"
"whenever not found goto nf2;\n"
"open cr2 (exclusive);\n"
"fetch cr2 into _id;\n"
"nf2:\n"
"select max (MM_ID) into _id1\n"
"from MAIL_MESSAGE\n"
"where MM_OWN = __uid and MM_FLD = \'Inbox\' and MM_ID >= _id;\n"
"_id1 := coalesce (_id1, 0) + 1;\n"
"insert into MAIL_MESSAGE (MM_ID, MM_OWN, MM_FLD, MM_BODY, MM_REC_DATE,\n"
"MM_SUBJ, MM_CC, MM_BCC, MM_SND_TIME, MM_TO, MM_FROM)\n"
"values (_id1, __uid, \'Inbox\', __msg, cast (now () as varchar),\n"
"_subj, _cc, _bcc, _sent, _to, _from);\n"
"close cr2;\n"
"}\n"
"}\n"
"else\n"
"{\n"
"_id := 0;\n"
"_id1 := 1;\n"
"declare cr3 cursor for\n"
"select MM_ID\n"
"from MAIL_MESSAGE\n"
"where MM_OWN = _uid and MM_FLD = \'Inbox\'\n"
"order by MM_OWN desc, MM_FLD desc, MM_ID desc;\n"
"whenever not found goto nf3;\n"
"open cr3 (exclusive);\n"
"fetch cr3 into _id;\n"
"nf3:\n"
"select max (MM_ID) into _id1\n"
"from MAIL_MESSAGE\n"
"where MM_OWN = _uid and MM_FLD = \'Inbox\' and MM_ID >= _id;\n"
"_id1 := coalesce (_id1, 0) + 1;\n"
"insert into MAIL_MESSAGE (MM_ID, MM_OWN, MM_FLD, MM_BODY, MM_REC_DATE,\n"
"MM_SUBJ, MM_CC, MM_BCC, MM_SND_TIME, MM_TO, MM_FROM)\n"
"values (_id1, _uid, \'Inbox\', __msg, cast (now () as varchar),\n"
"_subj, _cc, _bcc, _sent, _to, _from);\n"
"close cr3;\n"
"}\n"
"return NULL;\n"
"}\n"
"--src mail_cli.sql:443\n";

static const char *proc25 = 
"create procedure display_mime (inout doc varchar, inout ses varchar, inout parsed_message varchar, in msg varchar, in path varchar, in call_page varchar, in _type varchar)\n"
"{\n"
"\n"
"declare path_part, body, attrs, parts, entry_path varchar;\n"
"declare inx integer;\n"
"\n"
"entry_path := path;\n"
"\n"
"if (not isarray(parsed_message))\n"
"{\n"
"return;\n"
"}\n"
"\n"
"attrs := aref (parsed_message, 0);\n"
"body := aref (parsed_message, 1);\n"
"parts := aref (parsed_message, 2);\n"
"\n"
"if (isarray (attrs))\n"
"{\n"
"http (\'<TABLE CLASS=\"gen_list\" BORDER=\"0\" CELLPADDING=\"0\" WIDTH=\"90%\">\\n<TR CLASS=\"stat_head\"><TD COLSPAN=\"2\">Headers</TD></TR>\\n<TR CLASS=\"adm_borders\"><TD COLSPAN=\"2\"><IMG SRC=\"../admin/images/1x1.gif\" WIDTH=\"1\" HEIGHT=\"2\" ALT=\"\"></TD></TR>\\n<tr><td class=\"gen_listheadt\">Attribute</td><td class=\"gen_listheadt\">Value</td></tr>\\n\', ses);\n"
"inx := 0;\n"
"while (inx < (length (attrs) - 1))\n"
"{\n"
"http (\'<tr><td class=\"gen_data\">\', ses);\n"
"http_value (aref (attrs, inx), NULL, ses);\n"
"http (\'</td><td class=\"gen_data\">\', ses);\n"
"http_value (aref (attrs, inx + 1), NULL, ses);\n"
"http (\'</td></tr>\\n\', ses);\n"
"inx := inx + 2;\n"
"}\n"
"http (\'</table>\\n\', ses);\n"
"}\n"
"if (isarray (body))\n"
"{\n"
"if (aref (body, 1) > aref (body, 0))\n"
"{\n"
"declare body_submsg varchar;\n"
"body_submsg := aref (body, 2);\n"
"http (\'<TABLE CLASS=\"gen_list\" BORDER=\"0\" CELLPADDING=\"0\" WIDTH=\"90%\">\\n<TR CLASS=\"stat_head\"><TD>Body</TD></TR>\\n<TR CLASS=\"adm_borders\"><TD><IMG SRC=\"../admin/images/1x1.gif\" WIDTH=\"1\" HEIGHT=\"2\" ALT=\"\"></TD></TR>\\n<tr><td class=\"gen_data\">\\n\', ses);\n"
"if (isarray (body_submsg))\n"
"display_mime (doc, ses, body_submsg, msg, concat (path, \'/b\'), call_page, _type);\n"
"else\n"
"{\n"
"declare body_type, body_enc, body_file varchar;\n"
"\n"
"if (isarray (attrs))\n"
"{\n"
"body_type := lcase (get_keyword_ucase (\'Content-Type\', attrs));\n"
"body_enc := lcase (get_keyword_ucase (\'Content-Transfer-Encoding\', attrs));\n"
"body_file := get_keyword_ucase (\'filename\', attrs);\n"
"}\n"
"else\n"
"{\n"
"body_type := null;\n"
"body_enc := null;\n"
"}\n"
"if (length (body_type) = 0)\n"
"body_type := \'text/plain\';\n"
"if (length (body_enc) = 0)\n"
"body_enc := null;\n"
"if (length (body_file) = 0)\n"
"body_file := null;\n"
"if (isnull (body_type))\n"
"body_type := \'text/plain\';\n"
"if (subseq (body_type, 0, 9) = \'multipart\')\n"
"body_type := \'text/plain\';\n"
"if (strstr (body_type, \'html\') is null and subseq (body_type, 0, 4) = \'text\' and (body_enc is null or body_enc = \'7bit\' or body_enc = \'8bit\'))\n"
"{\n"
"if (not (subseq (body_type, 5, 9) = \'html\'))\n"
"{\n"
"http (\'\\n<PRE>\', ses);\n"
"http_value (subseq (msg, aref (body, 0), aref (body, 1)), null, ses);\n"
"http (\'</PRE>\\n\', ses);\n"
"}\n"
"else\n"
"http (subseq (msg, aref (body, 0), aref (body, 1)), ses);\n"
"}\n"
"else if (subseq (body_type, 0, 5) = \'image\' and\n"
"(subseq (body_type, 6, 9) = \'gif\' or subseq (body_type, 6, 10) = \'jpeg\'))\n"
"{\n"
"if (body_file is null)\n"
"body_file := concat (\'body.\', subseq (body_type, 5, length (body_type)));\n"
"http (\'<IMG src=\\\"/INLINEFILE/\');\n"
"http_url (body_file);\n"
"http (\'?VSP=\');\n"
"http_url (sprintf (\'%s\' ,call_page));\n"
"http (\'&msg=\');\n"
"http_url (doc);\n"
"http (\'&type=\');\n"
"http_url (_type);\n"
"http (\'&downloadpath=\');\n"
"http_url (concat (entry_path, \'/d/\', body_file));\n"
"http (\'\"></IMG>\');\n"
"}\n"
"else\n"
"{\n"
"if (body_file is null)\n"
"body_file := \'mime.body\';\n"
"http (\'<A href=\\\"/INLINEFILE/\');\n"
"http_url (body_file);\n"
"http (\'?VSP=\');\n"
"http_url (sprintf (\'%s\' ,call_page));\n"
"http (\'&msg=\');\n"
"http_url (doc);\n"
"http (\'&type=\');\n"
"http_url (_type);\n"
"http (\'&downloadpath=\');\n"
"http_url (concat (entry_path, \'/d/\', body_file));\n"
"http (\'\"> Download the body </A>\');\n"
"}\n"
"}\n"
"}\n"
"if (isarray (aref (body, 3)))\n"
"{\n"
"http (\'<hr><H3>Footer</H3>\\n<PRE>\', ses);\n"
"http_value (subseq (msg, aref (aref (body, 3), 0), aref (aref (body, 3), 1)), null, ses);\n"
"http (\'</PRE>\\n\', ses);\n"
"}\n"
"http (\'</TD></TR></TABLE>\', ses);\n"
"}\n"
"if (isarray (parts))\n"
"{\n"
"http (\'<hr><H3>_SubParts_</H3>\\n\', ses);\n"
"inx := 0;\n"
"while (inx < length (parts))\n"
"{\n"
"http (sprintf (\'<hr><H4>SubPart %d </H4>\\n\', inx + 1), ses);\n"
"display_mime (doc, ses, aref (parts, inx), msg, sprintf (\'%s/%d\', path, inx), call_page, _type);\n"
"inx := inx + 1;\n"
"}\n"
"}\n"
"}\n"
"--src mail_cli.sql:531\n";

/* admin_ddl.sql */

static const char *tbl21 = 
"create table ADMIN_SESSION\n"
"(\n"
"ASES_ID          varchar (32),\n"
"ASES_LAST_ACCESS datetime,\n"
"ASES_TREE        long varchar,\n"
"ASES_VARS	   long varchar,\n"
"primary key (ASES_ID)\n"
")\n";

static const char *view9 = 
"create view ADM_XML_VIEWS as select V_NAME from SYS_VIEWS where V_TEXT like \'create xml%\'\n";

static const char *tbl22 = 
"create table WS.WS.AUDIT_LOG (\n"
"EVTTIME timestamp,\n"
"REFERER varchar,\n"
"HOST varchar,\n"
"COMMAND varchar,\n"
"AUTHSTRING varchar,\n"
"USERNAME varchar(200),\n"
"REALM varchar(200),\n"
"AUTHALGORITHM varchar(100),\n"
"URI varchar,\n"
"USERAGENT varchar,\n"
"CLIENT varchar\n"
")\n";

/* vfsddk.sql */

static const char *tbl23 = 
"create table WS.WS.VFS_URL (\n"
"VU_HOST 	varchar,\n"
"VU_URL 	varchar,\n"
"VU_ROOT 	varchar,\n"
"VU_CHKSUM	varchar,\n"
"VU_ETAG	varchar,\n"
"VU_CPTIME	datetime,\n"
"VU_OTHER	varchar,\n"
"primary key (VU_HOST, VU_URL, VU_ROOT))\n"
"create index VU_HOST_ROOT on WS.WS.VFS_URL (VU_HOST, VU_ROOT)\n";

static const char *tbl24 = 
"create table WS.WS.VFS_QUEUE (\n"
"VQ_HOST 	varchar,\n"
"VQ_TS 	datetime,\n"
"VQ_URL 	varchar,\n"
"VQ_ROOT 	varchar,\n"
"VQ_STAT	varchar (15),\n"
"VQ_OTHER	varchar,\n"
"VQ_ERROR	long varchar,\n"
"VQ_LEVEL	int default 0,\n"
"primary key (VQ_HOST, VQ_URL, VQ_ROOT))\n"
"create index VQ_HOST_ROOT on WS.WS.VFS_QUEUE (VQ_HOST, VQ_ROOT)\n"
"create index VQ_HOST_TIME on WS.WS.VFS_QUEUE (VQ_HOST, VQ_ROOT, VQ_STAT, VQ_TS)\n"
"create index VQ_TS on WS.WS.VFS_QUEUE (VQ_TS)\n";

static const char *tbl25 = 
"create table WS.WS.VFS_SITE (\n"
"VS_DESCR	varchar,\n"
"VS_HOST 	varchar,\n"
"VS_URL	varchar,\n"
"VS_INX	varchar (5),\n"
"VS_OWN	integer,\n"
"VS_ROOT	varchar,\n"
"VS_NEWER	datetime,\n"
"VS_DEL	varchar,\n"
"VS_FOLLOW	varchar,\n"
"VS_NFOLLOW	varchar,\n"
"VS_SRC	varchar,\n"
"VS_OPTIONS  varchar,\n"
"VS_METHOD   varchar,\n"
"VS_OTHER	varchar,\n"
"VS_OPAGE	varchar,\n"
"VS_REDIRECT int default 1,\n"
"VS_STORE 	int default 1,\n"
"VS_UDATA	long varbinary,\n"
"VS_DLOAD_META int default 0,\n"
"VS_INST_ID	int,\n"
"VS_EXTRACT_FN  varchar,\n"
"VS_STORE_FN  varchar,\n"
"VS_DEPTH	int default null,\n"
"primary key (VS_HOST, VS_ROOT))\n"
"create index VS_HOST_ROOT on WS.WS.VFS_SITE (VS_HOST, VS_URL, VS_ROOT)\n";

static const char *tbl26 = 
"create table WS.WS.VFS_SITE_RDF_MAP (\n"
"VM_ID   integer identity,\n"
"VM_HOST varchar,\n"
"VM_ROOT varchar,\n"
"VM_RDF_MAP int,\n"
"VM_SEQ  integer identity,\n"
"primary key (VM_HOST, VM_ROOT, VM_RDF_MAP, VM_SEQ))\n";

static const char *alter0 = 
"alter table WS.WS.VFS_SITE add VS_DEPTH int default null\n";

static const char *alter1 = 
"alter table WS.WS.VFS_QUEUE add VQ_LEVEL int default 0\n";

/* virtual_dir.sql */

static const char *tbl27 = 
"create table DB.DBA.HTTP_PATH (\n"
"HP_HOST     varchar not null,\n"
"HP_LISTEN_HOST  varchar not null,\n"
"HP_LPATH        varchar not null,\n"
"HP_PPATH    varchar not null,\n"
"HP_STORE_AS_DAV   integer not null,\n"
"HP_DIR_BROWSEABLE   integer not null,\n"
"HP_DEFAULT    varchar,\n"
"HP_SECURITY       varchar,\n"
"HP_REALM          varchar,\n"
"HP_AUTH_FUNC      varchar,\n"
"HP_POSTPROCESS_FUNC varchar,\n"
"HP_RUN_VSP_AS     varchar,\n"
"HP_RUN_SOAP_AS    varchar,\n"
"HP_PERSIST_SES_VARS integer not null,\n"
"HP_SOAP_OPTIONS long varchar,\n"
"HP_AUTH_OPTIONS varchar,\n"
"HP_OPTIONS    any,\n"
"HP_IS_DEFAULT_HOST  integer,\n"
"primary key (HP_LISTEN_HOST, HP_HOST, HP_LPATH)\n"
")\n";

static const char *tbl28 = 
"create table HTTP_ACL (\n"
"HA_LIST   varchar not null,\n"
"HA_ORDER  integer not null,\n"
"HA_OBJECT integer not NULL default -1,\n"
"HA_CLIENT_IP  varchar not NULL,\n"
"HA_FLAG   integer not NULL default 1,\n"
"HA_RW   integer default 0,\n"
"HA_DEST_IP  varchar default \'*\',\n"
"HA_RATE double precision,\n"
"HA_LIMIT  integer default 0,\n"
"PRIMARY KEY (HA_LIST, HA_ORDER, HA_CLIENT_IP, HA_FLAG))\n";

static const char *alter2 = 
"alter table HTTP_ACL add HA_LIMIT integer default 0\n";

static const char *trig3 = 
"create trigger HTTP_ACL_I after insert on DB.DBA.HTTP_ACL\n"
"{\n"
"declare def_rate int;\n"
"if (HA_LIST <> \'NEWS\')\n"
"def_rate := 0;\n"
"else\n"
"def_rate := 1;\n"
"http_acl_set (HA_LIST, HA_ORDER, HA_CLIENT_IP, HA_FLAG, HA_DEST_IP, HA_OBJECT, HA_RW, coalesce (HA_RATE, def_rate), HA_LIMIT);\n"
"}\n"
"--src virtual_dir.sql:95\n";

static const char *trig4 = 
"create trigger HTTP_ACL_U after update on DB.DBA.HTTP_ACL referencing old as O, new as N\n"
"{\n"
"http_acl_remove (O.HA_LIST, O.HA_ORDER, O.HA_CLIENT_IP, O.HA_FLAG);\n"
"http_acl_set (N.HA_LIST, N.HA_ORDER, N.HA_CLIENT_IP, N.HA_FLAG, N.HA_DEST_IP, N.HA_OBJECT, N.HA_RW,\n"
"coalesce (N.HA_RATE, 0), N.HA_LIMIT);\n"
"}\n"
"--src virtual_dir.sql:110\n";

static const char *trig5 = 
"create trigger HTTP_ACL_D after delete on DB.DBA.HTTP_ACL referencing old as O\n"
"{\n"
"http_acl_remove (O.HA_LIST, O.HA_ORDER, O.HA_CLIENT_IP, O.HA_FLAG);\n"
"}\n"
"--src virtual_dir.sql:118\n";

static const char *view10 = 
"create view HTTP_PROXY_ACL (HP_SRC, HP_DEST, HP_FLAG)\n"
"as select HA_CLIENT_IP, HA_DEST_IP, HA_FLAG from DB.DBA.HTTP_ACL\n"
"where upper (HA_LIST) = \'PROXY\'\n";

static const char *view11 = 
"create view NEWS_ACL (NA_GROUP, NA_IP, NA_A_D, NA_RW)\n"
"as select HA_OBJECT, HA_CLIENT_IP, HA_FLAG, HA_RW from DB.DBA.HTTP_ACL\n"
"where upper (HA_LIST) = \'NEWS\'\n";

static const char *other183 = 
"insert soft DB.DBA.HTTP_PATH\n"
"(\n"
"HP_HOST, HP_LISTEN_HOST, HP_LPATH, HP_PPATH, HP_STORE_AS_DAV, HP_DIR_BROWSEABLE, HP_DEFAULT,\n"
"HP_SECURITY, HP_REALM, HP_AUTH_FUNC, HP_POSTPROCESS_FUNC, HP_RUN_VSP_AS, HP_RUN_SOAP_AS, HP_PERSIST_SES_VARS)\n"
"values ( \'*ini*\', \'*ini*\', \'/DAV\', \'/DAV/\', 1, 1, NULL, NULL, NULL, NULL, NULL, \'dba\', NULL, 0\n"
")\n";
static const char *other184 = 
"insert soft DB.DBA.HTTP_PATH\n"
"(\n"
"HP_HOST, HP_LISTEN_HOST, HP_LPATH, HP_PPATH, HP_STORE_AS_DAV, HP_DIR_BROWSEABLE, HP_DEFAULT,\n"
"HP_SECURITY, HP_REALM, HP_AUTH_FUNC, HP_POSTPROCESS_FUNC, HP_RUN_VSP_AS, HP_RUN_SOAP_AS, HP_PERSIST_SES_VARS)\n"
"values ( \'*sslini*\', \'*sslini*\', \'/DAV\', \'/DAV/\', 1, 1, NULL, NULL, NULL, NULL, NULL, \'dba\', NULL, 0\n"
")\n";
static const char *other185 = 
"insert soft DB.DBA.HTTP_PATH\n"
"(\n"
"HP_HOST, HP_LISTEN_HOST, HP_LPATH, HP_PPATH, HP_STORE_AS_DAV, HP_DIR_BROWSEABLE, HP_DEFAULT,\n"
"HP_SECURITY, HP_REALM, HP_AUTH_FUNC, HP_POSTPROCESS_FUNC, HP_RUN_VSP_AS, HP_RUN_SOAP_AS, HP_PERSIST_SES_VARS)\n"
"values ( \'*ini*\', \'*ini*\', \'/admin\', \'/admin/\', 0, 0, \'admin_main.vsp\', NULL, NULL, NULL, NULL, \'dba\', NULL, 0\n"
")\n";
static const char *other186 = 
"insert soft DB.DBA.HTTP_PATH\n"
"(\n"
"HP_HOST, HP_LISTEN_HOST, HP_LPATH, HP_PPATH, HP_STORE_AS_DAV, HP_DIR_BROWSEABLE, HP_DEFAULT,\n"
"HP_SECURITY, HP_REALM, HP_AUTH_FUNC, HP_POSTPROCESS_FUNC, HP_RUN_VSP_AS, HP_RUN_SOAP_AS, HP_PERSIST_SES_VARS)\n"
"values ( \'*ini*\', \'*ini*\', \'/install\', \'/install/\', 0, 0, \'install.vspx\', NULL, NULL, NULL, NULL, \'dba\', NULL, 0\n"
")\n";
static const char *other187 = 
"insert soft DB.DBA.HTTP_PATH\n"
"(\n"
"HP_HOST, HP_LISTEN_HOST, HP_LPATH, HP_PPATH, HP_STORE_AS_DAV, HP_DIR_BROWSEABLE, HP_DEFAULT,\n"
"HP_SECURITY, HP_REALM, HP_AUTH_FUNC, HP_POSTPROCESS_FUNC, HP_RUN_VSP_AS, HP_RUN_SOAP_AS, HP_PERSIST_SES_VARS)\n"
"values ( \'*sslini*\', \'*sslini*\', \'/admin\', \'/admin/\', 0, 0, \'admin_main.vsp\', NULL, NULL, NULL, NULL, \'dba\', NULL, 0\n"
")\n";
static const char *other188 = 
"insert soft DB.DBA.HTTP_PATH\n"
"(\n"
"HP_HOST, HP_LISTEN_HOST, HP_LPATH, HP_PPATH, HP_STORE_AS_DAV, HP_DIR_BROWSEABLE, HP_DEFAULT,\n"
"HP_SECURITY, HP_REALM, HP_AUTH_FUNC, HP_POSTPROCESS_FUNC, HP_RUN_VSP_AS, HP_RUN_SOAP_AS, HP_PERSIST_SES_VARS)\n"
"values ( \'*ini*\', \'*ini*\', \'/mime\', \'/mime/\', 0, 0, NULL, NULL, NULL, NULL, NULL, \'dba\', NULL, 0\n"
")\n";
static const char *other189 = 
"insert soft DB.DBA.HTTP_PATH\n"
"(\n"
"HP_HOST, HP_LISTEN_HOST, HP_LPATH, HP_PPATH, HP_STORE_AS_DAV, HP_DIR_BROWSEABLE, HP_DEFAULT,\n"
"HP_SECURITY, HP_REALM, HP_AUTH_FUNC, HP_POSTPROCESS_FUNC, HP_RUN_VSP_AS, HP_RUN_SOAP_AS, HP_PERSIST_SES_VARS)\n"
"values ( \'*ini*\', \'*ini*\', \'/images\', \'/images/\', 0, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0\n"
")\n";
static const char *other190 = 
"insert soft DB.DBA.HTTP_PATH\n"
"(\n"
"HP_HOST, HP_LISTEN_HOST, HP_LPATH, HP_PPATH, HP_STORE_AS_DAV, HP_DIR_BROWSEABLE, HP_DEFAULT,\n"
"HP_SECURITY, HP_REALM, HP_AUTH_FUNC, HP_POSTPROCESS_FUNC, HP_RUN_VSP_AS, HP_RUN_SOAP_AS, HP_PERSIST_SES_VARS)\n"
"values ( \'*sslini*\', \'*sslini*\', \'/mime\', \'/mime/\', 0, 0, NULL, NULL, NULL, NULL, NULL, \'dba\', NULL, 0\n"
")\n";
static const char *other191 = 
"insert soft DB.DBA.HTTP_PATH\n"
"(\n"
"HP_HOST, HP_LISTEN_HOST, HP_LPATH, HP_PPATH, HP_STORE_AS_DAV, HP_DIR_BROWSEABLE, HP_DEFAULT,\n"
"HP_SECURITY, HP_REALM, HP_AUTH_FUNC, HP_POSTPROCESS_FUNC, HP_RUN_VSP_AS, HP_RUN_SOAP_AS, HP_PERSIST_SES_VARS)\n"
"values ( \'*ini*\', \'*ini*\', \'/doc\', \'/doc/\', 0, 0, NULL, NULL, NULL, NULL, NULL, \'dba\', NULL, 0\n"
")\n";
static const char *other192 = 
"insert soft DB.DBA.HTTP_PATH\n"
"(\n"
"HP_HOST, HP_LISTEN_HOST, HP_LPATH, HP_PPATH, HP_STORE_AS_DAV, HP_DIR_BROWSEABLE, HP_DEFAULT,\n"
"HP_SECURITY, HP_REALM, HP_AUTH_FUNC, HP_POSTPROCESS_FUNC, HP_RUN_VSP_AS, HP_RUN_SOAP_AS, HP_PERSIST_SES_VARS)\n"
"values ( \'*sslini*\', \'*sslini*\', \'/doc\', \'/doc/\', 0, 0, NULL, NULL, NULL, NULL, NULL, \'dba\', NULL, 0\n"
")\n";
static const char *other193 = 
"insert soft DB.DBA.HTTP_PATH\n"
"(\n"
"HP_HOST, HP_LISTEN_HOST, HP_LPATH, HP_PPATH, HP_STORE_AS_DAV, HP_DIR_BROWSEABLE, HP_DEFAULT,\n"
"HP_SECURITY, HP_REALM, HP_AUTH_FUNC, HP_POSTPROCESS_FUNC, HP_RUN_VSP_AS, HP_RUN_SOAP_AS, HP_PERSIST_SES_VARS)\n"
"values ( \'*ini*\', \'*ini*\', \'/SOAP\', \'/SOAP/\', 0, 0, NULL, NULL, NULL, NULL, NULL, NULL, \'SOAP\', 0\n"
")\n";
static const char *other194 = 
"insert soft DB.DBA.HTTP_PATH\n"
"(\n"
"HP_HOST, HP_LISTEN_HOST, HP_LPATH, HP_PPATH, HP_STORE_AS_DAV, HP_DIR_BROWSEABLE, HP_DEFAULT,\n"
"HP_SECURITY, HP_REALM, HP_AUTH_FUNC, HP_POSTPROCESS_FUNC, HP_RUN_VSP_AS, HP_RUN_SOAP_AS, HP_PERSIST_SES_VARS)\n"
"values ( \'*sslini*\', \'*sslini*\', \'/SOAP\', \'/SOAP/\', 0, 0, NULL, NULL, NULL, NULL, NULL, NULL, \'SOAP\', 0\n"
")\n";
static const char *other195 = 
"insert soft DB.DBA.HTTP_PATH\n"
"(\n"
"HP_HOST, HP_LISTEN_HOST, HP_LPATH, HP_PPATH, HP_STORE_AS_DAV, HP_DIR_BROWSEABLE, HP_DEFAULT,\n"
"HP_SECURITY, HP_REALM, HP_AUTH_FUNC, HP_POSTPROCESS_FUNC, HP_RUN_VSP_AS, HP_RUN_SOAP_AS, HP_PERSIST_SES_VARS)\n"
"values ( \'*ini*\', \'*ini*\', \'/vsmx\', \'/vsmx/\', 0, 0, \'vsmx.vspx\', NULL, NULL, NULL, NULL, \'dba\', NULL, 0\n"
")\n";
static const char *other196 = 
"insert soft DB.DBA.HTTP_PATH\n"
"(\n"
"HP_HOST, HP_LISTEN_HOST, HP_LPATH, HP_PPATH, HP_STORE_AS_DAV, HP_DIR_BROWSEABLE, HP_DEFAULT,\n"
"HP_SECURITY, HP_REALM, HP_AUTH_FUNC, HP_POSTPROCESS_FUNC, HP_RUN_VSP_AS, HP_RUN_SOAP_AS, HP_PERSIST_SES_VARS)\n"
"values ( \'*sslini*\', \'*sslini*\', \'/vsmx\', \'/vsmx/\', 0, 0, \'vsmx.vspx\', NULL, NULL, NULL, NULL, \'dba\', NULL, 0\n"
")\n";
static const char *proc26 = 
"create procedure HTTP_SET_DBA_ADMIN (in realm varchar)\n"
"{\n"
"declare auth, _user varchar;\n"
"auth := vsp_auth_vec (http_request_header());\n"
"if (isarray (auth) and http_path () like \'/admin/%\' and http_path () not like \'/admin/admin_dav/%\'\n"
"and http_path () not like \'admin/admin_news/%\')\n"
"{\n"
"_user := get_keyword (\'username\', auth, \'\');\n"
"if (exists (select 1 from DB.DBA.SYS_USERS where U_NAME = _user and U_GROUP = 0))\n"
"{\n"
"__set_user_id (_user, 0);\n"
"set_qualifier (\'DB\');\n"
"}\n"
"}\n"
"return 1;\n"
"}\n"
"--src virtual_dir.sql:301\n";

static const char *proc27 = 
"create procedure\n"
"DB.DBA.IS_EMPTY_OR_NULL (in x any)\n"
"{\n"
"if (x is null or \'\' = x or 0 = x)\n"
"return 1;\n"
"return 0;\n"
"}\n"
"--src virtual_dir.sql:320\n";

static const char *proc28 = 
"create procedure INS_VIRTUAL_DIR (in lpath varchar, in ppath varchar)\n"
"{\n"
"declare is_dav integer;\n"
"if (DB.DBA.IS_EMPTY_OR_NULL (lpath) or DB.DBA.IS_EMPTY_OR_NULL (ppath))\n"
"return NULL;\n"
"is_dav := 0;\n"
"if (aref (lpath, length (lpath) - 1) = ascii (\'/\') and length (lpath) > 1)\n"
"lpath := substring (lpath, 1, length (lpath) - 1);\n"
"if (aref (ppath, length (ppath) - 1) <> ascii (\'/\'))\n"
"ppath := concat (ppath, \'/\');\n"
"if (ppath like \'/DAV/%\')\n"
"is_dav := 1;\n"
"insert into DB.DBA.HTTP_PATH (HP_LPATH, HP_PPATH, HP_HOST, HP_LISTEN_HOST,\n"
"HP_STORE_AS_DAV, HP_DIR_BROWSEABLE, HP_PERSIST_SES_VARS)\n"
"values (lpath, ppath, \'*ini*\', \'*ini*\', is_dav, 0, 0);\n"
"return http_map_table (lpath, ppath, \'*ini*\', \'*ini*\', is_dav);\n"
"}\n"
"--src virtual_dir.sql:331\n";

static const char *proc29 = 
"create procedure DEL_VIRTUAL_DIR (in lpath varchar)\n"
"{\n"
"if (DB.DBA.IS_EMPTY_OR_NULL (lpath))\n"
"return NULL;\n"
"delete from DB.DBA.HTTP_PATH where HP_LPATH = lpath and HP_HOST = \'*ini*\' and HP_LISTEN_HOST = \'*ini*\';\n"
"return http_map_del (lpath, \'*ini*\', \'*ini*\');\n"
"}\n"
"--src virtual_dir.sql:351\n";

static const char *proc30 = 
"create procedure VHOST_DEFINE (in vhost varchar := \'*ini*\',\n"
"in lhost varchar := \'*ini*\',\n"
"in lpath varchar,\n"
"in ppath varchar,\n"
"in is_dav integer := 0,\n"
"in is_brws integer := 0,\n"
"in def_page varchar := null,\n"
"in auth_fn varchar := null,\n"
"in realm varchar := null,\n"
"in ppr_fn varchar := null,\n"
"in vsp_user varchar := null,\n"
"in soap_user varchar := null,\n"
"in sec varchar := null,\n"
"in ses_vars integer := 0,\n"
"in soap_opts any := null,\n"
"in auth_opts any := null,\n"
"in opts any := null,\n"
"in is_default_host integer := 0)\n"
"{\n"
"declare ssl_port varchar;\n"
"declare ssl_opts any;\n"
"declare varr, lport any;\n"
"if (length (lpath) > 1 and aref (lpath, length (lpath) - 1) = ascii (\'/\') )\n"
"lpath := substring (lpath, 1, length (lpath) - 1);\n"
"\n"
"\n"
"if (lpath not like \'/%\' or (ppath not like \'/%\' and lower(ppath) not like \'http://%\'))\n"
"signal (\'22023\', \'Missing leading slash in lpath or ppath parameter.\', \'HT058\');\n"
"\n"
"if (ppath like \'/DAV/%\' and is_dav <> 1)\n"
"signal (\'22023\', \'The physical path must points to the dav domain.\', \'HT044\');\n"
"\n"
"if (is_default_host and (lhost = \'*ini*\' or lhost = \'*sslini*\'))\n"
"signal (\'22023\', \'The default directory for default web site can be changed only from the INI file.\', \'HT060\');\n"
"\n"
"lhost := replace (lhost, \'0.0.0.0\', \'\');\n"
"\n"
"ssl_port := coalesce (server_https_port (), \'\');\n"
"if (isstring (server_http_port ()))\n"
"{\n"
"varr := split_and_decode (\n"
"case\n"
"when vhost = \'*ini*\' then server_http_port ()\n"
"when vhost = \'*sslini*\' then ssl_port\n"
"else vhost\n"
"end\n"
", 0, \':=:\');\n"
"lport := split_and_decode (\n"
"case\n"
"when lhost = \'*ini*\' then server_http_port ()\n"
"when lhost = \'*sslini*\' then ssl_port\n"
"else lhost\n"
"end\n"
", 0, \':=:\');\n"
"\n"
"if (__tag (varr) = 193 and length (varr) > 1)\n"
"vhost := varr[0];\n"
"\n"
"if (__tag (lport) = 193 and length (lport) > 1)\n"
"lport := aref (lport, 1);\n"
"else if (lhost = \'*ini*\')\n"
"lport := server_http_port ();\n"
"else if (lhost = \'*sslini*\')\n"
"lport := ssl_port;\n"
"else if (atoi (lhost))\n"
"lport := lhost;\n"
"else\n"
"lport := \'80\';\n"
"}\n"
"else\n"
"lport := null;\n"
"\n"
"if (lport = server_http_port () and lhost <> \'*ini*\')\n"
"lhost := \'*ini*\';\n"
"else if (lport = ssl_port and lhost <> \'*sslini*\')\n"
"lhost := \'*sslini*\';\n"
"\n"
"ssl_opts := NULL;\n"
"if (isstring (sec) and upper (sec) = \'SSL\' and\n"
"not exists (select 1 from DB.DBA.HTTP_PATH where HP_LISTEN_HOST = lhost))\n"
"{\n"
"if (not isarray (auth_opts) or \'\' = get_keyword (\'https_cert\', auth_opts, \'\') or\n"
"\'\' = get_keyword (\'https_key\', auth_opts, \'\'))\n"
"signal (\'22023\', \'At least certificate and key files should be supplied for HTTPS listener.\', \'HT046\');\n"
"ssl_opts := auth_opts;\n"
"}\n"
"\n"
"if (opts is not null and mod(length (opts), 2) <> 0)\n"
"signal (\'22023\', \'The global options should be an array with even length or NULL.\', \'HT056\');\n"
"\n"
"if (is_default_host = 1 and\n"
"exists (select 1 from DB.DBA.HTTP_PATH where HP_LISTEN_HOST = lhost and HP_IS_DEFAULT_HOST = 1))\n"
"signal (\'22023\', sprintf (\'The default directory is already specified for interface %s.\', lhost), \'HT058\');\n"
"\n"
"if (is_default_host = 1 and\n"
"exists (select 1 from DB.DBA.HTTP_PATH where HP_LISTEN_HOST = lhost and HP_HOST = lhost))\n"
"signal (\'22023\', sprintf (\'The default directory for interface %s conflicts with existing directory entry for host (%s) and interface (%s).\', lhost, lhost, lhost), \'HT059\');\n"
"\n"
"if (lhost[0] <> ascii (\'*\') and lport is not null and\n"
"lhost not like \':%\' and exists (select 1 from DB.DBA.HTTP_PATH where HP_LISTEN_HOST = \':\'||lport))\n"
"{\n"
"signal (\'22023\', \'The specified port to listen is already occupied by another listener on all network interfaces\', \'HT078\');\n"
"}\n"
"if (lhost[0] <> ascii (\'*\') and lport is not null and\n"
"lhost = \':\'||lport and exists (select 1 from DB.DBA.HTTP_PATH where HP_LISTEN_HOST like \'%_:\'||lport))\n"
"{\n"
"signal (\'22023\', \'The specified port to listen on all interfaces is already occupied by another listener on a separate network interface\', \'HT079\');\n"
"}\n"
"\n"
"if (isstring (server_http_port()) and isstring (lhost) and lhost <> \'*ini*\' and\n"
"lhost <> server_http_port() and lhost <> \'*sslini*\' and lhost <> ssl_port and\n"
"not exists (select 1 from DB.DBA.HTTP_PATH where HP_LISTEN_HOST = lhost))\n"
"{\n"
"http_listen_host (lhost, 0, ssl_opts);\n"
"}\n"
"\n"
"insert into DB.DBA.HTTP_PATH (HP_LPATH, HP_PPATH, HP_HOST, HP_LISTEN_HOST,\n"
"HP_STORE_AS_DAV, HP_DIR_BROWSEABLE, HP_PERSIST_SES_VARS,\n"
"HP_DEFAULT, HP_SECURITY, HP_AUTH_FUNC, HP_REALM,\n"
"HP_POSTPROCESS_FUNC, HP_RUN_VSP_AS, HP_RUN_SOAP_AS, HP_SOAP_OPTIONS, HP_AUTH_OPTIONS,\n"
"HP_OPTIONS, HP_IS_DEFAULT_HOST)\n"
"values (lpath, ppath, vhost, lhost, is_dav, is_brws, ses_vars,\n"
"def_page, sec, auth_fn, realm, ppr_fn, vsp_user, soap_user, serialize (soap_opts), serialize (auth_opts),\n"
"serialize (opts), is_default_host);\n"
"\n"
"if (isstring (server_http_port ()))\n"
"{\n"
"http_map_table (lpath, ppath, vhost, lhost, is_dav, is_brws, def_page,\n"
"sec, realm, auth_fn, ppr_fn, vsp_user, soap_user, ses_vars, soap_opts, auth_opts, opts, is_default_host);\n"
"}\n"
"\n"
"}\n"
"--src virtual_dir.sql:364\n";

static const char *proc31 = 
"create procedure VHOST_MAP_RELOAD (in vhost varchar := \'*ini*\', in lhost varchar := \'*ini*\', in lpath varchar)\n"
"{\n"
"declare ssl_port, varr varchar;\n"
"declare ret int;\n"
"\n"
"if (DB.DBA.IS_EMPTY_OR_NULL (lpath) or DB.DBA.IS_EMPTY_OR_NULL (lhost))\n"
"return NULL;\n"
"http_map_del (lpath, vhost, lhost);\n"
"ret := 0;\n"
"for select\n"
"HP_LPATH,\n"
"HP_PPATH,\n"
"HP_HOST,\n"
"HP_LISTEN_HOST,\n"
"HP_STORE_AS_DAV,\n"
"HP_DIR_BROWSEABLE,\n"
"HP_DEFAULT,\n"
"HP_SECURITY,\n"
"HP_REALM,\n"
"HP_AUTH_FUNC,\n"
"HP_POSTPROCESS_FUNC,\n"
"HP_RUN_VSP_AS,\n"
"HP_RUN_SOAP_AS,\n"
"HP_PERSIST_SES_VARS,\n"
"HP_SOAP_OPTIONS,\n"
"HP_AUTH_OPTIONS,\n"
"HP_OPTIONS,\n"
"HP_IS_DEFAULT_HOST\n"
"from DB.DBA.HTTP_PATH where\n"
"HP_LPATH = lpath and HP_HOST = vhost and HP_LISTEN_HOST = lhost\n"
"do\n"
"{\n"
"http_map_table (\n"
"HP_LPATH,\n"
"HP_PPATH,\n"
"HP_HOST,\n"
"HP_LISTEN_HOST,\n"
"HP_STORE_AS_DAV,\n"
"HP_DIR_BROWSEABLE,\n"
"HP_DEFAULT,\n"
"HP_SECURITY,\n"
"HP_REALM,\n"
"HP_AUTH_FUNC,\n"
"HP_POSTPROCESS_FUNC,\n"
"HP_RUN_VSP_AS,\n"
"HP_RUN_SOAP_AS,\n"
"HP_PERSIST_SES_VARS,\n"
"deserialize (HP_SOAP_OPTIONS),\n"
"deserialize (HP_AUTH_OPTIONS),\n"
"deserialize (HP_OPTIONS),\n"
"HP_IS_DEFAULT_HOST);\n"
"ret := ret + 1;\n"
"}\n"
"return ret;\n"
"}\n"
"--src virtual_dir.sql:498\n";

static const char *proc32 = 
"create procedure VHOST_REMOVE (in vhost varchar := \'*ini*\',\n"
"in lhost varchar := \'*ini*\',\n"
"in lpath varchar,\n"
"in del_vsps integer := 0)\n"
"{\n"
"declare ssl_port, varr, lport varchar;\n"
"declare ppath, vsp_user, stat, msg varchar;\n"
"declare cr cursor for select HP_PPATH, HP_RUN_VSP_AS from DB.DBA.HTTP_PATH\n"
"where HP_LISTEN_HOST = lhost and HP_HOST = vhost and HP_LPATH = lpath;\n"
"if (DB.DBA.IS_EMPTY_OR_NULL (lpath) or DB.DBA.IS_EMPTY_OR_NULL (lhost))\n"
"return NULL;\n"
"\n"
"if (length (lpath) > 1 and aref (lpath, length (lpath) - 1) = ascii (\'/\') )\n"
"lpath := substring (lpath, 1, length (lpath) - 1);\n"
"\n"
"lhost := replace (lhost, \'0.0.0.0\', \'\');\n"
"\n"
"ssl_port := coalesce (server_https_port (), \'\');\n"
"if (isstring (server_http_port ()))\n"
"{\n"
"varr := split_and_decode (\n"
"case\n"
"when vhost = \'*ini*\' then server_http_port ()\n"
"when vhost = \'*sslini*\' then ssl_port\n"
"else vhost\n"
"end\n"
", 0, \':=:\');\n"
"lport := split_and_decode (\n"
"case\n"
"when lhost = \'*ini*\' then server_http_port ()\n"
"when lhost = \'*sslini*\' then ssl_port\n"
"else lhost\n"
"end\n"
", 0, \':=:\');\n"
"if (__tag (varr) = 193 and length (varr) > 1)\n"
"vhost := varr[0];\n"
"if (__tag (lport) = 193 and length (lport) > 1)\n"
"lport := aref (lport, 1);\n"
"else if (lhost = \'*ini*\')\n"
"lport := server_http_port ();\n"
"else if (lhost = \'*sslini*\')\n"
"lport := ssl_port;\n"
"else if (atoi (lhost))\n"
"lport := lhost;\n"
"else\n"
"lport := \'80\';\n"
"}\n"
"else\n"
"lport := null;\n"
"if (lport = server_http_port () and lhost <> \'*ini*\')\n"
"lhost := \'*ini*\';\n"
"else if (lport = ssl_port and lhost <> \'*sslini*\')\n"
"lhost := \'*sslini*\';\n"
"\n"
"whenever not found goto err_exit;\n"
"open cr (exclusive, prefetch 1);\n"
"fetch cr into ppath, vsp_user;\n"
"delete from DB.DBA.HTTP_PATH where current of cr;\n"
"http_map_del (lpath, vhost, lhost);\n"
"\n"
"if (lhost <> \'*ini*\' and lhost <> server_http_port() and\n"
"lhost <> \'*sslini*\' and lhost <> ssl_port and\n"
"not exists (select 1 from DB.DBA.HTTP_PATH where HP_LISTEN_HOST = lhost))\n"
"{\n"
"http_listen_host (lhost, 1);\n"
"}\n"
"for select P_NAME from DB.DBA.SYS_PROCEDURES where del_vsps and P_NAME like concat (\'WS.WS.\', ppath, \'%\')\n"
"and P_OWNER = vsp_user do\n"
"{\n"
"stat := \'00000\'; msg := \'\';\n"
"exec (sprintf (\'DROP PROCEDURE \"%I\"\', P_NAME), stat, msg);\n"
"}\n"
"err_exit:\n"
"close cr;\n"
"}\n"
"--src virtual_dir.sql:556\n";


static const char *other197 = 
" WS.WS.URIQA_VHOST_RESET()\n";

static const char *other198 = 
" WS.WS.SPARQL_VHOST_RESET()\n";
static const char *proc33 = 
"create procedure\n"
"HTTP_PROXY_ACCESS (in dst varchar)\n"
"returns integer\n"
"{\n"
"declare client varchar;\n"
"declare host, ppath any;\n"
"declare rc, rcc int;\n"
"\n"
"\n"
"ppath := http_map_get (\'mounted\');\n"
"if (lower (ppath) like \'http://%\')\n"
"return 1;\n"
"\n"
"\n"
"rc := 0;\n"
"\n"
"\n"
"client := http_client_ip ();\n"
"host := split_and_decode (dst, 0, \'\\0\\0:\');\n"
"\n"
"dst := host[0];\n"
"\n"
"rcc := http_acl_get (\'PROXY\', client, dst);\n"
"if (0 = rcc)\n"
"rc := 1;\n"
"\n"
"return rc;\n"
"}\n"
"--src virtual_dir.sql:643\n";

static const char *tbl29 = 
"create table WS.WS.SYS_RC_CACHE\n"
"(RC_URI varchar,\n"
"RC_DATA long varchar,\n"
"RC_INVALIDATE varchar,\n"
"RC_DT datetime,\n"
"RC_TAG varchar,\n"
"RC_CHARSET varchar,\n"
"primary key (RC_URI)\n"
")\n"
"create index RC_IN on WS.WS.SYS_RC_CACHE (RC_INVALIDATE)\n";

static const char *tbl30 = 
"create table WS.WS.SYS_CACHEABLE (CA_URI varchar, CA_CHECK varchar, primary key (CA_URI))\n";

static const char *trig6 = 
"create trigger SYS_CACHEABLE_I after insert on WS.WS.SYS_CACHEABLE\n"
"{\n"
"http_url_cache_set (CA_URI, CA_CHECK);\n"
"}\n"
"--src virtual_dir.sql:707\n";

static const char *trig7 = 
"create trigger SYS_CACHEABLE_U after update on WS.WS.SYS_CACHEABLE referencing old as O, new as N\n"
"{\n"
"http_url_cache_set (N.CA_URI, N.CA_CHECK);\n"
"}\n"
"--src virtual_dir.sql:713\n";

static const char *trig8 = 
"create trigger SYS_CACHEABLE_D after delete on WS.WS.SYS_CACHEABLE\n"
"{\n"
"http_url_cache_remove (CA_URI);\n"
"delete from WS.WS.SYS_RC_CACHE where RC_URI = CA_URI;\n"
"}\n"
"--src virtual_dir.sql:719\n";

static const char *proc34 = 
"create procedure WS.WS.HTTP_CACHE_CHECK (inout path any, inout lines any, inout check_fn any)\n"
"{\n"
"declare inv, rc, cnt, tag, charset, url, qstr, sch any;\n"
"inv := null;\n"
"\n"
"if (is_https_ctx ())\n"
"sch := \'https://\';\n"
"else\n"
"sch := \'http://\';\n"
"\n"
"qstr := http_request_get (\'QUERY_STRING\');\n"
"url := sch || http_request_header(lines, \'Host\', null, \'\') || path;\n"
"if (length (qstr))\n"
"url := url || \'?\' || qstr;\n"
"rc := call (check_fn) (url, lines, inv);\n"
"\n"
"if (rc)\n"
"{\n"
"whenever not found goto nf;\n"
"select RC_DATA, RC_TAG, RC_CHARSET into cnt, tag, charset from WS.WS.SYS_RC_CACHE where RC_URI = url;\n"
"commit work;\n"
"if (cnt is not null)\n"
"{\n"
"declare ses, ctag any;\n"
"ctag := http_request_header (lines, \'If-None-Match\');\n"
"if (not isstring (ctag))\n"
"ctag := \'\';\n"
"if (ctag <> tag)\n"
"{\n"
"if (charset is not null)\n"
"{\n"
"set http_charset=charset;\n"
"}\n"
"http_header (concat (http_header_get (), \'ETag: \"\', tag,\n"
"sprintf (\'\"\\r\\nContent-Length: %d\\r\\n\\r\\n\', length (cnt))));\n"
"http_flush (2);\n"
"ses_write (cnt);\n"
"}\n"
"else\n"
"{\n"
"http_request_status (\'HTTP/1.1 304 Not Modified\');\n"
"}\n"
"}\n"
"else\n"
"{\n"
"http (\'<HTML><HEAD><META HTTP-EQUIV=\"REFRESH\" CONTENT=\"1\" /></HEAD>\');\n"
"http (\'<BODY>\');\n"
"http (\'<P>if you see this for longer than 1 second, please <a href=\"\">click here</a> or reload.</P>\');\n"
"http (\'</BODY>\');\n"
"http (\'</HTML>\');\n"
"}\n"
"return 1;\n"
"nf:\n"
"insert into WS.WS.SYS_RC_CACHE (RC_URI, RC_INVALIDATE, RC_DT) values (url, inv, now ());\n"
"commit work;\n"
"\n"
"return 2;\n"
"}\n"
"return 0;\n"
"}\n"
"--src virtual_dir.sql:726\n";

static const char *proc35 = 
"create procedure WS.WS.HTTP_CACHE_STORE (inout path any, inout store int)\n"
"{\n"
"declare tag, cnt any;\n"
"declare url, qstr, sch any;\n"
"\n"
"if (is_https_ctx ())\n"
"sch := \'https://\';\n"
"else\n"
"sch := \'http://\';\n"
"\n"
"qstr := http_request_get (\'QUERY_STRING\');\n"
"url := sch || http_request_header(http_request_header (), \'Host\', null, \'\') || path;\n"
"if (length (qstr))\n"
"url := url || \'?\' || qstr;\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"if (not store)\n"
"{\n"
"delete from WS.WS.SYS_RC_CACHE where RC_URI = url;\n"
"return;\n"
"}\n"
"\n"
"tag := uuid ();\n"
"update WS.WS.SYS_RC_CACHE set RC_DATA = http_get_string_output (1000000),\n"
"RC_TAG = tag,\n"
"RC_CHARSET = http_current_charset ()\n"
"where RC_URI = url;\n"
"if (row_count ())\n"
"{\n"
"http_header (concat (http_header_get (), \'ETag: \"\', tag, \'\"\\r\\n\'));\n"
"}\n"
"}\n"
"--src virtual_dir.sql:788\n";

static const char *proc36 = 
"create procedure virt_proxy_init ()\n"
"{\n"
"if (not exists (select 1 from \"DB\".\"DBA\".\"SYS_USERS\" where U_NAME = \'PROXY\'))\n"
"DB.DBA.USER_CREATE (\'PROXY\', uuid(), vector (\'DISABLED\', 1));\n"
"if (registry_get (\'DB.DBA.virt_proxy_init_state\') = \'1.1\')\n"
"return;\n"
"DB.DBA.URLREWRITE_CREATE_REGEX_RULE (\'ext_http_proxy_rule_1\', 1,\n"
"\'/proxy/([^/\\?\\&]*)?/?([^/\\?\\&:]*)/(.*)\', vector (\'force\', \'login\', \'url\'), 2,\n"
"\'/proxy?url=%U&force=%U&login=%U\', vector (\'url\', \'force\', \'login\'), null, null, 2);\n"
"DB.DBA.URLREWRITE_CREATE_RULELIST (\'ext_http_proxy_rule_list1\', 1, vector (\'ext_http_proxy_rule_1\'));\n"
"DB.DBA.VHOST_REMOVE (lpath=>\'/proxy\');\n"
"DB.DBA.VHOST_DEFINE (lpath=>\'/proxy\', ppath=>\'/SOAP/Http/ext_http_proxy\', soap_user=>\'PROXY\',\n"
"opts=>vector(\'url_rewrite\', \'ext_http_proxy_rule_list1\'));\n"
"registry_set (\'DB.DBA.virt_proxy_init_state\', \'1.1\');\n"
"}\n"
"--src virtual_dir.sql:826\n";

static const char *proc37 = 
"create procedure\n"
"proxy_sp_html_error_page (in title varchar, in hd varchar, in message varchar)\n"
"{\n"
"http (\'<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01//EN\" \"http://www.w3.org/TR/html4/strict.dtd\">\');\n"
"http (\'<html>\');\n"
"http (\'<head>\');\n"
"http (\'  <title>\' || title || \'</title>\');\n"
"http (\'  <style type=\"text/css\">\');\n"
"http (\'  </style>\');\n"
"http (\'</head>\');\n"
"http (\'<body>\');\n"
"http (\'  <h1>\' || hd || \'</h1>\');\n"
"http (\'  <p>\' || message || \'</p>\');\n"
"http (\'</body>\');\n"
"http (\'</html>\');\n"
"}\n"
"--src virtual_dir.sql:843\n";

static const char *proc38 = 
"create procedure\n"
"str_fmt (in fmt_str varchar, in parm_arr any)\n"
"{\n"
"declare f_l,l,p,st,cnt integer;\n"
"declare s varchar;\n"
"\n"
"s := \'\';\n"
"st := 1;\n"
"l := length (parm_arr);\n"
"f_l := length (fmt_str);\n"
"\n"
"while (1)\n"
"{\n"
"p := locate (\'%\', fmt_str, st);\n"
"\n"
"if (p = 0)\n"
"{\n"
"if (cnt < l)\n"
"signal (\'42000\',\'Too many values in parm_arr in str_fmt\');\n"
"\n"
"if (cnt > l)\n"
"signal (\'42000\', \'Too few values in parm_arr in str_fmt\');\n"
"\n"
"if (st < f_l)\n"
"s := s || subseq (fmt_str, st-1, f_l);\n"
"return s;\n"
"}\n"
"\n"
"\n"
"\n"
"p := p + 1;\n"
"\n"
"s := s || sprintf (subseq (fmt_str, st-1, p), parm_arr[cnt]);\n"
"cnt := cnt + 1;\n"
"st := p + 1;\n"
"}\n"
"}\n"
"--src virtual_dir.sql:867\n";

static const char *tbl31 = 
"create table DB.DBA.PROXY_SP_QRY (\n"
"pspq_id integer identity,\n"
"pspq_qry varchar,\n"
"pspq_n_parms integer,\n"
"pspq_def_values any,\n"
"pspq_descr varchar,\n"
"pspq_expln varchar,\n"
"pspq_isparql_path varchar,\n"
"primary key (pspq_id)\n"
")\n";

static const char *proc39 = 
"create procedure\n"
"ext_http_proxy_exec_qry (in exec varchar, in params any)\n"
"{\n"
"declare qt, stat, msg, accept varchar;\n"
"declare metas, rset, triples, ses any;\n"
"declare parm_arr any;\n"
"\n"
"stat := \'00000\';\n"
"\n"
"set_user_id (\'SPARQL\');\n"
"\n"
"declare exit handler for not found\n"
"{\n"
"http_request_status (\'HTTP/1.1 400 Bad request\');\n"
"proxy_sp_html_error_page (\'Error: invalid query id\', \'Invalid Query ID\', \'The query id was invalid.\');\n"
"};\n"
"\n"
"declare _qry varchar;\n"
"declare _n_parms integer;\n"
"\n"
"select pspq_qry, pspq_n_parms\n"
"into _qry, _n_parms\n"
"from proxy_sp_qry\n"
"where pspq_id = exec;\n"
"\n"
"parm_arr := make_array (_n_parms, \'any\');\n"
"\n"
"declare parm_cnt integer;\n"
"parm_cnt := 0;\n"
"\n"
"for (declare i, l int, i := 0, l := length (params); i < l; i := i + 2)\n"
"{\n"
"if (params[i] like \'p%\')\n"
"{\n"
"aset (parm_arr, atoi (\"RIGHT\" (params[i], length (params[i]) - 1)) - 1, params[i+1]);\n"
"parm_cnt := parm_cnt + 1;\n"
"}\n"
"}\n"
"\n"
"if (parm_cnt < _n_parms)\n"
"{\n"
"http_rewrite();\n"
"http_request_status (\'HTTP/1.1 400 Bad request\');\n"
"proxy_sp_html_error_page (\'Error: insufficient no of params\',\n"
"\'Insufficient number of parameters\',\n"
"\'This query takes exactly \' || _n_parms || \'parameters\');\n"
"}\n"
"\n"
"declare xec_str varchar;\n"
"xec_str := str_fmt (_qry, parm_arr);\n"
"exec (xec_str, stat, msg, vector (), 0, metas, rset);\n"
"\n"
"accept := \'application/rdf+xml\';\n"
"\n"
"if (stat <> \'00000\')\n"
"signal (stat, msg);\n"
"\n"
"ses := string_output (1000000);\n"
"commit work;\n"
"\n"
"http_rewrite();\n"
"\n"
"if (rset is not null)\n"
"DB.DBA.SPARQL_RESULTS_WRITE (ses, metas, rset, accept, 1);\n"
"\n"
"http (ses);\n"
"}\n"
"--src virtual_dir.sql:921\n";

static const char *proc40 = 
"create procedure\n"
"ext_http_proxy (in url varchar := null,\n"
"in exec varchar := null,\n"
"in header varchar := null,\n"
"in force varchar := null,\n"
"in \"output-format\" varchar := null,\n"
"in get varchar := \'soft\',\n"
"in login varchar := \'\') __SOAP_HTTP \'text/html\'\n"
"{\n"
"declare hdr, content, req_hdr any;\n"
"declare ct any;\n"
"declare stat, msg, metas, accept, rset, triples, ses, arr any;\n"
"declare local_qry integer; local_qry := 0;\n"
"\n"
"declare params, ids any;\n"
"params := http_param ();\n"
"http_header (\'\');\n"
"\n"
"if (exec is not null)\n"
"{\n"
"ext_http_proxy_exec_qry (exec, params);\n"
"return \'\';\n"
"}\n"
"\n"
"req_hdr := null;\n"
"\n"
"if (header is not null)\n"
"req_hdr := header;\n"
"\n"
"arr := rfc1808_parse_uri (url);\n"
"arr[5] := \'\';\n"
"\n"
"if (arr[0] = \'nodeID\')\n"
"arr[2] := \'\';\n"
"\n"
"url := DB.DBA.vspx_uri_compose (arr);\n"
"\n"
"if (force is not null)\n"
"{\n"
"if (lower (force) = \'rdf\')\n"
"{\n"
"declare defs, host, pref, sponge any;\n"
"defs := \'\';\n"
"for (declare i,l int, i := 0, l := length (params); i < l; i := i + 2)\n"
"{\n"
"if (params[i] like \'sparql_%\')\n"
"{\n"
"declare nam varchar;\n"
"nam := subseq (params[i], 7);\n"
"if (nam in (\'local\')) {\n"
"local_qry := 1;\n"
"defs := \'\';\n"
"goto end_loop;\n"
"}\n"
"if (nam in (\'input:grab-depth\', \'input:grab-limit\', \'sql:log-enable\', \'sql:signal-void-variables\'))\n"
"defs := defs || \' define \'||nam||\' \'||params[i+1]||\' \';\n"
"else\n"
"defs := defs || \' define \'||nam||\' \"\'||params[i+1]||\'\" \';\n"
"}\n"
"}\n"
"end_loop:;\n"
"set http_charset=\'utf-8\';\n"
"accept := \'\';\n"
"if (header is not null and length (header))\n"
"accept := http_request_header (split_and_decode (header, 0, \'\\0\\0\\r\\n\'), \'Accept\', null, null);\n"
"else\n"
"{\n"
"accept := http_request_header_full (http_request_header(), \'Accept\', \'*/*\');\n"
"accept := HTTP_RDF_GET_ACCEPT_BY_Q (accept);\n"
"if (accept is null or accept = \'*/*\')\n"
"accept := \'application/rdf+xml\';\n"
"}\n"
"if (\"output-format\" is not null)\n"
"{\n"
"if (\"output-format\" = \'rdf\' or \"output-format\" = \'rdf+xml\' or \"output-format\" = \'xml\')\n"
"accept := \'application/rdf+xml\';\n"
"else if (\"output-format\" = \'ttl\' or \"output-format\" = \'turtle\' or \"output-format\" = \'n3\')\n"
"accept := \'text/rdf+n3\';\n"
"else if (\"output-format\" = \'nt\' or \"output-format\" = \'txt\')\n"
"accept := \'text/n3\';\n"
"}\n"
"stat := \'00000\';\n"
"if (get not in (\'soft\', \'replacing\'))\n"
"get := \'soft\';\n"
"if (length (login))\n"
"login := concat (\'define get:login \"\', login, \'\" \');\n"
"else\n"
"login := \'\';\n"
"host := http_request_header(http_request_header(), \'Host\', null, null);\n"
"ids := vector (\'rdf\', \'id/entity\', \'id\');\n"
"foreach (varchar idn in ids) do\n"
"{\n"
"pref := \'http://\' || host || http_map_get (\'domain\') || \'/\' || idn || \'/\';\n"
"if (url like pref || \'%\')\n"
"{\n"
"url := subseq (url, length (pref));\n"
"if (url like \'http/%\')\n"
"url := \'http:/\' || subseq (url, 4);\n"
"else if (url like \'https/%\')\n"
"url := \'https:/\' || subseq (url, 5);\n"
"else if (url like \'nodeID/%\')\n"
"url := \'nodeID:/\' || subseq (url, 6);\n"
"}\n"
"}\n"
"\n"
"url := replace (url, \'\'\'\', \'%27\');\n"
"url := replace (url, \'<\', \'%3C\');\n"
"url := replace (url, \'>\', \'%3E\');\n"
"url := replace (url, \' \', \'%20\');\n"
"\n"
"sponge := sprintf (\'define get:soft \"%s\"\', get);\n"
"\n"
"set_user_id (\'SPARQL\');\n"
"\n"
"if (local_qry)\n"
"{\n"
"exec (sprintf (\'sparql %s DESCRIBE <%S>\', defs, url), stat, msg, vector (), 0, metas, rset);\n"
"}\n"
"\n"
"else\n"
"if (url not like \'nodeID://%\')\n"
"{\n"
"exec (sprintf (\'sparql %s %s %s CONSTRUCT { ?s ?p ?o } FROM <%S> WHERE { ?s ?p ?o }\',\n"
"defs, login, sponge, url), stat, msg, vector (), 0, metas, rset);\n"
"}\n"
"else\n"
"{\n"
"exec (sprintf (\'sparql %s DESCRIBE <%S>\', defs, url), stat, msg, vector (), 0, metas, rset);\n"
"}\n"
"\n"
"if (stat <> \'00000\')\n"
"signal (stat, msg);\n"
"\n"
"ses := string_output (1000000);\n"
"commit work;\n"
"DB.DBA.SPARQL_RESULTS_WRITE (ses, metas, rset, accept, 1);\n"
"\n"
"for select HS_EXPIRATION, HS_LAST_MODIFIED, HS_LAST_ETAG\n"
"from DB.DBA.SYS_HTTP_SPONGE where HS_LOCAL_IRI = url and HS_PARSER = \'DB.DBA.RDF_LOAD_HTTP_RESPONSE\' do\n"
"{\n"
"if (HS_LAST_MODIFIED is not null)\n"
"http_header (http_header_get () || sprintf (\'Last-Modified: %s\\r\\n\', date_rfc1123 (HS_LAST_MODIFIED)));\n"
"if (HS_LAST_ETAG is not null)\n"
"http_header (http_header_get () || sprintf (\'ETag: %s\\r\\n\', HS_LAST_ETAG));\n"
"if (HS_EXPIRATION is not null)\n"
"http_header (http_header_get () || sprintf (\'Expires: %s\\r\\n\', date_rfc1123 (HS_EXPIRATION)));\n"
"}\n"
"\n"
"http (ses);\n"
"return \'\';\n"
"}\n"
"else\n"
"signal (\'22023\', \'The \"force\" parameter supports \"rdf\"\');\n"
"}\n"
"{\n"
"declare meth varchar;\n"
"declare body varchar;\n"
"declare pars, head any;\n"
"pars := http_param ();\n"
"head := http_request_header ();\n"
"meth := http_request_get (\'REQUEST_METHOD\');\n"
"body := \'\';\n"
"for (declare i, l int, i := 0, l := length (pars); i < l; i := i + 2)\n"
"{\n"
"if (pars[i] <> \'url\' and pars[i] <> \'header\')\n"
"body := body || sprintf (\'%U=%U&\', pars[i], pars[i + 1]);\n"
"}\n"
"if (length (body))\n"
"body := rtrim (body, \'&\');\n"
"else\n"
"body := null;\n"
"if (body is null and meth = \'POST\')\n"
"meth := \'GET\';\n"
"if (req_hdr is null)\n"
"{\n"
"req_hdr := \'\';\n"
"for (declare i, l int, i := 1, l := length (head); i < l; i := i + 1)\n"
"{\n"
"if (lower (head[i]) not like \'host:%\' and\n"
"lower (head[i]) not like \'keep-alive:%\' and\n"
"lower (head[i]) not like \'content-length:%\' and\n"
"lower (head[i]) not like \'connection:%\')\n"
"req_hdr := req_hdr || head[i];\n"
"}\n"
"req_hdr := rtrim (req_hdr, \'\\n\');\n"
"req_hdr := rtrim (req_hdr, \'\\r\');\n"
"req_hdr := rtrim (req_hdr, \'\\n\');\n"
"if (length (req_hdr) = 0)\n"
"req_hdr := null;\n"
"}\n"
"content := DB.DBA.RDF_HTTP_URL_GET (url, \'\', hdr, meth, req_hdr, body);\n"
"}\n"
"ct := http_request_header (hdr, \'Content-Type\');\n"
"if (ct is not null)\n"
"http_header (sprintf (\'Content-Type: %s\\r\\n\', ct));\n"
"\n"
"foreach (any hd in hdr) do\n"
"{\n"
"if (regexp_match (\'(etag:)|(expires:)|(last-modified:)|(pragma:)|(cache-control:)\', lower (hd)) is not null)\n"
"http_header (http_header_get () || hd);\n"
"}\n"
"\n"
"http (content);\n"
"return \'\';\n"
"}\n"
"--src virtual_dir.sql:992\n";

static const char *proc41 = 
"create procedure\n"
"DB.DBA.VHOST_DUMP_SQL (in lpath varchar, in vhost varchar := \'*ini*\', in lhost varchar := \'*ini*\')\n"
"{\n"
"declare ses any;\n"
"ses := string_output ();\n"
"for select\n"
"HP_PPATH,\n"
"HP_STORE_AS_DAV,\n"
"HP_DIR_BROWSEABLE,\n"
"HP_DEFAULT,\n"
"HP_SECURITY,\n"
"HP_REALM,\n"
"HP_AUTH_FUNC,\n"
"HP_POSTPROCESS_FUNC,\n"
"HP_RUN_VSP_AS,\n"
"HP_RUN_SOAP_AS,\n"
"HP_PERSIST_SES_VARS,\n"
"HP_SOAP_OPTIONS,\n"
"HP_AUTH_OPTIONS,\n"
"HP_OPTIONS,\n"
"HP_IS_DEFAULT_HOST\n"
"from\n"
"DB.DBA.HTTP_PATH\n"
"where HP_HOST = vhost and HP_LISTEN_HOST = lhost and HP_LPATH = lpath\n"
"do\n"
"{\n"
"http (\'DB.DBA.VHOST_REMOVE (\\n\', ses);\n"
"http (concat (\'\\t lhost=>\', SYS_SQL_VAL_PRINT (lhost), \',\\n\'), ses);\n"
"http (concat (\'\\t vhost=>\', SYS_SQL_VAL_PRINT (vhost), \',\\n\'), ses);\n"
"http (concat (\'\\t lpath=>\', SYS_SQL_VAL_PRINT (lpath), \'\\n\'), ses);\n"
"http (\');\\n\\n\', ses);\n"
"http (\'DB.DBA.VHOST_DEFINE (\\n\', ses);\n"
"http (concat (\'\\t lhost=>\', SYS_SQL_VAL_PRINT (lhost), \',\\n\'), ses);\n"
"http (concat (\'\\t vhost=>\', SYS_SQL_VAL_PRINT (vhost), \',\\n\'), ses);\n"
"http (concat (\'\\t lpath=>\', SYS_SQL_VAL_PRINT (lpath), \',\\n\'), ses);\n"
"http (concat (\'\\t ppath=>\', SYS_SQL_VAL_PRINT (HP_PPATH), \',\\n\'), ses);\n"
"http (concat (\'\\t is_dav=>\', SYS_SQL_VAL_PRINT (HP_STORE_AS_DAV), \',\\n\'), ses);\n"
"if (HP_DEFAULT is not null)\n"
"http (concat (\'\\t def_page=>\', SYS_SQL_VAL_PRINT (HP_DEFAULT), \',\\n\'), ses);\n"
"if (HP_SECURITY is not null)\n"
"http (concat (\'\\t sec=>\', SYS_SQL_VAL_PRINT (HP_SECURITY), \',\\n\'), ses);\n"
"if (HP_REALM is not null)\n"
"http (concat (\'\\t realm=>\', SYS_SQL_VAL_PRINT (HP_REALM), \',\\n\'), ses);\n"
"if (HP_AUTH_FUNC is not null)\n"
"http (concat (\'\\t auth_fn=>\', SYS_SQL_VAL_PRINT (HP_AUTH_FUNC), \',\\n\'), ses);\n"
"if (HP_POSTPROCESS_FUNC is not null)\n"
"http (concat (\'\\t ppr_fn=>\', SYS_SQL_VAL_PRINT (HP_POSTPROCESS_FUNC), \',\\n\'), ses);\n"
"if (HP_RUN_VSP_AS is not null)\n"
"http (concat (\'\\t vsp_user=>\', SYS_SQL_VAL_PRINT (HP_RUN_VSP_AS), \',\\n\'), ses);\n"
"if (HP_RUN_SOAP_AS is not null)\n"
"http (concat (\'\\t soap_user=>\', SYS_SQL_VAL_PRINT (HP_RUN_SOAP_AS), \',\\n\'), ses);\n"
"http (concat (\'\\t ses_vars=>\', SYS_SQL_VAL_PRINT (HP_PERSIST_SES_VARS), \',\\n\'), ses);\n"
"if (HP_SOAP_OPTIONS is not null and deserialize (HP_SOAP_OPTIONS) is not null)\n"
"http (concat (\'\\t soap_opts=>\', SYS_SQL_VAL_PRINT (deserialize (HP_SOAP_OPTIONS)), \',\\n\'), ses);\n"
"if (HP_AUTH_OPTIONS is not null and deserialize (HP_AUTH_OPTIONS) is not null)\n"
"http (concat (\'\\t auth_opts=>\', SYS_SQL_VAL_PRINT (deserialize (HP_AUTH_OPTIONS)), \',\\n\'), ses);\n"
"if (HP_OPTIONS is not null and deserialize (HP_OPTIONS) is not null)\n"
"http (concat (\'\\t opts=>\', SYS_SQL_VAL_PRINT (deserialize (HP_OPTIONS)), \',\\n\'), ses);\n"
"http (concat (\'\\t is_default_host=>\', SYS_SQL_VAL_PRINT (HP_IS_DEFAULT_HOST), \'\\n\'), ses);\n"
"http (\');\\n\\n\', ses);\n"
"}\n"
"return string_output_string (ses);\n"
"}\n"
"--src virtual_dir.sql:1199\n";

static const char *proc42 = 
"create procedure DB.DBA.HTTP_RDF_GET_ACCEPT_BY_Q (in accept varchar)\n"
"{\n"
"declare format, itm varchar;\n"
"declare arr any;\n"
"declare i, l int;\n"
"declare best_q, q double precision;\n"
"\n"
"arr := split_and_decode (accept, 0, \'\\0\\0,;\');\n"
"best_q := 0;\n"
"l := length (arr);\n"
"format := null;\n"
"for (i := 0; i < l; i := i + 2)\n"
"{\n"
"declare tmp any;\n"
"itm := trim(arr[i]);\n"
"q := arr[i+1];\n"
"if (q is null)\n"
"q := 1.0;\n"
"else\n"
"{\n"
"tmp := split_and_decode (q, 0, \'\\0\\0=\');\n"
"if (length (tmp) = 2)\n"
"q := atof (tmp[1]);\n"
"else\n"
"q := 1.0;\n"
"}\n"
"if (best_q < q)\n"
"{\n"
"best_q := q;\n"
"format := itm;\n"
"}\n"
"}\n"
"return format;\n"
"}\n"
"--src virtual_dir.sql:1265\n";

static const char *proc43 = 
"create procedure DB.DBA.HTTP_RDF_ACCEPT (in path varchar, in virtual_dir varchar, in lines any, in graph_mode int)\n"
"{\n"
"declare host, stat, msg, qry, data, meta, accept, format, graph, url, ssl varchar;\n"
"declare ses any;\n"
"\n"
"ses := 0;\n"
"host := http_request_header(lines, \'Host\', null, \'\');\n"
"accept := http_request_header_full (lines, \'Accept\', \'*/*\');\n"
"qry := http_request_get (\'QUERY_STRING\');\n"
"ssl := \'\';\n"
"if (is_https_ctx ())\n"
"ssl := \'s\';\n"
"if (length (qry))\n"
"path := path || \'?\' || qry;\n"
"\n"
"format := HTTP_RDF_GET_ACCEPT_BY_Q (accept);\n"
"\n"
"if (format is null)\n"
"accept := http_request_header (lines, \'Accept\', null, null);\n"
"\n"
"\n"
"set_user_id (\'SPARQL\');\n"
"stat := \'00000\';\n"
"graph := sprintf (\'FROM <http%s://%s%s>\', ssl, host, virtual_dir);\n"
"if (graph_mode = 2)\n"
"graph := \'\';\n"
"url := sprintf (\'http%s://%s%s\', ssl, host, path);\n"
"if (strchr (url, \'#\') is null)\n"
"qry := sprintf (\'SPARQL DESCRIBE <%s> <%s#this> %s\', url, url, graph);\n"
"else\n"
"qry := sprintf (\'SPARQL DESCRIBE <%s> %s\', url, graph);\n"
"exec (qry, stat, msg, vector (), 0, meta, data);\n"
"if (stat = \'00000\')\n"
"{\n"
"if (length (data) = 1 and length (dict_list_keys (data[0][0], 0)) > 0)\n"
"{\n"
"http_status_set (200);\n"
"http_rewrite ();\n"
"DB.DBA.SPARQL_RESULTS_WRITE (ses, meta, data, format, 1);\n"
"return 1;\n"
"}\n"
"}\n"
"else\n"
"signal (stat, msg);\n"
"return 0;\n"
"}\n"
"--src virtual_dir.sql:1301\n";

static const char *proc44 = 
"create procedure WS.WS.DIR_INDEX_MAKE_XML (inout _sheet varchar, in curdir varchar := null, in start_from varchar := null)\n"
"{\n"
"declare dirarr, filearr, fsize, xte_path, xte_list, xte_entry any;\n"
"declare dirname, root, modt varchar;\n"
"declare ix, len, flen, rflen, mult integer;\n"
"fsize := vector (\'b\',\'K\',\'M\',\'G\',\'T\');\n"
"if (curdir is null)\n"
"curdir := concat (http_root (), http_physical_path ());\n"
"if (start_from is null)\n"
"start_from := http_path ();\n"
"root := http_root ();\n"
"dirarr := sys_dirlist (curdir, 0, null, 1);\n"
"filearr := sys_dirlist (curdir, 1, null, 1);\n"
"if (curdir <> \'\\\\\' and aref (curdir, length (curdir) - 1) <> ascii (\'/\'))\n"
"curdir := concat (curdir, \'/\');\n"
"if (start_from <> \'/\' and aref (start_from, length (start_from) - 1) <> ascii (\'/\'))\n"
"start_from := concat (start_from, \'/\');\n"
"xte_nodebld_init (xte_path);\n"
"xte_nodebld_acc (xte_path, xte_node (xte_head (\'PATH\', \'dir_name\', start_from)));\n"
"if (aref (root, length (root) - 1) <> ascii (\'/\'))\n"
"root := concat (root, \'/\');\n"
"if (aref (curdir, length (curdir) - 1) <> ascii (\'/\'))\n"
"curdir := concat (curdir, \'/\');\n"
"len := length (dirarr);\n"
"ix := 0;\n"
"xte_nodebld_init (xte_list);\n"
"while (ix < len)\n"
"{\n"
"declare fst varchar;\n"
"dirname := aref (dirarr, ix);\n"
"fst := file_stat (concat (curdir, dirname));\n"
"if (isstring (fst))\n"
"modt := stringdate (fst);\n"
"else\n"
"modt := now();\n"
"if (dirname <> \'.\')\n"
"xte_nodebld_acc (xte_list, xte_node (xte_head (\'SUBDIR\', \'name\', dirname,\n"
"\'modify\', soap_print_box (modt, \'\', 2) ) ) );\n"
"ix := ix + 1;\n"
"}\n"
"xte_nodebld_final (xte_list, xte_head (\'DIRS\'));\n"
"xte_nodebld_acc (xte_path, xte_list);\n"
"xte_nodebld_init (xte_list);\n"
"len := length (filearr);\n"
"ix := 0;\n"
"while (ix < len)\n"
"{\n"
"dirname := aref (filearr, ix);\n"
"modt := stringdate (file_stat (concat (curdir, dirname)));\n"
"rflen := 0;\n"
"rflen := file_stat (concat (curdir, dirname), 1);\n"
"flen := atoi (rflen);\n"
"mult := 0;\n"
"if (lower (dirname) = \'folder.xsl\')\n"
"_sheet := concat (curdir, dirname);\n"
"while ((flen / 1000) > 1)\n"
"{\n"
"mult := mult + 1;\n"
"flen := flen / 1000;\n"
"}\n"
"xte_nodebld_acc (xte_list, xte_node (xte_head (\'FILE\', \'name\', dirname,\n"
"\'modify\', soap_print_box (modt, \'\', 2), \'rs\', rflen,\n"
"\'hs\', sprintf (\'%d %s\', flen, aref (fsize, mult)) ) ) );\n"
"ix := ix + 1;\n"
"}\n"
"xte_nodebld_final (xte_list, xte_head (\'FILES\'));\n"
"xte_nodebld_acc (xte_path, xte_list);\n"
"xte_nodebld_final (xte_path, xte_head (\'PATH\'));\n"
"return xml_tree_doc (xte_path);\n"
"}\n"
"--src virtual_dir.sql:1349\n";

static const char *other199 = 
"xslt_sheet (\'http://local.virt/dir_output\', xml_tree_doc (\'\n"
"<xsl:stylesheet xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\" version=\"1.0\">\n"
"<xsl:output method=\"text\" encoding=\"UTF-8\" />\n"
"\n"
"<xsl:template match=\"PATH\">\n"
"<xsl:variable name=\"path\"><xsl:value-of select=\"@dir_name\"/></xsl:variable>\n"
"&lt;!DOCTYPE HTML PUBLIC \"-//IETF//DTD HTML 2.0//EN\"&gt;\n"
"&lt;HTML&gt;\n"
"&lt;TITLE&gt;Directory listing of <xsl:value-of select=\"\\044path\"/>&lt;/TITLE&gt;\n"
"&lt;BODY bgcolor=\"#FFFFFF\" fgcolor=\"#000000\"&gt;\n"
"&lt;H4&gt;Index of <xsl:value-of select=\"\\044path\"/>&lt;/H4&gt;\n"
"&lt;TABLE&gt;\n"
"&lt;tr&gt;&lt;td colspan=2 align=\"center\"&gt;Name&lt;/td&gt;\n"
"&lt;td align=\"center\"&gt;Last modified&lt;/td&gt;&lt;td align=\"center\"&gt;Size&lt;/td&gt;&lt;/tr&gt;\n"
"&lt;tr&gt;&lt;td colspan=5&gt;&lt;HR /&gt;&lt;/td&gt;&lt;/tr&gt;\n"
"\n"
"<xsl:apply-templates select=\"DIRS\">\n"
"<xsl:with-param name=\"f_path\" select=\"\\044path\"/>\n"
"</xsl:apply-templates>\n"
"\n"
"<xsl:apply-templates select=\"FILES\">\n"
"<xsl:with-param name=\"f_path\" select=\"\\044path\"/>\n"
"</xsl:apply-templates>\n"
"\n"
"&lt;tr&gt;&lt;td colspan=5&gt;&lt;HR /&gt;&lt;/td&gt;&lt;/tr&gt;\n"
"&lt;/TABLE&gt;\n"
"&lt;/BODY&gt;\n"
"&lt;/HTML&gt;\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"SUBDIR\">\n"
"<xsl:param name=\"f_path\" />\n"
"&lt;tr&gt;\n"
"&lt;td&gt;&lt;img src=\"/conductor/images/dav_browser/foldr_16.png\" alt=\"folder\"&gt;&lt;/td&gt;\n"
"&lt;td&gt;&lt;a href=\"<xsl:value-of select=\"\\044f_path\"/><xsl:value-of select=\"@name\"/>/\"&gt;<xsl:value-of select=\"@name\"/>&lt;/a&gt;&lt;/td&gt;\n"
"&lt;td&gt;<xsl:value-of select=\"@modify\"/>&lt;/td&gt;&lt;td align=\"right\"&gt;-&lt;/td&gt;\n"
"&lt;/tr&gt;\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"FILE\">\n"
"<xsl:param name=\"f_path\" />\n"
"&lt;tr&gt;\n"
"&lt;td&gt;&lt;img src=\"/conductor/images/dav_browser/file_gen_16.png\" alt=\"file\"&gt;&lt;/td&gt;\n"
"&lt;td&gt;&lt;a href=\"<xsl:value-of select=\"\\044f_path\"/><xsl:value-of select=\"@name\"/>\"&gt;<xsl:value-of select=\"@name\"/>&lt;/a&gt;&lt;/td&gt;\n"
"&lt;td&gt;<xsl:value-of select=\"@modify\"/>&lt;/td&gt;&lt;td align=\"right\"&gt;<xsl:value-of select=\"@hs\"/>&lt;/td&gt;\n"
"&lt;/tr&gt;\n"
"</xsl:template>\n"
"\n"
"</xsl:stylesheet>\'))\n";
static const char *proc45 = 
"create procedure WS.WS.DIR_INDEX_XML (in path any, in params any, in lines any)\n"
"{\n"
"declare _html, _xml, _sheet varchar;\n"
"declare _b_opt any;\n"
"declare ssheet_name, ssheet_text varchar;\n"
"\n"
"_b_opt := NULL;\n"
"\n"
"if (exists (select 1 from HTTP_PATH\n"
"where HP_LPATH = http_map_get (\'domain\') and HP_PPATH = http_map_get (\'mounted\')))\n"
"select deserialize(HP_OPTIONS) into _b_opt from HTTP_PATH\n"
"where HP_LPATH = http_map_get (\'domain\') and HP_PPATH = http_map_get (\'mounted\');\n"
"\n"
"_sheet := \'\';\n"
"_xml := WS.WS.DIR_INDEX_MAKE_XML (_sheet);\n"
"\n"
"if (_b_opt is not NULL)\n"
"_b_opt := get_keyword (\'browse_sheet\', _b_opt, \'\');\n"
"\n"
"if (_sheet <> \'\')\n"
"{\n"
"ssheet_name := \'http://local.virt/custom_dir_output/\' || _sheet;\n"
"ssheet_text := file_to_string (_sheet);\n"
"}\n"
"else if (_b_opt <> \'\')\n"
"{\n"
"_b_opt := concat (http_root(), \'/\', _b_opt);\n"
"ssheet_name := \'http://local.virt/custom_dir_output/\' ||  _b_opt;\n"
"ssheet_text := file_to_string (_b_opt);\n"
"}\n"
"if (isstring (ssheet_name))\n"
"xslt_sheet (ssheet_name, xtree_doc (ssheet_text));\n"
"else\n"
"ssheet_name := \'http://local.virt/dir_output\';\n"
"return http_value (xslt (ssheet_name, _xml));\n"
"}\n"
"--src virtual_dir.sql:1474\n";

static const char *proc46 = 
"create procedure DB.DBA.SERVICES_WSIL (in path any, in params any, in lines any)\n"
"{\n"
"declare host, intf, requrl, proto, rhost varchar;\n"
"declare arr any;\n"
"host := http_map_get (\'vhost\');\n"
"intf := http_map_get (\'lhost\');\n"
"requrl := http_requested_url ();\n"
"arr := rfc1808_parse_uri (requrl);\n"
"proto := arr[0];\n"
"rhost := arr[1];\n"
"\n"
"if (host = server_http_port () and intf = server_http_port ())\n"
"{\n"
"host := \'*ini*\';\n"
"intf := \'*ini*\';\n"
"}\n"
"\n"
"http_header (\'Content-Type: text/xml\\r\\n\');\n"
"http(\'<?xml version=\"1.0\" ?>\');\n"
"http(\'<inspection xmlns=\"http://schemas.xmlsoap.org/ws/2001/10/inspection\">\');\n"
"for select HP_LPATH, deserialize (HP_SOAP_OPTIONS) as opts from DB.DBA.HTTP_PATH where HP_HOST = host and HP_LISTEN_HOST = intf and HP_PPATH = \'/SOAP/\' do\n"
"{\n"
"declare nam any;\n"
"nam := trim (HP_LPATH, \'/ \');\n"
"if (isarray (opts))\n"
"nam := get_keyword (\'ServiceName\', opts, nam);\n"
"http (\'<service>\');\n"
"http (sprintf (\'<name>%V</name>\', nam));\n"
"http (sprintf (\'<description referencedNamespace=\"http://schemas.xmlsoap.org/wsdl/\" location=\"%s://%s%s/services.wsdl\"/>\', proto, rhost, HP_LPATH));\n"
"http (\'</service>\');\n"
"}\n"
"http(\'</inspection>\');\n"
"}\n"
"--src virtual_dir.sql:1512\n";

/* url_rewrite.sql */

static const char *tbl32 = 
"create table DB.DBA.URL_REWRITE_RULE_LIST (\n"
"URRL_LIST     varchar not null,\n"
"URRL_INX      integer not null,\n"
"URRL_MEMBER   varchar not null,\n"
"primary key (URRL_LIST, URRL_INX) )\n";

static const char *tbl33 = 
"create table DB.DBA.URL_REWRITE_RULE (\n"
"URR_RULE      varchar not null,\n"
"URR_RULE_TYPE integer not null,\n"
"URR_NICE_FORMAT       varchar,\n"
"URR_NICE_PARAMS       any,\n"
"URR_NICE_MIN_PARAMS   integer,\n"
"URR_TARGET_FORMAT     varchar,\n"
"URR_TARGET_PARAMS     any,\n"
"URR_TARGET_EXPR       varchar,\n"
"URR_ACCEPT_PATTERN	varchar,\n"
"URR_NO_CONTINUATION	int,\n"
"URR_HTTP_REDIRECT	int,\n"
"URR_HTTP_HEADERS	varchar,\n"
"primary key (URR_RULE) )\n";

static const char *tbl34 = 
"create table DB.DBA.HTTP_VARIANT_MAP (\n"
"VM_ID		integer identity,\n"
"VM_RULELIST		varchar,\n"
"VM_URI		varchar,\n"
"VM_VARIANT_URI	varchar,\n"
"VM_QS		float,\n"
"VM_TYPE		varchar,\n"
"VM_LANG		varchar,\n"
"VM_ENC		varchar,\n"
"VM_DESCRIPTION	long varchar,\n"
"VM_ALGO		int default 0,\n"
"VM_CONTENT_LOCATION_HOOK	varchar,\n"
"primary key (VM_RULELIST, VM_URI, VM_VARIANT_URI))\n"
"create unique index HTTP_VARIANT_MAP_ID on DB.DBA.HTTP_VARIANT_MAP (VM_ID)\n";

static const char *proc47 = 
"create procedure DB.DBA.URLREWRITE_CREATE_RULE (\n"
"in rule_type int,\n"
"in rule_iri varchar,\n"
"in allow_update integer,\n"
"in nice_format varchar,\n"
"in nice_params any,\n"
"in nice_min_params integer,\n"
"in target_format varchar,\n"
"in target_params any,\n"
"in target_expn varchar := NULL,\n"
"in accept_pattern varchar := null,\n"
"in dont_continue int := 0,\n"
"in http_redirect int := null,\n"
"in http_headers varchar := null)\n"
"{\n"
"if (exists (select 1 from DB.DBA.URL_REWRITE_RULE_LIST where URRL_LIST = rule_iri))\n"
"signal (\'42000\', \'Rule IRI \' || rule_iri || \' is already in use as rule list IRI\');\n"
"if (exists (select 1 from DB.DBA.URL_REWRITE_RULE where URR_RULE = rule_iri))\n"
"{\n"
"if (not allow_update)\n"
"signal (\'42000\', \'Rule IRI \' || rule_iri || \' is already in use as rule IRI\');\n"
"}\n"
"if (rule_type = 1)\n"
"{\n"
"declare exit handler for sqlstate \'*\'\n"
"{\n"
"signal (__SQL_STATE, \'The URL matching pattern is an invalid REGEX.\');\n"
"};\n"
"regexp_match (nice_format, \'\');\n"
"}\n"
"if (length (accept_pattern))\n"
"{\n"
"declare exit handler for sqlstate \'*\'\n"
"{\n"
"signal (__SQL_STATE, \'The Accept header patter is an invalid REGEX.\');\n"
"};\n"
"regexp_match (accept_pattern, \'\');\n"
"}\n"
"\n"
"insert replacing DB.DBA.URL_REWRITE_RULE (URR_RULE, URR_RULE_TYPE, URR_NICE_FORMAT, URR_NICE_PARAMS, URR_NICE_MIN_PARAMS, URR_TARGET_FORMAT, URR_TARGET_PARAMS, URR_TARGET_EXPR, URR_ACCEPT_PATTERN, URR_NO_CONTINUATION, URR_HTTP_REDIRECT, URR_HTTP_HEADERS)\n"
"values (rule_iri, rule_type, nice_format, serialize (nice_params), nice_min_params, target_format, serialize (target_params), target_expn, accept_pattern, dont_continue, http_redirect, http_headers);\n"
"}\n"
"--src url_rewrite.sql:86\n";

static const char *proc48 = 
"create procedure DB.DBA.URLREWRITE_CREATE_SPRINTF_RULE (\n"
"in rule_iri varchar,\n"
"in allow_update integer,\n"
"in nice_format varchar,\n"
"in nice_params any,\n"
"in nice_min_params integer,\n"
"in target_format varchar,\n"
"in target_params any,\n"
"in target_expn varchar := NULL,\n"
"in accept_pattern varchar := null,\n"
"in dont_continue int := 0,\n"
"in http_redirect int := null,\n"
"in http_headers varchar := null)\n"
"{\n"
"DB.DBA.URLREWRITE_CREATE_RULE (0, rule_iri, allow_update, nice_format, nice_params, nice_min_params, target_format, target_params, target_expn, accept_pattern, dont_continue, http_redirect, http_headers);\n"
"}\n"
"--src url_rewrite.sql:130\n";

static const char *proc49 = 
"create procedure DB.DBA.URLREWRITE_CREATE_REGEX_RULE (\n"
"in rule_iri varchar,\n"
"in allow_update integer,\n"
"in nice_format varchar,\n"
"in nice_params any,\n"
"in nice_min_params integer,\n"
"in target_format varchar,\n"
"in target_params any,\n"
"in target_expn varchar := NULL,\n"
"in accept_pattern varchar := null,\n"
"in dont_continue int := 0,\n"
"in http_redirect int := null,\n"
"in http_headers varchar := null)\n"
"{\n"
"DB.DBA.URLREWRITE_CREATE_RULE (1, rule_iri, allow_update, nice_format, nice_params, nice_min_params, target_format, target_params, target_expn, accept_pattern, dont_continue, http_redirect, http_headers);\n"
"}\n"
"--src url_rewrite.sql:148\n";

static const char *proc50 = 
"create procedure DB.DBA.URLREWRITE_DROP_RULE (\n"
"in rule_iri varchar,\n"
"in force integer := 0)\n"
"{\n"
"if (exists (select 1 from DB.DBA.URL_REWRITE_RULE_LIST where URRL_LIST = rule_iri))\n"
"signal (\'42000\', \'Rule IRI \' || rule_iri || \' is already in use as rule list IRI\');\n"
"if (not exists (select 1 from DB.DBA.URL_REWRITE_RULE where URR_RULE = rule_iri))\n"
"signal (\'42000\', \'Rule IRI \' || rule_iri || \' is unknown\');\n"
"if (strstr (rule_iri, \'sys:\') = 0)\n"
"signal (\'42000\', \'Rule IRI \' || rule_iri || \' uses forbidden format (started with \"sys:\")\');\n"
"if (exists (select 1 from DB.DBA.URL_REWRITE_RULE_LIST where URRL_MEMBER = rule_iri))\n"
"{\n"
"if (force = 0)\n"
"signal (\'42000\', \'Rule IRI \' || rule_iri || \' is used in some rule list\');\n"
"else\n"
"delete from DB.DBA.URL_REWRITE_RULE_LIST where URRL_MEMBER = rule_iri;\n"
"}\n"
"delete from DB.DBA.URL_REWRITE_RULE where URR_RULE = rule_iri;\n"
"return 1;\n"
"}\n"
"--src url_rewrite.sql:166\n";

static const char *proc51 = 
"create procedure DB.DBA.URLREWRITE_CREATE_RULELIST (\n"
"in rulelist_iri varchar,\n"
"in allow_update integer,\n"
"in vector_of_rule_iris any)\n"
"{\n"
"declare rule_length, cur integer;\n"
"if (exists (select 1 from DB.DBA.URL_REWRITE_RULE where URR_RULE = rulelist_iri))\n"
"signal (\'42000\', \'Rule list IRI \' || rulelist_iri || \' is already in use as rule IRI\');\n"
"rule_length := length (vector_of_rule_iris);\n"
"foreach (varchar itm in vector_of_rule_iris) do\n"
"{\n"
"if (itm = rulelist_iri)\n"
"signal (\'42000\', \'Rule list IRI \' || rulelist_iri || \' is used in its own vector of rule IRIs\');\n"
"}\n"
"if (exists (select 1 from DB.DBA.URL_REWRITE_RULE_LIST where URRL_LIST = rulelist_iri))\n"
"{\n"
"if (allow_update = 0)\n"
"signal (\'42000\', \'Rule list IRI \' || rulelist_iri || \' is already in use as rule list IRI\');\n"
"delete from DB.DBA.URL_REWRITE_RULE_LIST where URRL_LIST = rulelist_iri;\n"
"}\n"
"for (cur := 0; cur < rule_length; cur := cur + 1)\n"
"{\n"
"insert replacing DB.DBA.URL_REWRITE_RULE_LIST (URRL_LIST, URRL_INX, URRL_MEMBER) values (rulelist_iri, cur, vector_of_rule_iris[cur]);\n"
"}\n"
"}\n"
"--src url_rewrite.sql:188\n";

static const char *proc52 = 
"create procedure DB.DBA.URLREWRITE_DROP_RULELIST (\n"
"in rulelist_iri varchar,\n"
"in force integer := 0)\n"
"{\n"
"if (exists (select 1 from DB.DBA.URL_REWRITE_RULE where URR_RULE = rulelist_iri))\n"
"signal (\'42000\', \'Rule list IRI \' || rulelist_iri || \' is already in use as rule IRI\');\n"
"if (not exists (select 1 from DB.DBA.URL_REWRITE_RULE_LIST where URRL_LIST = rulelist_iri))\n"
"signal (\'42000\', \'Rule list IRI \' || rulelist_iri || \' is unknown\');\n"
"if (strstr (rulelist_iri, \'sys:\') = 0)\n"
"signal (\'42000\', \'Can not drop \"sys:...\" rule list \' || rulelist_iri);\n"
"if (exists (select top 1 1 from DB.DBA.HTTP_PATH where HP_OPTIONS is not null and deserialize (HP_OPTIONS) is not null and get_keyword (\'url_rewrite\', deserialize (HP_OPTIONS), 0) = rulelist_iri))\n"
"{\n"
"if (not force)\n"
"signal (\'42000\', \'Rule list IRI \' || rulelist_iri || \' is in use as opts in some HTTP virtual host\');\n"
"for select HP_HOST, HP_LISTEN_HOST, HP_LPATH, HP_PPATH, HP_STORE_AS_DAV, HP_DIR_BROWSEABLE, HP_DEFAULT, HP_SECURITY, HP_REALM,\n"
"HP_AUTH_FUNC, HP_POSTPROCESS_FUNC, HP_RUN_VSP_AS, HP_RUN_SOAP_AS, HP_PERSIST_SES_VARS, HP_SOAP_OPTIONS, HP_AUTH_OPTIONS, HP_OPTIONS, HP_IS_DEFAULT_HOST\n"
"from DB.DBA.HTTP_PATH where HP_OPTIONS is not null do\n"
"{\n"
"declare opts, new_opts any;\n"
"declare i, opts_len integer;\n"
"declare st, msg varchar;\n"
"msg := \'\';\n"
"opts := deserialize (HP_OPTIONS);\n"
"if (isarray (opts) and get_keyword (\'url_rewrite\', opts, 0) = rulelist_iri)\n"
"{\n"
"opts_len := length (opts);\n"
"new_opts := vector ();\n"
"for (i := 0; i < opts_len; i := i + 2)\n"
"{\n"
"if ((opts[i] <> \'url_rewrite\') or (opts[i+1] <> rulelist_iri))\n"
"new_opts := vector_concat (new_opts, vector (opts[i], opts[i+1]));\n"
"}\n"
"VHOST_REMOVE (HP_HOST, HP_LISTEN_HOST, HP_LPATH, 0);\n"
"exec (\'VHOST_DEFINE (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)\', st, msg,\n"
"vector (HP_HOST, HP_LISTEN_HOST, HP_LPATH, HP_PPATH, HP_STORE_AS_DAV, HP_DIR_BROWSEABLE,\n"
"HP_DEFAULT, HP_AUTH_FUNC, HP_REALM, HP_POSTPROCESS_FUNC, HP_RUN_VSP_AS,\n"
"HP_RUN_SOAP_AS, HP_SECURITY, HP_PERSIST_SES_VARS,\n"
"deserialize (HP_SOAP_OPTIONS),\n"
"deserialize (HP_AUTH_OPTIONS), new_opts, HP_IS_DEFAULT_HOST));\n"
"}\n"
"}\n"
"}\n"
"if (exists (select 1 from DB.DBA.URL_REWRITE_RULE_LIST where URRL_MEMBER = rulelist_iri))\n"
"{\n"
"if (not force)\n"
"signal (\'42000\', \'Rule list IRI \' || rulelist_iri || \' is in use as rule IRI in rules lists\');\n"
"}\n"
"delete from DB.DBA.URL_REWRITE_RULE_LIST where URRL_LIST = rulelist_iri;\n"
"}\n"
"--src url_rewrite.sql:215\n";

static const char *proc53 = 
"create function DB.DBA.URLREWRITE_ENUMERATE_RULES (\n"
"in like_pattern_for_rule_iris varchar,\n"
"in dump_details integer := 0)\n"
"returns any\n"
"{\n"
"declare iri_list, rule_list any;\n"
"iri_list := vector ();\n"
"if (not dump_details)\n"
"return (select DB.DBA.VECTOR_AGG (URR_RULE) from DB.DBA.URL_REWRITE_RULE where URR_RULE like like_pattern_for_rule_iris);\n"
"for select URR_RULE, URR_RULE_TYPE, URR_NICE_FORMAT, URR_NICE_PARAMS, URR_NICE_MIN_PARAMS, URR_TARGET_FORMAT, URR_TARGET_PARAMS, URR_TARGET_EXPR from DB.DBA.URL_REWRITE_RULE where URR_RULE like like_pattern_for_rule_iris do\n"
"{\n"
"rule_list := ( select DB.DBA.VECTOR_AGG (d.URRL_LIST)\n"
"from (select distinct a.URRL_LIST from DB.DBA.URL_REWRITE_RULE_LIST as a where a.URRL_MEMBER = URR_RULE) as d );\n"
"iri_list := vector_concat (iri_list, vector (URR_RULE, vector (URR_RULE_TYPE, URR_NICE_FORMAT, deserialize(URR_NICE_PARAMS), URR_NICE_MIN_PARAMS, URR_TARGET_FORMAT, URR_TARGET_PARAMS, URR_TARGET_EXPR), rule_list));\n"
"}\n"
"return iri_list;\n"
"}\n"
"--src url_rewrite.sql:266\n";

static const char *proc54 = 
"create function DB.DBA.URLREWRITE_ENUMERATE_RULELISTS (\n"
"in like_pattern_for_rulelist_iris varchar,\n"
"in dump_details integer := 0)\n"
"returns any\n"
"{\n"
"declare iri_list, rule_list, http_vec any;\n"
"iri_list := vector ();\n"
"if (not dump_details)\n"
"return (select DB.DBA.VECTOR_AGG (d.URRL_LIST) from\n"
"(select distinct a.URRL_LIST from DB.DBA.URL_REWRITE_RULE_LIST as a where URRL_LIST like like_pattern_for_rulelist_iris) as d);\n"
"for select distinct URRL_LIST as cur_iri from DB.DBA.URL_REWRITE_RULE_LIST where URRL_LIST like like_pattern_for_rulelist_iris do\n"
"{\n"
"rule_list := (select DB.DBA.VECTOR_AGG (URRL_MEMBER) from DB.DBA.URL_REWRITE_RULE_LIST where URRL_LIST = cur_iri order by URRL_INX asc);\n"
"http_vec := (select DB.DBA.VECTOR_AGG (vector (HP_LISTEN_HOST, HP_HOST, HP_LPATH)) from DB.DBA.HTTP_PATH where HP_OPTIONS is not null and get_keyword (\'url_rewrite\', deserialize (HP_OPTIONS), 0) = cur_iri);\n"
"iri_list := vector_concat (iri_list, vector (cur_iri, rule_list, http_vec));\n"
"}\n"
"return iri_list;\n"
"}\n"
"--src url_rewrite.sql:285\n";

static const char *proc55 = 
"create function DB.DBA.URLREWRITE_VPRINTF (\n"
"in format varchar,\n"
"in params any,\n"
"out number_of_values int)\n"
"returns varchar\n"
"{\n"
"declare long_path, cur varchar;\n"
"declare i, j, tar_len integer;\n"
"declare pos1, pos2, pos3 integer;\n"
"long_path := \'\';\n"
"i := 0;\n"
"tar_len := length (format);\n"
"pos2 := 1;\n"
"while (pos2 < tar_len and i < length (params) and pos2 > 0)\n"
"{\n"
"pos1 := locate (\'%\', format, pos2) - 1;\n"
"if (pos1 = 0 and pos2 = 1)\n"
"return \'\';\n"
"pos3 := locate (\'%\', format, pos1 + 2) - 1;\n"
"if (pos3 = 0 or pos3 < 0)\n"
"cur := subseq (format, pos1);\n"
"else\n"
"cur := subseq (format, pos1, pos3);\n"
"pos2 := pos3;\n"
"j := 0;\n"
"\n"
"long_path := concat (long_path, sprintf (cur, coalesce( params[i+1], 0)));\n"
"\n"
"if (pos3 > 0)\n"
"i := i + 2;\n"
"}\n"
"number_of_values := i;\n"
"\n"
"return long_path;\n"
"}\n"
"--src url_rewrite.sql:305\n";

static const char *proc56 = 
"create function DB.DBA.URLREWRITE_SPRINTF_RESULTS (\n"
"in nice_params any,\n"
"in nice_parts any,\n"
"in target_params any,\n"
"in target_format varchar,\n"
"in target_exp varchar,\n"
"in accept_val varchar,\n"
"inout lines any)\n"
"returns varchar\n"
"{\n"
"declare long_path, cur, tmp, val varchar;\n"
"declare i, j, tar_len integer;\n"
"declare pos1, pos2, pos3 integer;\n"
"declare host varchar;\n"
"\n"
"host := registry_get (\'URIQADefaultHost\');\n"
"long_path := \'\';\n"
"i := 0;\n"
"\n"
"target_format := replace (target_format, \'%%\', \'<PERCENT>\');\n"
"tar_len := length (target_format);\n"
"pos2 := 1;\n"
"if (locate (\'%\', target_format, pos2) = 0)\n"
"{\n"
"long_path := target_format;\n"
"goto end_scan;\n"
"}\n"
"\n"
"while (pos2 < tar_len and i < length (target_params) and pos2 > 0)\n"
"{\n"
"pos1 := locate (\'%\', target_format, pos2) - 1;\n"
"\n"
"if (pos1 < 0)\n"
"return \'\';\n"
"pos3 := locate (\'%\', target_format, pos1 + 2) - 1;\n"
"\n"
"if (i = 0)\n"
"long_path := left(target_format, pos1);\n"
"\n"
"\n"
"if (pos3 < pos1 or pos3 < 0)\n"
"cur := subseq (target_format, pos1);\n"
"else\n"
"{\n"
"cur := subseq (target_format, pos1, pos3);\n"
"\n"
"}\n"
"pos2 := pos3;\n"
"\n"
"j := 0;\n"
"while (j < length (nice_params) and nice_params[j] <> target_params[i])\n"
"{\n"
"j := j + 1;\n"
"}\n"
"if (position (target_params[i], nice_params))\n"
"{\n"
"if (j < length (nice_parts))\n"
"val := nice_parts[j];\n"
"else\n"
"val := \'\';\n"
"}\n"
"else if (target_params[i] = \'*accept*\')\n"
"val := accept_val;\n"
"else if (target_params[i] like \'^*%^*\' escape \'^\')\n"
"{\n"
"declare hn varchar;\n"
"hn := lower (trim (target_params[i], \'*\'));\n"
"val := http_request_header (lines, hn, null, \'\');\n"
"}\n"
"else\n"
"val := \'\';\n"
"\n"
"if (target_exp is null)\n"
"tmp := sprintf (cur, coalesce (val, \'\'));\n"
"else\n"
"tmp := call (target_exp) (target_params[i], cur, val);\n"
"long_path := concat (long_path, tmp);\n"
"\n"
"i := i + 1;\n"
"}\n"
"end_scan:\n"
"\n"
"long_path := replace (long_path, \'<PERCENT>\', \'%\');\n"
"if (isstring (host))\n"
"{\n"
"long_path := replace (long_path, \'^{URIQADefaultHost}^\', host);\n"
"if (strstr (long_path, \'^{DynamicLocalFormat}^\') is not null)\n"
"{\n"
"if (strchr (host, \':\') is not null)\n"
"long_path := replace (long_path, \'^{DynamicLocalFormat}^\', sprintf (\'http://%{WSHostName}U:%{WSHostPort}U\'));\n"
"else\n"
"long_path := replace (long_path, \'^{DynamicLocalFormat}^\', sprintf (\'http://%{WSHost}U\'));\n"
"}\n"
"}\n"
"return long_path;\n"
"}\n"
"--src url_rewrite.sql:342\n";

static const char *proc57 = 
"create procedure DB.DBA.URLREWRITE_APPLY_RECURSIVE (\n"
"in rulelist_iri varchar,\n"
"in nice_host varchar,\n"
"in nice_lhost varchar,\n"
"in nice_lpath varchar,\n"
"in nice_get_params varchar,\n"
"in nice_frag varchar,\n"
"in post_params any,\n"
"in accept_header varchar,\n"
"out long_url varchar,\n"
"out params any,\n"
"out rule_iri varchar,\n"
"out target_vhost_pkey any,\n"
"out http_redir int,\n"
"out http_headers varchar,\n"
"inout lines any)\n"
"returns integer\n"
"{\n"
"\n"
"for select distinct URRL_MEMBER as cur_iri from DB.DBA.URL_REWRITE_RULE_LIST where URRL_LIST = rulelist_iri order by URRL_INX asc do\n"
"{\n"
"if (exists (select 1 from DB.DBA.URL_REWRITE_RULE_LIST where URRL_LIST = cur_iri))\n"
"{\n"
"if (DB.DBA.URLREWRITE_APPLY_RECURSIVE (cur_iri, nice_host,\n"
"nice_lhost, nice_lpath, nice_get_params, nice_frag, post_params, accept_header, long_url, params,\n"
"rule_iri, target_vhost_pkey, http_redir, http_headers, lines) = 1)\n"
"return 1;\n"
"}\n"
"else\n"
"{\n"
"\n"
"for select URR_RULE_TYPE, URR_NICE_FORMAT, URR_NICE_PARAMS, URR_NICE_MIN_PARAMS, URR_TARGET_FORMAT, URR_TARGET_PARAMS,\n"
"URR_TARGET_EXPR, URR_ACCEPT_PATTERN, URR_NO_CONTINUATION, URR_HTTP_REDIRECT, URR_HTTP_HEADERS\n"
"from DB.DBA.URL_REWRITE_RULE where URR_RULE = cur_iri do\n"
"{\n"
"\n"
"declare parts, nice_params any;\n"
"declare _result, accept_val varchar;\n"
"\n"
"if (registry_get (\'__debug_url_rewrite\') = \'2\')\n"
"dbg_printf (\'trying rule=[%s] URL=[%s]\', URR_NICE_FORMAT, nice_lpath);\n"
"if (length (URR_ACCEPT_PATTERN) and not length (accept_header))\n"
"goto next_rule;\n"
"accept_val := null;\n"
"if (length (URR_ACCEPT_PATTERN) and length (accept_header))\n"
"{\n"
"accept_val := regexp_match (URR_ACCEPT_PATTERN, accept_header);\n"
"if (accept_val is null)\n"
"goto next_rule;\n"
"}\n"
"\n"
"if (URR_RULE_TYPE = 0)\n"
"{\n"
"\n"
"parts := sprintf_inverse (nice_lpath, URR_NICE_FORMAT, 2);\n"
"\n"
"if ((length (parts) < URR_NICE_MIN_PARAMS) or (length (parts) >= URR_NICE_MIN_PARAMS and parts[URR_NICE_MIN_PARAMS - 1] is NULL))\n"
"{\n"
"if (URR_NO_CONTINUATION = 2 or URR_NO_CONTINUATION = 1)\n"
"goto next_rule;\n"
"return 0;\n"
"}\n"
"\n"
"}\n"
"else if (URR_RULE_TYPE = 1)\n"
"{\n"
"\n"
"_result := regexp_parse (URR_NICE_FORMAT, nice_lpath, 0);\n"
"\n"
"\n"
"if (_result is null)\n"
"{\n"
"if (URR_NO_CONTINUATION = 2 or URR_NO_CONTINUATION = 1)\n"
"goto next_rule;\n"
"return 0;\n"
"}\n"
"else\n"
"{\n"
"\n"
"declare parse_len, k, start_index int;\n"
"start_index := 0;\n"
"parts := vector ();\n"
"parse_len := length (_result);\n"
"if (parse_len > 2)\n"
"start_index := 2;\n"
"for (k := start_index; k < parse_len; k := k + 2)\n"
"{\n"
"\n"
"if (_result[k] < 0 or _result[k + 1] < 0)\n"
"parts := vector_concat (parts, vector (null));\n"
"else\n"
"parts := vector_concat (parts, vector (subseq (nice_lpath, _result[k], _result[k + 1])));\n"
"}\n"
"}\n"
"}\n"
"\n"
"declare get_len integer;\n"
"nice_params := split_and_decode (nice_get_params);\n"
"get_len := length (nice_params);\n"
"\n"
"if (nice_params is null or get_len = 0)\n"
"params := post_params;\n"
"else\n"
"params := vector_concat (post_params, nice_params);\n"
"\n"
"\n"
"long_url := DB.DBA.URLREWRITE_SPRINTF_RESULTS (deserialize(URR_NICE_PARAMS), parts, deserialize(URR_TARGET_PARAMS), URR_TARGET_FORMAT, URR_TARGET_EXPR, accept_val, lines);\n"
"if (registry_get (\'__debug_url_rewrite\') in (\'1\', \'2\'))\n"
"dbg_printf (\'MATCH rule=[%s] URL=[%s]\', cur_iri, long_url);\n"
"rule_iri := cur_iri;\n"
"http_redir := URR_HTTP_REDIRECT;\n"
"http_headers := URR_HTTP_HEADERS;\n"
"if (URR_NO_CONTINUATION = 1)\n"
"return 1;\n"
"next_rule:;\n"
"}\n"
"}\n"
"}\n"
"}\n"
"--src url_rewrite.sql:441\n";

static const char *proc58 = 
"create procedure DB.DBA.URLREWRITE_APPLY (\n"
"in nice_url varchar,\n"
"in post_params any,\n"
"out long_url varchar,\n"
"out params any,\n"
"out nice_vhost_pkey any,\n"
"out top_rulelist_iri varchar,\n"
"out rule_iri varchar,\n"
"out target_vhost_pkey any)\n"
"returns integer\n"
"{\n"
"declare elm any;\n"
"declare _lhost, _lhost_port, _host, _lpath, _get_params, _frag, db_lhost, db_host, db_lpath varchar;\n"
"declare pos, http_redir integer;\n"
"declare http_headers varchar;\n"
"declare lines any;\n"
"elm := rfc1808_parse_uri (nice_url);\n"
"\n"
"if (elm[2] is null)\n"
"return 0;\n"
"\n"
"_lhost := elm[1];\n"
"pos := strrchr (_lhost, \':\');\n"
"if (pos = 0)\n"
"_lhost_port := \'80\';\n"
"else\n"
"_lhost_port := subseq (_lhost, pos + 1);\n"
"_lpath := elm[2];\n"
"_get_params := elm[4];\n"
"_frag := elm[5];\n"
"\n"
"whenever not found goto no_rec;\n"
"select top 1 HP_HOST, HP_LISTEN_HOST, HP_LPATH, get_keyword (\'url_rewrite\', deserialize (HP_OPTIONS), NULL) into db_host, db_lhost, db_lpath, top_rulelist_iri from HTTP_PATH where\n"
"(HP_LISTEN_HOST = _lhost or HP_LISTEN_HOST = _lhost_port or (HP_LISTEN_HOST = \'*ini*\' and _lhost_port = cfg_item_value (virtuoso_ini_path (), \'HTTPServer\',\'ServerPort\'))) and\n"
"HP_OPTIONS is not null and deserialize (HP_OPTIONS) is not null and\n"
"left (_lpath, length (HP_LPATH)) = HP_LPATH order by HP_LPATH desc;\n"
"if (db_host is null and db_lhost is null and db_lpath is null)\n"
"{\n"
"no_rec:;\n"
"nice_vhost_pkey := vector (null, null, null);\n"
"target_vhost_pkey := vector (null, null, null);\n"
"long_url := _lpath;\n"
"if (_get_params <> \'\')\n"
"long_url := concat (long_url, \'?\', _get_params);\n"
"if (_frag <> \'\')\n"
"long_url := concat (long_url, \'#\', _frag);\n"
"return 1;\n"
"}\n"
"else if (top_rulelist_iri is NULL)\n"
"{\n"
"nice_vhost_pkey := vector (db_host, db_lhost, db_lpath);\n"
"target_vhost_pkey := vector (db_host, db_lhost, db_lpath);\n"
"long_url := _lpath;\n"
"if (_get_params <> \'\')\n"
"long_url := concat (long_url, \'?\', _get_params);\n"
"if (_frag <> \'\')\n"
"long_url := concat (long_url, \'#\', _frag);\n"
"return 1;\n"
"}\n"
"nice_vhost_pkey := vector (db_host, db_lhost, db_lpath);\n"
"lines := vector ();\n"
"return DB.DBA.URLREWRITE_APPLY_RECURSIVE (\n"
"top_rulelist_iri,\n"
"_host,\n"
"_lhost,\n"
"_lpath,\n"
"_get_params,\n"
"_frag,\n"
"post_params,\n"
"null,\n"
"long_url,\n"
"params,\n"
"rule_iri,\n"
"target_vhost_pkey,\n"
"http_redir,\n"
"http_headers,\n"
"lines);\n"
"}\n"
"--src url_rewrite.sql:562\n";

static const char *proc59 = 
"create procedure DB.DBA.URLREWRITE_TRY_INVERSE (\n"
"in rule_iri varchar,\n"
"in long_path varchar,\n"
"in known_params any,\n"
"in param_retrieval_callback varchar,\n"
"in param_retrieval_env any,\n"
"inout param_retrieval_cache any,\n"
"out nice_path varchar,\n"
"out nice_params any,\n"
"out error_report varchar)\n"
"{\n"
"declare elm any;\n"
"declare _lhost, _lhost_port, _host, _lpath, _get_params, _frag varchar;\n"
"declare pos, i, j, is_found, number_of_values, not_null integer;\n"
"elm := rfc1808_parse_uri (long_path);\n"
"\n"
"if (elm[2] is null)\n"
"{\n"
"error_report := \'Incorrect long path.\';\n"
"return;\n"
"}\n"
"_lhost := elm[1];\n"
"pos := strrchr (_lhost, \':\');\n"
"if (pos = 0)\n"
"_lhost_port := \'80\';\n"
"else\n"
"_lhost_port := subseq (_lhost, pos + 1);\n"
"_lpath := elm[2];\n"
"_get_params := elm[4];\n"
"_frag := elm[5];\n"
"for select URR_RULE_TYPE, URR_NICE_FORMAT, deserialize(URR_NICE_PARAMS) as NICE_PARAMS_VEC, URR_NICE_MIN_PARAMS, URR_TARGET_FORMAT, deserialize(URR_TARGET_PARAMS) as TARGET_PARAMS_VEC, URR_TARGET_EXPR from DB.DBA.URL_REWRITE_RULE where URR_RULE = rule_iri do\n"
"{\n"
"declare parts, full_list_params, long_get_params any;\n"
"declare _result, var_name, var_value varchar;\n"
"\n"
"if (URR_RULE_TYPE = 0)\n"
"{\n"
"parts := sprintf_inverse (_lpath, URR_TARGET_FORMAT, 2);\n"
"\n"
"nice_params := vector ();\n"
"for (i := 0; i < length (NICE_PARAMS_VEC); i := i + 1)\n"
"{\n"
"nice_params := vector_concat (nice_params, vector (NICE_PARAMS_VEC[i], NULL));\n"
"}\n"
"\n"
"long_get_params := split_and_decode (_get_params, 0, \'\\0\\0&\');\n"
"\n"
"for (i := 0; i < length (NICE_PARAMS_VEC); i := i + 1)\n"
"{\n"
"for (j := 0; j < length (TARGET_PARAMS_VEC); j := j + 1)\n"
"{\n"
"if (NICE_PARAMS_VEC[i] = TARGET_PARAMS_VEC[j])\n"
"{\n"
"\n"
"aset (nice_params, 2*i + 1, parts[j]);\n"
"is_found := 1;\n"
"goto break_the_for;\n"
"}\n"
"}\n"
"for (j := 0; j < length (long_get_params); j := j + 1)\n"
"{\n"
"var_name := split_and_decode (long_get_params, 0, \'\\0\\0=\')[0];\n"
"var_value := split_and_decode (long_get_params, 0, \'\\0\\0=\')[1];\n"
"if (NICE_PARAMS_VEC[i] = var_name)\n"
"{\n"
"\n"
"aset (nice_params, i + 1, var_value);\n"
"is_found := 1;\n"
"goto break_the_for;\n"
"}\n"
"}\n"
"for (j := 0; j < length (known_params); j := j + 2)\n"
"{\n"
"var_name := known_params[j];\n"
"var_value := known_params[j + 1];\n"
"if (NICE_PARAMS_VEC[i] = var_name)\n"
"{\n"
"\n"
"aset (nice_params, i + 1, var_value);\n"
"is_found := 1;\n"
"goto break_the_for;\n"
"}\n"
"}\n"
"for (j := 0; j < length (param_retrieval_cache); j := j + 2)\n"
"{\n"
"var_name := param_retrieval_cache[j];\n"
"var_value := param_retrieval_cache[j + 1];\n"
"if (NICE_PARAMS_VEC[i] = var_name)\n"
"{\n"
"\n"
"aset (nice_params, i + 1, var_value);\n"
"is_found := 1;\n"
"goto break_the_for;\n"
"}\n"
"}\n"
"if (param_retrieval_callback is not null and param_retrieval_callback <> \'\')\n"
"{\n"
"declare state, msg, descs, rows any;\n"
"state := \'00000\';\n"
"\n"
"exec (sprintf (\'%s (?, ?)\', param_retrieval_callback), null, null, vector (NICE_PARAMS_VEC[i], param_retrieval_env), 1, descs, rows);\n"
"if (state <> \'00000\')\n"
"goto break_the_for;\n"
"if (rows is not null and length (rows) > 0)\n"
"{\n"
"aset (nice_params, i + 1, rows[0][0]);\n"
"param_retrieval_cache := vector_concat (param_retrieval_cache, vector (NICE_PARAMS_VEC[i], rows[0][0]) );\n"
"}\n"
"}\n"
"break_the_for:;\n"
"}\n"
"\n"
"for (j := 0; j < length (TARGET_PARAMS_VEC); j := j + 1)\n"
"{\n"
"is_found := 0;\n"
"for (i := 0; i < length (NICE_PARAMS_VEC); i := i + 1)\n"
"{\n"
"if (NICE_PARAMS_VEC[i] = TARGET_PARAMS_VEC[j])\n"
"{\n"
"\n"
"is_found := 1;\n"
"goto break_the_for2;\n"
"}\n"
"}\n"
"if (is_found = 0)\n"
"{\n"
"nice_params := vector_concat (nice_params, vector (TARGET_PARAMS_VEC[j], parts[j]) );\n"
"}\n"
"break_the_for2:;\n"
"}\n"
"for (j := 0; j < length (long_get_params); j := j + 1)\n"
"{\n"
"var_name := split_and_decode (long_get_params, 0, \'\\0\\0=\')[0];\n"
"var_value := split_and_decode (long_get_params, 0, \'\\0\\0=\')[1];\n"
"is_found := 0;\n"
"for (i := 0; i < length (NICE_PARAMS_VEC); i := i + 1)\n"
"{\n"
"if (NICE_PARAMS_VEC[i] = var_name)\n"
"{\n"
"\n"
"is_found := 1;\n"
"goto break_the_for3;\n"
"}\n"
"}\n"
"if (is_found = 0)\n"
"nice_params := vector_concat (nice_params, vector (var_name, var_value) );\n"
"break_the_for3:;\n"
"}\n"
"for (j := 0; j < length (known_params); j := j + 2)\n"
"{\n"
"var_name := known_params[j];\n"
"var_value := known_params[j + 1];\n"
"is_found := 0;\n"
"for (i := 0; i < length (NICE_PARAMS_VEC); i := i + 1)\n"
"{\n"
"if (NICE_PARAMS_VEC[i] = var_name)\n"
"{\n"
"\n"
"is_found := 1;\n"
"goto break_the_for4;\n"
"}\n"
"}\n"
"if (is_found = 0)\n"
"nice_params := vector_concat (nice_params, vector (var_name, var_value) );\n"
"break_the_for4:;\n"
"}\n"
"\n"
"number_of_values := 0;\n"
"not_null := 0;\n"
"for (i := 0; i < length (NICE_PARAMS_VEC); i := i + 2)\n"
"{\n"
"if (nice_params[i + 1] is not NULL)\n"
"not_null := 1;\n"
"}\n"
"if (not_null = 0)\n"
"{\n"
"error_report := \'The rule \' || rule_iri || \' is not for this URL\';\n"
"return;\n"
"}\n"
"\n"
"nice_path := DB.DBA.URLREWRITE_VPRINTF (URR_NICE_FORMAT, nice_params, number_of_values);\n"
"if (number_of_values > 0)\n"
"{\n"
"declare tmp_vec any;\n"
"tmp_vec := vector();\n"
"i := number_of_values;\n"
"while (i < length (nice_params) )\n"
"{\n"
"tmp_vec := vector_concat (tmp_vec, vector (nice_params[i], nice_params[i+1]) );\n"
"i := i + 2;\n"
"}\n"
"nice_params := tmp_vec;\n"
"}\n"
"}\n"
"else\n"
"error_report := \'The rule \' || rule_iri || \' is not a sprintf rule\';\n"
"return;\n"
"}\n"
"nice_path := null;\n"
"error_report := \'The rule \' || rule_iri || \' is not found\';\n"
"}\n"
"--src url_rewrite.sql:642\n";

static const char *proc60 = 
"create procedure DB.DBA.HTTP_VARIANT_ADD (in rulelist_uri varchar,\n"
"in uri varchar, in variant_uri varchar, in mime varchar,\n"
"in qs float := 1.0, in _desc varchar := null,\n"
"in lang varchar := null, in enc varchar := null, in algo int := 1, in location_hook varchar := null)\n"
"{\n"
"declare tmp any;\n"
"declare mime_qs, lang_qs, enc_qs float;\n"
"\n"
"\n"
"\n"
"\n"
"if (isstring (qs) or qs < 0.001)\n"
"signal (\'22023\', \'The quality factor must be float number between 1.0 and 0.001\');\n"
"\n"
"if (length (mime))\n"
"{\n"
"tmp := split_and_decode (mime, 0, \'\\0\\0;=\');\n"
"mime := tmp[0];\n"
"}\n"
"else\n"
"mime := null;\n"
"if (length (lang))\n"
"{\n"
"tmp := split_and_decode (lang, 0, \'\\0\\0;=\');\n"
"lang := tmp[0];\n"
"}\n"
"else\n"
"lang := null;\n"
"if (length (enc))\n"
"{\n"
"tmp := split_and_decode (enc, 0, \'\\0\\0;=\');\n"
"enc := tmp[0];\n"
"}\n"
"else\n"
"enc := null;\n"
"insert replacing DB.DBA.HTTP_VARIANT_MAP (VM_RULELIST,VM_URI,VM_VARIANT_URI,VM_QS, VM_TYPE,\n"
"VM_LANG,VM_ENC,VM_DESCRIPTION,VM_ALGO, VM_CONTENT_LOCATION_HOOK)\n"
"values (rulelist_uri, uri, variant_uri, qs, mime, lang, enc, _desc, algo, location_hook);\n"
"}\n"
"--src url_rewrite.sql:845\n";

static const char *proc61 = 
"create procedure DB.DBA.HTTP_VARIANT_REMOVE (in rulelist_uri varchar, in uri varchar, in variant_uri varchar := \'%\')\n"
"{\n"
"if (not exists (select 1 from DB.DBA.URL_REWRITE_RULE_LIST where URRL_LIST = rulelist_uri))\n"
"signal (\'42000\', \'Rule IRI \' || rulelist_uri || \' does not exist.\');\n"
"delete from DB.DBA.HTTP_VARIANT_MAP where VM_RULELIST = rulelist_uri and VM_URI like uri and VM_VARIANT_URI like variant_uri;\n"
"}\n"
"--src url_rewrite.sql:886\n";

static const char *proc62 = 
"create procedure DB.DBA.URLREWRITE_CALC_QS (in accept varchar, in s_accept varchar)\n"
"{\n"
"declare arr, tmp any;\n"
"declare best_q, q float;\n"
"declare best_match varchar;\n"
"declare i, l int;\n"
"declare itm varchar;\n"
"\n"
"\n"
"if (s_accept is null or s_accept = \'*\')\n"
"return 1;\n"
"arr := split_and_decode (accept, 0, \'\\0\\0,;\');\n"
"\n"
"best_q := 0;\n"
"l := length (arr);\n"
"for (i := 0; i < l; i := i + 2)\n"
"{\n"
"itm := trim(arr[i]);\n"
"\n"
"if (s_accept like itm)\n"
"{\n"
"q := arr[i+1];\n"
"if (q is null)\n"
"q := 1.0;\n"
"else\n"
"{\n"
"tmp := split_and_decode (q, 0, \'\\0\\0=\');\n"
"if (length (tmp) = 2)\n"
"q := atof (tmp[1]);\n"
"else\n"
"q := 1.0;\n"
"}\n"
"if (best_q < q)\n"
"{\n"
"best_q := q;\n"
"}\n"
"}\n"
"}\n"
"return best_q;\n"
"}\n"
"--src url_rewrite.sql:894\n";

static const char *proc63 = 
"create procedure DB.DBA.HTTP_URLREWRITE_TCN_LIST (inout li any)\n"
"{\n"
"http (\'<!DOCTYPE HTML PUBLIC \"-//IETF//DTD HTML 2.0//EN\">\\n\');\n"
"http (\'<html><head>\\n\');\n"
"http (\'<title>300 Multiple Choices</title>\\n\');\n"
"http (\'</head><body>\\n\');\n"
"http (\'<h1>Multiple Choices</h1>\\n\');\n"
"http (\'Available variants:\');\n"
"http (\'<ul>\\n\');\n"
"http (li);\n"
"http (\'</ul>\\n</body></html>\');\n"
"}\n"
"--src url_rewrite.sql:936\n";

static const char *proc64 = 
"create procedure DB.DBA.HTTP_URLREWRITE_APPLY_PATTERN (in pattern varchar, in str varchar, in format varchar)\n"
"{\n"
"declare arr, pars, ret, tmp any;\n"
"declare inx, len, i int;\n"
"declare pos int;\n"
"declare host varchar;\n"
"\n"
"host := registry_get (\'URIQADefaultHost\');\n"
"arr := regexp_parse (pattern, str, 0);\n"
"if (arr is null)\n"
"return NULL;\n"
"len := length (arr);\n"
"pars := make_array ((len-2)/2, \'any\');\n"
"for (i := 0, inx := 2; inx < len; inx := inx + 2, i := i + 1)\n"
"{\n"
"if (arr[inx] < 0 or arr[inx + 1] < 0)\n"
"pars[i] := null;\n"
"else\n"
"pars[i] := subseq (str, arr[inx], arr[inx + 1]);\n"
"}\n"
"arr := regexp_parse (\'(\\\\x24[0-9]+)\', format, 0);\n"
"if (arr is null)\n"
"return format;\n"
"ret := \'\';\n"
"pos := 0;\n"
"while (arr is not null)\n"
"{\n"
"ret := ret || subseq (format, pos, arr[0]);\n"
"tmp := atoi(ltrim (subseq (format, arr[0], arr[1]), \'\\x24\'));\n"
"if (tmp > 0 and tmp <= length (pars))\n"
"ret := ret || pars[tmp-1];\n"
"pos := arr[1];\n"
"arr := regexp_parse (\'(\\\\x24[0-9]+)\', format, pos);\n"
"}\n"
"if (pos > 0 and pos < length (format))\n"
"ret := ret || subseq (format, pos);\n"
"if (isstring (host))\n"
"{\n"
"ret := replace (ret, \'^{URIQADefaultHost}^\', host);\n"
"if (strstr (ret, \'^{DynamicLocalFormat}^\') is not null)\n"
"{\n"
"if (strchr (host, \':\') is not null)\n"
"ret := replace (ret, \'^{DynamicLocalFormat}^\', sprintf (\'http://%{WSHostName}U:%{WSHostPort}U\'));\n"
"else\n"
"ret := replace (ret, \'^{DynamicLocalFormat}^\', sprintf (\'http://%{WSHost}U\'));\n"
"}\n"
"}\n"
"return ret;\n"
"}\n"
"--src url_rewrite.sql:950\n";

static const char *proc65 = 
"create procedure DB.DBA.HTTP_LOC_NEW_URL (in url any)\n"
"{\n"
"declare ret, host any;\n"
"\n"
"if (url like \'http:%\')\n"
"return url;\n"
"\n"
"if (url not like \'/%\')\n"
"return url;\n"
"\n"
"host := HTTP_GET_HOST ();\n"
"\n"
"if (is_https_ctx ())\n"
"ret := \'https://\';\n"
"else\n"
"ret := \'http://\';\n"
"\n"
"if (\"RIGHT\" (host, 3) = \':80\')\n"
"host := replace (host, \':80\', \'\');\n"
"\n"
"ret := ret || host || url;\n"
"\n"
"return ret;\n"
"}\n"
"--src url_rewrite.sql:1002\n";

static const char *proc66 = 
"create procedure DB.DBA.URLREWRITE_APPLY_TCN (in rulelist_uri varchar, inout path varchar, inout lines any,\n"
"out http_code any, out http_headers any)\n"
"{\n"
"\n"
"declare mime, lang, enc, cset varchar;\n"
"declare rel_uri any;\n"
"declare tmp, pos, hf, list_body any;\n"
"declare qs1, qs2, qs3, qs4 float;\n"
"declare best_q, curr float;\n"
"declare best_variant, algo, list, best_ct, hook varchar;\n"
"declare vlist, trans, guess, do_cn, best_id int;\n"
"declare ct, cl any;\n"
"\n"
"\n"
"hf := rfc1808_parse_uri (path);\n"
"tmp := hf[2];\n"
"\n"
"pos := strrchr (tmp, \'/\');\n"
"if (pos is not null)\n"
"rel_uri := subseq (path, pos + 1);\n"
"if (length (rel_uri))\n"
"rel_uri := aref (split_and_decode (rel_uri), 0);\n"
"mime := http_request_header_full (lines, \'Accept\', \'*/*\');\n"
"if (registry_get (\'__debug_url_rewrite\') in (\'1\', \'2\'))\n"
"dbg_printf (\'Accept: [%s]\', mime);\n"
"lang := http_request_header_full (lines, \'Accept-Language\', \'*\');\n"
"\n"
"cset := http_request_header_full (lines, \'Accept-Charset\', \'*\');\n"
"algo := http_request_header_full (lines, \'Negotiate\', \'*\');\n"
"do_cn := 1;\n"
"vlist := trans := guess := 0;\n"
"if (algo = \'trans\');\n"
"{\n"
"trans := 1;\n"
"do_cn := 0;\n"
"}\n"
"if (algo = \'vlist\');\n"
"{\n"
"trans := vlist := 1;\n"
"do_cn := 0;\n"
"}\n"
"if (algo = \'guess-small\');\n"
"{\n"
"trans := vlist := 1;\n"
"do_cn := 0;\n"
"}\n"
"if (atof (algo) >= 1)\n"
"do_cn := 1;\n"
"if (algo = \'*\')\n"
"vlist := trans := do_cn := 1;\n"
"\n"
"best_q := 0;\n"
"best_ct := null;\n"
"list := \'\';\n"
"list_body := \'\';\n"
"best_id := 0;\n"
"for select VM_ID, VM_URI, VM_VARIANT_URI, VM_QS, VM_TYPE, VM_LANG, VM_ENC, VM_DESCRIPTION, VM_ALGO, VM_CONTENT_LOCATION_HOOK\n"
"from DB.DBA.HTTP_VARIANT_MAP where VM_RULELIST = rulelist_uri do\n"
"{\n"
"declare alang, aenc, variant, path_str varchar;\n"
"\n"
"if (VM_URI not like \'/%\' and path like \'%/\')\n"
"goto next_variant;\n"
"\n"
"if (VM_URI like \'/%\')\n"
"path_str := path;\n"
"else\n"
"path_str := rel_uri;\n"
"\n"
"if (regexp_match (VM_URI, path_str) is null)\n"
"goto next_variant;\n"
"\n"
"variant := DB.DBA.HTTP_URLREWRITE_APPLY_PATTERN (VM_URI, path_str, VM_VARIANT_URI);\n"
"if (variant is null)\n"
"goto next_variant;\n"
"\n"
"qs1 := DB.DBA.URLREWRITE_CALC_QS (mime, VM_TYPE);\n"
"qs2 := DB.DBA.URLREWRITE_CALC_QS (lang, VM_LANG);\n"
"qs3 := DB.DBA.URLREWRITE_CALC_QS (cset, VM_ENC);\n"
"\n"
"curr := VM_QS * qs1 * qs2 * qs3;\n"
"if (registry_get (\'__debug_url_rewrite\') in (\'1\', \'2\'))\n"
"dbg_printf (\'tcn trying: %s qs1=%f qs2=%f qs3=%f qs=%f\', VM_VARIANT_URI, qs1, qs2, qs3, curr);\n"
"if (curr > best_q)\n"
"{\n"
"declare s any;\n"
"best_q := curr;\n"
"best_ct := VM_TYPE;\n"
"if (VM_URI like \'/%\')\n"
"best_variant := variant;\n"
"else\n"
"{\n"
"s := string_output ();\n"
"http_dav_url (variant, null, s);\n"
"s := string_output_string (s);\n"
"best_variant := s;\n"
"}\n"
"best_id := VM_ID;\n"
"hook := VM_CONTENT_LOCATION_HOOK;\n"
"}\n"
"if (not do_cn)\n"
"{\n"
"alang := \'\';\n"
"aenc := \'\';\n"
"if (VM_LANG is not null)\n"
"alang := sprintf (\' {language %s}\', VM_LANG);\n"
"if (VM_ENC is not null)\n"
"aenc := sprintf (\' {charset %s}\', VM_ENC);\n"
"cl := variant;\n"
"if (VM_CONTENT_LOCATION_HOOK is not null and __proc_exists (VM_CONTENT_LOCATION_HOOK) is not null)\n"
"cl := call (VM_CONTENT_LOCATION_HOOK) (VM_ID, variant);\n"
"list := list || sprintf (\'{\"%s\" %f {type %s}%s%s}, \', cl, VM_QS, VM_TYPE, alang, aenc);\n"
"list_body := list_body || sprintf (\'<li><a href=\"%V\">%V</a>, type %V</li>\\n\',\n"
"cl, coalesce (VM_DESCRIPTION, cl), VM_TYPE);\n"
"}\n"
"next_variant:;\n"
"}\n"
"if (do_cn and best_q > 0)\n"
"{\n"
"ct := \'\';\n"
"if (best_ct is not null)\n"
"{\n"
"if (best_q > 0.999)\n"
"ct := sprintf (\'Content-Type: %s\\r\\n\', best_ct);\n"
"else\n"
"{\n"
"declare q_str varchar;\n"
"q_str := rtrim (sprintf (\'%f\', best_q), \'0\');\n"
"ct := sprintf (\'Content-Type: %s; qs=%s\\r\\n\', best_ct, q_str);\n"
"}\n"
"}\n"
"cl := best_variant;\n"
"if (hook is not null and __proc_exists (hook) is not null)\n"
"cl := call (hook) (best_id, best_variant);\n"
"http_headers := sprintf (\'TCN: choice\\r\\nVary: negotiate,accept\\r\\nContent-Location: %s\\r\\n%s\', cl, ct);\n"
"\n"
"path := WS.WS.EXPAND_URL (path, replace (best_variant, \':\', \'\\x1\'));\n"
"path := replace (path, \'\\x1\', \':\');\n"
"if (registry_get (\'__debug_url_rewrite\') in (\'1\', \'2\'))\n"
"dbg_printf (\'TCN return: %s\', path);\n"
"return 1;\n"
"}\n"
"if (not do_cn and list <> \'\')\n"
"{\n"
"http_headers := sprintf (\'TCN: list\\r\\nVary: negotiate,accept\\r\\nAlternates: %s\\r\\n\', rtrim (list, \', \'));\n"
"http_code := 300;\n"
"if (is_http_ctx ())\n"
"DB.DBA.HTTP_URLREWRITE_TCN_LIST (list_body);\n"
"if (registry_get (\'__debug_url_rewrite\') in (\'1\', \'2\'))\n"
"dbg_printf (\'TCN list\');\n"
"return 1;\n"
"}\n"
"return 0;\n"
"}\n"
"--src url_rewrite.sql:1029\n";

static const char *proc67 = 
"create procedure DB.DBA.HTTP_URLREWRITE (in path varchar, in rule_list varchar, in post_params any := null) returns any\n"
"{\n"
"declare long_url varchar;\n"
"declare params, lines any;\n"
"declare nice_vhost_pkey any;\n"
"declare top_rulelist_iri varchar;\n"
"declare rule_iri, in_path, qstr varchar;\n"
"declare target_vhost_pkey, hf, accept, http_headers any;\n"
"declare result, http_redir, http_tcn_code, tcn_rc, keep_lpath int;\n"
"declare http_tcn_headers varchar;\n"
"\n"
"\n"
"\n"
"long_url := null;\n"
"in_path := rtrim (path, \'/\');\n"
"if (length (in_path) = 0)\n"
"in_path := \'/\';\n"
"accept := null;\n"
"qstr := null;\n"
"keep_lpath := 0;\n"
"\n"
"if (is_http_ctx ())\n"
"{\n"
"keep_lpath := http_map_get (\'url_rewrite_keep_lpath\');\n"
"lines := http_request_header ();\n"
"if (length (lines))\n"
"{\n"
"in_path := regexp_match (\'/[^ \\\\t\\\\n\\\\r]*\', lines[0]);\n"
"}\n"
"else\n"
"{\n"
"qstr := http_request_get (\'QUERY_STRING\');\n"
"}\n"
"accept := http_request_header (lines, \'Accept\');\n"
"if (not isstring (accept))\n"
"accept := \'*/*\';\n"
"}\n"
"else\n"
"{\n"
"lines := vector ();\n"
"}\n"
"\n"
"if (length (qstr))\n"
"in_path := in_path || \'?\' || qstr;\n"
"\n"
"http_tcn_headers := http_headers := null;\n"
"http_tcn_code := http_redir := null;\n"
"tcn_rc := DB.DBA.URLREWRITE_APPLY_TCN (rule_list, in_path, lines, http_tcn_code, http_tcn_headers);\n"
"\n"
"result := DB.DBA.URLREWRITE_APPLY_RECURSIVE (rule_list, null, null, in_path, \'\', qstr, post_params, accept,\n"
"long_url, params, rule_iri, target_vhost_pkey, http_redir, http_headers, lines);\n"
"if (registry_get (\'__debug_url_rewrite\') in (\'1\', \'2\') and length (long_url))\n"
"dbg_printf (\'*** RETURN rule=[%s] URL=[%s]\', rule_iri, long_url);\n"
"if (not tcn_rc and length (long_url))\n"
"{\n"
"tcn_rc := DB.DBA.URLREWRITE_APPLY_TCN (rule_list, long_url, lines, http_tcn_code, http_tcn_headers);\n"
"if (registry_get (\'__debug_url_rewrite\') in (\'1\', \'2\') and tcn_rc)\n"
"dbg_printf (\'*** TCN RETURN URL=[%s]\', long_url);\n"
"}\n"
"\n"
"if (http_redir is null or http_redir = 0)\n"
"http_redir := http_tcn_code;\n"
"if (http_headers is null or http_headers = 0)\n"
"http_headers := http_tcn_headers;\n"
"else if (http_tcn_headers is not null)\n"
"http_headers := http_tcn_headers || http_headers;\n"
"\n"
"if (tcn_rc and not length (long_url))\n"
"long_url := in_path;\n"
"\n"
"\n"
"if (length (long_url) and is_http_ctx ())\n"
"{\n"
"declare full_path, pars, p_full_path any;\n"
"\n"
"\n"
"if (length (http_headers) > 0)\n"
"{\n"
"declare fn, tmp, repl any;\n"
"\n"
"if (http_headers not like \'%\\n\')\n"
"http_headers := http_headers || \'\\n\';\n"
"\n"
"tmp := regexp_match (\'\\\\^{sql:[^}]*}\\\\^\', http_headers);\n"
"while (tmp is not null)\n"
"{\n"
"fn := subseq (tmp, 6, length (tmp)-2);\n"
"repl := \'\';\n"
"if (__proc_exists (fn))\n"
"{\n"
"repl := call (fn) (in_path);\n"
"}\n"
"http_headers := replace (http_headers, tmp, repl);\n"
"tmp := regexp_match (\'\\\\^{sql:[^}]*}\\\\^\', http_headers);\n"
"}\n"
"http_header (http_headers);\n"
"}\n"
"\n"
"if (http_redir in (301, 302, 303, 307))\n"
"{\n"
"http_status_set (http_redir);\n"
"http_header (http_header_get () || \'Location: \'|| DB.DBA.HTTP_LOC_NEW_URL (long_url) ||\'\\r\\n\');\n"
"http_body_read ();\n"
"return 1;\n"
"}\n"
"else if (http_redir = 300)\n"
"{\n"
"http_status_set (http_redir);\n"
"http_body_read ();\n"
"return 1;\n"
"}\n"
"else if (isinteger (http_redir) and http_redir > 399)\n"
"{\n"
"http_status_set (http_redir);\n"
"http_body_read ();\n"
"return 1;\n"
"}\n"
"else\n"
"{\n"
"hf := rfc1808_parse_uri (long_url);\n"
"full_path := hf[2];\n"
"pars := split_and_decode (hf[4]);\n"
"p_full_path := http_physical_path_resolve (full_path, 1);\n"
"http_internal_redirect (full_path, p_full_path, long_url, keep_lpath);\n"
"pars := vector_concat (params, pars);\n"
"http_set_params (pars);\n"
"}\n"
"}\n"
"return 0;\n"
"}\n"
"--src url_rewrite.sql:1185\n";

static const char *proc68 = 
"create procedure DB.DBA.URLREWRITE_DUMP_RULELIST_SQL (in rulelist_iri varchar)\n"
"{\n"
"declare ses, rules any;\n"
"ses := string_output ();\n"
"http (sprintf (\'DB.DBA.URLREWRITE_CREATE_RULELIST ( \\n\\\'%s\\\', 1, \\n  vector (\', rulelist_iri), ses);\n"
"rules := (select DB.DBA.VECTOR_AGG (URRL_MEMBER) from DB.DBA.URL_REWRITE_RULE_LIST where URRL_LIST = rulelist_iri order by URRL_INX);\n"
"http (SYS_SQL_VECTOR_PRINT (rules), ses);\n"
"http (\'));\\n\\n\', ses);\n"
"\n"
"for select URRL_MEMBER from DB.DBA.URL_REWRITE_RULE_LIST where URRL_LIST = rulelist_iri order by URRL_INX do\n"
"{\n"
"for select\n"
"URR_RULE_TYPE,\n"
"URR_NICE_FORMAT,\n"
"URR_NICE_PARAMS,\n"
"URR_NICE_MIN_PARAMS,\n"
"URR_TARGET_FORMAT,\n"
"URR_TARGET_PARAMS,\n"
"URR_TARGET_EXPR,\n"
"URR_ACCEPT_PATTERN,\n"
"URR_NO_CONTINUATION,\n"
"URR_HTTP_REDIRECT,\n"
"URR_HTTP_HEADERS from\n"
"DB.DBA.URL_REWRITE_RULE\n"
"where URR_RULE = URRL_MEMBER\n"
"do\n"
"{\n"
"if (URR_RULE_TYPE = 1)\n"
"{\n"
"http (sprintf (\'DB.DBA.URLREWRITE_CREATE_REGEX_RULE ( \\n\\\'%s\\\', 1, \\n  \', URRL_MEMBER), ses);\n"
"}\n"
"else\n"
"{\n"
"http (sprintf (\'DB.DBA.URLREWRITE_CREATE_SPRINTF_RULE ( \\n\\\'%s\\\', 1, \\n  \', URRL_MEMBER), ses);\n"
"}\n"
"\n"
"http (sprintf (\'\\\'%S\\\', \\n\', URR_NICE_FORMAT), ses);\n"
"http (sprintf (\'vector (%s), \\n\', SYS_SQL_VECTOR_PRINT (deserialize (URR_NICE_PARAMS))), ses);\n"
"http (sprintf (\'%d, \\n\', URR_NICE_MIN_PARAMS), ses);\n"
"http (sprintf (\'\\\'%S\\\', \\n\', URR_TARGET_FORMAT), ses);\n"
"http (sprintf (\'vector (%s), \\n\', SYS_SQL_VECTOR_PRINT (deserialize (URR_TARGET_PARAMS))), ses);\n"
"http (sprintf (\'%s, \\n\', SYS_SQL_VAL_PRINT (URR_TARGET_EXPR)), ses);\n"
"http (sprintf (\'%s, \\n\', SYS_SQL_VAL_PRINT (URR_ACCEPT_PATTERN)), ses);\n"
"http (sprintf (\'%s, \\n\', SYS_SQL_VAL_PRINT (URR_NO_CONTINUATION)), ses);\n"
"http (sprintf (\'%s, \\n\', SYS_SQL_VAL_PRINT (URR_HTTP_REDIRECT)), ses);\n"
"http (sprintf (\'%s \\n\', SYS_SQL_VAL_PRINT (URR_HTTP_HEADERS)), ses);\n"
"\n"
"http (\');\\n\\n\', ses);\n"
"}\n"
"}\n"
"\n"
"for select VM_RULELIST, VM_URI, VM_VARIANT_URI, VM_QS, VM_TYPE, VM_LANG, VM_ENC, VM_DESCRIPTION, VM_ALGO\n"
"from DB.DBA.HTTP_VARIANT_MAP where VM_RULELIST = rulelist_iri do\n"
"{\n"
"http (sprintf (\'DB.DBA.HTTP_VARIANT_ADD (\\n%s,\\n\', SYS_SQL_VAL_PRINT (VM_RULELIST)), ses);\n"
"http (sprintf (\'%s,\\n\', SYS_SQL_VAL_PRINT (VM_URI)), ses);\n"
"http (sprintf (\'%s,\\n\', SYS_SQL_VAL_PRINT (VM_VARIANT_URI)), ses);\n"
"http (sprintf (\'%s,\\n\', SYS_SQL_VAL_PRINT (VM_TYPE)), ses);\n"
"http (sprintf (\'%s,\\n\', SYS_SQL_VAL_PRINT (VM_QS)), ses);\n"
"http (sprintf (\'%s,\\n\', SYS_SQL_VAL_PRINT (VM_DESCRIPTION)), ses);\n"
"http (sprintf (\'%s,\\n\', SYS_SQL_VAL_PRINT (VM_LANG)), ses);\n"
"http (sprintf (\'%s,\\n\', SYS_SQL_VAL_PRINT (VM_ENC)), ses);\n"
"http (sprintf (\'%s\\n\', SYS_SQL_VAL_PRINT (VM_ALGO)), ses);\n"
"http (\');\\n\\n\', ses);\n"
"}\n"
"\n"
"return string_output_string (ses);\n"
"}\n"
"--src url_rewrite.sql:1317\n";

static const char *other200 = 
"virt_proxy_init ()\n";
static const char *other201 = 
"grant execute on ext_http_proxy to PROXY\n";
static int
sch_proc_def_exists (client_connection_t *cli, const char *proc_name)
{
  query_t *proc = NULL;
  char *full_name = sch_full_proc_name (isp_schema(NULL), proc_name,
	cli->cli_qualifier, CLI_OWNER (cli));
  if (full_name)
    proc = sch_proc_def (isp_schema(NULL), full_name);
  return (proc != NULL);
}

#define DEFINE_PROC(name, proc) \
   if (!sch_proc_def_exists (bootstrap_cli, (name))) \
     ddl_std_proc_1 (proc, 0x0, 1)


#define DEFINE_PUBLIC_PROC(name, proc) \
   if (!sch_proc_def_exists (bootstrap_cli, (name))) \
     ddl_std_proc_1 (proc, 0x1, 1)


#define DEFINE_OVERWRITE_PROC(name, proc) \
   ddl_std_proc_1 (proc, 0x1, 1)


void
sqls_define_ddk (void)
{
  caddr_t saved_qualifier = bootstrap_cli->cli_qualifier;

  /* replddk.sql */

  ddl_ensure_table ("DB.DBA.SYS_TP_ITEM", tbl0);
  ddl_ensure_table ("DB.DBA.TP_ITEM", view0);
  ddl_ensure_table ("do this always", other0);
  ddl_ensure_table ("DB.DBA.REPL_ACCOUNTS", view1);
  ddl_ensure_table ("do this always", other1);
  ddl_ensure_table ("DB.DBA.SYS_TP_GRANT", tbl1);
  ddl_ensure_table ("DB.DBA.SYS_REPL_CR", tbl2);
  ddl_ensure_table ("do this always", other2);

  /* davddk.sql */
  bootstrap_cli->cli_qualifier = box_string ("WS");

  ddl_ensure_table ("WS.WS.SYS_DAV_COL", tbl3);
  ddl_ensure_table ("WS.WS.SYS_DAV_RES", tbl4);
  DEFINE_PROC ("WS.WS.SYS_DAV_RES_RES_CONTENT_INDEX_HOOK", proc0);
  DEFINE_PROC ("WS.WS.SYS_DAV_RES_RES_CONTENT_UNINDEX_HOOK", proc1);
  ddl_ensure_table ("do this always", other3);
  ddl_ensure_table ("do this always", other4);
  ddl_ensure_table ("WS.WS.SYS_DAV_PROP", tbl5);
  ddl_ensure_table ("WS.WS.SYS_DAV_LOCK", tbl6);
  ddl_ensure_table ("WS.WS.SYS_DAV_USER", view2);
  ddl_ensure_table ("WS.WS.SYS_DAV_GROUP", view3);
  ddl_ensure_table ("WS.WS.SYS_DAV_USER_GROUP", view4);
  ddl_ensure_table ("WS.WS.SYS_DAV_RES_TYPES", tbl7);
  ddl_ensure_table ("WS.WS.SYS_MIME_TYPES", tbl8);
  ddl_ensure_table ("WS.WS.SYS_RDF_SCHEMAS", tbl9);
  ddl_ensure_table ("WS.WS.SYS_MIME_RDFS", tbl10);
  ddl_ensure_table ("WS.WS.SYS_RDF_PROP_NAME", tbl11);
  ddl_ensure_table ("WS.WS.SYS_DAV_CATFILTER", tbl12);
  ddl_ensure_table ("WS.WS.SYS_DAV_CATFILTER_DETS", tbl13);
  ddl_ensure_table ("WS.WS.SYS_DAV_RDF_INVERSE", tbl14);
  ddl_ensure_table ("WS.WS.SYS_DAV_ACL_INVERSE", tbl15);
  ddl_ensure_table ("WS.WS.SYS_DAV_ACL_GRANTS", view5);
  ddl_ensure_table ("WS.WS.SYS_DAV_SPACE_QUOTA", tbl16);
  ddl_ensure_table ("WS.WS.SYS_DAV_TAG", tbl17); 
  DEFINE_PUBLIC_PROC ("WS.WS.DAV_TAG_NORMALIZE", proc2);
  DEFINE_PROC ("WS.WS.SYS_DAV_TAG_DT_TAGS_INDEX_HOOK", proc3);
  DEFINE_PROC ("WS.WS.SYS_DAV_TAG_DT_TAGS_UNINDEX_HOOK", proc4);
  ddl_ensure_table ("do this always", other5);
  DEFINE_PROC ("WS.WS.GETID", proc5);
  DEFINE_PROC ("WS.WS.COL_PATH", proc6);
  DEFINE_PROC ("DB.DBA.DAV_CHANGED_FUNCTIONS", proc7);
  DEFINE_PROC ("WS.WS.SYS_DAV_INIT", proc8);
  DEFINE_PROC ("WS.WS.SYS_DAV_INIT_1", proc9);
  ddl_ensure_table ("do this always", other6);
  DEFINE_PROC ("WS.WS.SYS_DAV_PROP_PROP_VALUE_INDEX_HOOK", proc10);
  DEFINE_PROC ("WS.WS.SYS_DAV_PROP_PROP_VALUE_UNINDEX_HOOK", proc11);
  ddl_ensure_table ("do this always", other7);
  ddl_ensure_table ("do this always", other8);
  ddl_ensure_table ("do this always", other9);
  ddl_ensure_table ("do this always", other10);
  ddl_ensure_table ("do this always", other11);
  ddl_ensure_table ("do this always", other12);
  ddl_ensure_table ("do this always", other13);
  ddl_ensure_table ("do this always", other14);
  ddl_ensure_table ("do this always", other15);
  ddl_ensure_table ("do this always", other16);
  ddl_ensure_table ("do this always", other17);
  ddl_ensure_table ("do this always", other18);
  ddl_ensure_table ("do this always", other19);
  ddl_ensure_table ("do this always", other20);
  ddl_ensure_table ("do this always", other21);
  ddl_ensure_table ("do this always", other22);
  ddl_ensure_table ("do this always", other23);
  ddl_ensure_table ("do this always", other24);
  ddl_ensure_table ("do this always", other25);
  ddl_ensure_table ("do this always", other26);
  ddl_ensure_table ("do this always", other27);
  ddl_ensure_table ("do this always", other28);
  ddl_ensure_table ("do this always", other29);
  ddl_ensure_table ("do this always", other30);
  ddl_ensure_table ("do this always", other31);
  ddl_ensure_table ("do this always", other32);
  ddl_ensure_table ("do this always", other33);
  ddl_ensure_table ("do this always", other34);
  ddl_ensure_table ("do this always", other35);
  ddl_ensure_table ("do this always", other36);
  ddl_ensure_table ("do this always", other37);
  ddl_ensure_table ("do this always", other38);
  ddl_ensure_table ("do this always", other39);
  ddl_ensure_table ("do this always", other40);
  ddl_ensure_table ("do this always", other41);
  ddl_ensure_table ("do this always", other42);
  ddl_ensure_table ("do this always", other43);
  ddl_ensure_table ("do this always", other44);
  ddl_ensure_table ("do this always", other45);
  ddl_ensure_table ("do this always", other46);
  ddl_ensure_table ("do this always", other47);
  ddl_ensure_table ("do this always", other48);
  ddl_ensure_table ("do this always", other49);
  ddl_ensure_table ("do this always", other50);
  ddl_ensure_table ("do this always", other51);
  ddl_ensure_table ("do this always", other52);
  ddl_ensure_table ("do this always", other53);
  ddl_ensure_table ("do this always", other54);
  ddl_ensure_table ("do this always", other55);
  ddl_ensure_table ("do this always", other56);
  ddl_ensure_table ("do this always", other57);
  ddl_ensure_table ("do this always", other58);
  ddl_ensure_table ("do this always", other59);
  ddl_ensure_table ("do this always", other60);
  ddl_ensure_table ("do this always", other61);
  ddl_ensure_table ("do this always", other62);
  ddl_ensure_table ("do this always", other63);
  ddl_ensure_table ("do this always", other64);
  ddl_ensure_table ("do this always", other65);
  ddl_ensure_table ("do this always", other66);
  ddl_ensure_table ("do this always", other67);
  ddl_ensure_table ("do this always", other68);
  ddl_ensure_table ("do this always", other69);
  ddl_ensure_table ("do this always", other70);
  ddl_ensure_table ("do this always", other71);
  ddl_ensure_table ("do this always", other72);
  ddl_ensure_table ("do this always", other73);
  ddl_ensure_table ("do this always", other74);
  ddl_ensure_table ("do this always", other75);
  ddl_ensure_table ("do this always", other76);
  ddl_ensure_table ("do this always", other77);
  ddl_ensure_table ("do this always", other78);
  ddl_ensure_table ("do this always", other79);
  ddl_ensure_table ("do this always", other80);
  ddl_ensure_table ("do this always", other81);
  ddl_ensure_table ("do this always", other82);
  ddl_ensure_table ("do this always", other83);
  ddl_ensure_table ("do this always", other84);
  ddl_ensure_table ("do this always", other85);
  ddl_ensure_table ("do this always", other86);
  ddl_ensure_table ("do this always", other87);
  ddl_ensure_table ("do this always", other88);
  ddl_ensure_table ("do this always", other89);
  ddl_ensure_table ("do this always", other90);
  ddl_ensure_table ("do this always", other91);
  ddl_ensure_table ("do this always", other92);
  ddl_ensure_table ("do this always", other93);
  ddl_ensure_table ("do this always", other94);
  ddl_ensure_table ("do this always", other95);
  ddl_ensure_table ("do this always", other96);
  ddl_ensure_table ("do this always", other97);
  ddl_ensure_table ("do this always", other98);
  ddl_ensure_table ("do this always", other99);
  ddl_ensure_table ("do this always", other100);
  ddl_ensure_table ("do this always", other101);
  ddl_ensure_table ("do this always", other102);
  ddl_ensure_table ("do this always", other103);
  ddl_ensure_table ("do this always", other104);
  ddl_ensure_table ("do this always", other105);
  ddl_ensure_table ("do this always", other106);
  ddl_ensure_table ("do this always", other107);
  ddl_ensure_table ("do this always", other108);
  ddl_ensure_table ("do this always", other109);
  ddl_ensure_table ("do this always", other110);
  ddl_ensure_table ("do this always", other111);
  ddl_ensure_table ("do this always", other112);
  ddl_ensure_table ("do this always", other113);
  ddl_ensure_table ("do this always", other114);
  ddl_ensure_table ("do this always", other115);
  ddl_ensure_table ("do this always", other116);
  ddl_ensure_table ("do this always", other117);
  ddl_ensure_table ("do this always", other118);
  ddl_ensure_table ("do this always", other119);
  ddl_ensure_table ("do this always", other120);
  ddl_ensure_table ("do this always", other121);
  ddl_ensure_table ("do this always", other122);
  ddl_ensure_table ("do this always", other123);
  ddl_ensure_table ("do this always", other124);
  ddl_ensure_table ("do this always", other125);
  ddl_ensure_table ("do this always", other126);
  ddl_ensure_table ("do this always", other127);
  ddl_ensure_table ("do this always", other128);
  ddl_ensure_table ("do this always", other129);
  ddl_ensure_table ("do this always", other130);
  ddl_ensure_table ("do this always", other131);
  ddl_ensure_table ("do this always", other132);
  ddl_ensure_table ("do this always", other133);
  ddl_ensure_table ("do this always", other134);
  ddl_ensure_table ("do this always", other135);
  ddl_ensure_table ("do this always", other136);
  ddl_ensure_table ("do this always", other137);
  ddl_ensure_table ("do this always", other138);
  ddl_ensure_table ("do this always", other139);
  ddl_ensure_table ("do this always", other140);
  ddl_ensure_table ("do this always", other141);
  ddl_ensure_table ("do this always", other142);
  ddl_ensure_table ("do this always", other143);
  ddl_ensure_table ("do this always", other144);
  ddl_ensure_table ("do this always", other145);
  ddl_ensure_table ("do this always", other146);
  ddl_ensure_table ("do this always", other147);
  ddl_ensure_table ("do this always", other148);
  ddl_ensure_table ("do this always", other149);
  ddl_ensure_table ("do this always", other150);
  ddl_ensure_table ("do this always", other151);
  ddl_ensure_table ("do this always", other152);
  ddl_ensure_table ("do this always", other153);
  ddl_ensure_table ("do this always", other154);
  ddl_ensure_table ("do this always", other155);
  ddl_ensure_table ("do this always", other156);
  ddl_ensure_table ("do this always", other157);
  ddl_ensure_table ("do this always", other158);
  ddl_ensure_table ("do this always", other159);
  ddl_ensure_table ("do this always", other160);
  ddl_ensure_table ("do this always", other161);
  ddl_ensure_table ("do this always", other162);
  ddl_ensure_table ("do this always", other163);
  ddl_ensure_table ("do this always", other164);
  ddl_ensure_table ("do this always", other165);
  ddl_ensure_table ("do this always", other166);
  ddl_ensure_table ("do this always", other167);
  ddl_ensure_table ("do this always", other168);
  ddl_ensure_table ("do this always", other169);
  ddl_ensure_table ("do this always", other170);
  ddl_ensure_table ("do this always", other171);
  ddl_ensure_table ("do this always", other172);
  ddl_ensure_table ("do this always", other173);
  ddl_ensure_table ("do this always", other174);
  ddl_ensure_table ("do this always", other175);
  ddl_ensure_table ("do this always", other176);
  ddl_ensure_table ("do this always", other177);
  ddl_ensure_table ("do this always", other178);
  ddl_ensure_table ("do this always", other179);
  DEFINE_PROC ("DB.DBA.DAV_PLAIN_SUBCOLS_P", proc12);
  DEFINE_PROC ("DB.DBA.DAV_PLAIN_SUBCOLS_P_INT", proc13);
  ddl_ensure_table ("DB.DBA.DAV_PLAIN_SUBCOLS", view6);
  DEFINE_PROC ("DB.DBA.DAV_PLAIN_SUBMOUNTS_P", proc14);
  DEFINE_PROC ("DB.DBA.DAV_PLAIN_SUBMOUNTS_P_INT", proc15);
  ddl_ensure_table ("DB.DBA.DAV_PLAIN_SUBMOUNTS", view7); 
  DEFINE_PUBLIC_PROC ("DB.DBA.DAV_DIR_P", proc16);
  ddl_ensure_table ("DB.DBA.DAV_DIR", view8);
  ddl_ensure_table ("do this always", other180);

  dk_free_box (bootstrap_cli->cli_qualifier);
  bootstrap_cli->cli_qualifier =  saved_qualifier;

  /* mail_cli.sql */

  ddl_ensure_table ("DB.DBA.MAIL_MESSAGE", tbl18);
  ddl_ensure_table ("DB.DBA.MAIL_ATTACHMENT", tbl19);
  ddl_std_proc (trig0, 0x0);
  ddl_std_proc (trig1, 0x0);
  ddl_std_proc (trig2, 0x0);
  DEFINE_PROC ("DB.DBA.MAIL_MESSAGE_MM_BODY_INDEX_HOOK", proc17);
  DEFINE_PROC ("DB.DBA.MAIL_MESSAGE_MM_BODY_UNINDEX_HOOK", proc18);
  DEFINE_PROC ("MM_FEED_PART", proc19);
  ddl_ensure_table ("do this always", other181);
  ddl_ensure_table ("do this always", other182);
  ddl_ensure_table ("DB.DBA.MAIL_PARTS", tbl20); 
  DEFINE_PUBLIC_PROC ("MIME_PART", proc20); 
  DEFINE_PUBLIC_PROC ("MIME_BODY", proc21);
  DEFINE_PROC ("NEW_MAIL", proc22);
  DEFINE_PROC ("MAIL_GET_NEXT_ID", proc23);
  DEFINE_PROC ("BARE_NEW_MAIL", proc24);
  DEFINE_PROC ("display_mime", proc25);

  /* admin_ddl.sql */

  ddl_ensure_table ("DB.DBA.ADMIN_SESSION", tbl21);
  ddl_ensure_table ("DB.DBA.ADM_XML_VIEWS", view9);
  ddl_ensure_table ("WS.WS.AUDIT_LOG", tbl22);

  /* vfsddk.sql */
  bootstrap_cli->cli_qualifier = box_string ("WS");

  ddl_ensure_table ("WS.WS.VFS_URL", tbl23);
  ddl_ensure_table ("WS.WS.VFS_QUEUE", tbl24);
  ddl_ensure_table ("WS.WS.VFS_SITE", tbl25);
  ddl_ensure_table ("WS.WS.VFS_SITE_RDF_MAP", tbl26);
  ddl_ensure_column ("WS.WS.VFS_SITE", "VS_DEPTH", alter0, 0);
  ddl_ensure_column ("WS.WS.VFS_QUEUE", "VQ_LEVEL", alter1, 0);

  dk_free_box (bootstrap_cli->cli_qualifier);
  bootstrap_cli->cli_qualifier =  saved_qualifier;

  /* virtual_dir.sql */

  ddl_ensure_table ("DB.DBA.HTTP_PATH", tbl27);
  ddl_ensure_table ("DB.DBA.HTTP_ACL", tbl28);
  ddl_ensure_column ("HTTP_ACL", "HA_LIMIT", alter2, 0);
  ddl_std_proc (trig3, 0x0);
  ddl_std_proc (trig4, 0x0);
  ddl_std_proc (trig5, 0x0);
  ddl_ensure_table ("DB.DBA.HTTP_PROXY_ACL", view10);
  ddl_ensure_table ("DB.DBA.NEWS_ACL", view11);
  ddl_ensure_table ("do this always", other183);
  ddl_ensure_table ("do this always", other184);
  ddl_ensure_table ("do this always", other185);
  ddl_ensure_table ("do this always", other186);
  ddl_ensure_table ("do this always", other187);
  ddl_ensure_table ("do this always", other188);
  ddl_ensure_table ("do this always", other189);
  ddl_ensure_table ("do this always", other190);
  ddl_ensure_table ("do this always", other191);
  ddl_ensure_table ("do this always", other192);
  ddl_ensure_table ("do this always", other193);
  ddl_ensure_table ("do this always", other194);
  ddl_ensure_table ("do this always", other195);
  ddl_ensure_table ("do this always", other196);
  DEFINE_PROC ("HTTP_SET_DBA_ADMIN", proc26);
  DEFINE_PROC ("DB.DBA.IS_EMPTY_OR_NULL", proc27);
  DEFINE_PROC ("INS_VIRTUAL_DIR", proc28);
  DEFINE_PROC ("DEL_VIRTUAL_DIR", proc29);
  DEFINE_PROC ("VHOST_DEFINE", proc30);
  DEFINE_PROC ("VHOST_MAP_RELOAD", proc31);
  DEFINE_PROC ("VHOST_REMOVE", proc32);
  DEFINE_PROC ("HTTP_PROXY_ACCESS", proc33);
  ddl_ensure_table ("WS.WS.SYS_RC_CACHE", tbl29);
  ddl_ensure_table ("WS.WS.SYS_CACHEABLE", tbl30);
  ddl_std_proc (trig6, 0x0);
  ddl_std_proc (trig7, 0x0);
  ddl_std_proc (trig8, 0x0);
  DEFINE_PROC ("WS.WS.HTTP_CACHE_CHECK", proc34);
  DEFINE_PROC ("WS.WS.HTTP_CACHE_STORE", proc35);
  DEFINE_PROC ("virt_proxy_init", proc36);
  DEFINE_PROC ("proxy_sp_html_error_page", proc37);
  DEFINE_PROC ("str_fmt", proc38);
  ddl_ensure_table ("DB.DBA.PROXY_SP_QRY", tbl31);
  DEFINE_PROC ("ext_http_proxy_exec_qry", proc39);
  DEFINE_PROC ("ext_http_proxy", proc40);
  DEFINE_PROC ("DB.DBA.VHOST_DUMP_SQL", proc41);
  DEFINE_PROC ("DB.DBA.HTTP_RDF_GET_ACCEPT_BY_Q", proc42);
  DEFINE_PROC ("DB.DBA.HTTP_RDF_ACCEPT", proc43);
  DEFINE_PROC ("WS.WS.DIR_INDEX_MAKE_XML", proc44);
  ddl_ensure_table ("do this always", other199);
  DEFINE_PROC ("WS.WS.DIR_INDEX_XML", proc45);
  DEFINE_PROC ("DB.DBA.SERVICES_WSIL", proc46);

  /* url_rewrite.sql */

  ddl_ensure_table ("DB.DBA.URL_REWRITE_RULE_LIST", tbl32);
  ddl_ensure_table ("DB.DBA.URL_REWRITE_RULE", tbl33);
  ddl_ensure_table ("DB.DBA.HTTP_VARIANT_MAP", tbl34);
  DEFINE_PROC ("DB.DBA.URLREWRITE_CREATE_RULE", proc47);
  DEFINE_PROC ("DB.DBA.URLREWRITE_CREATE_SPRINTF_RULE", proc48);
  DEFINE_PROC ("DB.DBA.URLREWRITE_CREATE_REGEX_RULE", proc49);
  DEFINE_PROC ("DB.DBA.URLREWRITE_DROP_RULE", proc50);
  DEFINE_PROC ("DB.DBA.URLREWRITE_CREATE_RULELIST", proc51);
  DEFINE_PROC ("DB.DBA.URLREWRITE_DROP_RULELIST", proc52);
  DEFINE_PROC ("DB.DBA.URLREWRITE_ENUMERATE_RULES", proc53);
  DEFINE_PROC ("DB.DBA.URLREWRITE_ENUMERATE_RULELISTS", proc54);
  DEFINE_PROC ("DB.DBA.URLREWRITE_VPRINTF", proc55);
  DEFINE_PROC ("DB.DBA.URLREWRITE_SPRINTF_RESULTS", proc56);
  DEFINE_PROC ("DB.DBA.URLREWRITE_APPLY_RECURSIVE", proc57);
  DEFINE_PROC ("DB.DBA.URLREWRITE_APPLY", proc58);
  DEFINE_PROC ("DB.DBA.URLREWRITE_TRY_INVERSE", proc59);
  DEFINE_PROC ("DB.DBA.HTTP_VARIANT_ADD", proc60);
  DEFINE_PROC ("DB.DBA.HTTP_VARIANT_REMOVE", proc61);
  DEFINE_PROC ("DB.DBA.URLREWRITE_CALC_QS", proc62);
  DEFINE_PROC ("DB.DBA.HTTP_URLREWRITE_TCN_LIST", proc63);
  DEFINE_PROC ("DB.DBA.HTTP_URLREWRITE_APPLY_PATTERN", proc64);
  DEFINE_PROC ("DB.DBA.HTTP_LOC_NEW_URL", proc65);
  DEFINE_PROC ("DB.DBA.URLREWRITE_APPLY_TCN", proc66);
  DEFINE_PROC ("DB.DBA.HTTP_URLREWRITE", proc67);
  DEFINE_PROC ("DB.DBA.URLREWRITE_DUMP_RULELIST_SQL", proc68);
  ddl_ensure_table ("do this always", other200);
  ddl_ensure_table ("do this always", other201);
}


void
sqls_arfw_define_ddk (void)
{
  /* virtual_dir.sql */

  ddl_ensure_table ("do this always", other197);
  ddl_ensure_table ("do this always", other198);

}
