/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.more;

import java.io.BufferedReader;
import org.jmol.adapter.readers.more.FFReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.adapter.smarter.Bond;
import org.jmol.api.JmolAdapter;

public class Mol2Reader
extends FFReader {
    private int nAtoms = 0;
    private int atomCount = 0;
    private boolean isPDB = false;
    private int lastSequenceNumber = Integer.MAX_VALUE;
    private char chainID = (char)64;

    public AtomSetCollection readAtomSetCollection(BufferedReader bufferedReader) {
        this.reader = bufferedReader;
        this.atomSetCollection = new AtomSetCollection("mol2");
        try {
            this.setUserAtomTypes();
            this.setFractionalCoordinates(false);
            this.readLine();
            this.modelNumber = 0;
            while (this.line != null) {
                if (this.line.equals("@<TRIPOS>MOLECULE") && this.doGetModel(++this.modelNumber)) {
                    this.processMolecule();
                    if (!this.isLastModel(this.modelNumber)) continue;
                    break;
                }
                this.readLine();
            }
        }
        catch (Exception exception) {
            return this.setError(exception);
        }
        return this.atomSetCollection;
    }

    private void processMolecule() throws Exception {
        boolean bl;
        this.isPDB = false;
        String string = this.readLineTrimmed();
        this.lastSequenceNumber = Integer.MAX_VALUE;
        this.chainID = (char)64;
        this.readLine();
        this.line = this.line + " 0 0 0 0 0 0";
        this.atomCount = this.parseInt(this.line);
        int n = this.parseInt();
        int n2 = this.parseInt();
        this.readLine();
        this.readLine();
        boolean bl2 = bl = this.line.indexOf("NO_CHARGES") != 0;
        if (this.readLine() != null && (this.line.length() == 0 || this.line.charAt(0) != '@') && this.readLine() != null && this.line.length() != 0 && this.line.charAt(0) != '@') {
            string = string + ": " + this.line.trim();
        }
        this.newAtomSet(string);
        while (this.line != null && !this.line.equals("@<TRIPOS>MOLECULE")) {
            if (this.line.equals("@<TRIPOS>ATOM")) {
                this.readAtoms(this.atomCount, bl);
                this.atomSetCollection.setAtomSetName(string);
            } else if (this.line.equals("@<TRIPOS>BOND")) {
                this.readBonds(n);
            } else if (this.line.equals("@<TRIPOS>SUBSTRUCTURE")) {
                this.readResInfo(n2);
            } else if (this.line.equals("@<TRIPOS>CRYSIN")) {
                this.readCrystalInfo();
            }
            this.readLine();
        }
        this.nAtoms += this.atomCount;
        if (this.isPDB) {
            this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("isPDB", Boolean.TRUE);
            this.atomSetCollection.setAtomSetAuxiliaryInfo("isPDB", Boolean.TRUE);
        }
        this.applySymmetryAndSetTrajectory();
    }

    private void readAtoms(int n, boolean bl) throws Exception {
        for (int i = 0; i < n; ++i) {
            boolean bl2;
            Atom atom = this.atomSetCollection.addNewAtom();
            String[] stringArray = AtomSetCollectionReader.getTokens(this.readLine());
            String string = stringArray[5];
            atom.atomName = stringArray[1] + '\u0000' + string;
            this.setAtomCoord(atom, this.parseFloat(stringArray[2]), this.parseFloat(stringArray[3]), this.parseFloat(stringArray[4]));
            boolean bl3 = bl2 = !this.getElementSymbol(atom, string);
            if (stringArray.length > 6) {
                atom.sequenceNumber = this.parseInt(stringArray[6]);
                if (atom.sequenceNumber < this.lastSequenceNumber) {
                    if (this.chainID == 'Z') {
                        this.chainID = (char)96;
                    }
                    this.chainID = (char)(this.chainID + '\u0001');
                }
                this.lastSequenceNumber = atom.sequenceNumber;
                atom.chainID = this.chainID;
            }
            if (stringArray.length > 7) {
                atom.group3 = stringArray[7];
                atom.isHetero = JmolAdapter.isHetero(atom.group3);
                if (!this.isPDB && atom.group3.length() <= 3 && JmolAdapter.lookupGroupID(atom.group3) >= 0) {
                    this.isPDB = true;
                }
                if (this.isPDB && bl2) {
                    atom.elementSymbol = AtomSetCollectionReader.deducePdbElementSymbol(atom.isHetero, string, atom.group3);
                }
            }
            if (stringArray.length <= 8) continue;
            atom.partialCharge = this.parseFloat(stringArray[8]);
        }
    }

    private void readBonds(int n) throws Exception {
        for (int i = 0; i < n; ++i) {
            String[] stringArray = AtomSetCollectionReader.getTokens(this.readLine());
            int n2 = this.parseInt(stringArray[1]);
            int n3 = this.parseInt(stringArray[2]);
            int n4 = this.parseInt(stringArray[3]);
            if (n4 == Integer.MIN_VALUE) {
                n4 = stringArray[3].equals("ar") ? 515 : 7;
            }
            this.atomSetCollection.addBond(new Bond(this.nAtoms + n2 - 1, this.nAtoms + n3 - 1, n4));
        }
    }

    private void readResInfo(int n) throws Exception {
        for (int i = 0; i < n; ++i) {
            this.readLine();
        }
    }

    private void readCrystalInfo() throws Exception {
        this.readLine();
        String[] stringArray = this.getTokens();
        if (stringArray.length < 6) {
            return;
        }
        for (int i = 0; i < 6; ++i) {
            this.setUnitCellItem(i, this.parseFloat(stringArray[i]));
        }
        String string = "";
        for (int i = 6; i < stringArray.length; ++i) {
            string = string + " " + stringArray[i];
        }
        string = string == "" ? " P1" : string + " *";
        string = string.substring(1);
        this.setSpaceGroupName(string);
        Atom[] atomArray = this.atomSetCollection.getAtoms();
        for (int i = 0; i < this.atomCount; ++i) {
            this.setAtomCoord(atomArray[this.nAtoms + i]);
        }
    }
}

