/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.quantum;

import java.util.BitSet;
import java.util.Hashtable;
import java.util.Vector;
import javax.vecmath.Point3f;
import org.jmol.api.MOCalculationInterface;
import org.jmol.api.VolumeDataInterface;
import org.jmol.quantum.QuantumCalculation;
import org.jmol.util.Logger;
import org.jmol.viewer.JmolConstants;

public class MOCalculation
extends QuantumCalculation
implements MOCalculationInterface {
    private static int MAX_GRID = 80;
    final float[] CX = new float[MAX_GRID];
    final float[] CY = new float[MAX_GRID];
    final float[] CZ = new float[MAX_GRID];
    final float[] DXY = new float[MAX_GRID];
    final float[] DXZ = new float[MAX_GRID];
    final float[] DYZ = new float[MAX_GRID];
    final float[] EX = new float[MAX_GRID];
    final float[] EY = new float[MAX_GRID];
    final float[] EZ = new float[MAX_GRID];
    private String calculationType;
    private Vector shells;
    private float[][] gaussians;
    private int[][] slaterInfo;
    private float[][] slaterData;
    private float[] moCoefficients;
    private int moCoeff;
    private int gaussianPtr;
    private int firstAtomOffset;
    private boolean isElectronDensity;
    private float occupancy = 2.0f;
    protected float[][][] voxelDataTemp;
    boolean as5D = false;
    private static final float ROOT3 = 1.7320508f;

    public void calculate(VolumeDataInterface volumeDataInterface, BitSet bitSet, String string, Point3f[] point3fArray, int n, Vector vector, float[][] fArray, Hashtable hashtable, int[][] nArray, float[][] fArray2, float[] fArray3, float[] fArray4) {
        this.calculationType = string;
        this.firstAtomOffset = n;
        this.shells = vector;
        this.gaussians = fArray;
        this.slaterInfo = nArray;
        this.slaterData = fArray2;
        this.moCoefficients = fArray3;
        this.isElectronDensity = fArray4 != null;
        int[] nArray2 = volumeDataInterface.getVoxelCounts();
        this.initialize(nArray2[0], nArray2[1], nArray2[2]);
        this.voxelData = volumeDataInterface.getVoxelData();
        this.voxelDataTemp = this.isElectronDensity ? new float[this.nX][this.nY][this.nZ] : this.voxelData;
        this.setupCoordinates(volumeDataInterface.getOriginFloat(), volumeDataInterface.getVolumetricVectorLengths(), bitSet, point3fArray);
        this.atomIndex = n - 1;
        this.doDebug = Logger.debugging;
        if (nArray != null) {
            this.createSlaterCube();
        } else {
            this.createGaussianCube();
        }
    }

    public void calculateElectronDensity(float[] fArray) {
        float f = 0.0f;
        int n = this.nX;
        while (--n >= 0) {
            int n2 = this.nY;
            while (--n2 >= 0) {
                int n3 = this.nZ;
                while (--n3 >= 0) {
                    f += this.voxelData[n][n2][n3];
                }
            }
        }
        float f2 = this.stepBohr[0] * this.stepBohr[1] * this.stepBohr[2] / 1.8897161f / 1.8897161f / 1.8897161f;
        System.out.println("MOCalculation " + (f *= f2));
    }

    private void createSlaterCube() {
        this.moCoeff = 0;
        int n = this.slaterInfo.length;
        for (int i = 0; i < n; ++i) {
            this.processSlater(i);
        }
    }

    private void createGaussianCube() {
        if (!this.checkCalculationType()) {
            return;
        }
        this.check5D();
        int n = this.shells.size();
        this.moCoeff = 0;
        for (int i = 0; i < n; ++i) {
            this.processShell(i);
            if (!this.doDebug) continue;
            Logger.debug("createGaussianCube shell=" + i + " moCoeff=" + this.moCoeff + "/" + this.moCoefficients.length);
        }
    }

    private void check5D() {
        int n = this.shells.size();
        this.moCoeff = 0;
        this.thisAtom = null;
        for (int i = 0; i < n; ++i) {
            int[] nArray = (int[])this.shells.get(i);
            int n2 = nArray[1];
            this.gaussianPtr = nArray[2];
            int n3 = nArray[3];
            this.addData(n2, n3);
        }
        boolean bl = this.as5D = this.moCoeff > this.moCoefficients.length;
        if (this.as5D) {
            Logger.info("MO calculation is assuming spherical (5D,7F) orbitals");
        }
    }

    private boolean checkCalculationType() {
        if (this.calculationType == null) {
            Logger.warn("calculation type not identified -- continuing");
            return true;
        }
        if (this.calculationType.indexOf("+") >= 0 || this.calculationType.indexOf("*") >= 0) {
            Logger.warn("polarization/diffuse wavefunctions have not been tested fully: " + this.calculationType + " -- continuing");
        }
        if (this.calculationType.indexOf("?") >= 0) {
            Logger.warn("unknown calculation type may not render correctly -- continuing");
        } else {
            Logger.info("calculation type: " + this.calculationType + " OK.");
        }
        return true;
    }

    private void processShell(int n) {
        int n2 = this.atomIndex;
        int[] nArray = (int[])this.shells.get(n);
        this.atomIndex = nArray[0] + this.firstAtomOffset;
        int n3 = nArray[1];
        this.gaussianPtr = nArray[2];
        int n4 = nArray[3];
        if (this.doDebug) {
            Logger.debug("processShell: " + n + " type=" + JmolConstants.getQuantumShellTag(n3) + " nGaussians=" + n4 + " atom=" + this.atomIndex);
        }
        if (this.atomIndex != n2 && (this.thisAtom = this.qmAtoms[this.atomIndex]) != null) {
            this.thisAtom.setXYZ(true);
        }
        this.addData(n3, n4);
    }

    private void addData(int n, int n2) {
        switch (n) {
            case 0: {
                this.addDataS(n2);
                break;
            }
            case 1: {
                this.addDataP(n2);
                break;
            }
            case 2: {
                this.addDataSP(n2);
                break;
            }
            case 3: {
                if (this.as5D) {
                    this.addData5D(n2);
                    break;
                }
                this.addData6D(n2);
                break;
            }
            case 4: {
                this.addData5D(n2);
                break;
            }
            case 5: {
                if (this.as5D) {
                    this.addData7F(n2);
                    break;
                }
                this.addData10F(n2);
                break;
            }
            case 6: {
                this.addData7F(n2);
                break;
            }
            default: {
                Logger.warn(" Unsupported basis type for atomno=" + (this.atomIndex + 1) + " -- use \"set loglevel 5\" to debug.");
            }
        }
    }

    private void setTemp() {
        int n = this.xMax;
        while (--n >= this.xMin) {
            int n2 = this.yMax;
            while (--n2 >= this.yMin) {
                int n3 = this.zMax;
                while (--n3 >= this.zMin) {
                    float f = this.voxelDataTemp[n][n2][n3];
                    float[] fArray = this.voxelData[n][n2];
                    int n4 = n3;
                    fArray[n4] = fArray[n4] + f * f * this.occupancy;
                    this.voxelDataTemp[n][n2][n3] = 0.0f;
                }
            }
        }
    }

    private void addDataS(int n) {
        if (this.thisAtom == null) {
            ++this.moCoeff;
            return;
        }
        if (this.doDebug) {
            this.dumpInfo(n, "S ");
        }
        float f = this.moCoefficients[this.moCoeff++];
        for (int i = 0; i < n; ++i) {
            float f2 = this.gaussians[this.gaussianPtr + i][0];
            float f3 = this.gaussians[this.gaussianPtr + i][1];
            float f4 = f * f3 * (float)Math.pow(f2, 0.75) * 0.7127055f;
            int n2 = this.xMax;
            while (--n2 >= this.xMin) {
                this.EX[n2] = f4 * (float)Math.exp(-this.X2[n2] * f2);
            }
            n2 = this.yMax;
            while (--n2 >= this.yMin) {
                this.EY[n2] = (float)Math.exp(-this.Y2[n2] * f2);
            }
            n2 = this.zMax;
            while (--n2 >= this.zMin) {
                this.EZ[n2] = (float)Math.exp(-this.Z2[n2] * f2);
            }
            n2 = this.xMax;
            while (--n2 >= this.xMin) {
                float f5 = this.EX[n2];
                int n3 = this.yMax;
                while (--n3 >= this.yMin) {
                    float f6 = f5 * this.EY[n3];
                    int n4 = this.zMax;
                    while (--n4 >= this.zMin) {
                        float[] fArray = this.voxelDataTemp[n2][n3];
                        int n5 = n4;
                        fArray[n5] = fArray[n5] + f6 * this.EZ[n4];
                    }
                }
            }
        }
        if (this.isElectronDensity) {
            this.setTemp();
        }
    }

    private void addDataP(int n) {
        if (this.thisAtom == null) {
            this.moCoeff += 3;
            return;
        }
        if (this.doDebug) {
            this.dumpInfo(n, "X Y Z ");
        }
        float f = this.moCoefficients[this.moCoeff++];
        float f2 = this.moCoefficients[this.moCoeff++];
        float f3 = this.moCoefficients[this.moCoeff++];
        if (this.isElectronDensity) {
            float f4;
            float f5;
            float f6;
            int n2;
            for (n2 = 0; n2 < n; ++n2) {
                f6 = this.gaussians[this.gaussianPtr + n2][0];
                f5 = this.gaussians[this.gaussianPtr + n2][1];
                f4 = f5 * (float)Math.pow(f6, 1.25) * 1.425411f;
                this.calcSP(f6, 0.0f, f4 * f, 0.0f, 0.0f);
            }
            this.setTemp();
            for (n2 = 0; n2 < n; ++n2) {
                f6 = this.gaussians[this.gaussianPtr + n2][0];
                f5 = this.gaussians[this.gaussianPtr + n2][1];
                f4 = f5 * (float)Math.pow(f6, 1.25) * 1.425411f;
                this.calcSP(f6, 0.0f, 0.0f, f4 * f2, 0.0f);
            }
            this.setTemp();
            for (n2 = 0; n2 < n; ++n2) {
                f6 = this.gaussians[this.gaussianPtr + n2][0];
                f5 = this.gaussians[this.gaussianPtr + n2][1];
                f4 = f5 * (float)Math.pow(f6, 1.25) * 1.425411f;
                this.calcSP(f6, 0.0f, 0.0f, 0.0f, f4 * f3);
            }
            this.setTemp();
        } else {
            for (int i = 0; i < n; ++i) {
                float f7 = this.gaussians[this.gaussianPtr + i][0];
                float f8 = this.gaussians[this.gaussianPtr + i][1];
                float f9 = f8 * (float)Math.pow(f7, 1.25) * 1.425411f;
                this.calcSP(f7, 0.0f, f9 * f, f9 * f2, f9 * f3);
            }
        }
    }

    private void addDataSP(int n) {
        float f = this.gaussians[this.gaussianPtr][1];
        if (this.thisAtom == null) {
            this.moCoeff += f == 0.0f ? 3 : 4;
            return;
        }
        if (this.doDebug) {
            this.dumpInfo(n, f == 0.0f ? "X Y Z " : "S X Y Z ");
        }
        float f2 = f == 0.0f ? 0.0f : this.moCoefficients[this.moCoeff++];
        float f3 = this.moCoefficients[this.moCoeff++];
        float f4 = this.moCoefficients[this.moCoeff++];
        float f5 = this.moCoefficients[this.moCoeff++];
        if (this.isElectronDensity) {
            float f6;
            float f7;
            float f8;
            int n2;
            for (n2 = 0; n2 < n; ++n2) {
                f8 = this.gaussians[this.gaussianPtr + n2][0];
                f = this.gaussians[this.gaussianPtr + n2][1];
                f7 = f * (float)Math.pow(f8, 0.75) * 0.7127055f;
                this.calcSP(f8, f7 * f2, 0.0f, 0.0f, 0.0f);
            }
            this.setTemp();
            for (n2 = 0; n2 < n; ++n2) {
                f8 = this.gaussians[this.gaussianPtr + n2][0];
                f7 = this.gaussians[this.gaussianPtr + n2][2];
                f6 = f7 * (float)Math.pow(f8, 1.25) * 1.425411f;
                this.calcSP(f8, 0.0f, f6 * f3, 0.0f, 0.0f);
            }
            this.setTemp();
            for (n2 = 0; n2 < n; ++n2) {
                f8 = this.gaussians[this.gaussianPtr + n2][0];
                f7 = this.gaussians[this.gaussianPtr + n2][2];
                f6 = f7 * (float)Math.pow(f8, 1.25) * 1.425411f;
                this.calcSP(f8, 0.0f, 0.0f, f6 * f4, 0.0f);
            }
            this.setTemp();
            for (n2 = 0; n2 < n; ++n2) {
                f8 = this.gaussians[this.gaussianPtr + n2][0];
                f7 = this.gaussians[this.gaussianPtr + n2][2];
                f6 = f7 * (float)Math.pow(f8, 1.25) * 1.425411f;
                this.calcSP(f8, 0.0f, 0.0f, 0.0f, f6 * f5);
            }
            this.setTemp();
        } else {
            for (int i = 0; i < n; ++i) {
                float f9 = this.gaussians[this.gaussianPtr + i][0];
                f = this.gaussians[this.gaussianPtr + i][1];
                float f10 = this.gaussians[this.gaussianPtr + i][2];
                float f11 = f * (float)Math.pow(f9, 0.75) * 0.7127055f;
                float f12 = f10 * (float)Math.pow(f9, 1.25) * 1.425411f;
                this.calcSP(f9, f11 * f2, f12 * f3, f12 * f4, f12 * f5);
            }
        }
    }

    private void setCE(float[] fArray, float[] fArray2, float f, float f2, float f3, float f4, float f5) {
        int n = this.xMax;
        while (--n >= this.xMin) {
            fArray[n] = f2 + f3 * this.X[n];
            fArray2[n] = (float)Math.exp(-this.X2[n] * f);
        }
        n = this.yMax;
        while (--n >= this.yMin) {
            this.CY[n] = f4 * this.Y[n];
            this.EY[n] = (float)Math.exp(-this.Y2[n] * f);
        }
        n = this.zMax;
        while (--n >= this.zMin) {
            this.CZ[n] = f5 * this.Z[n];
            this.EZ[n] = (float)Math.exp(-this.Z2[n] * f);
        }
    }

    private void setE(float[] fArray, float f) {
        int n = this.xMax;
        while (--n >= this.xMin) {
            fArray[n] = (float)Math.exp(-this.X2[n] * f);
        }
        n = this.yMax;
        while (--n >= this.yMin) {
            this.EY[n] = (float)Math.exp(-this.Y2[n] * f);
        }
        n = this.zMax;
        while (--n >= this.zMin) {
            this.EZ[n] = (float)Math.exp(-this.Z2[n] * f);
        }
    }

    private void calcSP(float f, float f2, float f3, float f4, float f5) {
        this.setCE(this.CX, this.EX, f, f2, f3, f4, f5);
        int n = this.xMax;
        while (--n >= this.xMin) {
            float f6 = this.EX[n];
            float f7 = this.CX[n];
            int n2 = this.yMax;
            while (--n2 >= this.yMin) {
                float f8 = f6 * this.EY[n2];
                float f9 = f7 + this.CY[n2];
                int n3 = this.zMax;
                while (--n3 >= this.zMin) {
                    float[] fArray = this.voxelDataTemp[n][n2];
                    int n4 = n3;
                    fArray[n4] = fArray[n4] + (f9 + this.CZ[n3]) * f8 * this.EZ[n3];
                }
            }
        }
    }

    private void addData6D(int n) {
        if (this.thisAtom == null || this.isElectronDensity) {
            this.moCoeff += 6;
            return;
        }
        if (this.doDebug) {
            this.dumpInfo(n, "XXYYZZXYXZYZ");
        }
        float f = this.moCoefficients[this.moCoeff++];
        float f2 = this.moCoefficients[this.moCoeff++];
        float f3 = this.moCoefficients[this.moCoeff++];
        float f4 = this.moCoefficients[this.moCoeff++];
        float f5 = this.moCoefficients[this.moCoeff++];
        float f6 = this.moCoefficients[this.moCoeff++];
        for (int i = 0; i < n; ++i) {
            float f7 = this.gaussians[this.gaussianPtr + i][0];
            float f8 = this.gaussians[this.gaussianPtr + i][1];
            float f9 = f8 * (float)Math.pow(f7, 1.75) * 2.850822f;
            float f10 = f9 / 1.7320508f * f;
            float f11 = f9 / 1.7320508f * f2;
            float f12 = f9 / 1.7320508f * f3;
            float f13 = f9 * f4;
            float f14 = f9 * f5;
            float f15 = f9 * f6;
            this.setCE(this.CX, this.EX, f7, 0.0f, f10, f11, f12);
            int n2 = this.xMax;
            while (--n2 >= this.xMin) {
                this.DXY[n2] = f13 * this.X[n2];
                this.DXZ[n2] = f14 * this.X[n2];
            }
            n2 = this.yMax;
            while (--n2 >= this.yMin) {
                this.DYZ[n2] = f15 * this.Y[n2];
            }
            n2 = this.xMax;
            while (--n2 >= this.xMin) {
                float f16 = this.CX[n2] * this.X[n2];
                float f17 = this.DXY[n2];
                float f18 = this.DXZ[n2];
                float f19 = this.EX[n2];
                int n3 = this.yMax;
                while (--n3 >= this.yMin) {
                    float f20 = f16 + (this.CY[n3] + f17) * this.Y[n3];
                    float f21 = f18 + this.DYZ[n3];
                    float f22 = f19 * this.EY[n3];
                    int n4 = this.zMax;
                    while (--n4 >= this.zMin) {
                        float[] fArray = this.voxelDataTemp[n2][n3];
                        int n5 = n4;
                        fArray[n5] = fArray[n5] + (f20 + (this.CZ[n4] + f21) * this.Z[n4]) * f22 * this.EZ[n4];
                    }
                }
            }
        }
    }

    private void addData5D(int n) {
        if (this.thisAtom == null || this.isElectronDensity) {
            this.moCoeff += 5;
            return;
        }
        if (this.doDebug) {
            this.dumpInfo(n, 4);
        }
        float f = (float)Math.pow(66.05114251919257, 0.25);
        float f2 = (float)((double)f / Math.sqrt(3.0));
        float f3 = (float)Math.sqrt(0.75);
        float f4 = this.moCoefficients[this.moCoeff++];
        float f5 = this.moCoefficients[this.moCoeff++];
        float f6 = this.moCoefficients[this.moCoeff++];
        float f7 = this.moCoefficients[this.moCoeff++];
        float f8 = this.moCoefficients[this.moCoeff++];
        for (int i = 0; i < n; ++i) {
            float f9 = this.gaussians[this.gaussianPtr + i][0];
            float f10 = this.gaussians[this.gaussianPtr + i][1];
            float f11 = f10 * (float)Math.pow(f9, 1.75);
            float f12 = f11 * f4;
            float f13 = f11 * f5;
            float f14 = f11 * f6;
            float f15 = f11 * f7;
            float f16 = f11 * f8;
            this.setE(this.EX, f9);
            int n2 = this.xMax;
            while (--n2 >= this.xMin) {
                float f17 = this.X[n2];
                float f18 = this.EX[n2];
                float f19 = f2 * f17 * f17;
                int n3 = this.yMax;
                while (--n3 >= this.yMin) {
                    float f20 = this.Y[n3];
                    float f21 = f18 * this.EY[n3];
                    float f22 = f2 * f20 * f20;
                    float f23 = f * f17 * f20;
                    int n4 = this.zMax;
                    while (--n4 >= this.zMin) {
                        float f24 = this.Z[n4];
                        float f25 = f2 * f24 * f24;
                        float f26 = f * f17 * f24;
                        float f27 = f * f20 * f24;
                        float[] fArray = this.voxelDataTemp[n2][n3];
                        int n5 = n4;
                        fArray[n5] = fArray[n5] + (f12 * (f25 - 0.5f * (f19 + f22)) + f13 * f26 + f14 * f27 + f15 * f3 * (f19 - f22) + f16 * f23) * f21 * this.EZ[n4];
                    }
                }
            }
        }
    }

    private void addData10F(int n) {
        if (this.thisAtom == null || this.isElectronDensity) {
            this.moCoeff += 10;
            return;
        }
        if (this.doDebug) {
            this.dumpInfo(n, 5);
        }
        float f = (float)Math.pow(1056.818280307081, 0.25);
        float f2 = (float)((double)f / Math.sqrt(3.0));
        float f3 = (float)((double)f / Math.sqrt(15.0));
        float f4 = this.moCoefficients[this.moCoeff++];
        float f5 = this.moCoefficients[this.moCoeff++];
        float f6 = this.moCoefficients[this.moCoeff++];
        float f7 = this.moCoefficients[this.moCoeff++];
        float f8 = this.moCoefficients[this.moCoeff++];
        float f9 = this.moCoefficients[this.moCoeff++];
        float f10 = this.moCoefficients[this.moCoeff++];
        float f11 = this.moCoefficients[this.moCoeff++];
        float f12 = this.moCoefficients[this.moCoeff++];
        float f13 = this.moCoefficients[this.moCoeff++];
        for (int i = 0; i < n; ++i) {
            float f14 = this.gaussians[this.gaussianPtr + i][0];
            float f15 = this.gaussians[this.gaussianPtr + i][1];
            this.setE(this.EX, f14);
            float f16 = f15 * (float)Math.pow(f14, 2.25);
            float f17 = f16 * f3 * f4;
            float f18 = f16 * f3 * f5;
            float f19 = f16 * f3 * f6;
            float f20 = f16 * f2 * f7;
            float f21 = f16 * f2 * f8;
            float f22 = f16 * f2 * f9;
            float f23 = f16 * f2 * f10;
            float f24 = f16 * f2 * f11;
            float f25 = f16 * f2 * f12;
            float f26 = f16 * f * f13;
            int n2 = this.xMax;
            while (--n2 >= this.xMin) {
                float f27 = this.X[n2];
                float f28 = f27 * f27;
                float f29 = this.EX[n2];
                float f30 = f17 * f28 * f27;
                int n3 = this.yMax;
                while (--n3 >= this.yMin) {
                    float f31 = this.Y[n3];
                    float f32 = f31 * f31;
                    float f33 = f29 * this.EY[n3];
                    float f34 = f18 * f32 * f31;
                    float f35 = f21 * f28 * f31;
                    float f36 = f20 * f27 * f32;
                    int n4 = this.zMax;
                    while (--n4 >= this.zMin) {
                        float f37 = this.Z[n4];
                        float f38 = f37 * f37;
                        float f39 = f19 * f38 * f37;
                        float f40 = f22 * f28 * f37;
                        float f41 = f23 * f27 * f38;
                        float f42 = f25 * f32 * f37;
                        float f43 = f24 * f31 * f38;
                        float f44 = f26 * f27 * f31 * f37;
                        float[] fArray = this.voxelDataTemp[n2][n3];
                        int n5 = n4;
                        fArray[n5] = fArray[n5] + (f30 + f34 + f39 + f36 + f35 + f40 + f41 + f43 + f42 + f44) * f33 * this.EZ[n4];
                    }
                }
            }
        }
    }

    private void addData7F(int n) {
        if (this.thisAtom == null || this.isElectronDensity) {
            this.moCoeff += 7;
            return;
        }
        if (this.doDebug) {
            this.dumpInfo(n, 6);
        }
        float f = (float)Math.pow(1056.818280307081, 0.25);
        float f2 = (float)((double)f / Math.sqrt(3.0));
        float f3 = (float)((double)f / Math.sqrt(15.0));
        float f4 = (float)(3.0 / (2.0 * Math.sqrt(5.0)));
        float f5 = (float)Math.sqrt(1.2);
        float f6 = (float)Math.sqrt(0.375);
        float f7 = (float)Math.sqrt(0.075);
        float f8 = f5;
        float f9 = f6;
        float f10 = f7;
        float f11 = (float)Math.sqrt(0.75);
        float f12 = (float)Math.sqrt(0.625);
        float f13 = 0.75f * (float)Math.sqrt(2.0);
        float f14 = f12;
        float f15 = f13;
        float f16 = this.moCoefficients[this.moCoeff++];
        float f17 = this.moCoefficients[this.moCoeff++];
        float f18 = this.moCoefficients[this.moCoeff++];
        float f19 = this.moCoefficients[this.moCoeff++];
        float f20 = this.moCoefficients[this.moCoeff++];
        float f21 = this.moCoefficients[this.moCoeff++];
        float f22 = this.moCoefficients[this.moCoeff++];
        for (int i = 0; i < n; ++i) {
            float f23 = this.gaussians[this.gaussianPtr + i][0];
            float f24 = this.gaussians[this.gaussianPtr + i][1];
            float f25 = f24 * (float)Math.pow(f23, 2.25);
            float f26 = f25 * f16;
            float f27 = f25 * f17;
            float f28 = f25 * f18;
            float f29 = f25 * f19;
            float f30 = f25 * f20;
            float f31 = f25 * f21;
            float f32 = f25 * f22;
            this.setE(this.EX, f23);
            int n2 = this.xMax;
            while (--n2 >= this.xMin) {
                float f33 = this.X[n2];
                float f34 = f33 * f33;
                float f35 = this.EX[n2];
                float f36 = f3 * f33 * f34;
                int n3 = this.yMax;
                while (--n3 >= this.yMin) {
                    float f37 = this.Y[n3];
                    float f38 = f37 * f37;
                    float f39 = f35 * this.EY[n3];
                    float f40 = f3 * f37 * f38;
                    float f41 = f2 * f33 * f38;
                    float f42 = f2 * f34 * f37;
                    int n4 = this.zMax;
                    while (--n4 >= this.zMin) {
                        float f43 = this.Z[n4];
                        float f44 = f43 * f43;
                        float f45 = f3 * f43 * f44;
                        float f46 = f2 * f34 * f43;
                        float f47 = f2 * f33 * f44;
                        float f48 = f2 * f38 * f43;
                        float f49 = f2 * f37 * f44;
                        float f50 = f * f33 * f37 * f43;
                        float f51 = f26 * (f45 - f4 * (f46 + f48));
                        float f52 = f27 * (f5 * f47 - f6 * f36 - f7 * f41);
                        float f53 = f28 * (f8 * f49 - f9 * f40 - f10 * f42);
                        float f54 = f29 * (f11 * (f46 - f48));
                        float f55 = f30 * f50;
                        float f56 = f31 * (f12 * f36 - f13 * f41);
                        float f57 = f32 * (-f14 * f40 + f15 * f42);
                        float[] fArray = this.voxelDataTemp[n2][n3];
                        int n5 = n4;
                        fArray[n5] = fArray[n5] + (f51 + f52 + f53 + f54 + f55 + f56 + f57) * f39 * this.EZ[n4];
                    }
                }
            }
        }
    }

    private void processSlater(int n) {
        float f;
        int n2 = this.atomIndex;
        this.atomIndex = this.slaterInfo[n][0];
        float f2 = -this.slaterData[n][0];
        this.thisAtom = this.qmAtoms[this.atomIndex];
        if (this.thisAtom == null) {
            if (f2 <= 0.0f) {
                ++this.moCoeff;
            }
            return;
        }
        if (this.atomIndex != n2) {
            this.thisAtom.setXYZ(true);
        }
        int n3 = this.slaterInfo[n][1];
        int n4 = this.slaterInfo[n][2];
        int n5 = this.slaterInfo[n][3];
        int n6 = this.slaterInfo[n][4];
        if (f2 > 0.0f) {
            f2 = -f2;
            --this.moCoeff;
        }
        if ((f = this.slaterData[n][1] * this.moCoefficients[this.moCoeff++]) == 0.0f) {
            return;
        }
        if (n3 == -2 || n4 == -2) {
            int n7 = this.xMax;
            while (--n7 >= this.xMin) {
                float f3 = this.X2[n7];
                int n8 = this.yMax;
                while (--n8 >= this.yMin) {
                    float f4 = this.Y2[n8];
                    int n9 = this.zMax;
                    while (--n9 >= this.zMin) {
                        float f5 = this.Z2[n9];
                        float f6 = (float)Math.sqrt(f3 + f4 + f5);
                        float f7 = f * (float)Math.exp(f2 * f6) * ((n3 == -2 ? 2.0f * f5 - f3 : f3) - f4);
                        int n10 = n6;
                        while (--n10 >= 0) {
                            f7 *= f6;
                        }
                        float[] fArray = this.voxelDataTemp[n7][n8];
                        int n11 = n9;
                        fArray[n11] = fArray[n11] + f7;
                    }
                }
            }
        } else {
            int n12 = this.xMax;
            while (--n12 >= this.xMin) {
                float f8 = this.X[n12];
                int n13 = this.yMax;
                while (--n13 >= this.yMin) {
                    float f9 = this.Y[n13];
                    int n14 = this.zMax;
                    while (--n14 >= this.zMin) {
                        float f10 = this.Z[n14];
                        float f11 = (float)Math.sqrt(f8 * f8 + f9 * f9 + f10 * f10);
                        float f12 = f * (float)Math.exp(f2 * f11);
                        int n15 = n3;
                        while (--n15 >= 0) {
                            f12 *= f8;
                        }
                        n15 = n4;
                        while (--n15 >= 0) {
                            f12 *= f9;
                        }
                        n15 = n5;
                        while (--n15 >= 0) {
                            f12 *= f10;
                        }
                        n15 = n6;
                        while (--n15 >= 0) {
                            f12 *= f11;
                        }
                        float[] fArray = this.voxelDataTemp[n12][n13];
                        int n16 = n14;
                        fArray[n16] = fArray[n16] + f12;
                    }
                }
            }
        }
        if (this.isElectronDensity) {
            this.setTemp();
        }
    }

    private void dumpInfo(int n, String string) {
        int n2;
        for (n2 = 0; n2 < n; ++n2) {
            float f = this.gaussians[this.gaussianPtr + n2][0];
            float f2 = this.gaussians[this.gaussianPtr + n2][1];
            if (!Logger.debugging) continue;
            Logger.debug("Gaussian " + (n2 + 1) + " alpha=" + f + " c=" + f2);
        }
        n2 = string.length() / 2;
        if (Logger.debugging) {
            for (int i = 0; i < n2; ++i) {
                Logger.debug("MO coeff " + string.substring(2 * i, 2 * i + 2) + " " + (this.moCoeff + i + 1) + " " + this.moCoefficients[this.moCoeff + i]);
            }
        }
    }

    private void dumpInfo(int n, int n2) {
        for (int i = 0; i < n; ++i) {
            float f = this.gaussians[this.gaussianPtr + i][0];
            float f2 = this.gaussians[this.gaussianPtr + i][1];
            Logger.debug("Gaussian " + (i + 1) + " alpha=" + f + " c=" + f2);
        }
        if (n2 >= 0 && Logger.debugging) {
            String[] stringArray = JmolConstants.getShellOrder(n2);
            for (int i = 0; i < stringArray.length; ++i) {
                Logger.debug("MO coeff " + stringArray[i] + " " + (this.moCoeff + i + 1) + " " + this.moCoefficients[this.moCoeff + i]);
            }
        }
    }
}

