/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shape;

import java.util.BitSet;
import javax.vecmath.Point3f;
import org.jmol.g3d.Graphics3D;
import org.jmol.shape.Mesh;
import org.jmol.shape.Shape;
import org.jmol.util.ArrayUtil;
import org.jmol.util.BitSetUtil;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.TextFormat;
import org.jmol.viewer.Token;

public abstract class MeshCollection
extends Shape {
    public int meshCount;
    public Mesh[] meshes = new Mesh[4];
    public Mesh currentMesh;
    public int modelCount;
    public boolean isFixed;
    public String script;
    public int nUnnamed;
    public short colix;
    public String myType;
    public boolean explicitID;
    protected String previousMeshID;
    protected Mesh linkedMesh;
    protected boolean iHaveModelIndex;
    protected int modelIndex;
    protected boolean allowContourLines;
    protected boolean haveContours = false;
    public String[] title;
    protected boolean allowMesh = true;

    private Mesh setMesh(String string) {
        this.linkedMesh = null;
        if (string == null || TextFormat.isWild(string)) {
            this.currentMesh = null;
            return null;
        }
        int n = this.getIndexFromName(string);
        if (n >= 0) {
            this.currentMesh = this.meshes[n];
            if (string.equals("+PREVIOUS_MESH+")) {
                this.linkedMesh = this.currentMesh.linkedMesh;
            }
        } else {
            this.allocMesh(string);
        }
        if (this.currentMesh.thisID == null) {
            this.currentMesh.thisID = this.myType + ++this.nUnnamed;
        }
        this.previousMeshID = this.currentMesh.thisID;
        return this.currentMesh;
    }

    public void allocMesh(String string) {
        this.meshes = (Mesh[])ArrayUtil.ensureLength(this.meshes, this.meshCount + 1);
        Mesh mesh = new Mesh(string, this.g3d, this.colix);
        this.meshes[this.meshCount++] = mesh;
        this.currentMesh = mesh;
        this.previousMeshID = null;
    }

    public void initShape() {
        super.initShape();
        this.colix = (short)5;
        this.modelCount = this.viewer.getModelCount();
    }

    public void setProperty(String string, Object object, BitSet bitSet) {
        if (Logger.debugging) {
            Logger.debug("MeshCollection.setProperty(" + string + "," + (object == null ? "null" : (string == "token" ? Token.nameOf((Integer)object) : object.toString())) + ")");
        }
        if ("init" == string) {
            this.title = null;
            return;
        }
        if ("link" == string) {
            if (this.meshCount >= 2 && this.currentMesh != null) {
                this.currentMesh.linkedMesh = this.meshes[this.meshCount - 2];
            }
            return;
        }
        if ("commandOption" == string) {
            String string2 = "# " + (String)object;
            if (this.script.indexOf(string2) < 0) {
                this.script = this.script + " " + string2;
            }
            return;
        }
        if ("thisID" == string) {
            String string3 = (String)object;
            this.setMesh(string3);
            boolean bl = this.explicitID = string3 != null && !string3.equals("+PREVIOUS_MESH+");
            if (this.explicitID) {
                this.previousMeshID = string3;
            }
            return;
        }
        if ("title" == string) {
            if (object == null) {
                this.title = null;
            } else if (object instanceof String[]) {
                this.title = (String[])object;
            } else {
                int n = 1;
                String string4 = (String)object;
                int n2 = string4.length();
                while (--n2 >= 0) {
                    if (string4.charAt(n2) != '|') continue;
                    ++n;
                }
                this.title = new String[n];
                n = 0;
                n2 = -1;
                for (int i = 0; i < string4.length(); ++i) {
                    if (string4.charAt(i) != '|') continue;
                    this.title[n++] = string4.substring(n2 + 1, i);
                    n2 = i;
                }
                this.title[n] = string4.substring(n2 + 1);
            }
            return;
        }
        if ("delete" == string) {
            this.deleteMesh();
            return;
        }
        if ("reset" == string) {
            String string5 = (String)object;
            if (this.setMesh(string5) == null) {
                return;
            }
            this.setMesh(string5);
            return;
        }
        if ("color" == string) {
            if (object == null) {
                return;
            }
            this.colix = Graphics3D.getColix(object);
            this.setProperty(141562115, false);
            return;
        }
        if ("translucency" == string) {
            this.setProperty(67108927, ((String)object).equals("translucent"));
            return;
        }
        if ("hidden" == string) {
            object = new Integer((Boolean)object != false ? 0x100010 : 0x100011);
            string = "token";
        }
        if ("token" == string) {
            int n = (Integer)object;
            int n3 = 0;
            boolean bl = true;
            switch (n) {
                case 528399: 
                case 0x100011: 
                case 0x4000006: 
                case 0x4000010: 
                case 67108883: 
                case 0x4000014: 
                case 67108885: 
                case 0x4000040: {
                    break;
                }
                case 0x100010: {
                    bl = false;
                    n = 0x100011;
                    break;
                }
                case 0x4000070: {
                    n3 = 67108891;
                    break;
                }
                case 67108994: {
                    bl = false;
                    n = 0x4000070;
                    n3 = 67108891;
                    break;
                }
                case 67108891: {
                    n3 = 0x4000070;
                    break;
                }
                case 67108897: {
                    bl = false;
                    n = 67108891;
                    n3 = 0x4000070;
                    break;
                }
                case 67108895: {
                    bl = false;
                    n = 528399;
                    break;
                }
                case 0x4000020: {
                    bl = false;
                    n = 0x4000010;
                    break;
                }
                case 0x4000024: {
                    bl = false;
                    n = 0x4000040;
                    break;
                }
                case 67108899: {
                    bl = false;
                    n = 0x4000014;
                    break;
                }
                default: {
                    System.out.println("PROBLEM IN MESHCOLLECTION: token? " + Token.nameOf(n));
                }
            }
            this.setProperty(n, bl);
            if (n3 != 0 && this.currentMesh.havePlanarContours && this.currentMesh.drawTriangles != this.currentMesh.showContourLines) {
                this.setProperty(n3, bl);
            }
            return;
        }
        super.setProperty(string, object, bitSet);
    }

    private void setProperty(int n, boolean bl) {
        String string;
        if (this.currentMesh != null) {
            switch (n) {
                case 0x100011: {
                    this.currentMesh.visible = bl;
                    return;
                }
                case 141562115: {
                    this.currentMesh.colix = this.colix;
                    if (this.linkedMesh != null) {
                        this.linkedMesh.colix = this.colix;
                    }
                    return;
                }
                case 67108927: {
                    this.currentMesh.setTranslucent(bl, this.translucentLevel);
                    if (this.linkedMesh != null) {
                        this.linkedMesh.setTranslucent(bl, this.translucentLevel);
                    }
                    return;
                }
                case 0x4000006: 
                case 67108883: 
                case 67108885: {
                    this.currentMesh.setLighting(n);
                    if (this.linkedMesh != null) {
                        this.linkedMesh.setLighting(n);
                    }
                    return;
                }
                case 0x4000070: {
                    this.currentMesh.showContourLines = bl;
                    if (this.linkedMesh != null) {
                        this.linkedMesh.showContourLines = bl;
                    }
                    return;
                }
                case 67108891: {
                    this.currentMesh.drawTriangles = bl;
                    if (this.linkedMesh != null) {
                        this.linkedMesh.drawTriangles = bl;
                    }
                    return;
                }
                case 528399: {
                    this.currentMesh.showPoints = bl;
                    if (this.linkedMesh != null) {
                        this.linkedMesh.showPoints = bl;
                    }
                    return;
                }
                case 0x4000010: {
                    this.currentMesh.fillTriangles = bl;
                    if (this.linkedMesh != null) {
                        this.linkedMesh.fillTriangles = bl;
                    }
                    return;
                }
                case 0x4000040: {
                    this.currentMesh.showTriangles = bl;
                    if (this.linkedMesh != null) {
                        this.linkedMesh.showTriangles = bl;
                    }
                    return;
                }
                case 0x4000014: {
                    this.currentMesh.frontOnly = bl;
                    if (this.linkedMesh != null) {
                        this.linkedMesh.frontOnly = bl;
                    }
                    return;
                }
            }
            return;
        }
        String string2 = string = this.explicitID && this.previousMeshID != null && TextFormat.isWild(this.previousMeshID) ? this.previousMeshID.toUpperCase() : null;
        if (string != null && string.length() == 0) {
            string = null;
        }
        block22: for (int i = 0; i < this.meshCount; ++i) {
            Mesh mesh = this.meshes[i];
            if (string != null && !TextFormat.isMatch(mesh.thisID.toUpperCase(), string, true, true)) continue;
            switch (n) {
                case 0x100011: {
                    mesh.visible = bl;
                    continue block22;
                }
                case 141562115: {
                    mesh.colix = this.colix;
                    continue block22;
                }
                case 67108927: {
                    mesh.setTranslucent(bl, this.translucentLevel);
                    continue block22;
                }
                case 0x4000006: 
                case 67108883: 
                case 67108885: {
                    mesh.setLighting(n);
                    continue block22;
                }
                case 528399: {
                    mesh.showPoints = bl;
                    continue block22;
                }
                case 67108891: {
                    mesh.drawTriangles = bl;
                    continue block22;
                }
                case 0x4000010: {
                    mesh.fillTriangles = bl;
                    continue block22;
                }
                case 0x4000040: {
                    mesh.showTriangles = bl;
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object getProperty(String string, int n) {
        if (string == "count") {
            int n2 = 0;
            int n3 = 0;
            while (n3 < this.meshCount) {
                if (this.meshes[n3] != null && this.meshes[n3].vertexCount > 0) {
                    ++n2;
                }
                ++n3;
            }
            return new Integer(n2);
        }
        if (string == "ID") {
            return this.currentMesh == null ? (String)null : this.currentMesh.thisID;
        }
        if (string == "list") {
            StringBuffer stringBuffer = new StringBuffer();
            int n4 = 0;
            int n5 = 0;
            while (n5 < this.meshCount) {
                if (this.meshes[n5] != null && this.meshes[n5].vertexCount != 0) {
                    Mesh mesh = this.meshes[n5];
                    stringBuffer.append(++n4).append(" id:" + mesh.thisID).append("; model:" + this.viewer.getModelNumberDotted(mesh.modelIndex)).append("; vertices:" + mesh.vertexCount).append("; polygons:" + mesh.polygonCount).append("; visible:" + mesh.visible);
                    if (mesh.title != null) {
                        String string2 = "";
                        for (int i = 0; i < mesh.title.length; ++i) {
                            string2 = string2 + (i == 0 ? "; title:" : " | ") + mesh.title[i];
                        }
                        if (string2.length() > 100) {
                            string2 = string2.substring(0, 100) + "...";
                        }
                        stringBuffer.append(string2);
                    }
                    stringBuffer.append('\n');
                }
                ++n5;
            }
            return stringBuffer.toString();
        }
        if (string == "command") {
            String string3 = this.previousMeshID.toUpperCase();
            boolean bl = TextFormat.isWild(string3);
            StringBuffer stringBuffer = new StringBuffer();
            int n6 = this.meshCount;
            while (--n6 >= 0) {
                String string4 = this.meshes[n6].thisID.toUpperCase();
                if (!string4.equals(string3) && (!bl || !TextFormat.isMatch(string4, string3, true, true))) continue;
                this.getMeshCommand(stringBuffer, n6);
            }
            return stringBuffer.toString();
        }
        if (string.startsWith("checkID:")) {
            String string5 = string.substring(8).toUpperCase();
            boolean bl = TextFormat.isWild(string5);
            int n7 = this.meshCount;
            while (--n7 >= 0) {
                String string6 = this.meshes[n7].thisID.toUpperCase();
                if (string6.equals(string5)) return string6;
                if (!bl || !TextFormat.isMatch(string6, string5, true, true)) continue;
                return string6;
            }
        }
        if (string == "vertices") {
            return this.getVertices(this.currentMesh);
        }
        if (!string.startsWith("getCenter:")) return null;
        int n8 = this.getIndexFromName(string.substring(10));
        if (n8 < 0) return null;
        Mesh mesh = this.meshes[n8];
        if (mesh.vertices == null) return null;
        if (mesh.vertexCount <= n) {
            return null;
        }
        if (n < 0) return null;
        Point3f point3f = mesh.vertices[n];
        return point3f;
    }

    private Object getVertices(Mesh mesh) {
        if (mesh == null) {
            return null;
        }
        return mesh.vertices;
    }

    private void deleteMesh() {
        int n = 0;
        if (this.explicitID && this.currentMesh != null) {
            n = this.meshCount;
            while (this.meshes[--n] != this.currentMesh) {
            }
            this.deleteMesh(n);
        } else {
            String string;
            String string2 = string = this.explicitID && this.previousMeshID != null && TextFormat.isWild(this.previousMeshID) ? this.previousMeshID.toUpperCase() : null;
            if (string == null || string.length() == 0) {
                n = this.meshCount;
                while (--n >= 0) {
                    this.meshes[n] = null;
                }
                this.meshCount = 0;
                this.nUnnamed = 0;
            } else {
                n = this.meshCount;
                while (--n >= 0) {
                    if (!TextFormat.isMatch(this.meshes[n].thisID.toUpperCase(), string, true, true)) continue;
                    this.deleteMesh(n);
                }
            }
        }
        this.currentMesh = null;
    }

    public void deleteMesh(int n) {
        for (int i = n + 1; i < this.meshCount; ++i) {
            this.meshes[i - 1] = this.meshes[i];
        }
        this.meshes[--this.meshCount] = null;
    }

    public int getIndexFromName(String string) {
        if ("+PREVIOUS_MESH+".equals(string)) {
            return this.previousMeshID == null ? this.meshCount - 1 : this.getIndexFromName(this.previousMeshID);
        }
        if (TextFormat.isWild(string)) {
            string = string.toLowerCase();
            int n = this.meshCount;
            while (--n >= 0) {
                if (this.meshes[n] == null || !TextFormat.isMatch(this.meshes[n].thisID, string, true, true)) continue;
                return n;
            }
        } else {
            int n = this.meshCount;
            while (--n >= 0) {
                if (this.meshes[n] == null || !string.equalsIgnoreCase(this.meshes[n].thisID)) continue;
                return n;
            }
        }
        return -1;
    }

    public void setModelIndex(int n, int n2) {
        if (this.currentMesh == null) {
            return;
        }
        this.currentMesh.visible = true;
        this.currentMesh.atomIndex = n;
        this.currentMesh.modelIndex = this.currentMesh.atomIndex >= 0 ? this.viewer.getAtomModelIndex(n) : (this.isFixed ? -1 : (n2 >= 0 ? n2 : this.viewer.getCurrentModelIndex()));
        this.currentMesh.scriptCommand = this.script;
    }

    public String getShapeState() {
        StringBuffer stringBuffer = new StringBuffer("\n");
        for (int i = 0; i < this.meshCount; ++i) {
            this.getMeshCommand(stringBuffer, i);
        }
        return stringBuffer.toString();
    }

    private void getMeshCommand(StringBuffer stringBuffer, int n) {
        String string;
        Mesh mesh = this.meshes[n];
        String string2 = mesh.scriptCommand;
        if (string2 == null) {
            return;
        }
        int n2 = (string2 = string2.replace('\t', ' ')).indexOf(";#");
        if (n2 >= 0) {
            string2 = string2.substring(0, n2 + 1);
        }
        if (mesh.bitsets != null) {
            string2 = string2 + "# " + (mesh.bitsets[0] == null ? "({null})" : Escape.escape(mesh.bitsets[0])) + " " + (mesh.bitsets[1] == null ? "({null})" : Escape.escape(mesh.bitsets[1])) + (mesh.bitsets[2] == null ? "" : "/" + Escape.escape(mesh.bitsets[2]));
        }
        if (string2.toLowerCase().indexOf(" ID ") < 0 && !this.myType.equals("mo")) {
            string2 = string2 + "# ID=\"" + mesh.thisID + "\"";
        }
        if (mesh.modelIndex >= 0) {
            string2 = string2 + "# MODEL({" + mesh.modelIndex + "})";
        }
        if (mesh.linkedMesh != null) {
            string2 = string2 + " LINK";
        }
        if (mesh.data1 != null) {
            string = ((String)mesh.data1.elementAt(0)).toLowerCase();
            if (string.indexOf("data2d_") != 0) {
                string = "data2d_" + string;
            }
            string = TextFormat.simpleReplace(string, "_xyz", "_");
            string2 = Escape.encapsulateData(string, mesh.data1.elementAt(5)) + "  " + string2 + "# DATA=\"" + string + "\"";
        }
        if (mesh.data2 != null) {
            string = ((String)mesh.data2.elementAt(0)).toLowerCase();
            if (string.indexOf("data2d_") != 0) {
                string = "data2d_" + string;
            }
            string = TextFormat.simpleReplace(string, "_xyz", "_");
            string2 = Escape.encapsulateData(string, mesh.data2.elementAt(5)) + "  " + string2 + "# DATA2=\"" + string + "\"";
        }
        if (mesh.modelIndex >= 0 && this.modelCount > 1) {
            Shape.appendCmd(stringBuffer, "frame " + this.viewer.getModelNumberDotted(mesh.modelIndex));
        }
        Shape.appendCmd(stringBuffer, string2);
        if (string2.charAt(0) != '#') {
            if (this.allowMesh) {
                Shape.appendCmd(stringBuffer, mesh.getState(this.myType));
            }
            if (mesh.colorCommand != null) {
                if (!mesh.isColorSolid && Graphics3D.isColixTranslucent(mesh.colix)) {
                    Shape.appendCmd(stringBuffer, this.getColorCommand(this.myType, mesh.colix));
                }
                Shape.appendCmd(stringBuffer, mesh.colorCommand);
            }
            this.getColorState(stringBuffer, mesh);
        }
    }

    protected void getColorState(StringBuffer stringBuffer, Mesh mesh) {
        this.getColorState(stringBuffer, mesh);
        if (mesh.isColorSolid) {
            Shape.appendCmd(stringBuffer, this.getColorCommand(this.myType, mesh.colix));
        }
    }

    public void setVisibilityFlags(BitSet bitSet) {
        int n = this.meshCount;
        while (--n >= 0) {
            Mesh mesh = this.meshes[n];
            mesh.visibilityFlags = mesh.visible && mesh.isValid && (mesh.modelIndex < 0 || bitSet.get(mesh.modelIndex) && (mesh.atomIndex < 0 || !this.modelSet.isAtomHidden(mesh.atomIndex))) ? this.myVisibilityFlag : 0;
        }
    }

    protected void getModelIndex(String string) {
        int n;
        this.iHaveModelIndex = false;
        this.modelIndex = -1;
        if (string == null || (n = string.indexOf("MODEL({")) < 0) {
            return;
        }
        int n2 = string.indexOf("})", n);
        if (n2 < 0) {
            return;
        }
        BitSet bitSet = Escape.unescapeBitset(string.substring(n + 3, n2 + 1));
        this.modelIndex = bitSet == null ? -1 : BitSetUtil.firstSetBit(bitSet);
        this.iHaveModelIndex = this.modelIndex >= 0;
    }
}

