/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shape;

import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import org.jmol.api.JmolRendererInterface;
import org.jmol.modelset.ModelSet;
import org.jmol.shape.Shape;
import org.jmol.viewer.JmolConstants;
import org.jmol.viewer.Viewer;

public abstract class ShapeRenderer {
    protected Viewer viewer;
    protected JmolRendererInterface g3d;
    protected ModelSet modelSet;
    protected Shape shape;
    protected int myVisibilityFlag;
    protected int shapeID;
    protected short colix;
    protected short mad;
    protected short madBeg;
    protected short madMid;
    protected short madEnd;
    protected boolean isGenerator;
    protected boolean slabbing;

    public void setGenerator(boolean bl) {
        this.isGenerator = bl;
    }

    public short getMad(int n) {
        switch (n) {
            case 1: {
                return this.madBeg;
            }
            case 2: {
                return this.madMid;
            }
            case 3: {
                return this.madEnd;
            }
        }
        return this.mad;
    }

    public final void setViewerG3dShapeID(Viewer viewer, JmolRendererInterface jmolRendererInterface, int n) {
        this.viewer = viewer;
        this.g3d = jmolRendererInterface;
        this.shapeID = n;
        this.myVisibilityFlag = JmolConstants.getShapeVisibilityFlag(n);
        this.initRenderer();
    }

    protected void initRenderer() {
    }

    public void render(JmolRendererInterface jmolRendererInterface, ModelSet modelSet, Shape shape) {
        this.g3d = jmolRendererInterface;
        this.modelSet = modelSet;
        this.shape = shape;
        this.render();
    }

    protected abstract void render();

    protected void renderLine(Point3f point3f, Point3f point3f2, int n, byte by, Point3i point3i, Point3i point3i2) {
        point3i.set((int)point3f.x, (int)point3f.y, (int)point3f.z);
        point3i2.set((int)point3f2.x, (int)point3f2.y, (int)point3f2.z);
        if (n < 0) {
            this.g3d.drawDottedLine(point3i, point3i2);
        } else {
            this.g3d.fillCylinder(by, n, point3i, point3i2);
        }
    }
}

