/*
 * Decompiled with CFR 0.152.
 */
package edu.hws.jcm.draw;

import edu.hws.jcm.awt.Computable;
import edu.hws.jcm.data.Value;
import edu.hws.jcm.draw.Drawable;
import java.awt.Color;
import java.awt.Graphics;

public class DrawGeometric
extends Drawable
implements Computable {
    public static final int LINE_ABSOLUTE = 0;
    public static final int INFINITE_LINE_ABSOLUTE = 1;
    public static final int RECT_ABSOLUTE = 2;
    public static final int OVAL_ABSOLUTE = 3;
    public static final int LINE_RELATIVE = 4;
    public static final int INFINITE_LINE_RELATIVE = 5;
    public static final int RECT_RELATIVE = 6;
    public static final int OVAL_RELATIVE = 7;
    public static final int LINE_CENTERED = 8;
    public static final int RECT_CENTERED = 9;
    public static final int OVAL_CENTERED = 10;
    public static final int CROSS = 11;
    protected int shape;
    protected Value x1;
    protected Value x2;
    protected Value y1;
    protected Value y2;
    protected int h = 10;
    protected int v = 10;
    protected double a = Double.NaN;
    protected double b;
    protected double c;
    protected double d;
    protected Color color = Color.black;
    protected Color fillColor;
    protected int lineWidth = 1;
    private boolean changed = true;

    public DrawGeometric() {
    }

    public DrawGeometric(int n, Value value, Value value2, Value value3, Value value4) {
        this.setShape(n);
        this.setPoints(value, value2, value3, value4);
    }

    public DrawGeometric(int n, Value value, Value value2, int n2, int n3) {
        this.setShape(n);
        this.setPoints(value, value2, n2, n3);
    }

    public void setShape(int n) {
        if (n < 0 || n > 11) {
            throw new IllegalArgumentException("Internal error:  Illegal value for shape of DrawGeometric object.");
        }
        this.shape = n;
        this.needsRedraw();
    }

    public void setPoints(Value value, Value value2, Value value3, Value value4) {
        this.x1 = value;
        this.y1 = value2;
        this.x2 = value3;
        this.y2 = value4;
        this.compute();
    }

    public void setPoints(Value value, Value value2, int n, int n2) {
        this.x1 = value;
        this.y1 = value2;
        this.x2 = null;
        this.y2 = null;
        this.h = n;
        this.v = n2;
        this.compute();
    }

    public void setX1(Value value) {
        this.x1 = value;
        this.compute();
    }

    public Value getX1() {
        return this.x1;
    }

    public void setX2(Value value) {
        this.x2 = value;
        this.compute();
    }

    public Value getX2() {
        return this.x2;
    }

    public void setY1(Value value) {
        this.y1 = value;
        this.compute();
    }

    public Value getY1() {
        return this.y1;
    }

    public void setY2(Value value) {
        this.y2 = value;
        this.compute();
    }

    public Value getY2() {
        return this.y2;
    }

    public void setH(int n) {
        this.h = n;
        this.x2 = null;
        this.compute();
    }

    public int getH() {
        return this.h;
    }

    public void setV(int n) {
        this.v = n;
        this.y2 = null;
        this.needsRedraw();
    }

    public int getV() {
        return this.v;
    }

    public void setColor(Color color) {
        this.color = color == null ? Color.black : color;
        this.needsRedraw();
    }

    public Color getColor() {
        return this.color;
    }

    public void setFillColor(Color color) {
        this.fillColor = color;
        this.needsRedraw();
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public void setLineWidth(int n) {
        if (n != this.lineWidth) {
            this.lineWidth = n;
            if (this.lineWidth > 10) {
                this.lineWidth = 10;
            } else if (this.lineWidth < 0) {
                this.lineWidth = 0;
            }
            this.needsRedraw();
        }
    }

    public int getLineWidth() {
        return this.lineWidth;
    }

    public void compute() {
        this.changed = true;
        this.needsRedraw();
    }

    private void doValues() {
        if (this.x1 != null) {
            this.a = this.x1.getVal();
        }
        if (this.y1 != null) {
            this.b = this.y1.getVal();
        }
        if (this.x2 != null) {
            this.c = this.x2.getVal();
        }
        if (this.y2 != null) {
            this.d = this.y2.getVal();
        }
        this.changed = false;
    }

    public void draw(Graphics graphics, boolean bl) {
        if (this.changed) {
            this.doValues();
        }
        if (this.coords == null || this.x1 == null || this.y1 == null || Double.isNaN(this.a) || Double.isNaN(this.b) || Double.isInfinite(this.a) || Double.isInfinite(this.b)) {
            return;
        }
        if (this.x2 != null && (Double.isNaN(this.c) || Double.isInfinite(this.c))) {
            return;
        }
        if (this.y2 != null && (Double.isNaN(this.d) || Double.isInfinite(this.d))) {
            return;
        }
        double d = this.xToPixelDouble(this.a);
        double d2 = this.yToPixelDouble(this.b);
        double d3 = this.x2 == null ? (double)this.h : (this.shape <= 3 ? this.xToPixelDouble(this.c) - d : this.c / this.coords.getPixelWidth());
        double d4 = this.y2 == null ? (double)(-this.v) : (this.shape <= 3 ? this.yToPixelDouble(this.d) - d2 : -this.d / this.coords.getPixelHeight());
        if (this.shape == 1 || this.shape == 5) {
            this.drawInfiniteLine(graphics, d, d2, d3, d4);
        } else if (this.shape == 11) {
            this.drawCross(graphics, (int)d, (int)d2, (int)(Math.abs(d3) + 0.5), (int)(Math.abs(d4) + 0.5));
        } else if (this.shape == 4 || this.shape == 0) {
            this.drawLine(graphics, (int)d, (int)d2, (int)(d + d3), (int)(d2 + d4));
        } else if (this.shape == 8) {
            this.drawLine(graphics, (int)(d - Math.abs(d3) + 1.0), (int)(d2 - Math.abs(d4) + 1.0), (int)(d + Math.abs(d3)), (int)(d2 + Math.abs(d4)));
        } else if (this.shape <= 7) {
            if (d3 < 0.0) {
                d3 = -d3;
                d -= d3;
            }
            if (d4 < 0.0) {
                d4 = -d4;
                d2 -= d4;
            }
            this.drawShape(graphics, (int)d, (int)d2, (int)(d3 + 0.5), (int)(d4 + 0.5));
        } else {
            this.drawShape(graphics, (int)(d - Math.abs(d3) + 1.0), (int)(d2 - Math.abs(d4) + 1.0), (int)(2.0 * Math.abs(d3) - 0.5), (int)(2.0 * Math.abs(d4) - 0.5));
        }
    }

    private double xToPixelDouble(double d) {
        return (double)(this.coords.getLeft() + this.coords.getGap()) + (d - this.coords.getXmin()) / (this.coords.getXmax() - this.coords.getXmin()) * (double)(this.coords.getWidth() - 2 * this.coords.getGap() - 1);
    }

    private double yToPixelDouble(double d) {
        return (double)(this.coords.getTop() + this.coords.getGap()) + (this.coords.getYmax() - d) / (this.coords.getYmax() - this.coords.getYmin()) * (double)(this.coords.getHeight() - 2 * this.coords.getGap() - 1);
    }

    private void drawLine(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = Math.abs(n3 - n);
        int n6 = Math.abs(n4 - n2);
        graphics.setColor(this.color);
        if (n5 == 0 && n6 == 0) {
            graphics.drawLine(n, n2, n, n2);
        } else if (n5 > n6) {
            int n7 = 0;
            while (n7 < this.lineWidth) {
                graphics.drawLine(n, n2 - this.lineWidth / 2 + n7, n3, n4 - this.lineWidth / 2 + n7);
                ++n7;
            }
        } else {
            int n8 = 0;
            while (n8 < this.lineWidth) {
                graphics.drawLine(n - this.lineWidth / 2 + n8, n2, n3 - this.lineWidth / 2 + n8, n4);
                ++n8;
            }
        }
    }

    private void drawShape(Graphics graphics, int n, int n2, int n3, int n4) {
        if (n > this.coords.getLeft() + this.coords.getWidth() || n2 > this.coords.getTop() + this.coords.getHeight() || n + n3 < this.coords.getLeft() || n2 + n4 < this.coords.getTop()) {
            return;
        }
        if (this.fillColor != null) {
            graphics.setColor(this.fillColor);
            if (this.shape == 2 || this.shape == 6 || this.shape == 9) {
                graphics.fillRect(n, n2, n3, n4);
            } else {
                graphics.fillOval(n, n2, n3, n4);
            }
        }
        graphics.setColor(this.color);
        if (this.shape == 2 || this.shape == 6 || this.shape == 9) {
            int n5 = 0;
            while (n5 < this.lineWidth) {
                graphics.drawRect(n + n5, n2 + n5, n3 - 2 * n5, n4 - 2 * n5);
                ++n5;
            }
        } else {
            int n6 = 0;
            while (n6 < this.lineWidth) {
                graphics.drawOval(n + n6, n2 + n6, n3 - 2 * n6, n4 - 2 * n6);
                ++n6;
            }
        }
    }

    private void drawCross(Graphics graphics, int n, int n2, int n3, int n4) {
        if (n - n3 > this.coords.getLeft() + this.coords.getWidth() || n2 - n4 > this.coords.getTop() + this.coords.getHeight() || n + n3 < this.coords.getLeft() || n2 + n4 < this.coords.getTop()) {
            return;
        }
        int n5 = n - this.lineWidth / 2;
        int n6 = n2 - this.lineWidth / 2;
        graphics.setColor(this.color);
        int n7 = 0;
        while (n7 < this.lineWidth) {
            graphics.drawLine(n - n3, n6 + n7, n + n3, n6 + n7);
            ++n7;
        }
        int n8 = 0;
        while (n8 < this.lineWidth) {
            graphics.drawLine(n5 + n8, n2 - n4, n5 + n8, n2 + n4);
            ++n8;
        }
    }

    private void drawInfiniteLine(Graphics graphics, double d, double d2, double d3, double d4) {
        block5: {
            block4: {
                if (Math.abs(d3) < 1.0E-10 && Math.abs(d4) < 1.0E-10) {
                    return;
                }
                graphics.setColor(this.color);
                if (!(Math.abs(d4) > Math.abs(d3))) break block4;
                double d5 = d3 / d4;
                int n = this.coords.getTop() - 5;
                int n2 = this.coords.getTop() + this.coords.getHeight() + 5;
                int n3 = (int)(d5 * ((double)n - d2) + d);
                int n4 = (int)(d5 * ((double)n2 - d2) + d);
                if (Math.abs(n3) >= 20000 || Math.abs(n4) >= 20000) break block5;
                int n5 = 0;
                while (n5 < this.lineWidth) {
                    graphics.drawLine(n3 - this.lineWidth / 2 + n5, n, n4 - this.lineWidth / 2 + n5, n2);
                    ++n5;
                }
                break block5;
            }
            double d6 = d4 / d3;
            int n = this.coords.getLeft() - 5;
            int n6 = this.coords.getLeft() + this.coords.getWidth() + 5;
            int n7 = (int)(d6 * ((double)n - d) + d2);
            int n8 = (int)(d6 * ((double)n6 - d) + d2);
            if (Math.abs(n7) < 20000 && Math.abs(n8) < 20000) {
                int n9 = 0;
                while (n9 < this.lineWidth) {
                    graphics.drawLine(n, n7 - this.lineWidth / 2 + n9, n6, n8 - this.lineWidth / 2 + n9);
                    ++n9;
                }
            }
        }
    }
}

