/*
 * Decompiled with CFR 0.152.
 */
package edu.hws.jcm.draw;

import edu.hws.jcm.awt.Controller;
import edu.hws.jcm.awt.InputObject;
import edu.hws.jcm.awt.Tie;
import edu.hws.jcm.awt.Tieable;
import edu.hws.jcm.data.Value;
import edu.hws.jcm.data.Variable;
import edu.hws.jcm.draw.CoordinateRect;
import edu.hws.jcm.draw.DisplayCanvas;
import edu.hws.jcm.draw.Drawable;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class MouseTracker
extends Drawable
implements MouseListener,
MouseMotionListener,
InputObject {
    protected boolean listenForDrags;
    protected boolean undefinedWhenNotDragging;
    protected Controller onUserAction;
    protected boolean clampX = true;
    protected boolean clampY = true;
    private MTVariable xVar;
    private MTVariable yVar;
    private int xClick;
    private int yClick;
    private boolean inRect;

    public MouseTracker() {
        this(true, false);
    }

    public MouseTracker(boolean bl, boolean bl2) {
        this.listenForDrags = bl;
        this.undefinedWhenNotDragging = bl2;
        this.xVar = new MTVariable(true);
        this.yVar = new MTVariable(false);
    }

    public Variable getXVar() {
        return this.xVar;
    }

    public Variable getYVar() {
        return this.yVar;
    }

    public void setListenForDrags(boolean bl) {
        if (bl != this.listenForDrags) {
            this.listenForDrags = bl;
            if (this.canvas != null) {
                if (bl) {
                    this.canvas.addMouseMotionListener(this);
                } else {
                    this.canvas.removeMouseMotionListener(this);
                }
            }
        }
    }

    public boolean getListenForDrags() {
        return this.listenForDrags;
    }

    public void setUndefinedWhenNotDragging(boolean bl) {
        this.undefinedWhenNotDragging = bl;
    }

    public boolean getUndefinedWhenNotDragging() {
        return this.undefinedWhenNotDragging;
    }

    public void setOnUserAction(Controller controller) {
        this.onUserAction = controller;
    }

    public void notifyControllerOnChange(Controller controller) {
        this.setOnUserAction(controller);
    }

    public Controller getOnUserAction() {
        return this.onUserAction;
    }

    public void setClampX(boolean bl) {
        this.clampX = bl;
    }

    public boolean getClampX() {
        return this.clampX;
    }

    public void setClampY(boolean bl) {
        this.clampY = bl;
    }

    public boolean getClampY() {
        return this.clampX;
    }

    public void checkInput() {
        if (this.coords == null || this.undefinedWhenNotDragging && !this.inRect) {
            this.xVar.setVal(Double.NaN);
            this.yVar.setVal(Double.NaN);
        } else {
            double d = this.coords.pixelToX(this.xClick);
            if (this.clampX) {
                if (d < this.coords.getXmin()) {
                    d = this.coords.getXmin();
                } else if (d > this.coords.getXmax()) {
                    d = this.coords.getXmax();
                }
            }
            this.xVar.setVal(d);
            double d2 = this.coords.pixelToY(this.yClick);
            if (this.clampY) {
                if (d2 < this.coords.getYmin()) {
                    d2 = this.coords.getYmin();
                } else if (d2 > this.coords.getYmax()) {
                    d2 = this.coords.getYmax();
                }
            }
            this.yVar.setVal(d2);
        }
    }

    public void draw(Graphics graphics, boolean bl) {
    }

    protected void setOwnerData(DisplayCanvas displayCanvas, CoordinateRect coordinateRect) {
        if (this.canvas != null) {
            displayCanvas.removeMouseListener(this);
            displayCanvas.removeMouseMotionListener(this);
        }
        this.canvas = displayCanvas;
        this.coords = coordinateRect;
        displayCanvas.addMouseListener(this);
        if (this.listenForDrags) {
            displayCanvas.addMouseMotionListener(this);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isConsumed() || this.coords == null) {
            return;
        }
        boolean bl = this.inRect = mouseEvent.getX() >= this.coords.getLeft() && mouseEvent.getX() <= this.coords.getLeft() + this.coords.getWidth() && mouseEvent.getY() >= this.coords.getTop() && mouseEvent.getY() <= this.coords.getTop() + this.coords.getHeight();
        if (!this.inRect) {
            return;
        }
        mouseEvent.consume();
        this.xClick = mouseEvent.getX();
        this.yClick = mouseEvent.getY();
        ++this.xVar.serialNumber;
        ++this.yVar.serialNumber;
        if (this.onUserAction != null) {
            this.onUserAction.compute();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (!this.inRect) {
            return;
        }
        this.inRect = false;
        if (this.listenForDrags && this.undefinedWhenNotDragging) {
            ++this.xVar.serialNumber;
            ++this.yVar.serialNumber;
            if (this.onUserAction != null) {
                this.onUserAction.compute();
            }
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.listenForDrags && this.inRect) {
            this.xClick = mouseEvent.getX();
            this.yClick = mouseEvent.getY();
            ++this.xVar.serialNumber;
            ++this.yVar.serialNumber;
            if (this.onUserAction != null) {
                this.onUserAction.compute();
            }
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    static /* synthetic */ int access$0(MouseTracker mouseTracker) {
        return mouseTracker.xClick;
    }

    static /* synthetic */ int access$2(MouseTracker mouseTracker) {
        return mouseTracker.yClick;
    }

    private class MTVariable
    extends Variable
    implements Tieable {
        private boolean isXVar;
        long serialNumber;

        MTVariable(boolean bl) {
            super(bl ? "xMouse" : "yMouse");
            this.isXVar = bl;
            super.setVal(Double.NaN);
        }

        public void setVal(double d) {
            if (this.isXVar) {
                if (MouseTracker.this.coords != null) {
                    MouseTracker.this.xClick = MouseTracker.this.coords.xToPixel(d);
                }
            } else if (MouseTracker.this.coords != null) {
                MouseTracker.this.yClick = MouseTracker.this.coords.yToPixel(d);
            }
            super.setVal(d);
        }

        public long getSerialNumber() {
            return this.serialNumber;
        }

        public void sync(Tie tie, Tieable tieable) {
            if (!(tieable instanceof Value)) {
                throw new IllegalArgumentException("Internal Error:  A MouseTracker variable can only be tied to a Value object.");
            }
            if (tieable != this) {
                this.setVal(((Value)((Object)tieable)).getVal());
                this.serialNumber = tieable.getSerialNumber();
            }
        }
    }
}

