/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.font;

import java.awt.Shape;
import java.io.IOException;
import java.io.OutputStream;
import org.freehep.graphicsio.QuadToCubicPathConstructor;

public class CharstringEncoder
extends QuadToCubicPathConstructor {
    private static final int LAST_POINT = 0;
    private static final int HORIZONTAL = 1;
    private static final int VERTICAL = 2;
    private static final int BOTH = 3;
    private OutputStream out;
    private int currentX;
    private int currentY;

    public CharstringEncoder(OutputStream outputStream) {
        this.out = outputStream;
        this.currentY = 0;
        this.currentX = 0;
    }

    private int writeNumber(double d2) throws IOException {
        int n2 = (int)Math.round(d2);
        this.writeNumber(n2);
        return n2;
    }

    private void writeNumber(int n2) throws IOException {
        if (n2 >= -107 && n2 <= 107) {
            this.out.write(n2 + 139);
        } else if (n2 >= 108 && n2 <= 1131) {
            int n3 = (n2 - 108) / 256;
            this.out.write(n3 + 247);
            this.out.write(n2 - 108 - 256 * n3);
        } else if (n2 >= -1131 && n2 <= -108) {
            int n4 = (n2 + 108) / 256;
            this.out.write(-n4 + 251);
            this.out.write(-(n2 + 108 - 256 * n4));
        } else {
            this.out.write(255);
            this.out.write(n2 >>> 24 & 0xFF);
            this.out.write(n2 >>> 16 & 0xFF);
            this.out.write(n2 >>> 8 & 0xFF);
            this.out.write(n2 >>> 0 & 0xFF);
        }
    }

    protected void writeCommand(int n2) throws IOException {
        if (n2 >= 31) {
            throw new IOException("Charstring command out of range: " + n2);
        }
        this.out.write(n2);
    }

    protected void writeExtCommand(int n2) throws IOException {
        this.out.write(12);
        this.out.write(n2);
    }

    private void writePoint(double d2, double d3) throws IOException {
        this.currentX += this.writeNumber(d2 - (double)this.currentX);
        this.currentY += this.writeNumber(d3 - (double)this.currentY);
    }

    private void writeX(double d2) throws IOException {
        this.currentX += this.writeNumber(d2 - (double)this.currentX);
    }

    private void writeY(double d2) throws IOException {
        this.currentY += this.writeNumber(d2 - (double)this.currentY);
    }

    public void startChar(double d2, double d3) throws IOException {
        this.currentX = this.writeNumber(d2);
        this.writeNumber(d3);
        this.writeCommand(13);
    }

    public void endchar() throws IOException {
        this.writeCommand(14);
    }

    private int to(double d2, double d3) throws IOException {
        int n2 = (int)Math.round(d2);
        int n3 = (int)Math.round(d3);
        if (n2 == this.currentX) {
            if (n3 == this.currentY) {
                return 0;
            }
            this.writeY(d3);
            return 2;
        }
        if (n3 == this.currentY) {
            this.writeX(d2);
            return 1;
        }
        this.writePoint(d2, d3);
        return 3;
    }

    public void move(double d2, double d3) throws IOException {
        switch (this.to(d2, d3)) {
            case 3: {
                this.writeCommand(21);
                break;
            }
            case 1: {
                this.writeCommand(22);
                break;
            }
            case 2: {
                this.writeCommand(4);
                break;
            }
        }
        super.move(d2, d3);
    }

    public void line(double d2, double d3) throws IOException {
        switch (this.to(d2, d3)) {
            case 3: {
                this.writeCommand(5);
                break;
            }
            case 1: {
                this.writeCommand(6);
                break;
            }
            case 2: {
                this.writeCommand(7);
                break;
            }
        }
        super.line(d2, d3);
    }

    public void cubic(double d2, double d3, double d4, double d5, double d6, double d7) throws IOException {
        this.writePoint(d2, d3);
        this.writePoint(d4, d5);
        this.writePoint(d6, d7);
        this.writeCommand(8);
        super.cubic(d2, d3, d4, d5, d6, d7);
    }

    public void closePath(double d2, double d3) throws IOException {
        this.writeCommand(9);
        super.closePath(d2, d3);
    }

    public void drawPath(Shape shape) throws IOException {
        this.addPath(shape);
    }
}

