/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.util.io;

import java.io.IOException;
import java.io.Writer;
import java.util.EventListener;
import java.util.EventObject;
import java.util.TooManyListenersException;

public class LineNumberWriter
extends Writer {
    private static final int UNKNOWN = 0;
    private static final int CR = 1;
    private static final int CRLF = 2;
    private static final int LF = 3;
    private static final int LFCR = 4;
    private int lineSeparator = 0;
    private Writer out;
    private int lineNo = 0;
    private LineNumberListener listener;
    private int lineNoLimit;
    private int previous = -1;

    public LineNumberWriter(Writer writer) {
        this.out = writer;
    }

    public void write(char[] cArray) throws IOException {
        this.write(cArray, 0, cArray.length);
    }

    public void write(char[] cArray, int n2, int n3) throws IOException {
        for (int i2 = 0; i2 < n3; ++i2) {
            this.write(cArray[n2 + i2]);
        }
    }

    public void write(String string) throws IOException {
        this.write(string, 0, string.length());
    }

    public void write(String string, int n2, int n3) throws IOException {
        for (int i2 = 0; i2 < n3; ++i2) {
            this.write(string.charAt(n2 + i2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(int n2) throws IOException {
        boolean bl2 = false;
        Object object = this.lock;
        synchronized (object) {
            this.out.write(n2);
            block2 : switch (this.lineSeparator) {
                default: {
                    switch (this.previous) {
                        case 13: {
                            ++this.lineNo;
                            int n3 = this.lineSeparator = n2 == 10 ? 2 : 1;
                            if (n2 != 13) break block2;
                            ++this.lineNo;
                            break;
                        }
                        case 10: {
                            ++this.lineNo;
                            int n4 = this.lineSeparator = n2 == 13 ? 4 : 3;
                            if (n2 != 10) break block2;
                            ++this.lineNo;
                            break;
                        }
                    }
                    break;
                }
                case 1: {
                    if (n2 != 13) break;
                    ++this.lineNo;
                    bl2 = true;
                    break;
                }
                case 2: {
                    if (this.previous != 13 || n2 != 10) break;
                    ++this.lineNo;
                    bl2 = true;
                    break;
                }
                case 3: {
                    if (n2 != 10) break;
                    ++this.lineNo;
                    bl2 = true;
                    break;
                }
                case 4: {
                    if (this.previous != 10 || n2 != 13) break;
                    ++this.lineNo;
                    bl2 = true;
                }
            }
            this.previous = n2;
        }
        if (this.listener != null && bl2 && this.lineNo >= this.lineNoLimit) {
            this.listener.lineNumberReached(new LineNumberEvent(this, this.lineNo));
        }
    }

    public void close() throws IOException {
        this.out.close();
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public int getLineNumber() {
        return this.lineNo;
    }

    public void setLineNumber(int n2) {
        this.lineNo = n2;
    }

    public void addLineNumberListener(LineNumberListener lineNumberListener, int n2) throws TooManyListenersException {
        if (this.listener != null) {
            throw new TooManyListenersException();
        }
        if (n2 < 2) {
            throw new IllegalArgumentException("LineNoLimit cannot be less than 2");
        }
        this.listener = lineNumberListener;
        this.lineNoLimit = n2;
    }

    public static class LineNumberEvent
    extends EventObject {
        private static final long serialVersionUID = 2821724279014031198L;
        private int lineNo;

        public LineNumberEvent(Object object, int n2) {
            super(object);
            this.lineNo = n2;
        }

        public int getLineNumber() {
            return this.lineNo;
        }

        public String toString() {
            return "LineNumberEvent: line=" + this.lineNo + "; " + this.getSource().toString();
        }
    }

    public static interface LineNumberListener
    extends EventListener {
        public void lineNumberReached(LineNumberEvent var1);
    }
}

