/*
 * Decompiled with CFR 0.152.
 */
package WIMSchem;

import WIMSchem.MainPanel;
import WIMSchem.Molecule;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.QuadCurve2D;
import java.text.DecimalFormat;
import java.util.ArrayList;

public class DrawMolecule {
    Molecule mol;
    Graphics2D g;
    Color backgr = Color.WHITE;
    Color colHighlight = null;
    Color colSelected = null;
    Color colDragged = null;
    boolean showHydr = false;
    int showMode = 1;
    boolean showSter = false;
    double offsetX = 0.0;
    double offsetY = 0.0;
    double scale = 20.0;
    String[] atomLabel = null;
    boolean[] expl = null;
    int[] hcount = null;
    double[] px = null;
    double[] py = null;
    double[] rw = null;
    double[] rh = null;
    double[][] bfx = null;
    double[][] bfy = null;
    double[][] btx = null;
    double[][] bty = null;
    int[] hdir = null;
    Font font = null;
    Font smallFont = null;
    Font boldFont = null;
    FontMetrics metrics = null;
    FontMetrics smallMetrics = null;
    FontMetrics boldMetrics = null;
    int txh = 0;
    boolean[] selected = null;
    boolean[] dragged = null;
    int highlightAtom = 0;
    int highlightBond = 0;
    boolean bondInProgress = false;
    int bipFrom;
    int bipOrder;
    int bipType;
    double bipToX;
    double bipToY;
    boolean atomInProgress = false;
    String aipLabel;
    double aipToX;
    double aipToY;
    boolean newBondLine = false;
    double nblX1;
    double nblY1;
    double nblX2;
    double nblY2;
    boolean dragSelect = false;
    int dslX1;
    int dslY1;
    int dslX2;
    int dslY2;
    boolean dragScale = false;
    double dscCX;
    double dscCY;
    double dscExtMul;
    boolean dragMove = false;
    double dmvDX;
    double dmvDY;
    boolean dmvCopy;
    boolean dragRotate = false;
    double droTheta;
    int droX;
    int droY;
    boolean outlineTemplate = false;
    Molecule oltMol;
    boolean viewC = MainPanel.viewC;
    public static final double DEFSCALE = 20.0;
    public static final int SHOW_ELEMENTS = 0;
    public static final int SHOW_ALL_ELEMENTS = 1;
    public static final int SHOW_INDEXES = 2;
    public static final int SHOW_RINGID = 3;
    public static final int SHOW_PRIORITY = 4;
    public static final int SHOW_MAPNUM = 5;

    public DrawMolecule(Molecule Mol, Graphics2D Gr) {
        this.mol = Mol;
        this.g = Gr;
    }

    public void SetBackground(Color Col) {
        this.backgr = Col;
    }

    public void SetShowHydr(boolean ShowH) {
        this.showHydr = ShowH;
    }

    public void SetShowMode(int Mode) {
        this.showMode = Mode;
    }

    public void SetShowStereo(boolean ShowSter) {
        this.showSter = ShowSter;
    }

    public void SetTransform(double OX, double OY, double Scale) {
        this.offsetX = OX;
        this.offsetY = OY;
        this.scale = Scale;
    }

    public void SetSelected(boolean[] Selected, boolean[] Dragged) {
        this.selected = Selected;
        this.dragged = Dragged;
    }

    public void SetHighlight(int Atom2, int Bond2) {
        this.highlightAtom = Atom2;
        this.highlightBond = Bond2;
    }

    public void BondInProgress(int From, double X, double Y, int Order, int Type2) {
        this.bondInProgress = true;
        this.bipFrom = From;
        this.bipToX = X;
        this.bipToY = Y;
        this.bipOrder = Order;
        this.bipType = Type2;
    }

    public void AtomInProgress(String Label, double X, double Y) {
        this.atomInProgress = true;
        this.aipLabel = Label;
        this.aipToX = X;
        this.aipToY = Y;
    }

    public void NewBondLine(double X1, double Y1, double X2, double Y2) {
        this.newBondLine = true;
        this.nblX1 = X1;
        this.nblY1 = Y1;
        this.nblX2 = X2;
        this.nblY2 = Y2;
    }

    public void DragSelect(int X1, int Y1, int X2, int Y2) {
        this.dragSelect = true;
        this.dslX1 = X1;
        this.dslY1 = Y1;
        this.dslX2 = X2;
        this.dslY2 = Y2;
    }

    public void DragScale(double CX, double CY, double ExtMul) {
        this.dragScale = true;
        this.dscCX = CX;
        this.dscCY = CY;
        this.dscExtMul = ExtMul;
    }

    public void DragMove(double DX, double DY, boolean Copy) {
        this.dragMove = true;
        this.dmvDX = DX;
        this.dmvDY = DY;
        this.dmvCopy = Copy;
    }

    public void DragRotate(double Theta, int X, int Y) {
        this.dragRotate = true;
        this.droTheta = Theta;
        this.droX = X;
        this.droY = Y;
    }

    public void OutlineTemplate(Molecule Templ) {
        this.outlineTemplate = true;
        this.oltMol = Templ;
    }

    public double[] GetPX() {
        return this.px;
    }

    public double[] GetPY() {
        return this.py;
    }

    public double[] GetRW() {
        return this.rw;
    }

    public double[] GetRH() {
        return this.rh;
    }

    public double[][] GetBFX() {
        return this.bfx;
    }

    public double[][] GetBFY() {
        return this.bfy;
    }

    public double[][] GetBTX() {
        return this.btx;
    }

    public double[][] GetBTY() {
        return this.bty;
    }

    public void Draw() {
        this.SetupColours();
        this.SetupFonts();
        this.SetupLabels();
        this.SetupPositions();
        this.SetupHydrogens();
        this.DrawBacklighting();
        this.DrawBonds();
        this.DrawAtoms();
        this.DrawEffects();
        this.DrawAnnotations();
        this.DrawCorrections();
    }

    void SetupColours() {
        if (this.colHighlight == null) {
            this.colHighlight = this.backgr.darker();
        }
        if (this.colSelected == null) {
            this.colSelected = new Color(this.colHighlight.getRed(), this.colHighlight.getGreen(), 255);
        }
        if (this.colDragged == null) {
            this.colDragged = new Color(this.colHighlight.getRed(), 192, 255);
        }
    }

    void SetupFonts() {
        this.font = new Font("SansSerif", 0, (int)(0.7 * this.scale));
        this.g.setFont(this.font);
        this.metrics = this.g.getFontMetrics();
        this.txh = (int)((double)this.metrics.getAscent() * 0.85);
        this.smallFont = new Font("SansSerif", 0, (int)(0.35 * this.scale));
        this.g.setFont(this.smallFont);
        this.smallMetrics = this.g.getFontMetrics();
        this.boldFont = new Font("SansSerif", 1, (int)(0.7 * this.scale));
        this.g.setFont(this.boldFont);
        this.boldMetrics = this.g.getFontMetrics();
        this.font = new Font("SansSerif", 0, (int)(0.7 * this.scale));
    }

    void SetupLabels() {
        if (this.selected == null) {
            this.selected = new boolean[this.mol.NumAtoms()];
        }
        if (this.dragged == null) {
            this.dragged = new boolean[this.mol.NumAtoms()];
        }
        if (this.atomLabel != null && this.expl != null && this.hcount != null) {
            return;
        }
        this.atomLabel = new String[this.mol.NumAtoms()];
        this.expl = new boolean[this.mol.NumAtoms()];
        this.hcount = new int[this.mol.NumAtoms()];
        for (int n = 1; n <= this.mol.NumAtoms(); ++n) {
            this.atomLabel[n - 1] = this.mol.AtomElement(n).equals("C") && !this.viewC && (this.showMode == 0 || this.showMode == 1) ? (this.mol.AtomMapNum(n) > 0 ? String.valueOf(this.mol.AtomMapNum(n)) : "") : (this.showMode == 0 ? (this.mol.AtomExplicit(n) ? this.mol.AtomElement(n) : "") : (this.showMode == 1 ? this.mol.AtomElement(n) : (this.showMode == 2 ? String.valueOf(n) : (this.showMode == 3 ? String.valueOf(this.mol.AtomRingBlock(n)) : (this.showMode == 4 ? String.valueOf(this.mol.AtomPriority(n)) : (this.showMode == 5 ? (this.mol.AtomMapNum(n) > 0 ? String.valueOf(this.mol.AtomMapNum(n)) : "") : "?"))))));
            this.expl[n - 1] = this.atomLabel[n - 1].length() > 0;
            this.hcount[n - 1] = this.showHydr && (this.showMode == 0 || this.showMode == 1) && this.expl[n - 1] ? this.mol.AtomHydrogens(n) : 0;
        }
    }

    void SetupPositions() {
        int i;
        double thbond;
        int numTo;
        int numFrom;
        int numRight;
        int numLeft;
        int n;
        if (this.px != null && this.py != null && this.rw != null && this.rh != null && this.bfx != null && this.bfy != null && this.btx != null && this.bty != null) {
            return;
        }
        this.px = new double[this.mol.NumAtoms()];
        this.py = new double[this.mol.NumAtoms()];
        this.rw = new double[this.mol.NumAtoms()];
        this.rh = new double[this.mol.NumAtoms()];
        this.bfx = new double[3][this.mol.NumBonds() + 1];
        this.bfy = new double[3][this.mol.NumBonds() + 1];
        this.btx = new double[3][this.mol.NumBonds() + 1];
        this.bty = new double[3][this.mol.NumBonds() + 1];
        for (int n2 = 1; n2 <= this.mol.NumAtoms(); ++n2) {
            this.px[n2 - 1] = this.AngToX(this.mol.AtomX(n2));
            this.py[n2 - 1] = this.AngToY(this.mol.AtomY(n2));
            if (this.expl[n2 - 1]) {
                this.rw[n2 - 1] = this.mol.AtomMapNum(n2) == 0 ? 0.5 * (double)this.metrics.stringWidth(this.atomLabel[n2 - 1]) : 0.5 * (double)this.boldMetrics.stringWidth(this.atomLabel[n2 - 1]);
                this.rh[n2 - 1] = 0.5 * (double)(this.metrics.getAscent() + this.metrics.getDescent());
                continue;
            }
            double d = (double)this.txh * 0.4;
            this.rh[n2 - 1] = d;
            this.rw[n2 - 1] = d;
        }
        int[] bondside = new int[this.mol.NumBonds()];
        for (int n3 = 0; n3 < this.mol.NumBonds(); ++n3) {
            bondside[n3] = 0;
        }
        int[][] ring6 = this.mol.FindRingSize(6);
        int nring6 = ring6.length;
        for (int n4 = 0; n4 < ring6.length; ++n4) {
            int a = ring6[n4][0];
            for (int i2 = 0; i2 < 6; ++i2) {
                ring6[n4][i2] = this.mol.FindBond(ring6[n4][i2], i2 == 5 ? a : ring6[n4][i2 + 1]);
            }
        }
        int[] r6score = new int[ring6.length];
        while (true) {
            int best = -1;
            for (n = 0; n < nring6; ++n) {
                r6score[n] = 0;
                for (int i3 = 0; i3 < 6; ++i3) {
                    if (this.mol.BondOrder(ring6[n][i3]) != 2 || bondside[ring6[n][i3] - 1] != 0) continue;
                    int n5 = n;
                    r6score[n5] = r6score[n5] + 1;
                }
                if (r6score[n] <= 0 || best >= 0 && r6score[n] <= r6score[best]) continue;
                best = n;
            }
            if (best < 0) break;
            for (n = 0; n < 6; ++n) {
                int bond = ring6[best][n];
                if (this.mol.BondOrder(bond) != 2 || bondside[bond - 1] != 0) continue;
                int from = this.mol.BondFrom(bond);
                int to = this.mol.BondTo(bond);
                numLeft = 0;
                numRight = 0;
                numFrom = 0;
                numTo = 0;
                thbond = Math.atan2(this.mol.AtomY(to) - this.mol.AtomY(from), this.mol.AtomX(to) - this.mol.AtomX(from));
                for (i = 0; i < 6; ++i) {
                    double theta;
                    if (i == n) continue;
                    int o = this.mol.BondOther(ring6[best][i], from);
                    if (o > 0) {
                        theta = Math.atan2(this.mol.AtomY(o) - this.mol.AtomY(from), this.mol.AtomX(o) - this.mol.AtomX(from));
                        ++numFrom;
                    } else {
                        o = this.mol.BondOther(ring6[best][i], to);
                        if (o <= 0) continue;
                        theta = Math.atan2(this.mol.AtomY(o) - this.mol.AtomY(to), this.mol.AtomX(o) - this.mol.AtomX(to));
                        ++numTo;
                    }
                    theta += theta > Math.PI ? Math.PI * -2 : ((theta -= thbond) < -Math.PI ? Math.PI * 2 : 0.0);
                    if (theta < 0.0) {
                        ++numLeft;
                    }
                    if (!(theta > 0.0)) continue;
                    ++numRight;
                }
                if (numFrom <= 0 || numTo <= 0) continue;
                bondside[bond - 1] = numLeft > numRight ? -1 : 1;
            }
            if (best >= nring6 - 1) continue;
            ring6[best] = ring6[--nring6];
        }
        for (int n6 = 1; n6 <= this.mol.NumBonds(); ++n6) {
            int v;
            double theta;
            if (this.mol.BondOrder(n6) != 2 || bondside[n6 - 1] != 0) continue;
            int from = this.mol.BondFrom(n6);
            int to = this.mol.BondTo(n6);
            int[] adj1 = this.mol.AtomAdjList(from);
            int[] adj2 = this.mol.AtomAdjList(to);
            if (adj1.length >= 3 && adj2.length >= 3 && !this.mol.BondInRing(n6) || adj1.length == 1 && adj2.length >= 3 || adj2.length == 1 && adj1.length >= 3) continue;
            numLeft = 0;
            numRight = 0;
            numFrom = 0;
            numTo = 0;
            thbond = Math.atan2(this.mol.AtomY(to) - this.mol.AtomY(from), this.mol.AtomX(to) - this.mol.AtomX(from));
            for (i = 0; i < adj1.length; ++i) {
                if (adj1[i] == to) continue;
                theta += (theta = Math.atan2(this.mol.AtomY(adj1[i]) - this.mol.AtomY(from), this.mol.AtomX(adj1[i]) - this.mol.AtomX(from)) - thbond) > Math.PI ? Math.PI * -2 : (theta < -Math.PI ? Math.PI * 2 : 0.0);
                int n7 = v = this.mol.BondInRing(n6) && this.mol.AtomRingBlock(from) == this.mol.AtomRingBlock(adj1[i]) ? 2 : 1;
                if (theta < 0.0) {
                    numLeft += v;
                }
                if (!(theta > 0.0)) continue;
                numRight += v;
            }
            for (i = 0; i < adj2.length; ++i) {
                if (adj2[i] == from) continue;
                theta += (theta = Math.atan2(this.mol.AtomY(adj2[i]) - this.mol.AtomY(to), this.mol.AtomX(adj2[i]) - this.mol.AtomX(to)) - thbond) > Math.PI ? Math.PI * -2 : (theta < -Math.PI ? Math.PI * 2 : 0.0);
                int n8 = v = this.mol.BondInRing(n6) && this.mol.AtomRingBlock(to) == this.mol.AtomRingBlock(adj2[i]) ? 2 : 1;
                if (theta < 0.0) {
                    numLeft += v;
                }
                if (!(theta > 0.0)) continue;
                numRight += v;
            }
            if (numLeft == numRight) continue;
            bondside[n6 - 1] = numLeft > numRight ? -1 : 1;
        }
        int extraAtom = this.bondInProgress ? 1 : 0;
        for (n = 1; n <= this.mol.NumBonds() + extraAtom; ++n) {
            boolean expl2;
            boolean expl1;
            double h2;
            double w2;
            double h1;
            double w1;
            double y2;
            double x2;
            double y1;
            double x1;
            int side;
            int type;
            int order;
            int to;
            int from;
            if (n <= this.mol.NumBonds()) {
                from = this.mol.BondFrom(n);
                to = this.mol.BondTo(n);
                order = this.mol.BondOrder(n);
                type = this.mol.BondType(n);
                side = bondside[n - 1];
                x1 = this.px[from - 1];
                y1 = this.py[from - 1];
                x2 = this.px[to - 1];
                y2 = this.py[to - 1];
                w1 = this.rw[from - 1];
                h1 = this.rh[from - 1];
                w2 = this.rw[to - 1];
                h2 = this.rh[to - 1];
                expl1 = this.expl[from - 1];
                expl2 = this.expl[to - 1];
            } else {
                from = this.bipFrom;
                to = 0;
                order = this.bipOrder;
                type = this.bipType;
                side = 0;
                x1 = this.px[from - 1];
                y1 = this.py[from - 1];
                x2 = this.AngToX(this.bipToX);
                y2 = this.AngToY(this.bipToY);
                w1 = this.rw[from - 1];
                h1 = this.rh[from - 1];
                w2 = 0.0;
                h2 = 0.0;
                expl1 = this.expl[from - 1];
                expl2 = false;
            }
            double dx = x2 - x1;
            double dy = y2 - y1;
            if (Math.abs(dx) < 0.001) {
                dx = 0.0;
                if (expl1) {
                    y1 += h1 * (double)(dy > 0.0 ? 1 : -1);
                }
                if (expl2) {
                    y2 += h2 * (double)(dy > 0.0 ? -1 : 1);
                }
            } else if (Math.abs(dy) < 0.001) {
                dy = 0.0;
                if (expl1) {
                    x1 += w1 * (double)(dx > 0.0 ? 1 : -1);
                }
                if (expl2) {
                    x2 += w2 * (double)(dx > 0.0 ? -1 : 1);
                }
            } else {
                double xy = Math.abs(dx / dy);
                double yx = Math.abs(dy / dx);
                if (expl1) {
                    x1 += w1 * h1 * xy / (xy * h1 + w1) * (double)(dx > 0.0 ? 2 : -2);
                    y1 += w1 * h1 * yx / (yx * h1 + w1) * (double)(dy > 0.0 ? 2 : -2);
                }
                if (expl2) {
                    x2 += w2 * h2 * xy / (xy * h2 + w2) * (double)(dx > 0.0 ? -2 : 2);
                    y2 += w2 * h2 * yx / (yx * h2 + w2) * (double)(dy > 0.0 ? -2 : 2);
                }
            }
            for (int i4 = 0; i4 < 3; ++i4) {
                this.bfx[i4][n - 1] = x1;
                this.bfy[i4][n - 1] = y1;
                this.btx[i4][n - 1] = x2;
                this.bty[i4][n - 1] = y2;
            }
            if (order != 2 && order != 3) continue;
            double norm = 0.15 * this.scale / Math.sqrt(dx * dx + dy * dy);
            double ox = Math.signum(dy) * Math.ceil(norm * Math.abs(dy) * (order == 3 ? 1.0 : 0.5));
            double oy = -Math.signum(dx) * Math.ceil(norm * Math.abs(dx) * (order == 3 ? 1.0 : 0.5));
            if (order == 2) {
                int w;
                double[] dArray = this.bfx[0];
                int n9 = n - 1;
                dArray[n9] = dArray[n9] + ox * (double)(side - 1);
                double[] dArray2 = this.bfy[0];
                int n10 = n - 1;
                dArray2[n10] = dArray2[n10] + oy * (double)(side - 1);
                double[] dArray3 = this.btx[0];
                int n11 = n - 1;
                dArray3[n11] = dArray3[n11] + ox * (double)(side - 1);
                double[] dArray4 = this.bty[0];
                int n12 = n - 1;
                dArray4[n12] = dArray4[n12] + oy * (double)(side - 1);
                double[] dArray5 = this.bfx[1];
                int n13 = n - 1;
                dArray5[n13] = dArray5[n13] + ox * (double)(side + 1);
                double[] dArray6 = this.bfy[1];
                int n14 = n - 1;
                dArray6[n14] = dArray6[n14] + oy * (double)(side + 1);
                double[] dArray7 = this.btx[1];
                int n15 = n - 1;
                dArray7[n15] = dArray7[n15] + ox * (double)(side + 1);
                double[] dArray8 = this.bty[1];
                int n16 = n - 1;
                dArray8[n16] = dArray8[n16] + oy * (double)(side + 1);
                if (n > this.mol.NumBonds() || side == 0 || this.mol.AtomRingBlock(from) <= 0 || !this.mol.BondInRing(n)) continue;
                int n17 = w = side < 0 ? 0 : 1;
                if (!expl1) {
                    double[] dArray9 = this.bfx[w];
                    int n18 = n - 1;
                    dArray9[n18] = dArray9[n18] + norm * dx;
                    double[] dArray10 = this.bfy[w];
                    int n19 = n - 1;
                    dArray10[n19] = dArray10[n19] + norm * dy;
                }
                if (expl2) continue;
                double[] dArray11 = this.btx[w];
                int n20 = n - 1;
                dArray11[n20] = dArray11[n20] - norm * dx;
                double[] dArray12 = this.bty[w];
                int n21 = n - 1;
                dArray12[n21] = dArray12[n21] - norm * dy;
                continue;
            }
            double[] dArray = this.bfx[1];
            int n22 = n - 1;
            dArray[n22] = dArray[n22] - ox;
            double[] dArray13 = this.bfy[1];
            int n23 = n - 1;
            dArray13[n23] = dArray13[n23] - oy;
            double[] dArray14 = this.btx[1];
            int n24 = n - 1;
            dArray14[n24] = dArray14[n24] - ox;
            double[] dArray15 = this.bty[1];
            int n25 = n - 1;
            dArray15[n25] = dArray15[n25] - oy;
            double[] dArray16 = this.bfx[2];
            int n26 = n - 1;
            dArray16[n26] = dArray16[n26] + ox;
            double[] dArray17 = this.bfy[2];
            int n27 = n - 1;
            dArray17[n27] = dArray17[n27] + oy;
            double[] dArray18 = this.btx[2];
            int n28 = n - 1;
            dArray18[n28] = dArray18[n28] + ox;
            double[] dArray19 = this.bty[2];
            int n29 = n - 1;
            dArray19[n29] = dArray19[n29] + oy;
        }
        for (n = 1; n <= this.mol.NumAtoms(); ++n) {
            int i5;
            if (this.atomLabel[n - 1].length() != 0 || this.mol.AtomRingBlock(n) != 0) continue;
            boolean any = false;
            double dpx1 = 0.0;
            double dpy1 = 0.0;
            double dpx2 = 0.0;
            double dpy2 = 0.0;
            for (i5 = 1; i5 <= this.mol.NumBonds(); ++i5) {
                if (this.mol.BondOrder(i5) != 2) continue;
                if (this.mol.BondFrom(i5) == n) {
                    dpx1 = this.bfx[0][i5 - 1];
                    dpy1 = this.bfy[0][i5 - 1];
                    dpx2 = this.bfx[1][i5 - 1];
                    dpy2 = this.bfy[1][i5 - 1];
                    any = true;
                    break;
                }
                if (this.mol.BondTo(i5) != n) continue;
                dpx1 = this.btx[0][i5 - 1];
                dpy1 = this.bty[0][i5 - 1];
                dpx2 = this.btx[1][i5 - 1];
                dpy2 = this.bty[1][i5 - 1];
                any = true;
                break;
            }
            if (!any) continue;
            for (i5 = 1; i5 <= this.mol.NumBonds(); ++i5) {
                double dy2;
                double dx2;
                double dy1;
                double dx1;
                if (this.mol.BondOrder(i5) != 1) continue;
                if (this.mol.BondFrom(i5) == n) {
                    dx1 = dpx1 - this.btx[0][i5 - 1];
                    dy1 = dpy1 - this.bty[0][i5 - 1];
                    dx2 = dpx2 - this.btx[0][i5 - 1];
                    dy2 = dpy2 - this.bty[0][i5 - 1];
                    if (dx1 * dx1 + dy1 * dy1 < dx2 * dx2 + dy2 * dy2) {
                        this.bfx[0][i5 - 1] = dpx1;
                        this.bfy[0][i5 - 1] = dpy1;
                        continue;
                    }
                    this.bfx[0][i5 - 1] = dpx2;
                    this.bfy[0][i5 - 1] = dpy2;
                    continue;
                }
                if (this.mol.BondTo(i5) != n) continue;
                dx1 = dpx1 - this.bfx[0][i5 - 1];
                dy1 = dpy1 - this.bfy[0][i5 - 1];
                dx2 = dpx2 - this.bfx[0][i5 - 1];
                dy2 = dpy2 - this.bfy[0][i5 - 1];
                if (dx1 * dx1 + dy1 * dy1 < dx2 * dx2 + dy2 * dy2) {
                    this.btx[0][i5 - 1] = dpx1;
                    this.bty[0][i5 - 1] = dpy1;
                    continue;
                }
                this.btx[0][i5 - 1] = dpx2;
                this.bty[0][i5 - 1] = dpy2;
            }
        }
    }

    void SetupHydrogens() {
        this.hdir = new int[this.mol.NumAtoms()];
        for (int n = 1; n <= this.mol.NumAtoms(); ++n) {
            this.hdir[n - 1] = 0;
            if (this.hcount[n - 1] == 0) continue;
            int[] bonds = this.mol.AtomAdjList(n);
            int avoid1 = 0;
            int avoid2 = 20;
            int avoid3 = 10;
            int avoid4 = 20;
            for (int i = 0; i < bonds.length + (this.bondInProgress && this.bipFrom == n ? 1 : 0); ++i) {
                double x = i < bonds.length ? this.mol.AtomX(bonds[i]) : this.bipToX;
                double y = i < bonds.length ? this.mol.AtomY(bonds[i]) : this.bipToY;
                double theta = Math.atan2(y - this.mol.AtomY(n), x - this.mol.AtomX(n)) * 180.0 / Math.PI;
                double dt1 = 0.0 - theta;
                double dt2 = 90.0 - theta;
                double dt3 = 180.0 - theta;
                double dt4 = 270.0 - theta;
                dt1 = Math.abs(dt1 + (double)(dt1 < -180.0 ? 360 : 0) + (double)(dt1 > 180.0 ? -360 : 0));
                dt2 = Math.abs(dt2 + (double)(dt2 < -180.0 ? 360 : 0) + (double)(dt2 > 180.0 ? -360 : 0));
                dt3 = Math.abs(dt3 + (double)(dt3 < -180.0 ? 360 : 0) + (double)(dt3 > 180.0 ? -360 : 0));
                dt4 = Math.abs(dt4 + (double)(dt4 < -180.0 ? 360 : 0) + (double)(dt4 > 180.0 ? -360 : 0));
                avoid1 = (int)((double)avoid1 + (dt1 < 80.0 ? 80.0 - dt1 : 0.0));
                avoid2 = (int)((double)avoid2 + (dt2 < 80.0 ? 80.0 - dt2 : 0.0));
                avoid3 = (int)((double)avoid3 + (dt3 < 80.0 ? 80.0 - dt3 : 0.0));
                avoid4 = (int)((double)avoid4 + (dt4 < 80.0 ? 80.0 - dt4 : 0.0));
            }
            this.hdir[n - 1] = avoid1 <= avoid2 && avoid1 <= avoid3 && avoid1 <= avoid4 ? 1 : (avoid3 <= avoid2 && avoid3 <= avoid4 ? 3 : (avoid2 <= avoid4 ? 2 : 4));
        }
    }

    void DrawBacklighting() {
        int n;
        for (n = 1; n <= this.mol.NumAtoms(); ++n) {
            boolean drag = false;
            if (this.dragged != null) {
                drag = this.dragged[n - 1];
            }
            if (!this.selected[n - 1] && n != this.highlightAtom && !drag) continue;
            this.g.setColor(this.selected[n - 1] ? this.colSelected : (drag ? this.colDragged : this.colHighlight));
            double ext = Math.max(this.rw[n - 1] * 1.2, this.rh[n - 1] * 1.2);
            this.g.fill(new Ellipse2D.Double(this.px[n - 1] - ext, this.py[n - 1] - ext, 2.0 * ext, 2.0 * ext));
        }
        if (this.highlightBond != 0) {
            for (n = 0; n == 0 || n < this.mol.BondOrder(this.highlightBond) && n < 3; ++n) {
                int bn = this.highlightBond - 1;
                double x1 = this.bfx[n][bn];
                double y1 = this.bfy[n][bn];
                double x2 = this.btx[n][bn];
                double y2 = this.bty[n][bn];
                double dx = x2 - x1;
                double dy = y2 - y1;
                double norm = 0.15 * this.scale / Math.sqrt(dx * dx + dy * dy);
                double ox = norm * dy;
                double oy = -norm * dx;
                Polygon pgn = new Polygon();
                pgn.addPoint((int)Math.round(x1 + oy * 0.5), (int)Math.round(y1 - ox * 0.5));
                pgn.addPoint((int)Math.round(x1 - ox), (int)Math.round(y1 - oy));
                pgn.addPoint((int)Math.round(x2 - ox), (int)Math.round(y2 - oy));
                pgn.addPoint((int)Math.round(x2 - oy * 0.5), (int)Math.round(y2 + ox * 0.5));
                pgn.addPoint((int)Math.round(x2 + ox), (int)Math.round(y2 + oy));
                pgn.addPoint((int)Math.round(x1 + ox), (int)Math.round(y1 + oy));
                this.g.setColor(this.colHighlight);
                this.g.fill(pgn);
            }
        }
    }

    void DrawBonds() {
        for (int n = 1; n <= this.mol.NumBonds() + (this.bondInProgress ? 1 : 0); ++n) {
            int i;
            int i2;
            double oy;
            double ox;
            int type;
            double x1 = this.bfx[0][n - 1];
            double y1 = this.bfy[0][n - 1];
            double x2 = this.btx[0][n - 1];
            double y2 = this.bty[0][n - 1];
            double dx = x2 - x1;
            double dy = y2 - y1;
            int order = n <= this.mol.NumBonds() ? this.mol.BondOrder(n) : this.bipOrder;
            int n2 = type = n <= this.mol.NumBonds() ? this.mol.BondType(n) : this.bipType;
            boolean mappedBond = n <= this.mol.NumBonds() ? this.mol.AtomMapNum(this.mol.BondFrom(n)) > 0 && this.mol.AtomMapNum(this.mol.BondTo(n)) > 0 : false;
            this.g.setColor(Color.BLACK);
            if (type == 1) {
                double norm = 0.15 * this.scale / Math.sqrt(dx * dx + dy * dy);
                double ox2 = norm * dy;
                double oy2 = -norm * dx;
                Polygon pgn = new Polygon();
                pgn.addPoint((int)Math.round(x1), (int)Math.round(y1));
                pgn.addPoint((int)Math.round(x2 - ox2), (int)Math.round(y2 - oy2));
                pgn.addPoint((int)Math.round(x2 + ox2), (int)Math.round(y2 + oy2));
                this.g.fill(pgn);
                continue;
            }
            if (type == 2) {
                int nsteps = (int)Math.ceil(Math.sqrt(dx * dx + dy * dy) * 0.15);
                double norm = 0.15 * this.scale / Math.sqrt(dx * dx + dy * dy);
                ox = norm * dy;
                oy = -norm * dx;
                for (i2 = 0; i2 <= nsteps + 1; ++i2) {
                    double cx = x1 + (double)i2 * dx / (double)(nsteps + 1);
                    double cy = y1 + (double)i2 * dy / (double)(nsteps + 1);
                    double ix = ox * (double)i2 / (double)(nsteps + 1);
                    double iy = oy * (double)i2 / (double)(nsteps + 1);
                    this.g.setStroke(new BasicStroke((float)(0.05 * this.scale)));
                    this.g.draw(new Line2D.Double(cx - ix, cy - iy, cx + ix, cy + iy));
                }
                continue;
            }
            if (type == 3) {
                int nsteps = (int)Math.ceil(Math.sqrt(dx * dx + dy * dy) * 0.2);
                double norm = 0.2 * this.scale / Math.sqrt(dx * dx + dy * dy);
                ox = norm * dy;
                oy = -norm * dx;
                for (i2 = 0; i2 <= nsteps; ++i2) {
                    double ax = x1 + (double)i2 * dx / (double)(nsteps + 1);
                    double ay = y1 + (double)i2 * dy / (double)(nsteps + 1);
                    double cx = x1 + (double)(i2 + 1) * dx / (double)(nsteps + 1);
                    double cy = y1 + (double)(i2 + 1) * dy / (double)(nsteps + 1);
                    double bx = (ax + cx) / 2.0;
                    double by = (ay + cy) / 2.0;
                    int sign = i2 % 2 == 0 ? 1 : -1;
                    this.g.setStroke(new BasicStroke((float)(0.05 * this.scale)));
                    this.g.draw(new QuadCurve2D.Double(ax, ay, bx + (double)sign * ox, by + (double)sign * oy, cx, cy));
                }
                continue;
            }
            if (order == 0) {
                int nsteps = (int)Math.ceil(Math.sqrt(dx * dx + dy * dy) * 0.1);
                float radius = (float)(mappedBond ? 0.2 * this.scale : 0.1 * this.scale);
                for (int i3 = 0; i3 <= nsteps + 1; ++i3) {
                    double cx = x1 + (double)i3 * dx / (double)(nsteps + 1);
                    double cy = y1 + (double)i3 * dy / (double)(nsteps + 1);
                    this.g.fill(new Ellipse2D.Double(cx - 0.05 * this.scale, cy - 0.05 * this.scale, radius, radius));
                }
                continue;
            }
            float thickness = (float)(mappedBond ? 0.125 * this.scale : 0.075 * this.scale);
            this.g.setStroke(new BasicStroke(thickness, 1, 1));
            int n3 = i = order <= 3 ? order - 1 : 2;
            while (i >= 0) {
                this.g.draw(new Line2D.Double(this.bfx[i][n - 1], this.bfy[i][n - 1], this.btx[i][n - 1], this.bty[i][n - 1]));
                --i;
            }
        }
    }

    void DrawAtoms() {
        for (int n = 1; n <= this.mol.NumAtoms(); ++n) {
            int subHWid;
            if (this.atomLabel[n - 1].length() == 0) continue;
            this.g.setColor(this.showMode == 2 ? Color.BLUE : (this.showMode == 3 ? Color.RED : (this.showMode == 4 ? Color.GREEN.darker() : (this.showMode == 5 ? Color.MAGENTA : Color.BLACK))));
            double hx = this.px[n - 1];
            double hy = this.py[n - 1] - 0.1 * (double)this.metrics.getAscent();
            this.g.setFont(this.mol.AtomMapNum(n) > 0 && (this.showMode == 0 || this.showMode == 1) ? this.boldFont : this.font);
            this.g.drawString(this.atomLabel[n - 1], (float)(hx - this.rw[n - 1]), (float)(hy + 0.5 * (double)this.metrics.getAscent()));
            if (this.hcount[n - 1] <= 0) continue;
            int bigHWid = this.metrics.stringWidth("H");
            int n2 = subHWid = this.hcount[n - 1] > 1 ? this.smallMetrics.stringWidth(String.valueOf(this.hcount[n - 1])) : 0;
            if (this.hdir[n - 1] == 1) {
                hx += this.rw[n - 1];
                hy += 0.5 * (double)this.metrics.getAscent();
            } else if (this.hdir[n - 1] == 3) {
                hx -= this.rw[n - 1] + (double)bigHWid + (double)subHWid;
                hy += 0.5 * (double)this.metrics.getAscent();
            } else if (this.hdir[n - 1] == 2) {
                hx -= this.rw[n - 1];
                hy -= 0.5 * (double)this.metrics.getAscent();
            } else if (this.hdir[n - 1] == 4) {
                hx -= this.rw[n - 1];
                hy += 1.5 * (double)this.metrics.getAscent();
            }
            this.g.setFont(this.font);
            this.g.setColor(Color.BLACK);
            this.g.drawString("H", (float)hx, (float)hy);
            if (this.hcount[n - 1] <= 1) continue;
            this.g.setFont(this.smallFont);
            this.g.drawString(String.valueOf(this.hcount[n - 1]), (float)hx + (float)bigHWid, (float)hy);
        }
        boolean ANNOT_PLUS = true;
        int ANNOT_MINUS = 2;
        int ANNOT_RAD = 3;
        ArrayList<Integer> annot = new ArrayList<Integer>();
        double usz = this.scale * 0.3;
        for (int n = 1; n <= this.mol.NumAtoms(); ++n) {
            int chg;
            annot.clear();
            for (chg = this.mol.AtomCharge(n); chg < 0; ++chg) {
                annot.add(2);
            }
            while (chg > 0) {
                annot.add(1);
                --chg;
            }
            for (int rad = this.mol.AtomUnpaired(n); rad > 0; --rad) {
                annot.add(3);
            }
            if (annot.size() == 0) continue;
            double bw = (double)annot.size() * usz;
            double bh = usz;
            int ANG_INCR = 5;
            int CLOCK_SZ = 72;
            int SAMP_SZ = 216;
            double bestAng = 0.0;
            double bestExt = 0.0;
            double bestScore = Double.MAX_VALUE;
            for (int i = 1; i <= 3; ++i) {
                for (int j = 0; j < 72; ++j) {
                    double from45;
                    double ext;
                    double score;
                    double ang = j * 5;
                    if (this.hdir[n - 1] == 1 && (ang <= 45.0 || ang >= 315.0) || this.hdir[n - 1] == 4 && ang >= 45.0 && ang <= 135.0 || this.hdir[n - 1] == 3 && ang >= 135.0 && ang <= 225.0 || this.hdir[n - 1] == 2 && ang >= 225.0 && ang <= 315.0 || (score = 10.0 * (ext = 0.5 * (this.rw[n - 1] + this.rw[n - 1]) + (double)i * this.scale * 0.25) + 0.01 * (from45 = Math.min(Math.abs(315.0 - ang + (double)(ang < 135.0 ? -360 : 0)), 90.0))) > bestScore) continue;
                    double ax = this.px[n - 1] + ext * Math.cos(ang * Math.PI / 180.0);
                    double ay = this.py[n - 1] + ext * Math.sin(ang * Math.PI / 180.0);
                    for (int k = 1; k <= this.mol.NumBonds(); ++k) {
                        double wy;
                        double y2;
                        double vy;
                        double wx;
                        double dsq = 0.0;
                        double x1 = this.px[this.mol.BondFrom(k) - 1];
                        double y1 = this.py[this.mol.BondFrom(k) - 1];
                        double x2 = this.px[this.mol.BondTo(k) - 1];
                        double vx = x2 - x1;
                        double c1 = vx * (wx = ax - x1) + (vy = (y2 = this.py[this.mol.BondTo(k) - 1]) - y1) * (wy = ay - y1);
                        if (c1 <= 0.0) {
                            dsq = (ax - x1) * (ax - x1) + (ay - y1) * (ay - y1);
                        } else {
                            double c2 = vx * vx + vy * vy;
                            if (c2 <= c1) {
                                dsq = (ax - x2) * (ax - x2) + (ay - y2) * (ay - y2);
                            } else {
                                double b = c1 / c2;
                                double bx = x1 + b * vx;
                                double by = y1 + b * vy;
                                dsq = (ax - bx) * (ax - bx) + (ay - by) * (ay - by);
                            }
                        }
                        score += 100.0 / Math.max(dsq, 1.0E-4);
                    }
                    if (!(score < bestScore)) continue;
                    bestAng = ang;
                    bestExt = ext;
                    bestScore = score;
                }
            }
            double ax = this.px[n - 1] + bestExt * Math.cos(bestAng * Math.PI / 180.0) - 0.5 * bw;
            double ay = this.py[n - 1] + bestExt * Math.sin(bestAng * Math.PI / 180.0) - 0.5 * bh;
            this.g.setColor(Color.BLACK);
            for (int i = 0; i < annot.size(); ++i) {
                int type = (Integer)annot.get(i);
                double x1 = ax + 0.2 * usz;
                double x2 = ax + 0.8 * usz;
                double y1 = ay + 0.2 * usz;
                double y2 = ay + 0.8 * usz;
                if (type == 2 || type == 1) {
                    this.g.draw(new Line2D.Double(x1, 0.5 * (y1 + y2), x2, 0.5 * (y1 + y2)));
                }
                if (type == 1) {
                    this.g.draw(new Line2D.Double(0.5 * (x1 + x2), y1, 0.5 * (x1 + x2), y2));
                }
                if (type == 3) {
                    this.g.fill(new Ellipse2D.Double(ax + 0.2 * usz, ay + 0.2 * usz, 0.6 * usz, 0.6 * usz));
                }
                ax += usz;
            }
        }
    }

    void DrawAnnotations() {
        if (this.showSter) {
            String label;
            int chi;
            int n;
            for (n = 1; n <= this.mol.NumAtoms(); ++n) {
                chi = this.mol.AtomChirality(n);
                if (chi == 0) continue;
                label = chi == 1 ? "R" : (chi == 2 ? "S" : "R/S");
                this.g.setColor(Color.BLUE);
                this.g.setFont(this.font);
                this.g.drawString(label, (float)(this.px[n - 1] - 0.5 * (double)this.metrics.stringWidth(label)), (float)(this.py[n - 1] + (double)this.metrics.getHeight()));
            }
            for (n = 1; n <= this.mol.NumBonds(); ++n) {
                chi = this.mol.BondStereo(n);
                if (chi == 0) continue;
                label = chi == 1 ? "Z" : (chi == 2 ? "E" : "E/Z");
                int i1 = this.mol.BondFrom(n) - 1;
                int i2 = this.mol.BondTo(n) - 1;
                this.g.setColor(Color.BLUE);
                this.g.setFont(this.font);
                this.g.drawString(label, (float)(0.5 * (this.px[i1] + this.px[i2] - (double)this.metrics.stringWidth(label))), (float)(0.5 * (this.py[i1] + this.py[i2] + (double)this.metrics.getHeight())));
            }
        }
    }

    void DrawEffects() {
        if (this.atomInProgress) {
            this.g.setColor(Color.BLUE);
            this.g.setFont(this.font);
            double tx = this.AngToX(this.aipToX);
            double ty = this.AngToY(this.aipToY);
            this.g.drawString(this.aipLabel, (float)(tx - 0.5 * (double)this.metrics.stringWidth(this.aipLabel)), (float)(ty + 0.4 * (double)this.metrics.getAscent()));
        }
        if (this.newBondLine) {
            this.g.setColor(Color.BLACK);
            this.g.draw(new Line2D.Double(this.AngToX(this.nblX1), this.AngToY(this.nblY1), this.AngToX(this.nblX2), this.AngToY(this.nblY2)));
        }
        if (this.dragSelect) {
            this.g.setXORMode(Color.YELLOW);
            int x = this.dslX1;
            int y = this.dslY1;
            int w = this.dslX2 - this.dslX1;
            int h = this.dslY2 - this.dslY1;
            if (w < 0) {
                w = -w;
                x -= w;
            }
            if (h < 0) {
                h = -h;
                y -= h;
            }
            this.g.drawRect(x, y, w, h);
            this.g.setXORMode(Color.BLACK);
        }
        if (this.dragScale) {
            this.g.setColor(Color.BLACK);
            this.g.setStroke(new BasicStroke(1.1f));
            for (int n = 1; n <= this.mol.NumAtoms(); ++n) {
                if (!this.selected[n - 1]) continue;
                double sx = this.AngToX((this.mol.AtomX(n) - this.dscCX) * this.dscExtMul + this.dscCX);
                double sy = this.AngToY((this.mol.AtomY(n) - this.dscCY) * this.dscExtMul + this.dscCY);
                this.g.draw(new Ellipse2D.Double(sx - this.scale * 0.3, sy - this.scale * 0.3, this.scale * 0.6, this.scale * 0.6));
            }
        }
        if (this.dragMove) {
            this.g.setColor(Color.BLACK);
            this.g.setStroke(new BasicStroke(1.1f));
            for (int n = 1; n <= this.mol.NumAtoms(); ++n) {
                if (!this.selected[n - 1]) continue;
                double sx = this.px[n - 1] + this.dmvDX;
                double sy = this.py[n - 1] + this.dmvDY;
                this.g.draw(new Ellipse2D.Double(sx - this.scale * 0.3, sy - this.scale * 0.3, this.scale * 0.6, this.scale * 0.6));
                if (!this.dmvCopy) continue;
                this.g.draw(new Line2D.Double(sx - this.scale * 0.15, sy, sx + this.scale * 0.15, sy));
                this.g.draw(new Line2D.Double(sx, sy - this.scale * 0.15, sx, sy + this.scale * 0.15));
            }
        }
        if (this.dragRotate) {
            double thrad = this.droTheta * Math.PI / 180.0;
            this.g.setColor(Color.RED);
            this.g.setStroke(new BasicStroke(0.5f, 1, 1, 1.0f, new float[]{2.0f, 2.0f}, 0.0f));
            this.g.draw(new Line2D.Double(this.droX, this.droY, this.droX + 50, this.droY));
            this.g.setStroke(new BasicStroke(1.0f));
            this.g.draw(new Line2D.Double(this.droX, this.droY, (double)this.droX + 50.0 * Math.cos(-thrad), (double)this.droY + 50.0 * Math.sin(-thrad)));
            this.g.draw(new Arc2D.Double(this.droX - 20, this.droY - 20, 40.0, 40.0, 0.0, this.droTheta, 0));
            int ty = this.droTheta > 25.0 || this.droTheta < 0.0 && this.droTheta >= -25.0 ? this.droY - 5 : this.droY + 5 + this.txh;
            DecimalFormat fmt = new DecimalFormat("0");
            this.g.drawString((this.droTheta > 0.0 ? "+" : "") + fmt.format(Math.round(this.droTheta)), this.droX + 25, ty);
            double ax = this.XToAng(this.droX);
            double ay = this.YToAng(this.droY);
            this.g.setStroke(new BasicStroke(1.1f));
            for (int n = 1; n <= this.mol.NumAtoms(); ++n) {
                if (!this.selected[n - 1]) continue;
                double rx = this.mol.AtomX(n) - ax;
                double ry = this.mol.AtomY(n) - ay;
                double rth = Math.atan2(ry, rx);
                double ext = Math.sqrt(rx * rx + ry * ry);
                rx = ax + ext * Math.cos(rth + thrad);
                ry = ay + ext * Math.sin(rth + thrad);
                this.g.draw(new Ellipse2D.Double(this.AngToX(rx) - this.scale * 0.3, this.AngToY(ry) - this.scale * 0.3, this.scale * 0.6, this.scale * 0.6));
            }
        }
        if (this.outlineTemplate) {
            this.g.setColor(new Color(128, 128, 128));
            this.g.setStroke(new BasicStroke(1.0f));
            for (int n = 1; n <= this.oltMol.NumBonds(); ++n) {
                int from = this.oltMol.BondFrom(n);
                int to = this.oltMol.BondTo(n);
                this.g.draw(new Line2D.Double(this.AngToX(this.oltMol.AtomX(from)), this.AngToY(this.oltMol.AtomY(from)), this.AngToX(this.oltMol.AtomX(to)), this.AngToY(this.oltMol.AtomY(to))));
            }
        }
    }

    void DrawCorrections() {
        for (int i = 1; i <= this.mol.NumAtoms() - 1; ++i) {
            for (int j = i + 1; j <= this.mol.NumAtoms(); ++j) {
                double dy;
                double dx = this.mol.AtomX(i) - this.mol.AtomX(j);
                if (!(dx * dx + (dy = this.mol.AtomY(i) - this.mol.AtomY(j)) * dy < 0.04000000000000001)) continue;
                this.g.setColor(Color.RED);
                this.g.setStroke(new BasicStroke(0.5f));
                this.g.draw(new Ellipse2D.Double(this.px[i - 1] - this.scale * 0.25, this.py[i - 1] - this.scale * 0.25, this.scale * 0.5, this.scale * 0.5));
            }
        }
    }

    double AngToX(double AX) {
        return (this.offsetX + AX) * this.scale;
    }

    double AngToY(double AY) {
        return (this.offsetY - AY) * this.scale;
    }

    double XToAng(double PX) {
        return PX / this.scale - this.offsetX;
    }

    double YToAng(double PY) {
        return -PY / this.scale + this.offsetY;
    }
}

