%%
%%  wpf_7x14.erl --
%%
%%     7x14 proportional bitmap font.
%%
%%  Copyright (c) 2001-2004 Bjorn Gustavsson.
%%
%%  See the file "license.terms" for information on usage and redistribution
%%  of this file, and for a DISCLAIMER OF ALL WARRANTIES.
%%
%%     $Id$
%%

-module(wpf_7x14).
-export([desc/0,width_fun/0,width/0,height/0,draw/1,char/1,bold/1]).

desc() ->
    "Large (7x14)".

width_fun() -> fun cw/1.

width() -> 7.
height() -> 14.

draw([C|T]) ->
    char(C),
    draw(T);
draw([]) -> ok.

bold([C|T]) ->
    bold_char(C),
    bold(T);
bold([]) -> ok.

cw(32) -> 5;
cw($,) -> 4;
cw($.) -> 5;
cw($:) -> 5;
cw($-) -> 5;
cw($i) -> 2;
cw($l) -> 2;
cw($m) -> 10;
cw($r) -> 6;
cw($t) -> 5;
cw($I) -> 4;
cw(160) -> 3;
cw(169) -> 9;
cw(_) -> 7.

bold_char(C) ->
    char(C),
    Cw = cw(C),
    gl:bitmap(1, 1, 0, 0, -Cw+1, 0, <<0>>),
    char(C).

char(32) ->
 B = <<>>,
 gl:bitmap(0, 0, 0, 0, 5, 0, B);

char(127) ->
 B = <<>>,
 gl:bitmap(0, 0, 0, 0, 7, 0, B);

char(160) ->
 B = <<>>,
 gl:bitmap(0, 0, 0, 0, 3, 0, B);

% char: 0xff

char(255) ->
 B = <<16#60,16#90,16#10,16#38,16#28,16#48,16#44,16#84,16#84,16#0,16#48>>,
 gl:bitmap(6, 11, -1, 2, 7, 0, B);

% char: 0xfe

char(254) ->
 B = <<16#80,16#80,16#b8,16#c4,16#84,16#84,16#84,16#c4,16#b8,16#80,16#80,16#80>>,
 gl:bitmap(6, 12, -1, 2, 7, 0, B);

% char: 0xfd

char(253) ->
 B = <<16#60,16#90,16#10,16#38,16#28,16#48,16#44,16#84,16#84,16#20,16#10,16#8>>,
 gl:bitmap(6, 12, -1, 2, 7, 0, B);

% char: 0xfc

char(252) ->
 B = <<16#74,16#8c,16#84,16#84,16#84,16#84,16#84,16#0,16#48>>,
 gl:bitmap(6, 9, -1, 0, 7, 0, B);

% char: 0xfb

char(251) ->
 B = <<16#74,16#8c,16#84,16#84,16#84,16#84,16#84,16#0,16#48,16#30>>,
 gl:bitmap(6, 10, -1, 0, 7, 0, B);

% char: 0xfa

char(250) ->
 B = <<16#74,16#8c,16#84,16#84,16#84,16#84,16#84,16#20,16#10,16#8>>,
 gl:bitmap(6, 10, -1, 0, 7, 0, B);

% char: 0xf9

char(249) ->
 B = <<16#74,16#8c,16#84,16#84,16#84,16#84,16#84,16#10,16#20,16#40>>,
 gl:bitmap(6, 10, -1, 0, 7, 0, B);

% char: 0xf8

char(248) ->
 B = <<16#80,16#80,16#78,16#c4,16#a4,16#a4,16#94,16#94,16#78,16#8,16#4>>,
 gl:bitmap(6, 11, -1, 2, 7, 0, B);

% char: 0xf7

char(247) ->
 B = <<16#30,16#0,16#fc,16#0,16#30>>,
 gl:bitmap(6, 5, 0, 0, 7, 0, B);

% char: 0xf6

char(246) ->
 B = <<16#78,16#84,16#84,16#84,16#84,16#84,16#78,16#0,16#48>>,
 gl:bitmap(6, 9, -1, 0, 7, 0, B);

% char: 0xf5

char(245) ->
 B = <<16#78,16#84,16#84,16#84,16#84,16#84,16#78,16#0,16#50,16#28>>,
 gl:bitmap(6, 10, -1, 0, 7, 0, B);

% char: 0xf4

char(244) ->
 B = <<16#78,16#84,16#84,16#84,16#84,16#84,16#78,16#0,16#48,16#30>>,
 gl:bitmap(6, 10, -1, 0, 7, 0, B);

% char: 0xf3

char(243) ->
 B = <<16#78,16#84,16#84,16#84,16#84,16#84,16#78,16#0,16#20,16#10,16#8>>,
 gl:bitmap(6, 11, -1, 0, 7, 0, B);

% char: 0xf2

char(242) ->
 B = <<16#78,16#84,16#84,16#84,16#84,16#84,16#78,16#0,16#10,16#20,16#40>>,
 gl:bitmap(6, 11, -1, 0, 7, 0, B);

% char: 0xf1

char(241) ->
 B = <<16#84,16#84,16#84,16#84,16#84,16#c4,16#b8,16#0,16#50,16#28>>,
 gl:bitmap(6, 10, -1, 0, 7, 0, B);

% char: 0xf0

char(240) ->
 B = <<16#70,16#88,16#88,16#88,16#88,16#88,16#78,16#8,16#50,16#20,16#50>>,
 gl:bitmap(5, 11, -1, 0, 7, 0, B);

% char: 0xef

char(239) ->
 B = <<16#f8,16#20,16#20,16#20,16#20,16#20,16#60,16#0,16#50>>,
 gl:bitmap(5, 9, -2, 0, 7, 0, B);

% char: 0xee

char(238) ->
 B = <<16#f8,16#20,16#20,16#20,16#20,16#20,16#60,16#0,16#90,16#60>>,
 gl:bitmap(5, 10, -2, 0, 7, 0, B);

% char: 0xed

char(237) ->
 B = <<16#f8,16#20,16#20,16#20,16#20,16#20,16#60,16#0,16#40,16#20,16#10>>,
 gl:bitmap(5, 11, -2, 0, 7, 0, B);

% char: 0xec

char(236) ->
 B = <<16#f8,16#20,16#20,16#20,16#20,16#20,16#60,16#0,16#10,16#20,16#40>>,
 gl:bitmap(5, 11, -2, 0, 7, 0, B);

% char: 0xeb

char(235) ->
 B = <<16#78,16#84,16#80,16#fc,16#84,16#84,16#78,16#0,16#48>>,
 gl:bitmap(6, 9, -1, 0, 7, 0, B);

% char: 0xea

char(234) ->
 B = <<16#78,16#84,16#80,16#fc,16#84,16#84,16#78,16#0,16#48,16#30>>,
 gl:bitmap(6, 10, -1, 0, 7, 0, B);

% char: 0xe9

char(233) ->
 B = <<16#78,16#84,16#80,16#fc,16#84,16#84,16#78,16#0,16#20,16#10,16#8>>,
 gl:bitmap(6, 11, -1, 0, 7, 0, B);

% char: 0xe8

char(232) ->
 B = <<16#78,16#84,16#80,16#fc,16#84,16#84,16#78,16#0,16#10,16#20,16#40>>,
 gl:bitmap(6, 11, -1, 0, 7, 0, B);

% char: 0xe7

char(231) ->
 B = <<16#20,16#10,16#78,16#84,16#80,16#80,16#80,16#84,16#78>>,
 gl:bitmap(6, 9, -1, 2, 7, 0, B);

% char: 0xe6

char(230) ->
 B = <<16#7c,16#92,16#90,16#5e,16#32,16#92,16#7c>>,
 gl:bitmap(7, 7, 0, 0, 7, 0, B);

% char: 0xe5

char(229) ->
 B = <<16#74,16#8c,16#84,16#64,16#1c,16#84,16#78,16#0,16#20,16#50,16#20>>,
 gl:bitmap(6, 11, -1, 0, 7, 0, B);

% char: 0xe4

char(228) ->
 B = <<16#74,16#8c,16#84,16#64,16#1c,16#84,16#78,16#0,16#48>>,
 gl:bitmap(6, 9, -1, 0, 7, 0, B);

% char: 0xe3

char(227) ->
 B = <<16#74,16#8c,16#84,16#64,16#1c,16#84,16#78,16#0,16#50,16#28>>,
 gl:bitmap(6, 10, -1, 0, 7, 0, B);

% char: 0xe2

char(226) ->
 B = <<16#74,16#8c,16#84,16#64,16#1c,16#84,16#78,16#0,16#48,16#30>>,
 gl:bitmap(6, 10, -1, 0, 7, 0, B);

% char: 0xe1

char(225) ->
 B = <<16#74,16#8c,16#84,16#64,16#1c,16#84,16#78,16#0,16#20,16#10,16#8>>,
 gl:bitmap(6, 11, -1, 0, 7, 0, B);

% char: 0xe0

char(224) ->
 B = <<16#74,16#8c,16#84,16#64,16#1c,16#84,16#78,16#0,16#10,16#20,16#40>>,
 gl:bitmap(6, 11, -1, 0, 7, 0, B);

% char: 0xdf

char(223) ->
 B = <<16#f8,16#44,16#44,16#44,16#48,16#70,16#48,16#48,16#48,16#30>>,
 gl:bitmap(6, 10, -1, 0, 7, 0, B);

% char: 0xde

char(222) ->
 B = <<16#80,16#80,16#f8,16#84,16#84,16#84,16#84,16#f8,16#80,16#80>>,
 gl:bitmap(6, 10, -1, 0, 7, 0, B);

% char: 0xdd

char(221) ->
 B = <<16#20,16#20,16#20,16#20,16#30,16#50,16#48,16#88,16#84,16#84,16#30,16#8>>,
 gl:bitmap(6, 12, -1, 0, 7, 0, B);

% char: 0xdc

char(220) ->
 B = <<16#78,16#84,16#84,16#84,16#84,16#84,16#84,16#84,16#84,16#0,16#48>>,
 gl:bitmap(6, 11, -1, 0, 7, 0, B);

% char: 0xdb

char(219) ->
 B = <<16#78,16#84,16#84,16#84,16#84,16#84,16#84,16#84,16#84,16#0,16#48,16#30>>,
 gl:bitmap(6, 12, -1, 0, 7, 0, B);

% char: 0xda

char(218) ->
 B = <<16#78,16#84,16#84,16#84,16#84,16#84,16#84,16#84,16#84,16#0,16#30,16#8>>,
 gl:bitmap(6, 12, -1, 0, 7, 0, B);

% char: 0xd9

char(217) ->
 B = <<16#78,16#84,16#84,16#84,16#84,16#84,16#84,16#84,16#84,16#0,16#30,16#40>>,
 gl:bitmap(6, 12, -1, 0, 7, 0, B);

% char: 0xd8

char(216) ->
 B = <<16#80,16#80,16#78,16#c4,16#a4,16#a4,16#a4,16#94,16#94,16#94,16#8c,16#78,16#4,16#4>>,
 gl:bitmap(6, 14, -1, 2, 7, 0, B);

% char: 0xd7

char(215) ->
 B = <<16#82,16#44,16#28,16#10,16#28,16#44,16#82>>,
 gl:bitmap(7, 7, 0, 0, 7, 0, B);

% char: 0xd6

char(214) ->
 B = <<16#78,16#84,16#84,16#84,16#84,16#84,16#84,16#84,16#78,16#0,16#48>>,
 gl:bitmap(6, 11, -1, 0, 7, 0, B);

% char: 0xd5

char(213) ->
 B = <<16#78,16#84,16#84,16#84,16#84,16#84,16#84,16#84,16#78,16#0,16#50,16#28>>,
 gl:bitmap(6, 12, -1, 0, 7, 0, B);

% char: 0xd4

char(212) ->
 B = <<16#78,16#84,16#84,16#84,16#84,16#84,16#84,16#84,16#78,16#0,16#48,16#30>>,
 gl:bitmap(6, 12, -1, 0, 7, 0, B);

% char: 0xd3

char(211) ->
 B = <<16#78,16#84,16#84,16#84,16#84,16#84,16#84,16#84,16#78,16#0,16#30,16#8>>,
 gl:bitmap(6, 12, -1, 0, 7, 0, B);

% char: 0xd2

char(210) ->
 B = <<16#78,16#84,16#84,16#84,16#84,16#84,16#84,16#84,16#78,16#0,16#30,16#40>>,
 gl:bitmap(6, 12, -1, 0, 7, 0, B);

% char: 0xd1

char(209) ->
 B = <<16#8c,16#8c,16#94,16#94,16#94,16#a4,16#a4,16#c4,16#c4,16#0,16#50,16#28>>,
 gl:bitmap(6, 12, -1, 0, 7, 0, B);

% char: 0xd0

char(208) ->
 B = <<16#78,16#44,16#42,16#42,16#42,16#f2,16#42,16#42,16#44,16#78>>,
 gl:bitmap(7, 10, 0, 0, 7, 0, B);

% char: 0xcf

char(207) ->
 B = <<16#f8,16#20,16#20,16#20,16#20,16#20,16#20,16#20,16#f8,16#0,16#50>>,
 gl:bitmap(5, 11, -2, 0, 7, 0, B);

% char: 0xce

char(206) ->
 B = <<16#f8,16#20,16#20,16#20,16#20,16#20,16#20,16#20,16#f8,16#0,16#50,16#20>>,
 gl:bitmap(5, 12, -2, 0, 7, 0, B);

% char: 0xcd

char(205) ->
 B = <<16#f8,16#20,16#20,16#20,16#20,16#20,16#20,16#20,16#f8,16#0,16#60,16#10>>,
 gl:bitmap(5, 12, -2, 0, 7, 0, B);

% char: 0xcc

char(204) ->
 B = <<16#f8,16#20,16#20,16#20,16#20,16#20,16#20,16#20,16#f8,16#0,16#30,16#40>>,
 gl:bitmap(5, 12, -2, 0, 7, 0, B);

% char: 0xcb

char(203) ->
 B = <<16#fc,16#80,16#80,16#80,16#f8,16#80,16#80,16#80,16#fc,16#0,16#48>>,
 gl:bitmap(6, 11, -1, 0, 7, 0, B);

% char: 0xca

char(202) ->
 B = <<16#fc,16#80,16#80,16#80,16#f8,16#80,16#80,16#80,16#fc,16#0,16#48,16#30>>,
 gl:bitmap(6, 12, -1, 0, 7, 0, B);

% char: 0xc9

char(201) ->
 B = <<16#fc,16#80,16#80,16#80,16#f8,16#80,16#80,16#80,16#fc,16#0,16#30,16#8>>,
 gl:bitmap(6, 12, -1, 0, 7, 0, B);

% char: 0xc8

char(200) ->
 B = <<16#fc,16#80,16#80,16#80,16#f8,16#80,16#80,16#80,16#fc,16#0,16#30,16#40>>,
 gl:bitmap(6, 12, -1, 0, 7, 0, B);

% char: 0xc7

char(199) ->
 B = <<16#20,16#10,16#78,16#84,16#84,16#80,16#80,16#80,16#80,16#84,16#84,16#78>>,
 gl:bitmap(6, 12, -1, 2, 7, 0, B);

% char: 0xc6

char(198) ->
 B = <<16#9e,16#90,16#90,16#90,16#90,16#fc,16#90,16#90,16#50,16#3e>>,
 gl:bitmap(7, 10, 0, 0, 7, 0, B);

% char: 0xc5

char(197) ->
 B = <<16#84,16#84,16#84,16#84,16#fc,16#84,16#84,16#48,16#30,16#0,16#30,16#30>>,
 gl:bitmap(6, 12, -1, 0, 7, 0, B);

% char: 0xc4

char(196) ->
 B = <<16#84,16#84,16#84,16#84,16#fc,16#84,16#84,16#48,16#30,16#0,16#48,16#48>>,
 gl:bitmap(6, 12, -1, 0, 7, 0, B);

% char: 0xc3

char(195) ->
 B = <<16#84,16#84,16#84,16#84,16#fc,16#84,16#84,16#48,16#30,16#0,16#50,16#28>>,
 gl:bitmap(6, 12, -1, 0, 7, 0, B);

% char: 0xc2

char(194) ->
 B = <<16#84,16#84,16#84,16#84,16#fc,16#84,16#84,16#48,16#30,16#0,16#48,16#30>>,
 gl:bitmap(6, 12, -1, 0, 7, 0, B);

% char: 0xc1

char(193) ->
 B = <<16#84,16#84,16#84,16#84,16#fc,16#84,16#84,16#48,16#30,16#0,16#30,16#8>>,
 gl:bitmap(6, 12, -1, 0, 7, 0, B);

% char: 0xc0

char(192) ->
 B = <<16#84,16#84,16#84,16#84,16#fc,16#84,16#84,16#48,16#30,16#0,16#30,16#40>>,
 gl:bitmap(6, 12, -1, 0, 7, 0, B);

% char: 0xbf

char(191) ->
 B = <<16#78,16#84,16#84,16#8,16#10,16#10,16#10,16#10,16#0,16#10,16#10>>,
 gl:bitmap(6, 11, -1, 2, 7, 0, B);

% char: 0xbe

char(190) ->
 B = <<16#4,16#9c,16#54,16#4c,16#24,16#d0,16#30,16#48,16#24,16#c4>>,
 gl:bitmap(6, 10, -1, 0, 7, 0, B);

% char: 0xbd

char(189) ->
 B = <<16#9c,16#88,16#44,16#34,16#28,16#50,16#48,16#48,16#c4,16#40>>,
 gl:bitmap(6, 10, -1, 0, 7, 0, B);

% char: 0xbc

char(188) ->
 B = <<16#84,16#9c,16#54,16#2c,16#24,16#50,16#48,16#48,16#c4,16#40>>,
 gl:bitmap(6, 10, -1, 0, 7, 0, B);

% char: 0xbb

char(187) ->
 B = <<16#a0,16#50,16#28,16#14,16#28,16#50,16#a0>>,
 gl:bitmap(6, 7, -1, 0, 7, 0, B);

% char: 0xba

char(186) ->
 B = <<16#f0,16#0,16#60,16#90,16#90,16#60>>,
 gl:bitmap(4, 6, -2, -4, 7, 0, B);

% char: 0xb9

char(185) ->
 B = <<16#40,16#40,16#40,16#40,16#c0,16#40>>,
 gl:bitmap(2, 6, -1, -4, 7, 0, B);

% char: 0xb8

char(184) ->
 B = <<16#80,16#40,16#40>>,
 gl:bitmap(2, 3, -2, 2, 7, 0, B);

% char: 0xb7

char(183) ->
 B = <<16#80>>,
 gl:bitmap(1, 1, -3, -5, 7, 0, B);

% char: 0xb6

char(182) ->
 B = <<16#38,16#28,16#28,16#28,16#28,16#28,16#68,16#a8,16#a8,16#a8,16#a8,16#78>>,
 gl:bitmap(5, 12, -1, 2, 7, 0, B);

% char: 0xb5

char(181) ->
 B = <<16#80,16#80,16#a8,16#d8,16#88,16#88,16#88,16#88>>,
 gl:bitmap(5, 8, -1, 2, 7, 0, B);

% char: 0xb4

char(180) ->
 B = <<16#80,16#40,16#20,16#10>>,
 gl:bitmap(4, 4, -1, -7, 7, 0, B);

% char: 0xb3

char(179) ->
 B = <<16#60,16#90,16#10,16#60,16#10,16#90,16#60>>,
 gl:bitmap(4, 7, -1, -4, 7, 0, B);

% char: 0xb2

char(178) ->
 B = <<16#f0,16#80,16#40,16#20,16#10,16#90,16#60>>,
 gl:bitmap(4, 7, -1, -4, 7, 0, B);

% char: 0xb1

char(177) ->
 B = <<16#f8,16#20,16#20,16#f8,16#20,16#20>>,
 gl:bitmap(5, 6, -1, 0, 7, 0, B);

% char: 0xb0

char(176) ->
 B = <<16#60,16#90,16#90,16#60>>,
 gl:bitmap(4, 4, -1, -7, 7, 0, B);

% char: 0xaf

char(175) ->
 B = <<16#f0>>,
 gl:bitmap(4, 1, 0, -9, 7, 0, B);

% char: 0xae

char(174) ->
 B = <<16#78,16#84,16#cc,16#cc,16#cc,16#f4,16#cc,16#cc,16#f4,16#84,16#78>>,
 gl:bitmap(6, 11, -1, 0, 7, 0, B);

% char: 0xad

char(173) ->
 B = <<16#f0>>,
 gl:bitmap(4, 1, 0, -3, 7, 0, B);

% char: 0xac

char(172) ->
 B = <<16#8,16#8,16#8,16#f8>>,
 gl:bitmap(5, 4, 0, 0, 7, 0, B);

% char: 0xab

char(171) ->
 B = <<16#14,16#28,16#50,16#a0,16#50,16#28,16#14>>,
 gl:bitmap(6, 7, -1, 0, 7, 0, B);

% char: 0xaa

char(170) ->
 B = <<16#f8,16#0,16#68,16#98,16#88,16#78,16#88,16#70>>,
 gl:bitmap(5, 8, -2, -3, 7, 0, B);

% char: 0xa9 (Copyright)

char(169) ->
    %%B = <<16#78,16#84,16#b4,16#cc,16#c4,16#c4,16#c4,16#cc,16#b4,16#84,16#78>>,
    B = <<
	 2#00111100,
	 2#01000010,
	 2#10011001,
	 2#10100101,
	 2#10100001,
	 2#10100001,
	 2#10100001,
	 2#10100101,
	 2#10011001,
	 2#01000010,
	 2#00111100
	 >>,
    gl:bitmap(8, 11, -1, 0, 9, 0, B);

% char: 0xa8

char(168) ->
 B = <<16#90,16#90>>,
 gl:bitmap(4, 2, -1, -9, 7, 0, B);

% char: 0xa7

char(167) ->
 B = <<16#78,16#84,16#8,16#30,16#48,16#84,16#48,16#30,16#40,16#84,16#78>>,
 gl:bitmap(6, 11, -1, 0, 7, 0, B);

% char: 0xa6

char(166) ->
 B = <<16#80,16#80,16#80,16#80,16#0,16#0,16#80,16#80,16#80,16#80>>,
 gl:bitmap(1, 10, -3, 0, 7, 0, B);

% char: 0xa5

char(165) ->
 B = <<16#10,16#10,16#10,16#fc,16#10,16#10,16#fc,16#30,16#48,16#84>>,
 gl:bitmap(6, 10, -1, 0, 7, 0, B);

% char: 0xa4

char(164) ->
 B = <<16#84,16#78,16#48,16#48,16#78,16#84>>,
 gl:bitmap(6, 6, -1, -2, 7, 0, B);

% char: 0xa3

char(163) ->
 B = <<16#48,16#f0,16#40,16#40,16#f0,16#40,16#40,16#48,16#30>>,
 gl:bitmap(5, 9, -1, 0, 7, 0, B);

% char: 0xa2

char(162) ->
 B = <<16#20,16#7c,16#a4,16#a0,16#a0,16#a0,16#a4,16#7c,16#20>>,
 gl:bitmap(6, 9, -1, 1, 7, 0, B);

% char: 0xa1

char(161) ->
 B = <<16#80,16#80,16#80,16#80,16#80,16#80,16#80,16#0,16#80,16#80>>,
 gl:bitmap(1, 10, -3, 0, 7, 0, B);

% char: 0x7e '~' */

char(126) ->
 B = <<16#8,16#94,16#a4,16#40>>,
 gl:bitmap(6, 4, -1, -7, 7, 0, B);

% char: 0x7d '}' */

char(125) ->
 B = <<16#c0,16#20,16#20,16#20,16#20,16#20,16#10,16#20,16#20,16#20,16#20,16#20,16#c0>>,
 gl:bitmap(4, 13, -1, 2, 7, 0, B);

% char: 0x7c '|' */

char(124) ->
 B = <<16#80,16#80,16#80,16#80,16#80,16#80,16#80,16#80,16#80,16#80,16#80,16#80,16#80>>,
 gl:bitmap(1, 13, -3, 2, 7, 0, B);

% char: 0x7b '{' */

char(123) ->
 B = <<16#30,16#40,16#40,16#40,16#40,16#40,16#80,16#40,16#40,16#40,16#40,16#40,16#30>>,
 gl:bitmap(4, 13, -3, 2, 7, 0, B);

% char: 0x7a 'z' */

char(122) ->
 B = <<16#fc,16#40,16#20,16#20,16#10,16#8,16#fc>>,
 gl:bitmap(6, 7, -1, 0, 7, 0, B);

% char: 0x79 'y' */

char(121) ->
 B = <<16#78,16#84,16#4,16#74,16#8c,16#84,16#84,16#84,16#84>>,
 gl:bitmap(6, 9, -1, 2, 7, 0, B);

% char: 0x78 'x' */

char(120) ->
 B = <<16#84,16#84,16#48,16#30,16#48,16#84,16#84>>,
 gl:bitmap(6, 7, -1, 0, 7, 0, B);

% char: 0x77 'w' */

char(119) ->
    %%B = <<16#50,16#a8,16#a8,16#a8,16#a8,16#88,16#88>>,
    B = <<
       	 2#01000100,
	 2#01000100,
       	 2#01000100,
	 2#10101010,
	 2#10101010,
	 2#10010010,
	 2#10010010
	 >>,
    gl:bitmap(7, 7, -1, 0, 8, 0, B);

% char: 0x76 'v' */

char(118) ->
 B = <<16#20,16#20,16#50,16#50,16#88,16#88,16#88>>,
 gl:bitmap(5, 7, -1, 0, 7, 0, B);

% char: 0x75 'u' */

char(117) ->
 B = <<16#74,16#8c,16#84,16#84,16#84,16#84,16#84>>,
 gl:bitmap(6, 7, -1, 0, 7, 0, B);

% char: 0x74 't' */

char(116) ->
    %%B = <<16#18,16#24,16#20,16#20,16#20,16#20,16#f8,16#20,16#20,16#20>>,
    B = <<
	 2#01110000,
	 2#01000000,
	 2#01000000,
	 2#01000000,
	 2#01000000,
	 2#01000000,
	 2#11110000,
	 2#01000000,
	 2#01000000,
	 2#01000000
	 >>,

    gl:bitmap(4, 10, -1, 0, 5, 0, B);

% char: 0x73 's' */

char(115) ->
 B = <<16#78,16#84,16#8,16#30,16#40,16#84,16#78>>,
 gl:bitmap(6, 7, -1, 0, 7, 0, B);

% char: 0x72 'r' */

char(114) ->
    %%B = <<16#80,16#80,16#80,16#80,16#84,16#c4,16#b8>>,
    B = <<
	 2#10000000,
	 2#10000000,
	 2#10000000,
	 2#10000000,
	 2#10000000,
	 2#11000000,
	 2#10111000
	 >>,
    gl:bitmap(5, 7, -1, 0, 6, 0, B);

% char: 0x71 'q' */

char(113) ->
 B = <<16#4,16#4,16#74,16#8c,16#84,16#84,16#84,16#8c,16#74>>,
 gl:bitmap(6, 9, -1, 2, 7, 0, B);

% char: 0x70 'p' */

char(112) ->
 B = <<16#80,16#80,16#b8,16#c4,16#84,16#84,16#84,16#c4,16#b8>>,
 gl:bitmap(6, 9, -1, 2, 7, 0, B);

% char: 0x6f 'o' */

char(111) ->
 B = <<16#78,16#84,16#84,16#84,16#84,16#84,16#78>>,
 gl:bitmap(6, 7, -1, 0, 7, 0, B);

% char: 0x6e 'n' */

char(110) ->
 B = <<16#84,16#84,16#84,16#84,16#84,16#c4,16#b8>>,
 gl:bitmap(6, 7, -1, 0, 7, 0, B);

% char: 0x6d 'm' */

char(109) ->
    %%B = <<16#88,16#a8,16#a8,16#a8,16#a8,16#a8,16#d0>>,
    B = <<
	 2#1000100010000000:16,
	 2#1000100010000000:16,
	 2#1000100010000000:16,
	 2#1000100010000000:16,
	 2#1000100010000000:16,
	 2#1000100010000000:16,
	 2#1111011100000000:16
	 >>,
    gl:bitmap(9, 7, -1, 0, 10, 0, B);

% char: 0x6c 'l' */

char(108) ->
    %%B = <<16#f8,16#20,16#20,16#20,16#20,16#20,16#20,16#20,16#20,16#60>>,
    B = <<
	 2#10000000,
	 2#10000000,
	 2#10000000,
	 2#10000000,
	 2#10000000,
	 2#10000000,
	 2#10000000,
	 2#10000000,
	 2#10000000,
	 2#10000000
	 >>,
    gl:bitmap(1, 10, -1, 0, 2, 0, B);

% char: 0x6b 'k' */

char(107) ->
 B = <<16#84,16#88,16#90,16#e0,16#a0,16#90,16#88,16#80,16#80,16#80>>,
 gl:bitmap(6, 10, -1, 0, 7, 0, B);

% char: 0x6a 'j' */

char(106) ->
 B = <<16#70,16#88,16#88,16#8,16#8,16#8,16#8,16#8,16#18,16#0,16#8,16#8>>,
 gl:bitmap(5, 12, -1, 2, 7, 0, B);

% char: 0x69 'i' */

char(105) ->
    %%B = <<16#f8,16#20,16#20,16#20,16#20,16#20,16#60,16#0,16#20,16#20>>,
    B = <<
	 2#10000000,
	 2#10000000,
	 2#10000000,
	 2#10000000,
	 2#10000000,
	 2#10000000,
	 2#10000000,
	 2#00000000,
	 2#00000000,
	 2#10000000
	 >>,
    gl:bitmap(1, 10, -1, 0, 2, 0, B);

% char: 0x68 'h' */

char(104) ->
 B = <<16#84,16#84,16#84,16#84,16#84,16#c4,16#b8,16#80,16#80,16#80>>,
 gl:bitmap(6, 10, -1, 0, 7, 0, B);

% char: 0x67 'g' */

char(103) ->
    %%B = <<16#78,16#84,16#b8,16#40,16#70,16#88,16#88,16#88,16#74>>,
        B = <<
	 2#11111000,
	 2#00000100,
	 2#00000100,
	 2#01111100,
	 2#10000100,
	 2#10000100,
	 2#10000100,
	 2#10000100,
	 2#10000100,
	 2#01111100
	 >>,
    gl:bitmap(6, 10, -1, 3, 7, 0, B);

% char: 0x66 'f' */

char(102) ->
 B = <<16#20,16#20,16#20,16#20,16#20,16#f8,16#20,16#20,16#24,16#18>>,
 gl:bitmap(6, 10, -1, 0, 7, 0, B);

% char: 0x65 'e' */

char(101) ->
 B = <<16#78,16#84,16#80,16#fc,16#84,16#84,16#78>>,
 gl:bitmap(6, 7, -1, 0, 7, 0, B);

% char: 0x64 'd' */

char(100) ->
 B = <<16#74,16#8c,16#84,16#84,16#84,16#8c,16#74,16#4,16#4,16#4>>,
 gl:bitmap(6, 10, -1, 0, 7, 0, B);

% char: 0x63 'c' */

char(99) ->
 B = <<16#78,16#84,16#80,16#80,16#80,16#84,16#78>>,
 gl:bitmap(6, 7, -1, 0, 7, 0, B);

% char: 0x62 'b' */

char(98) ->
 B = <<16#b8,16#c4,16#84,16#84,16#84,16#c4,16#b8,16#80,16#80,16#80>>,
 gl:bitmap(6, 10, -1, 0, 7, 0, B);

% char: 0x61 'a' */

char(97) ->
 B = <<16#74,16#8c,16#84,16#64,16#1c,16#84,16#78>>,
 gl:bitmap(6, 7, -1, 0, 7, 0, B);

% char: 0x60 '`' */

char(96) ->
 B = <<16#40,16#80,16#80,16#c0>>,
 gl:bitmap(2, 4, -4, -7, 7, 0, B);

% char: 0x5f '_' */

char(95) ->
 B = <<16#fc>>,
 gl:bitmap(6, 1, -1, 2, 7, 0, B);

% char: 0x5e '^' */

char(94) ->
 B = <<16#84,16#48,16#30>>,
 gl:bitmap(6, 3, -1, -8, 7, 0, B);

% char: 0x5d ']' */

char(93) ->
 B = <<16#f0,16#10,16#10,16#10,16#10,16#10,16#10,16#10,16#10,16#10,16#10,16#10,16#f0>>,
 gl:bitmap(4, 13, -1, 2, 7, 0, B);

% char: 0x5c '\' */

char(92) ->
 B = <<16#4,16#4,16#8,16#8,16#10,16#10,16#20,16#20,16#20,16#40,16#40,16#80,16#80>>,
 gl:bitmap(6, 13, -1, 2, 7, 0, B);

% char: 0x5b '[' */

char(91) ->
 B = <<16#f0,16#80,16#80,16#80,16#80,16#80,16#80,16#80,16#80,16#80,16#80,16#80,16#f0>>,
 gl:bitmap(4, 13, -3, 2, 7, 0, B);

% char: 0x5a 'Z' */

char(90) ->
 B = <<16#fc,16#80,16#40,16#40,16#20,16#10,16#10,16#8,16#4,16#fc>>,
 gl:bitmap(6, 10, -1, 0, 7, 0, B);

% char: 0x59 'Y' */

char(89) ->
 B = <<16#20,16#20,16#20,16#20,16#20,16#50,16#50,16#88,16#88,16#88>>,
 gl:bitmap(5, 10, -1, 0, 7, 0, B);

% char: 0x58 'X' */

char(88) ->
 B = <<16#84,16#84,16#48,16#48,16#30,16#30,16#48,16#48,16#84,16#84>>,
 gl:bitmap(6, 10, -1, 0, 7, 0, B);

% char: 0x57 'W' */

char(87) ->
 B = <<16#84,16#cc,16#cc,16#b4,16#b4,16#84,16#84,16#84,16#84,16#84>>,
 gl:bitmap(6, 10, -1, 0, 7, 0, B);

% char: 0x56 'V' */

char(86) ->
 B = <<16#30,16#30,16#30,16#48,16#48,16#48,16#84,16#84,16#84,16#84>>,
 gl:bitmap(6, 10, -1, 0, 7, 0, B);

% char: 0x55 'U' */

char(85) ->
 B = <<16#78,16#84,16#84,16#84,16#84,16#84,16#84,16#84,16#84,16#84>>,
 gl:bitmap(6, 10, -1, 0, 7, 0, B);

% char: 0x54 'T' */

char(84) ->
 B = <<16#10,16#10,16#10,16#10,16#10,16#10,16#10,16#10,16#10,16#fe>>,
 gl:bitmap(7, 10, 0, 0, 7, 0, B);

% char: 0x53 'S' */

char(83) ->
 B = <<16#78,16#84,16#84,16#4,16#18,16#60,16#80,16#84,16#84,16#78>>,
 gl:bitmap(6, 10, -1, 0, 7, 0, B);

% char: 0x52 'R' */

char(82) ->
 B = <<16#84,16#84,16#88,16#90,16#f8,16#84,16#84,16#84,16#84,16#f8>>,
 gl:bitmap(6, 10, -1, 0, 7, 0, B);

% char: 0x51 'Q' */

char(81) ->
 B = <<16#4,16#8,16#78,16#8c,16#94,16#e4,16#84,16#84,16#84,16#84,16#84,16#78>>,
 gl:bitmap(6, 12, -1, 2, 7, 0, B);

% char: 0x50 'P' */

char(80) ->
 B = <<16#80,16#80,16#80,16#80,16#f8,16#84,16#84,16#84,16#84,16#f8>>,
 gl:bitmap(6, 10, -1, 0, 7, 0, B);

% char: 0x4f 'O' */

char(79) ->
 B = <<16#78,16#84,16#84,16#84,16#84,16#84,16#84,16#84,16#84,16#78>>,
 gl:bitmap(6, 10, -1, 0, 7, 0, B);

% char: 0x4e 'N' */

char(78) ->
 B = <<16#84,16#84,16#8c,16#8c,16#94,16#a4,16#c4,16#c4,16#84,16#84>>,
 gl:bitmap(6, 10, -1, 0, 7, 0, B);

% char: 0x4d 'M' */

char(77) ->
 B = <<16#84,16#84,16#84,16#84,16#84,16#b4,16#b4,16#cc,16#cc,16#84>>,
 gl:bitmap(6, 10, -1, 0, 7, 0, B);

% char: 0x4c 'L' */

char(76) ->
 B = <<16#fc,16#80,16#80,16#80,16#80,16#80,16#80,16#80,16#80,16#80>>,
 gl:bitmap(6, 10, -1, 0, 7, 0, B);

% char: 0x4b 'K' */

char(75) ->
 B = <<16#84,16#84,16#88,16#90,16#a0,16#c0,16#a0,16#90,16#88,16#84>>,
 gl:bitmap(6, 10, -1, 0, 7, 0, B);

% char: 0x4a 'J' */

char(74) ->
 B = <<16#70,16#88,16#88,16#8,16#8,16#8,16#8,16#8,16#8,16#1c>>,
 gl:bitmap(6, 10, -1, 0, 7, 0, B);

% char: 0x49 'I' */

char(73) ->
    %%B = <<16#f8,16#20,16#20,16#20,16#20,16#20,16#20,16#20,16#20,16#f8>>,
    B = <<
	 2#11100000,
	 2#01000000,
	 2#01000000,
	 2#01000000,
	 2#01000000,
	 2#01000000,
	 2#01000000,
	 2#01000000,
	 2#01000000,
	 2#11100000
	 >>,
    gl:bitmap(3, 10, -1, 0, 4, 0, B);

% char: 0x48 'H' */

char(72) ->
 B = <<16#84,16#84,16#84,16#84,16#84,16#fc,16#84,16#84,16#84,16#84>>,
 gl:bitmap(6, 10, -1, 0, 7, 0, B);

% char: 0x47 'G' */

char(71) ->
 B = <<16#74,16#8c,16#84,16#84,16#9c,16#80,16#80,16#84,16#84,16#78>>,
 gl:bitmap(6, 10, -1, 0, 7, 0, B);

% char: 0x46 'F' */

char(70) ->
 B = <<16#80,16#80,16#80,16#80,16#80,16#f0,16#80,16#80,16#80,16#fc>>,
 gl:bitmap(6, 10, -1, 0, 7, 0, B);

% char: 0x45 'E' */

char(69) ->
 B = <<16#fc,16#80,16#80,16#80,16#80,16#f0,16#80,16#80,16#80,16#fc>>,
 gl:bitmap(6, 10, -1, 0, 7, 0, B);

% char: 0x44 'D' */

char(68) ->
    %%B = <<16#f8,16#44,16#44,16#44,16#44,16#44,16#44,16#44,16#44,16#f8>>,
    B = <<
	 2#11111000,
	 2#10000100,
	 2#10000100,
	 2#10000100,
	 2#10000100,
	 2#10000100,
	 2#10000100,
	 2#10000100,
	 2#10000100,
	 2#11111000
	 >>,
    gl:bitmap(6, 10, -1, 0, 7, 0, B);

% char: 0x43 'C' */

char(67) ->
 B = <<16#78,16#84,16#84,16#80,16#80,16#80,16#80,16#84,16#84,16#78>>,
 gl:bitmap(6, 10, -1, 0, 7, 0, B);

% char: 0x42 'B' */

char(66) ->
 B = <<16#f8,16#44,16#44,16#44,16#44,16#78,16#44,16#44,16#44,16#f8>>,
 gl:bitmap(6, 10, -1, 0, 7, 0, B);

% char: 0x41 'A' */

char(65) ->
 B = <<16#84,16#84,16#84,16#84,16#fc,16#84,16#84,16#84,16#48,16#30>>,
    gl:bitmap(6, 10, -1, 0, 7, 0, B);

% char: 0x40 '@' */

char(64) ->
 B = <<16#3c,16#40,16#9c,16#a4,16#a4,16#a4,16#a4,16#9c,16#44,16#38>>,
 gl:bitmap(6, 10, -1, 0, 7, 0, B);

% char: 0x3f '?' */

char(63) ->
 B = <<16#10,16#10,16#0,16#10,16#10,16#10,16#8,16#84,16#84,16#78>>,
 gl:bitmap(6, 10, -1, 0, 7, 0, B);

% char: 0x3e '>' */

char(62) ->
 B = <<16#80,16#40,16#20,16#10,16#8,16#10,16#20,16#40,16#80>>,
 gl:bitmap(5, 9, -1, 0, 7, 0, B);

% char: 0x3d '=' */

char(61) ->
 B = <<16#fc,16#0,16#0,16#fc>>,
 gl:bitmap(6, 4, -1, -3, 7, 0, B);

% char: 0x3c '<' */

char(60) ->
 B = <<16#8,16#10,16#20,16#40,16#80,16#40,16#20,16#10,16#8>>,
 gl:bitmap(5, 9, -1, 0, 7, 0, B);

% char: 0x3b ';' */

char(59) ->
 B = <<16#80,16#40,16#40,16#c0,16#0,16#0,16#c0,16#c0>>,
 gl:bitmap(2, 8, -3, 1, 7, 0, B);

% char: 0x3a ':' */

char(58) ->
    B = <<16#40,16#e0,16#40,16#0,16#0,16#40,16#e0,16#40>>,
    gl:bitmap(3, 8, -2, 0, 5, 0, B);

% char: 0x39 '9' */

char(57) ->
 B = <<16#70,16#88,16#84,16#4,16#74,16#8c,16#84,16#84,16#84,16#78>>,
 gl:bitmap(6, 10, -1, 0, 7, 0, B);

% char: 0x38 '8' */

char(56) ->
 B = <<16#78,16#84,16#84,16#84,16#48,16#30,16#48,16#84,16#84,16#78>>,
 gl:bitmap(6, 10, -1, 0, 7, 0, B);

% char: 0x37 '7' */

char(55) ->
 B = <<16#10,16#10,16#10,16#10,16#10,16#10,16#8,16#88,16#84,16#fc>>,
 gl:bitmap(6, 10, -1, 0, 7, 0, B);

% char: 0x36 '6' */

char(54) ->
 B = <<16#78,16#84,16#84,16#84,16#c4,16#b8,16#80,16#84,16#44,16#38>>,
 gl:bitmap(6, 10, -1, 0, 7, 0, B);

% char: 0x35 '5' */

char(53) ->
 B = <<16#78,16#84,16#84,16#4,16#4,16#84,16#f8,16#80,16#80,16#fc>>,
 gl:bitmap(6, 10, -1, 0, 7, 0, B);

% char: 0x34 '4' */

char(52) ->
 B = <<16#8,16#8,16#fc,16#88,16#48,16#48,16#28,16#28,16#18,16#8>>,
 gl:bitmap(6, 10, -1, 0, 7, 0, B);

% char: 0x33 '3' */

char(51) ->
 B = <<16#78,16#84,16#84,16#4,16#4,16#38,16#4,16#84,16#84,16#78>>,
 gl:bitmap(6, 10, -1, 0, 7, 0, B);

% char: 0x32 '2' */

char(50) ->
 B = <<16#fc,16#40,16#20,16#10,16#8,16#8,16#4,16#84,16#84,16#78>>,
 gl:bitmap(6, 10, -1, 0, 7, 0, B);

% char: 0x31 '1' */

char(49) ->
 B = <<16#f8,16#20,16#20,16#20,16#20,16#20,16#20,16#a0,16#60,16#20>>,
 gl:bitmap(5, 10, -2, 0, 7, 0, B);

% char: 0x30 '0' */

char(48) ->
 B = <<16#30,16#48,16#84,16#84,16#84,16#84,16#84,16#84,16#48,16#30>>,
 gl:bitmap(6, 10, -1, 0, 7, 0, B);

% char: 0x2f '/' */

char(47) ->
 B = <<16#80,16#80,16#40,16#40,16#20,16#20,16#10,16#10,16#10,16#8,16#8,16#4,16#4>>,
 gl:bitmap(6, 13, -1, 2, 7, 0, B);

% char: 0x2e '.' */

char(46) ->
    B = <<16#40,16#e0,16#40>>,
    gl:bitmap(3, 3, -2, 1, 5, 0, B);

% char: 0x2d '-' */

char(45) ->
    B = <<16#f0>>,
    gl:bitmap(4, 1, -1, -4, 5, 0, B);

% char: 0x2c ',' */

char(44) ->
    B = <<16#80,16#40,16#40,16#c0>>,
    gl:bitmap(2, 4, -2, 2, 4, 0, B);

% char: 0x2b '+' */

char(43) ->
 B = <<16#20,16#20,16#20,16#f8,16#20,16#20,16#20>>,
 gl:bitmap(5, 7, -1, -1, 7, 0, B);

% char: 0x2a '*' */

char(42) ->
 B = <<16#20,16#a8,16#70,16#20,16#70,16#a8,16#20>>,
 gl:bitmap(5, 7, -2, -3, 7, 0, B);

% char: 0x29 ')' */

char(41) ->
 B = <<16#80,16#40,16#20,16#20,16#10,16#10,16#10,16#10,16#10,16#20,16#20,16#40,16#80>>,
 gl:bitmap(4, 13, -1, 2, 7, 0, B);

% char: 0x28 '(' */

char(40) ->
 B = <<16#10,16#20,16#40,16#40,16#80,16#80,16#80,16#80,16#80,16#40,16#40,16#20,16#10>>,
 gl:bitmap(4, 13, -3, 2, 7, 0, B);

% char: 0x27 ''' */

char(39) ->
 B = <<16#80,16#40,16#40,16#c0>>,
 gl:bitmap(2, 4, -3, -7, 7, 0, B);

% char: 0x26 '&' */

char(38) ->
 B = <<16#64,16#98,16#88,16#94,16#64,16#30,16#48,16#48,16#48,16#30>>,
 gl:bitmap(6, 10, -1, 0, 7, 0, B);

% char: 0x25 '%' */

char(37) ->
 B = <<16#98,16#a4,16#64,16#38,16#20,16#10,16#70,16#98,16#94,16#64>>,
 gl:bitmap(6, 10, -1, 0, 7, 0, B);

% char: 0x24 '$' */

char(36) ->
 B = <<16#10,16#78,16#94,16#94,16#14,16#38,16#50,16#94,16#94,16#78,16#10>>,
 gl:bitmap(6, 11, -1, 1, 7, 0, B);

% char: 0x23 '#' */

char(35) ->
 B = <<16#50,16#50,16#50,16#fc,16#28,16#28,16#fc,16#14,16#14,16#14>>,
 gl:bitmap(6, 10, -1, 0, 7, 0, B);

% char: 0x22 '"' */

char(34) ->
 B = <<16#90,16#48,16#48,16#d8>>,
 gl:bitmap(5, 4, -1, -7, 7, 0, B);

% char: 0x21 '!' */

char(33) ->
 B = <<16#80,16#80,16#0,16#80,16#80,16#80,16#80,16#80,16#80,16#80>>,
 gl:bitmap(1, 10, -3, 0, 7, 0, B);

% char: 0x19

char(25) ->
 B = <<16#80,16#80,16#80,16#80,16#80,16#80,16#80,16#80,16#80,16#80,16#80,16#80,16#80,16#80>>,
 gl:bitmap(1, 14, -3, 2, 7, 0, B);

% char: 0x18

char(24) ->
 B = <<16#10,16#10,16#10,16#10,16#10,16#10,16#fe>>,
 gl:bitmap(7, 7, 0, 2, 7, 0, B);

% char: 0x17

char(23) ->
 B = <<16#fe,16#10,16#10,16#10,16#10,16#10,16#10,16#10>>,
 gl:bitmap(7, 8, 0, -4, 7, 0, B);

% char: 0x16

char(22) ->
 B = <<16#10,16#10,16#10,16#10,16#10,16#10,16#f0,16#10,16#10,16#10,16#10,16#10,16#10,16#10>>,
 gl:bitmap(4, 14, 0, 2, 7, 0, B);

% char: 0x15

char(21) ->
 B = <<16#80,16#80,16#80,16#80,16#80,16#80,16#f0,16#80,16#80,16#80,16#80,16#80,16#80,16#80>>,
 gl:bitmap(4, 14, -3, 2, 7, 0, B);

% char: 0x14

char(20) ->
 B = <<16#fe>>,
 gl:bitmap(7, 1, 0, 2, 7, 0, B);

% char: 0x13

char(19) ->
 B = <<16#fe>>,
 gl:bitmap(7, 1, 0, -2, 7, 0, B);

% char: 0x12

char(18) ->
 B = <<16#fe>>,
 gl:bitmap(7, 1, 0, -4, 7, 0, B);

% char: 0x11

char(17) ->
 B = <<16#fe>>,
 gl:bitmap(7, 1, 0, -7, 7, 0, B);

% char: 0x10

char(16) ->
 B = <<16#fe>>,
 gl:bitmap(7, 1, 0, -11, 7, 0, B);

% char: 0xf

char(15) ->
 B = <<16#10,16#10,16#10,16#10,16#10,16#10,16#fe,16#10,16#10,16#10,16#10,16#10,16#10,16#10>>,
 gl:bitmap(7, 14, 0, 2, 7, 0, B);

% char: 0xe

char(14) ->
 B = <<16#f0,16#80,16#80,16#80,16#80,16#80,16#80,16#80>>,
 gl:bitmap(4, 8, -3, -4, 7, 0, B);

% char: 0xd

char(13) ->
 B = <<16#80,16#80,16#80,16#80,16#80,16#80,16#f0>>,
 gl:bitmap(4, 7, -3, 2, 7, 0, B);

% char: 0xc

char(12) ->
 B = <<16#10,16#10,16#10,16#10,16#10,16#10,16#f0>>,
 gl:bitmap(4, 7, 0, 2, 7, 0, B);

% char: 0xb

char(11) ->
 B = <<16#f0,16#10,16#10,16#10,16#10,16#10,16#10,16#10>>,
 gl:bitmap(4, 8, 0, -4, 7, 0, B);

char(10) ->
 B = <<16#10,16#10,16#10,16#10,16#78,16#40,16#60,16#90,16#90>>,
 gl:bitmap(5, 9, 0, 2, 7, 0, B);

% char: 0x08 BSP */

char(8) ->
 B = <<16#00>>,
 gl:bitmap(6, 1, -1, 2, -7, 0, B);

% char: 0x2

char(2) ->
 B = <<16#aa,16#54,16#aa,16#54,16#aa,16#54,16#aa,16#54,16#aa,16#54,16#aa,16#54,16#aa,16#54>>,
 gl:bitmap(7, 14, 0, 2, 7, 0, B);

% char: 0x1

char(1) ->
 B = <<16#30,16#30,16#78,16#78,16#fc,16#fc,16#78,16#78,16#30,16#30>>,
 gl:bitmap(6, 10, -1, 0, 7, 0, B).
