// DBus-client-template.hh --- DBUS template
//
// Copyright (C) 2007, 2008 Rob Caelers <robc@krandor.nl>
// All rights reserved.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <string>
#include <list>
#include <map>
#include <deque>

#include "DBusBinding.hh"
#include "DBusException.hh"
#include "DBusGnomeApplet.hh"

using namespace std;
using namespace workrave;





class org_workrave_GnomeAppletInterface_Impl : public org_workrave_GnomeAppletInterface, public DBusBaseTypes
{
public:
  org_workrave_GnomeAppletInterface_Impl(DBus *dbus, const string &service, const string &path);
  
  guint32 GetSocketId(    /**/   );
  void GetSocketId_async(     GetSocketId_slot slot   );


  guint32 GetSize(    /**/   );
  void GetSize_async(     GetSize_slot slot   );


  guint32 GetOrientation(    /**/   );
  void GetOrientation_async(     GetOrientation_slot slot   );


  void SetMenuStatus(  const    std::string     &menu  , bool     &status  );
  void SetMenuStatus_async(      const      std::string     &menu    , bool     &status    , SetMenuStatus_slot slot   );


  void GetMenuStatus(  const    std::string     &menu  , bool      &status  );
  void GetMenuStatus_async(      const      std::string     &menu    , GetMenuStatus_slot slot   );


  void SetMenuActive(  const    std::string     &menu  , bool     &active  );
  void SetMenuActive_async(      const      std::string     &menu    , bool     &active    , SetMenuActive_slot slot   );


  void GetMenuActive(  const    std::string     &menu  , bool      &active  );
  void GetMenuActive_async(      const      std::string     &menu    , GetMenuActive_slot slot   );


  
private:
  typedef sigc::signal<void, DBusError *     , guint32   > GetSocketId_signal;
  struct GetSocketId_async_closure
  {
     class org_workrave_GnomeAppletInterface_Impl *impl;
     GetSocketId_signal signal;
  };
  static void GetSocketId_async_closure_free(void *mem)
  {
    delete (GetSocketId_async_closure *)mem;
  }
  
  static void GetSocketId_fcn_static(DBusPendingCall *pending, void *user_data);
  void GetSocketId_fcn(DBusPendingCall *pending, void *user_data);

  typedef sigc::signal<void, DBusError *     , guint32   > GetSize_signal;
  struct GetSize_async_closure
  {
     class org_workrave_GnomeAppletInterface_Impl *impl;
     GetSize_signal signal;
  };
  static void GetSize_async_closure_free(void *mem)
  {
    delete (GetSize_async_closure *)mem;
  }
  
  static void GetSize_fcn_static(DBusPendingCall *pending, void *user_data);
  void GetSize_fcn(DBusPendingCall *pending, void *user_data);

  typedef sigc::signal<void, DBusError *     , guint32   > GetOrientation_signal;
  struct GetOrientation_async_closure
  {
     class org_workrave_GnomeAppletInterface_Impl *impl;
     GetOrientation_signal signal;
  };
  static void GetOrientation_async_closure_free(void *mem)
  {
    delete (GetOrientation_async_closure *)mem;
  }
  
  static void GetOrientation_fcn_static(DBusPendingCall *pending, void *user_data);
  void GetOrientation_fcn(DBusPendingCall *pending, void *user_data);

  typedef sigc::signal<void, DBusError *   > SetMenuStatus_signal;
  struct SetMenuStatus_async_closure
  {
     class org_workrave_GnomeAppletInterface_Impl *impl;
     SetMenuStatus_signal signal;
  };
  static void SetMenuStatus_async_closure_free(void *mem)
  {
    delete (SetMenuStatus_async_closure *)mem;
  }
  
  static void SetMenuStatus_fcn_static(DBusPendingCall *pending, void *user_data);
  void SetMenuStatus_fcn(DBusPendingCall *pending, void *user_data);

  typedef sigc::signal<void, DBusError *     , bool     &  > GetMenuStatus_signal;
  struct GetMenuStatus_async_closure
  {
     class org_workrave_GnomeAppletInterface_Impl *impl;
     GetMenuStatus_signal signal;
  };
  static void GetMenuStatus_async_closure_free(void *mem)
  {
    delete (GetMenuStatus_async_closure *)mem;
  }
  
  static void GetMenuStatus_fcn_static(DBusPendingCall *pending, void *user_data);
  void GetMenuStatus_fcn(DBusPendingCall *pending, void *user_data);

  typedef sigc::signal<void, DBusError *   > SetMenuActive_signal;
  struct SetMenuActive_async_closure
  {
     class org_workrave_GnomeAppletInterface_Impl *impl;
     SetMenuActive_signal signal;
  };
  static void SetMenuActive_async_closure_free(void *mem)
  {
    delete (SetMenuActive_async_closure *)mem;
  }
  
  static void SetMenuActive_fcn_static(DBusPendingCall *pending, void *user_data);
  void SetMenuActive_fcn(DBusPendingCall *pending, void *user_data);

  typedef sigc::signal<void, DBusError *     , bool     &  > GetMenuActive_signal;
  struct GetMenuActive_async_closure
  {
     class org_workrave_GnomeAppletInterface_Impl *impl;
     GetMenuActive_signal signal;
  };
  static void GetMenuActive_async_closure_free(void *mem)
  {
    delete (GetMenuActive_async_closure *)mem;
  }
  
  static void GetMenuActive_fcn_static(DBusPendingCall *pending, void *user_data);
  void GetMenuActive_fcn(DBusPendingCall *pending, void *user_data);

  




  DBus *dbus;
  string service;
  string path;
};


org_workrave_GnomeAppletInterface_Impl::org_workrave_GnomeAppletInterface_Impl(DBus *dbus, const string &service, const string &path)
  : dbus(dbus), service(service), path(path)
{
}

org_workrave_GnomeAppletInterface *org_workrave_GnomeAppletInterface::instance(DBus *dbus, const string &service, const string &path)
{
  return new org_workrave_GnomeAppletInterface_Impl(dbus, service, path);
}








guint32 org_workrave_GnomeAppletInterface_Impl::GetSocketId(    /**/   )
{

  DBusMessage *message = NULL;
  DBusMessage *reply = NULL;
  DBusPendingCall *pending = NULL;
  
  DBusMessageIter reader;
  DBusMessageIter writer;
  dbus_bool_t ok;

    guint32 id;
  
  try
    {
      message = dbus_message_new_method_call(service.c_str(),
                                             path.c_str(),
                                             "org.workrave.GnomeAppletInterface",  "GetSocketId"); 

      dbus_message_iter_init_append(message, &writer);


      if (!dbus_connection_send_with_reply(dbus->conn(), message, &pending, -1))
        { 
          throw DBusSystemException("Cannot send");
        }
      
      if (NULL == pending)
        { 
          throw DBusSystemException("No pending reply");
        }
      
      dbus_connection_flush(dbus->conn());
      
      // free message
      dbus_message_unref(message);
      message = NULL;
      
      // block until we receive a reply
      dbus_pending_call_block(pending);
      
      // get the reply message
      reply = dbus_pending_call_steal_reply(pending);
      if (NULL == reply)
        {
          throw DBusSystemException("No reply");
        }
      
      // free the pending message handle
      dbus_pending_call_unref(pending);
      pending = NULL;
      
      ok = dbus_message_iter_init(reply, &reader);
      
      get_uint32(&reader, &id);
      
    }
  catch (DBusException)
    {
      if (reply != NULL)
        {
          dbus_message_unref(reply);
        }

      if (message != NULL)
        {
          dbus_message_unref(message);
        }

      if (pending != NULL)
        {
          dbus_pending_call_unref(pending);
        }
      
      throw;
    }
  
  return id;
    
}


void org_workrave_GnomeAppletInterface_Impl::GetSocketId_async(   GetSocketId_slot slot                                                    
  )
{

  DBusMessage *message = NULL;
  DBusPendingCall *pending = NULL;
  
  DBusMessageIter writer;

  try
    {
      message = dbus_message_new_method_call(service.c_str(),
                                             path.c_str(),
                                             "org.workrave.GnomeAppletInterface",  "GetSocketId"); 

      dbus_message_iter_init(message, &writer);


      if (!dbus_connection_send_with_reply(dbus->conn(), message, &pending, -1))
        { 
          throw DBusSystemException("Cannot send");
        }
      
      if (NULL == pending)
        { 
          throw DBusSystemException("No pending reply");
        }

      GetSocketId_async_closure *closure = new GetSocketId_async_closure;
      closure->impl = this;
      closure->signal.connect(slot);
      
      if (!dbus_pending_call_set_notify(pending,
                                        org_workrave_GnomeAppletInterface_Impl::GetSocketId_fcn_static,
                                        closure, GetSocketId_async_closure_free))
        {
          throw DBusSystemException("Cannot set notifier");
        }
      
      // free message
      dbus_message_unref(message);
      message = NULL;
    }
  catch (DBusException)
    {
      if (message != NULL)
        {
          dbus_message_unref(message);
        }

      if (pending != NULL)
        {
          dbus_pending_call_unref(pending);
        }
      
      throw;
    }
  
}

void org_workrave_GnomeAppletInterface_Impl::GetSocketId_fcn_static(DBusPendingCall *pending, void *user_data)
{
  GetSocketId_async_closure *closure = (GetSocketId_async_closure *)user_data;

  closure->impl->GetSocketId_fcn(pending, user_data);
}

void org_workrave_GnomeAppletInterface_Impl::GetSocketId_fcn(DBusPendingCall *pending, void *user_data)
{
  GetSocketId_async_closure *closure = (GetSocketId_async_closure *)user_data;
	DBusMessage *reply = NULL;
  DBusMessageIter reader;
	DBusError error;
  dbus_bool_t ok;

      guint32 id;
  
	dbus_error_init(&error);

  try
    {
      reply = dbus_pending_call_steal_reply(pending);
      if (reply == NULL)
        {
          throw DBusSystemException("Cannot get reply");
        }
      
      ok = dbus_message_iter_init(reply, &reader);
      if (!ok)
        {
          throw DBusSystemException("No parameters");
        }
      
      get_uint32(&reader, &id);

      closure->signal.emit((DBusError *)NULL       , id       );
    }
  catch (DBusException)
    {
      if (reply != NULL)
        {
          dbus_message_unref(reply);
        }

      if (pending != NULL)
        {
          dbus_pending_call_unref(pending);
        }
      
      throw;
    }
}                           
  


  


guint32 org_workrave_GnomeAppletInterface_Impl::GetSize(    /**/   )
{

  DBusMessage *message = NULL;
  DBusMessage *reply = NULL;
  DBusPendingCall *pending = NULL;
  
  DBusMessageIter reader;
  DBusMessageIter writer;
  dbus_bool_t ok;

    guint32 size;
  
  try
    {
      message = dbus_message_new_method_call(service.c_str(),
                                             path.c_str(),
                                             "org.workrave.GnomeAppletInterface",  "GetSize"); 

      dbus_message_iter_init_append(message, &writer);


      if (!dbus_connection_send_with_reply(dbus->conn(), message, &pending, -1))
        { 
          throw DBusSystemException("Cannot send");
        }
      
      if (NULL == pending)
        { 
          throw DBusSystemException("No pending reply");
        }
      
      dbus_connection_flush(dbus->conn());
      
      // free message
      dbus_message_unref(message);
      message = NULL;
      
      // block until we receive a reply
      dbus_pending_call_block(pending);
      
      // get the reply message
      reply = dbus_pending_call_steal_reply(pending);
      if (NULL == reply)
        {
          throw DBusSystemException("No reply");
        }
      
      // free the pending message handle
      dbus_pending_call_unref(pending);
      pending = NULL;
      
      ok = dbus_message_iter_init(reply, &reader);
      
      get_uint32(&reader, &size);
      
    }
  catch (DBusException)
    {
      if (reply != NULL)
        {
          dbus_message_unref(reply);
        }

      if (message != NULL)
        {
          dbus_message_unref(message);
        }

      if (pending != NULL)
        {
          dbus_pending_call_unref(pending);
        }
      
      throw;
    }
  
  return size;
    
}


void org_workrave_GnomeAppletInterface_Impl::GetSize_async(   GetSize_slot slot                                                    
  )
{

  DBusMessage *message = NULL;
  DBusPendingCall *pending = NULL;
  
  DBusMessageIter writer;

  try
    {
      message = dbus_message_new_method_call(service.c_str(),
                                             path.c_str(),
                                             "org.workrave.GnomeAppletInterface",  "GetSize"); 

      dbus_message_iter_init(message, &writer);


      if (!dbus_connection_send_with_reply(dbus->conn(), message, &pending, -1))
        { 
          throw DBusSystemException("Cannot send");
        }
      
      if (NULL == pending)
        { 
          throw DBusSystemException("No pending reply");
        }

      GetSize_async_closure *closure = new GetSize_async_closure;
      closure->impl = this;
      closure->signal.connect(slot);
      
      if (!dbus_pending_call_set_notify(pending,
                                        org_workrave_GnomeAppletInterface_Impl::GetSize_fcn_static,
                                        closure, GetSize_async_closure_free))
        {
          throw DBusSystemException("Cannot set notifier");
        }
      
      // free message
      dbus_message_unref(message);
      message = NULL;
    }
  catch (DBusException)
    {
      if (message != NULL)
        {
          dbus_message_unref(message);
        }

      if (pending != NULL)
        {
          dbus_pending_call_unref(pending);
        }
      
      throw;
    }
  
}

void org_workrave_GnomeAppletInterface_Impl::GetSize_fcn_static(DBusPendingCall *pending, void *user_data)
{
  GetSize_async_closure *closure = (GetSize_async_closure *)user_data;

  closure->impl->GetSize_fcn(pending, user_data);
}

void org_workrave_GnomeAppletInterface_Impl::GetSize_fcn(DBusPendingCall *pending, void *user_data)
{
  GetSize_async_closure *closure = (GetSize_async_closure *)user_data;
	DBusMessage *reply = NULL;
  DBusMessageIter reader;
	DBusError error;
  dbus_bool_t ok;

      guint32 size;
  
	dbus_error_init(&error);

  try
    {
      reply = dbus_pending_call_steal_reply(pending);
      if (reply == NULL)
        {
          throw DBusSystemException("Cannot get reply");
        }
      
      ok = dbus_message_iter_init(reply, &reader);
      if (!ok)
        {
          throw DBusSystemException("No parameters");
        }
      
      get_uint32(&reader, &size);

      closure->signal.emit((DBusError *)NULL       , size       );
    }
  catch (DBusException)
    {
      if (reply != NULL)
        {
          dbus_message_unref(reply);
        }

      if (pending != NULL)
        {
          dbus_pending_call_unref(pending);
        }
      
      throw;
    }
}                           
  


  


guint32 org_workrave_GnomeAppletInterface_Impl::GetOrientation(    /**/   )
{

  DBusMessage *message = NULL;
  DBusMessage *reply = NULL;
  DBusPendingCall *pending = NULL;
  
  DBusMessageIter reader;
  DBusMessageIter writer;
  dbus_bool_t ok;

    guint32 orientation;
  
  try
    {
      message = dbus_message_new_method_call(service.c_str(),
                                             path.c_str(),
                                             "org.workrave.GnomeAppletInterface",  "GetOrientation"); 

      dbus_message_iter_init_append(message, &writer);


      if (!dbus_connection_send_with_reply(dbus->conn(), message, &pending, -1))
        { 
          throw DBusSystemException("Cannot send");
        }
      
      if (NULL == pending)
        { 
          throw DBusSystemException("No pending reply");
        }
      
      dbus_connection_flush(dbus->conn());
      
      // free message
      dbus_message_unref(message);
      message = NULL;
      
      // block until we receive a reply
      dbus_pending_call_block(pending);
      
      // get the reply message
      reply = dbus_pending_call_steal_reply(pending);
      if (NULL == reply)
        {
          throw DBusSystemException("No reply");
        }
      
      // free the pending message handle
      dbus_pending_call_unref(pending);
      pending = NULL;
      
      ok = dbus_message_iter_init(reply, &reader);
      
      get_uint32(&reader, &orientation);
      
    }
  catch (DBusException)
    {
      if (reply != NULL)
        {
          dbus_message_unref(reply);
        }

      if (message != NULL)
        {
          dbus_message_unref(message);
        }

      if (pending != NULL)
        {
          dbus_pending_call_unref(pending);
        }
      
      throw;
    }
  
  return orientation;
    
}


void org_workrave_GnomeAppletInterface_Impl::GetOrientation_async(   GetOrientation_slot slot                                                    
  )
{

  DBusMessage *message = NULL;
  DBusPendingCall *pending = NULL;
  
  DBusMessageIter writer;

  try
    {
      message = dbus_message_new_method_call(service.c_str(),
                                             path.c_str(),
                                             "org.workrave.GnomeAppletInterface",  "GetOrientation"); 

      dbus_message_iter_init(message, &writer);


      if (!dbus_connection_send_with_reply(dbus->conn(), message, &pending, -1))
        { 
          throw DBusSystemException("Cannot send");
        }
      
      if (NULL == pending)
        { 
          throw DBusSystemException("No pending reply");
        }

      GetOrientation_async_closure *closure = new GetOrientation_async_closure;
      closure->impl = this;
      closure->signal.connect(slot);
      
      if (!dbus_pending_call_set_notify(pending,
                                        org_workrave_GnomeAppletInterface_Impl::GetOrientation_fcn_static,
                                        closure, GetOrientation_async_closure_free))
        {
          throw DBusSystemException("Cannot set notifier");
        }
      
      // free message
      dbus_message_unref(message);
      message = NULL;
    }
  catch (DBusException)
    {
      if (message != NULL)
        {
          dbus_message_unref(message);
        }

      if (pending != NULL)
        {
          dbus_pending_call_unref(pending);
        }
      
      throw;
    }
  
}

void org_workrave_GnomeAppletInterface_Impl::GetOrientation_fcn_static(DBusPendingCall *pending, void *user_data)
{
  GetOrientation_async_closure *closure = (GetOrientation_async_closure *)user_data;

  closure->impl->GetOrientation_fcn(pending, user_data);
}

void org_workrave_GnomeAppletInterface_Impl::GetOrientation_fcn(DBusPendingCall *pending, void *user_data)
{
  GetOrientation_async_closure *closure = (GetOrientation_async_closure *)user_data;
	DBusMessage *reply = NULL;
  DBusMessageIter reader;
	DBusError error;
  dbus_bool_t ok;

      guint32 orientation;
  
	dbus_error_init(&error);

  try
    {
      reply = dbus_pending_call_steal_reply(pending);
      if (reply == NULL)
        {
          throw DBusSystemException("Cannot get reply");
        }
      
      ok = dbus_message_iter_init(reply, &reader);
      if (!ok)
        {
          throw DBusSystemException("No parameters");
        }
      
      get_uint32(&reader, &orientation);

      closure->signal.emit((DBusError *)NULL       , orientation       );
    }
  catch (DBusException)
    {
      if (reply != NULL)
        {
          dbus_message_unref(reply);
        }

      if (pending != NULL)
        {
          dbus_pending_call_unref(pending);
        }
      
      throw;
    }
}                           
  


  


void org_workrave_GnomeAppletInterface_Impl::SetMenuStatus(  const    std::string     &menu  , bool     &status  )
{

  DBusMessage *message = NULL;
  DBusMessage *reply = NULL;
  DBusPendingCall *pending = NULL;
  
  DBusMessageIter reader;
  DBusMessageIter writer;
  dbus_bool_t ok;

  
  try
    {
      message = dbus_message_new_method_call(service.c_str(),
                                             path.c_str(),
                                             "org.workrave.GnomeAppletInterface",  "SetMenuStatus"); 

      dbus_message_iter_init_append(message, &writer);

      put_string(&writer, &menu);
      put_bool(&writer, &status);

      if (!dbus_connection_send_with_reply(dbus->conn(), message, &pending, -1))
        { 
          throw DBusSystemException("Cannot send");
        }
      
      if (NULL == pending)
        { 
          throw DBusSystemException("No pending reply");
        }
      
      dbus_connection_flush(dbus->conn());
      
      // free message
      dbus_message_unref(message);
      message = NULL;
      
      // block until we receive a reply
      dbus_pending_call_block(pending);
      
      // get the reply message
      reply = dbus_pending_call_steal_reply(pending);
      if (NULL == reply)
        {
          throw DBusSystemException("No reply");
        }
      
      // free the pending message handle
      dbus_pending_call_unref(pending);
      pending = NULL;
      
      ok = dbus_message_iter_init(reply, &reader);
      if (!ok)
        {
          throw DBusSystemException("No parameters");
        }
      
      
    }
  catch (DBusException)
    {
      if (reply != NULL)
        {
          dbus_message_unref(reply);
        }

      if (message != NULL)
        {
          dbus_message_unref(message);
        }

      if (pending != NULL)
        {
          dbus_pending_call_unref(pending);
        }
      
      throw;
    }
  
    
}


void org_workrave_GnomeAppletInterface_Impl::SetMenuStatus_async(      const      std::string     &menu    , bool     &status  , SetMenuStatus_slot slot                                                    
  )
{

  DBusMessage *message = NULL;
  DBusPendingCall *pending = NULL;
  
  DBusMessageIter writer;

  try
    {
      message = dbus_message_new_method_call(service.c_str(),
                                             path.c_str(),
                                             "org.workrave.GnomeAppletInterface",  "SetMenuStatus"); 

      dbus_message_iter_init(message, &writer);

      put_string(&writer, &menu);
      put_bool(&writer, &status);

      if (!dbus_connection_send_with_reply(dbus->conn(), message, &pending, -1))
        { 
          throw DBusSystemException("Cannot send");
        }
      
      if (NULL == pending)
        { 
          throw DBusSystemException("No pending reply");
        }

      SetMenuStatus_async_closure *closure = new SetMenuStatus_async_closure;
      closure->impl = this;
      closure->signal.connect(slot);
      
      if (!dbus_pending_call_set_notify(pending,
                                        org_workrave_GnomeAppletInterface_Impl::SetMenuStatus_fcn_static,
                                        closure, SetMenuStatus_async_closure_free))
        {
          throw DBusSystemException("Cannot set notifier");
        }
      
      // free message
      dbus_message_unref(message);
      message = NULL;
    }
  catch (DBusException)
    {
      if (message != NULL)
        {
          dbus_message_unref(message);
        }

      if (pending != NULL)
        {
          dbus_pending_call_unref(pending);
        }
      
      throw;
    }
  
}

void org_workrave_GnomeAppletInterface_Impl::SetMenuStatus_fcn_static(DBusPendingCall *pending, void *user_data)
{
  SetMenuStatus_async_closure *closure = (SetMenuStatus_async_closure *)user_data;

  closure->impl->SetMenuStatus_fcn(pending, user_data);
}

void org_workrave_GnomeAppletInterface_Impl::SetMenuStatus_fcn(DBusPendingCall *pending, void *user_data)
{
  SetMenuStatus_async_closure *closure = (SetMenuStatus_async_closure *)user_data;
	DBusMessage *reply = NULL;
  DBusMessageIter reader;
	DBusError error;
  dbus_bool_t ok;

  
	dbus_error_init(&error);

  try
    {
      reply = dbus_pending_call_steal_reply(pending);
      if (reply == NULL)
        {
          throw DBusSystemException("Cannot get reply");
        }
      
      ok = dbus_message_iter_init(reply, &reader);
      

      closure->signal.emit((DBusError *)NULL       );
    }
  catch (DBusException)
    {
      if (reply != NULL)
        {
          dbus_message_unref(reply);
        }

      if (pending != NULL)
        {
          dbus_pending_call_unref(pending);
        }
      
      throw;
    }
}                           
  


  


void org_workrave_GnomeAppletInterface_Impl::GetMenuStatus(  const    std::string     &menu  , bool      &status  )
{

  DBusMessage *message = NULL;
  DBusMessage *reply = NULL;
  DBusPendingCall *pending = NULL;
  
  DBusMessageIter reader;
  DBusMessageIter writer;
  dbus_bool_t ok;

  
  try
    {
      message = dbus_message_new_method_call(service.c_str(),
                                             path.c_str(),
                                             "org.workrave.GnomeAppletInterface",  "GetMenuStatus"); 

      dbus_message_iter_init_append(message, &writer);

      put_string(&writer, &menu);

      if (!dbus_connection_send_with_reply(dbus->conn(), message, &pending, -1))
        { 
          throw DBusSystemException("Cannot send");
        }
      
      if (NULL == pending)
        { 
          throw DBusSystemException("No pending reply");
        }
      
      dbus_connection_flush(dbus->conn());
      
      // free message
      dbus_message_unref(message);
      message = NULL;
      
      // block until we receive a reply
      dbus_pending_call_block(pending);
      
      // get the reply message
      reply = dbus_pending_call_steal_reply(pending);
      if (NULL == reply)
        {
          throw DBusSystemException("No reply");
        }
      
      // free the pending message handle
      dbus_pending_call_unref(pending);
      pending = NULL;
      
      ok = dbus_message_iter_init(reply, &reader);
      if (!ok)
        {
          throw DBusSystemException("No parameters");
        }
      
      get_bool(&reader, &status);
      
    }
  catch (DBusException)
    {
      if (reply != NULL)
        {
          dbus_message_unref(reply);
        }

      if (message != NULL)
        {
          dbus_message_unref(message);
        }

      if (pending != NULL)
        {
          dbus_pending_call_unref(pending);
        }
      
      throw;
    }
  
    
}


void org_workrave_GnomeAppletInterface_Impl::GetMenuStatus_async(      const      std::string     &menu  , GetMenuStatus_slot slot                                                    
  )
{

  DBusMessage *message = NULL;
  DBusPendingCall *pending = NULL;
  
  DBusMessageIter writer;

  try
    {
      message = dbus_message_new_method_call(service.c_str(),
                                             path.c_str(),
                                             "org.workrave.GnomeAppletInterface",  "GetMenuStatus"); 

      dbus_message_iter_init(message, &writer);

      put_string(&writer, &menu);

      if (!dbus_connection_send_with_reply(dbus->conn(), message, &pending, -1))
        { 
          throw DBusSystemException("Cannot send");
        }
      
      if (NULL == pending)
        { 
          throw DBusSystemException("No pending reply");
        }

      GetMenuStatus_async_closure *closure = new GetMenuStatus_async_closure;
      closure->impl = this;
      closure->signal.connect(slot);
      
      if (!dbus_pending_call_set_notify(pending,
                                        org_workrave_GnomeAppletInterface_Impl::GetMenuStatus_fcn_static,
                                        closure, GetMenuStatus_async_closure_free))
        {
          throw DBusSystemException("Cannot set notifier");
        }
      
      // free message
      dbus_message_unref(message);
      message = NULL;
    }
  catch (DBusException)
    {
      if (message != NULL)
        {
          dbus_message_unref(message);
        }

      if (pending != NULL)
        {
          dbus_pending_call_unref(pending);
        }
      
      throw;
    }
  
}

void org_workrave_GnomeAppletInterface_Impl::GetMenuStatus_fcn_static(DBusPendingCall *pending, void *user_data)
{
  GetMenuStatus_async_closure *closure = (GetMenuStatus_async_closure *)user_data;

  closure->impl->GetMenuStatus_fcn(pending, user_data);
}

void org_workrave_GnomeAppletInterface_Impl::GetMenuStatus_fcn(DBusPendingCall *pending, void *user_data)
{
  GetMenuStatus_async_closure *closure = (GetMenuStatus_async_closure *)user_data;
	DBusMessage *reply = NULL;
  DBusMessageIter reader;
	DBusError error;
  dbus_bool_t ok;

      bool status;
  
	dbus_error_init(&error);

  try
    {
      reply = dbus_pending_call_steal_reply(pending);
      if (reply == NULL)
        {
          throw DBusSystemException("Cannot get reply");
        }
      
      ok = dbus_message_iter_init(reply, &reader);
      if (!ok)
        {
          throw DBusSystemException("No parameters");
        }
      
      get_bool(&reader, &status);

      closure->signal.emit((DBusError *)NULL       , status       );
    }
  catch (DBusException)
    {
      if (reply != NULL)
        {
          dbus_message_unref(reply);
        }

      if (pending != NULL)
        {
          dbus_pending_call_unref(pending);
        }
      
      throw;
    }
}                           
  


  


void org_workrave_GnomeAppletInterface_Impl::SetMenuActive(  const    std::string     &menu  , bool     &active  )
{

  DBusMessage *message = NULL;
  DBusMessage *reply = NULL;
  DBusPendingCall *pending = NULL;
  
  DBusMessageIter reader;
  DBusMessageIter writer;
  dbus_bool_t ok;

  
  try
    {
      message = dbus_message_new_method_call(service.c_str(),
                                             path.c_str(),
                                             "org.workrave.GnomeAppletInterface",  "SetMenuActive"); 

      dbus_message_iter_init_append(message, &writer);

      put_string(&writer, &menu);
      put_bool(&writer, &active);

      if (!dbus_connection_send_with_reply(dbus->conn(), message, &pending, -1))
        { 
          throw DBusSystemException("Cannot send");
        }
      
      if (NULL == pending)
        { 
          throw DBusSystemException("No pending reply");
        }
      
      dbus_connection_flush(dbus->conn());
      
      // free message
      dbus_message_unref(message);
      message = NULL;
      
      // block until we receive a reply
      dbus_pending_call_block(pending);
      
      // get the reply message
      reply = dbus_pending_call_steal_reply(pending);
      if (NULL == reply)
        {
          throw DBusSystemException("No reply");
        }
      
      // free the pending message handle
      dbus_pending_call_unref(pending);
      pending = NULL;
      
      ok = dbus_message_iter_init(reply, &reader);
      if (!ok)
        {
          throw DBusSystemException("No parameters");
        }
      
      
    }
  catch (DBusException)
    {
      if (reply != NULL)
        {
          dbus_message_unref(reply);
        }

      if (message != NULL)
        {
          dbus_message_unref(message);
        }

      if (pending != NULL)
        {
          dbus_pending_call_unref(pending);
        }
      
      throw;
    }
  
    
}


void org_workrave_GnomeAppletInterface_Impl::SetMenuActive_async(      const      std::string     &menu    , bool     &active  , SetMenuActive_slot slot                                                    
  )
{

  DBusMessage *message = NULL;
  DBusPendingCall *pending = NULL;
  
  DBusMessageIter writer;

  try
    {
      message = dbus_message_new_method_call(service.c_str(),
                                             path.c_str(),
                                             "org.workrave.GnomeAppletInterface",  "SetMenuActive"); 

      dbus_message_iter_init(message, &writer);

      put_string(&writer, &menu);
      put_bool(&writer, &active);

      if (!dbus_connection_send_with_reply(dbus->conn(), message, &pending, -1))
        { 
          throw DBusSystemException("Cannot send");
        }
      
      if (NULL == pending)
        { 
          throw DBusSystemException("No pending reply");
        }

      SetMenuActive_async_closure *closure = new SetMenuActive_async_closure;
      closure->impl = this;
      closure->signal.connect(slot);
      
      if (!dbus_pending_call_set_notify(pending,
                                        org_workrave_GnomeAppletInterface_Impl::SetMenuActive_fcn_static,
                                        closure, SetMenuActive_async_closure_free))
        {
          throw DBusSystemException("Cannot set notifier");
        }
      
      // free message
      dbus_message_unref(message);
      message = NULL;
    }
  catch (DBusException)
    {
      if (message != NULL)
        {
          dbus_message_unref(message);
        }

      if (pending != NULL)
        {
          dbus_pending_call_unref(pending);
        }
      
      throw;
    }
  
}

void org_workrave_GnomeAppletInterface_Impl::SetMenuActive_fcn_static(DBusPendingCall *pending, void *user_data)
{
  SetMenuActive_async_closure *closure = (SetMenuActive_async_closure *)user_data;

  closure->impl->SetMenuActive_fcn(pending, user_data);
}

void org_workrave_GnomeAppletInterface_Impl::SetMenuActive_fcn(DBusPendingCall *pending, void *user_data)
{
  SetMenuActive_async_closure *closure = (SetMenuActive_async_closure *)user_data;
	DBusMessage *reply = NULL;
  DBusMessageIter reader;
	DBusError error;
  dbus_bool_t ok;

  
	dbus_error_init(&error);

  try
    {
      reply = dbus_pending_call_steal_reply(pending);
      if (reply == NULL)
        {
          throw DBusSystemException("Cannot get reply");
        }
      
      ok = dbus_message_iter_init(reply, &reader);
      

      closure->signal.emit((DBusError *)NULL       );
    }
  catch (DBusException)
    {
      if (reply != NULL)
        {
          dbus_message_unref(reply);
        }

      if (pending != NULL)
        {
          dbus_pending_call_unref(pending);
        }
      
      throw;
    }
}                           
  


  


void org_workrave_GnomeAppletInterface_Impl::GetMenuActive(  const    std::string     &menu  , bool      &active  )
{

  DBusMessage *message = NULL;
  DBusMessage *reply = NULL;
  DBusPendingCall *pending = NULL;
  
  DBusMessageIter reader;
  DBusMessageIter writer;
  dbus_bool_t ok;

  
  try
    {
      message = dbus_message_new_method_call(service.c_str(),
                                             path.c_str(),
                                             "org.workrave.GnomeAppletInterface",  "GetMenuActive"); 

      dbus_message_iter_init_append(message, &writer);

      put_string(&writer, &menu);

      if (!dbus_connection_send_with_reply(dbus->conn(), message, &pending, -1))
        { 
          throw DBusSystemException("Cannot send");
        }
      
      if (NULL == pending)
        { 
          throw DBusSystemException("No pending reply");
        }
      
      dbus_connection_flush(dbus->conn());
      
      // free message
      dbus_message_unref(message);
      message = NULL;
      
      // block until we receive a reply
      dbus_pending_call_block(pending);
      
      // get the reply message
      reply = dbus_pending_call_steal_reply(pending);
      if (NULL == reply)
        {
          throw DBusSystemException("No reply");
        }
      
      // free the pending message handle
      dbus_pending_call_unref(pending);
      pending = NULL;
      
      ok = dbus_message_iter_init(reply, &reader);
      if (!ok)
        {
          throw DBusSystemException("No parameters");
        }
      
      get_bool(&reader, &active);
      
    }
  catch (DBusException)
    {
      if (reply != NULL)
        {
          dbus_message_unref(reply);
        }

      if (message != NULL)
        {
          dbus_message_unref(message);
        }

      if (pending != NULL)
        {
          dbus_pending_call_unref(pending);
        }
      
      throw;
    }
  
    
}


void org_workrave_GnomeAppletInterface_Impl::GetMenuActive_async(      const      std::string     &menu  , GetMenuActive_slot slot                                                    
  )
{

  DBusMessage *message = NULL;
  DBusPendingCall *pending = NULL;
  
  DBusMessageIter writer;

  try
    {
      message = dbus_message_new_method_call(service.c_str(),
                                             path.c_str(),
                                             "org.workrave.GnomeAppletInterface",  "GetMenuActive"); 

      dbus_message_iter_init(message, &writer);

      put_string(&writer, &menu);

      if (!dbus_connection_send_with_reply(dbus->conn(), message, &pending, -1))
        { 
          throw DBusSystemException("Cannot send");
        }
      
      if (NULL == pending)
        { 
          throw DBusSystemException("No pending reply");
        }

      GetMenuActive_async_closure *closure = new GetMenuActive_async_closure;
      closure->impl = this;
      closure->signal.connect(slot);
      
      if (!dbus_pending_call_set_notify(pending,
                                        org_workrave_GnomeAppletInterface_Impl::GetMenuActive_fcn_static,
                                        closure, GetMenuActive_async_closure_free))
        {
          throw DBusSystemException("Cannot set notifier");
        }
      
      // free message
      dbus_message_unref(message);
      message = NULL;
    }
  catch (DBusException)
    {
      if (message != NULL)
        {
          dbus_message_unref(message);
        }

      if (pending != NULL)
        {
          dbus_pending_call_unref(pending);
        }
      
      throw;
    }
  
}

void org_workrave_GnomeAppletInterface_Impl::GetMenuActive_fcn_static(DBusPendingCall *pending, void *user_data)
{
  GetMenuActive_async_closure *closure = (GetMenuActive_async_closure *)user_data;

  closure->impl->GetMenuActive_fcn(pending, user_data);
}

void org_workrave_GnomeAppletInterface_Impl::GetMenuActive_fcn(DBusPendingCall *pending, void *user_data)
{
  GetMenuActive_async_closure *closure = (GetMenuActive_async_closure *)user_data;
	DBusMessage *reply = NULL;
  DBusMessageIter reader;
	DBusError error;
  dbus_bool_t ok;

      bool active;
  
	dbus_error_init(&error);

  try
    {
      reply = dbus_pending_call_steal_reply(pending);
      if (reply == NULL)
        {
          throw DBusSystemException("Cannot get reply");
        }
      
      ok = dbus_message_iter_init(reply, &reader);
      if (!ok)
        {
          throw DBusSystemException("No parameters");
        }
      
      get_bool(&reader, &active);

      closure->signal.emit((DBusError *)NULL       , active       );
    }
  catch (DBusException)
    {
      if (reply != NULL)
        {
          dbus_message_unref(reply);
        }

      if (pending != NULL)
        {
          dbus_pending_call_unref(pending);
        }
      
      throw;
    }
}                           
  


  




