#!/bin/sh

# Delete anything that is setup already
$PRG_TC qdisc del dev $DEV root 2> /dev/null

# Attach htb to device:
$PRG_TC qdisc add dev $DEV root handle 8000: htb default 1

# Create default high-priority class for forwarded traffic:
$PRG_TC class add dev $DEV parent 8000:0 classid 8000:1 htb rate $BW"Kbit" prio 5

# Add WRR to the class:
$PRG_TC qdisc add dev $DEV parent 8000:1 handle 8001: \
  wrr $WRR_ADDR_FIELD $CLASSIFY $MAXCLASSES $PROXY_MAXCON

# Attach SFQ queus to WRR:
declare -i NUM=$MAXCLASSES;
while [ $NUM -ge 1 ]; do
  HNUM=$(printf %X $NUM)
  $PRG_TC qdisc add dev $DEV parent 8001:$HNUM handle $HNUM: sfq
  NUM=$NUM-1
done  

# If we also have a local address on this interface add this and don't
# shape traffic from that address:
if [ "$ADDR" != "" ]; then
  $PRG_TC class add dev $DEV parent 8000:0 classid 8000:2 htb prio 6 rate 100Mbit
  $PRG_TC filter add dev $DEV parent 8000: protocol ip pref 10 \
    u32 match ip src $ADDR flowid 8000:2
  $PRG_TC qdisc add dev $DEV parent 8000:2 handle 8002: pfifo
fi     
