<tal:vhm repeat="id python:vh_map.keys()">
backend <tal:backend replace="id" /> {
    set backend.host = "<tal:zopehost replace='python:vh_map[id]["zope_host"]' />";
    set backend.port = "<tal:zopeport replace='python:vh_map[id]["zope_port"]' />";
}</tal:vhm>


acl purge {
    "localhost";<tal:vhm repeat="vh python:vh_map.values()">
    "<tal:host replace='python:vh["zope_host"]' />";</tal:vhm>
}


sub vcl_recv {

    /* Find the right backend for this request */
    if (!req.url) {
        error 404 "Unknown host";<tal:vhm repeat="id python:vh_map.keys()"><tal:vh 
          define="host python:vh_map[id]['host'];
                  zope_path python:vh_map[id]['zope_path'];
                  match string:/VirtualHostBase/http/$host:80/$zope_path/VirtualHostRoot">
    } elseif (req.url ~ "^<tal:match replace='match' />") {
        set req.backend = <tal:backend replace="id" />;</tal:vh></tal:vhm>
    } else {
        error 404 "Unknown host";
    }

    /* Do not cache if request is not GET or HEAD */
    if (req.request != "GET" && req.request != "HEAD") {
        /* Forward to 'lookup' if request is an authorized PURGE request */
        if (req.request == "PURGE") {
            if (!client.ip ~ purge) {
                error 405 "Not allowed.";
            }
            lookup;
        }
        set req.http.connection = "close";
        pipe;
    }

    /* Do not cache if request contains an Expect header */
    if (req.http.Expect) {
        set req.http.connection = "close";
        pipe;
    }

    /* Varnish doesn't do INM requests so pass it through */
    if (req.http.If-None-Match) {
        pass;
    }

    lookup;
}

sub vcl_hit {
    if (req.request == "PURGE") {
        purge_url(req.url);
        error 200 "Purged";
    }
    if (!obj.cacheable) {
        pass;
    }
    deliver;
}

sub vcl_miss {

    /* Varnish doesn't do IMS to backend, so if not in cache just pass it through */
    if (req.http.If-Modified-Since) {
        pass;
    }

    if (req.request == "PURGE") {
        error 404 "Not in cache";
    }

    fetch;
}

sub vcl_fetch {
    if (!obj.valid) {
        error;
    }
    if (!obj.cacheable) {
        pass;
    }
    if (obj.http.Set-Cookie) {
        pass;
    }

    /* Do not cache if response contains any 'no cache' tokens */
    if (obj.http.Cache-Control ~ "(private|no-cache|no-store)") {
        pass;
    }

    /* Do not cache if request contains an Authorization header, unless response is 'public' */
    if (req.http.Authorization && !obj.http.Cache-Control ~ "public") {
        pass;
    }

    insert;
}

