/**********************************************************************
zyGrib: meteorological GRIB file viewer
Copyright (C) 2008 - Jacques Zaninetti - http://www.zygrib.org

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
***********************************************************************/

#ifndef BOARDTOOLBAR_H
#define BOARDTOOLBAR_H

#include <QApplication>
#include <QToolBar>
#include <QLabel>
#include <QHBoxLayout>

#include "GribPlot.h"
#include "Util.h"

class BoardToolBar : public QToolBar
{
    Q_OBJECT
public:
    BoardToolBar(QWidget *parent);
    
    void showGribPointInfo(const GribPointInfo &pf);

    
//------------------------------------------------------------------------
private:        
    QLabel     lbLon;
    QLabel     lbLat;
    QLabel     lbPres;
    QLabel     lbTemp;
    QLabel     lbTempPot;
    QLabel     lbTempMin;
    QLabel     lbTempMax;
    QLabel     lbWindDir;
    QLabel     lbWindSpeed;
    QLabel     lbWindBf;
    QLabel     lbRain;
    QLabel     lbCloud;
    QLabel     lbHumid;
    QLabel     lbDewPoint;
    QLabel     lbIsotherm0HGT;
    QLabel     lbSnowDepth;
    QLabel     lbSnowCateg;
    QLabel     lbCAPEsfc;
};

#endif
