/**********************************************************************
zyGrib: meteorological GRIB file viewer
Copyright (C) 2008 - Jacques Zaninetti - http://www.zygrib.org

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
***********************************************************************/

#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QApplication>
#include <QMainWindow>
#include <QMouseEvent>

#include "GshhsReader.h"
#include "Terrain.h"
#include "MenuBar.h"
#include "BoardToolBar.h"

#include "DialogGraphicsParams.h"
#include "DialogLoadGRIB.h"
#include "DialogLoadIAC.h"
#include "DialogServerStatus.h"
#include "DialogProxy.h"
#include "DialogUnits.h"
#include "POI.h"
#include "GribAnimator.h"
#include "Projection.h"

class MainWindow: public QMainWindow
{
    Q_OBJECT
    
    public:
        MainWindow(int w, int h, QString startFileName="", QWidget *parent = 0);
        ~MainWindow();

        void openMeteoDataFile(QString fileName, bool zoomOnGrib=true);

    public slots:
        void slotOpenMeteotable();
        void slotCreatePOI();
        void slotCreateAnimation();
		void slotOpenMeteotablePOI(POI*);
        
        void slotFile_Open();
        void slotFile_Close();
        void slotFile_Load_GRIB();
        void slotFile_Load_IAC();
        void slotFile_GribServerStatus();
        void slotFile_Info_GRIB();
        void slotFile_Quit();
        void slotMap_Quality();
        void slotMap_Projection(QAction *);
        void slotMap_CitiesNames();
        void slotIsobarsStep();
        void slotIsotherms0Step();
        void slotGribFileReceived(QString fileName);
        
        void slotMouseClicked(QMouseEvent * e);
        void slotMouseMoved(QMouseEvent * e);
        void slotPOImoved(POI *);

        void slotDateGribChanged(int id);
        void slotDateGribChanged_next();
        void slotDateGribChanged_prev();
		void slotTimeZoneChanged();
		
		void slot_GroupColorMap(QAction *);
        
        void slotWindArrows(bool b);
        
        void slotOptions_Language();
        void slotHelp_Help();
        void slotOpenAngleConverter();
        void slotHelp_APropos();
        void slotHelp_AProposQT();

    signals:
        void signalMapQuality(int quality);

    private:
        GshhsReader *gshhsReader;
        Projection  *proj;
        
        QString      gribFileName;
        QString      gribFilePath;
        
        DialogLoadGRIB  dialogLoadGRIB;
        DialogLoadIAC   dialogLoadIAC;
        DialogProxy     dialogProxy;
        DialogUnits     dialogUnits;
        DialogGraphicsParams dialogGraphicsParams;
        
        Terrain      *terre;
        MenuBar      *menuBar;
        QToolBar     *toolBar;
        BoardToolBar *boardToolBar;
        QStatusBar   *statusBar;
        
        QMenu    *menuPopupBtRight;
        
        void        connectSignals();
        void        InitActionsStatus();
		void 		setMenubarColorMapMode(int colorMapMode);
        void        statusBar_showSelectedZone();
        QString     dataPresentInGrib (GribReader* grib,
        						int dataType,int levelType,int levelValue,
        						bool *ok=NULL);
		void		initProjection();
		
        int mouseClicX, mouseClicY;

        //---------------------------------------------
		QLabel     lbLon;
		QLabel     lbLat;
		QLabel     lbPres;
		QLabel     lbTemp;
		QLabel     lbWindDir;
		QLabel     lbWindSpeed;
		QLabel     lbWindBf;
		QLabel     lbRain;
		QLabel     lbCloud;
		QLabel     lbHumid;
        
		void closeEvent(QCloseEvent *) {QApplication::quit();};
        
};

#endif
