/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/**
 * This file is generated by browser/components/asrouter/bin/import-rollouts.js
 * Run the following from the repository root to regenerate it:
 * ./mach npm run import-rollouts --prefix=browser/components/asrouter
 */

export const NimbusRolloutMessageProvider = {
  getMessages() {
    return [
      {
        // Nimbus slug: device-migration-q4-spotlights-remaining-population-esr:treatment (message 1 of 3)
        // Recipe: https://experimenter.services.mozilla.com/nimbus/device-migration-q4-spotlights-remaining-population-esr/summary#treatment
        id: "Q4_DEVICE_MIGRATION_BACKUP_SPOTLIGHT",
        groups: ["eco"],
        content: {
          id: "Q4_DEVICE_MIGRATION_BACKUP_SPOTLIGHT",
          modal: "tab",
          screens: [
            {
              id: "Q4_DEVICE_MIGRATION_BACKUP_SPOTLIGHT_BACKUP",
              content: {
                logo: {
                  height: "152px",
                  imageURL:
                    "https://icecat-settings-attachments.cdn.mozilla.net/main-workspace/ms-images/c92a41e4-82cf-4ad5-8480-04a138bfb3cd.png",
                },
                title: {
                  fontSize: "24px",
                  string_id: "device-migration-fxa-spotlight-heavy-user-header",
                  letterSpacing: 0,
                },
                subtitle: {
                  fontSize: "15px",
                  string_id: "device-migration-fxa-spotlight-heavy-user-body",
                  lineHeight: "1.4",
                  marginBlock: "8px 20px",
                  letterSpacing: 0,
                  paddingInline: "20px",
                },
                dismiss_button: {
                  action: {
                    navigate: true,
                  },
                },
                primary_button: {
                  label: {
                    string_id:
                      "device-migration-fxa-spotlight-heavy-user-primary-button",
                    paddingBlock: "4px",
                    paddingInline: "16px",
                  },
                  action: {
                    data: {
                      args: "https://support.mozilla.org/1/icecat/%VERSION%/%OS%/%LOCALE%/switching-devices?utm_source=spotlight-default&utm_medium=icecat-desktop&utm_campaign=migration&utm_content=dont-forget-to-backup&entrypoint=device-migration-spotlight-experiment-v2",
                      where: "tabshifted",
                    },
                    type: "OPEN_URL",
                    navigate: true,
                  },
                },
              },
            },
          ],
          backdrop: "transparent",
          template: "multistage",
          transitions: true,
        },
        trigger: {
          id: "defaultBrowserCheck",
        },
        template: "spotlight",
        frequency: {
          lifetime: 1,
        },
        targeting:
          "source == 'startup' && !willShowDefaultPrompt && 'browser.newtabpage.activity-stream.asrouter.userprefs.cfr.features'|preferenceValue && !usesIceCatSync && !hasActiveEnterprisePolicies && userMonthlyActivity[userMonthlyActivity|length - 2][1]|date >= currentDate|date - (28 * 24 * 60 * 60 * 1000) && (((currentDate|date - profileAgeCreated|date) / 86400000 >= 168) || totalBookmarksCount >= 35)",
      },
      {
        // Nimbus slug: device-migration-q4-spotlights-remaining-population-esr:treatment (message 2 of 3)
        // Recipe: https://experimenter.services.mozilla.com/nimbus/device-migration-q4-spotlights-remaining-population-esr/summary#treatment
        id: "Q4_DEVICE_MIGRATION_BACKUP_SPOTLIGHT",
        groups: ["eco"],
        content: {
          id: "Q4_DEVICE_MIGRATION_BACKUP_SPOTLIGHT",
          modal: "tab",
          screens: [
            {
              id: "Q4_DEVICE_MIGRATION_BACKUP_SPOTLIGHT_PEACE",
              content: {
                logo: {
                  height: "133px",
                  imageURL:
                    "https://icecat-settings-attachments.cdn.mozilla.net/main-workspace/ms-images/4a56d3ed-98c8-4a33-b853-b2cf7646efd8.png",
                  marginBlock: "22px -10px",
                },
                title: {
                  fontSize: "24px",
                  string_id:
                    "device-migration-fxa-spotlight-older-device-header",
                  letterSpacing: 0,
                },
                subtitle: {
                  fontSize: "15px",
                  string_id: "device-migration-fxa-spotlight-older-device-body",
                  lineHeight: "1.4",
                  marginBlock: "8px 20px",
                  letterSpacing: 0,
                  paddingInline: "40px",
                },
                dismiss_button: {
                  action: {
                    navigate: true,
                  },
                },
                primary_button: {
                  label: {
                    string_id:
                      "device-migration-fxa-spotlight-older-device-primary-button",
                    marginBlock: "0 22px",
                    paddingBlock: "4px",
                    paddingInline: "16px",
                  },
                  action: {
                    data: {
                      args: "https://support.mozilla.org/1/icecat/%VERSION%/%OS%/%LOCALE%/switching-devices?utm_source=spotlight-default&utm_medium=icecat-desktop&utm_campaign=migration&utm_content=peace-of-mind&entrypoint=device-migration-spotlight-experiment-v2",
                      where: "tabshifted",
                    },
                    type: "OPEN_URL",
                    navigate: true,
                  },
                },
              },
            },
          ],
          backdrop: "transparent",
          template: "multistage",
          transitions: true,
        },
        trigger: {
          id: "defaultBrowserCheck",
        },
        template: "spotlight",
        frequency: {
          lifetime: 1,
        },
        targeting:
          "source == 'startup' && !willShowDefaultPrompt && 'browser.newtabpage.activity-stream.asrouter.userprefs.cfr.features'|preferenceValue && !usesIceCatSync && !hasActiveEnterprisePolicies && userMonthlyActivity[userMonthlyActivity|length - 2][1]|date >= currentDate|date - (28 * 24 * 60 * 60 * 1000) && !(((currentDate|date - profileAgeCreated|date) / 86400000 >= 168) || totalBookmarksCount >= 35) && os.isWindows && os.windowsVersion >= 6.1 && os.windowsBuildNumber < 22000",
      },
      {
        // Nimbus slug: device-migration-q4-spotlights-remaining-population-esr:treatment (message 3 of 3)
        // Recipe: https://experimenter.services.mozilla.com/nimbus/device-migration-q4-spotlights-remaining-population-esr/summary#treatment
        id: "Q4_DEVICE_MIGRATION_BACKUP_SPOTLIGHT",
        groups: ["eco"],
        content: {
          id: "Q4_DEVICE_MIGRATION_BACKUP_SPOTLIGHT",
          modal: "tab",
          screens: [
            {
              id: "Q4_DEVICE_MIGRATION_BACKUP_SPOTLIGHT_NEW_DEVICE",
              content: {
                logo: {
                  height: "149px",
                  imageURL:
                    "https://icecat-settings-attachments.cdn.mozilla.net/main-workspace/ms-images/a43cd9cc-e8b2-477c-92f2-345557370de1.svg",
                },
                title: {
                  fontSize: "24px",
                  string_id:
                    "device-migration-fxa-spotlight-getting-new-device-header-2",
                  letterSpacing: 0,
                },
                subtitle: {
                  fontSize: "15px",
                  string_id:
                    "device-migration-fxa-spotlight-getting-new-device-body-2",
                  lineHeight: "1.4",
                  marginBlock: "8px 20px",
                  letterSpacing: 0,
                  paddingInline: "40px",
                },
                dismiss_button: {
                  action: {
                    navigate: true,
                  },
                },
                primary_button: {
                  label: {
                    string_id:
                      "device-migration-fxa-spotlight-getting-new-device-primary-button",
                    paddingBlock: "4px",
                    paddingInline: "16px",
                  },
                  action: {
                    data: {
                      args: "https://support.mozilla.org/1/icecat/%VERSION%/%OS%/%LOCALE%/switching-devices?utm_source=spotlight-default&utm_medium=icecat-desktop&utm_campaign=migration&utm_content=new-device-in-your-future&entrypoint=device-migration-spotlight-experiment-v2",
                      where: "tabshifted",
                    },
                    type: "OPEN_URL",
                    navigate: true,
                  },
                },
              },
            },
          ],
          backdrop: "transparent",
          template: "multistage",
          transitions: true,
        },
        trigger: {
          id: "defaultBrowserCheck",
        },
        template: "spotlight",
        frequency: {
          lifetime: 1,
        },
        targeting:
          "source == 'startup' && !willShowDefaultPrompt && 'browser.newtabpage.activity-stream.asrouter.userprefs.cfr.features'|preferenceValue && !usesIceCatSync && !hasActiveEnterprisePolicies && userMonthlyActivity[userMonthlyActivity|length - 2][1]|date >= currentDate|date - (28 * 24 * 60 * 60 * 1000) && !(((currentDate|date - profileAgeCreated|date) / 86400000 >= 168) || totalBookmarksCount >= 35) && !(os.isWindows && os.windowsVersion >= 6.1 && os.windowsBuildNumber < 22000)",
      },
      {
        // Nimbus slug: device-migration-q4-spotlights-remaining-population:treatment (message 1 of 3)
        // Version range: 122+
        // Recipe: https://experimenter.services.mozilla.com/nimbus/device-migration-q4-spotlights-remaining-population/summary#treatment
        id: "Q4_DEVICE_MIGRATION_BACKUP_SPOTLIGHT",
        groups: ["eco"],
        content: {
          id: "Q4_DEVICE_MIGRATION_BACKUP_SPOTLIGHT",
          modal: "tab",
          screens: [
            {
              id: "Q4_DEVICE_MIGRATION_BACKUP_SPOTLIGHT_BACKUP",
              content: {
                logo: {
                  height: "152px",
                  imageURL:
                    "https://icecat-settings-attachments.cdn.mozilla.net/main-workspace/ms-images/c92a41e4-82cf-4ad5-8480-04a138bfb3cd.png",
                },
                title: {
                  fontSize: "24px",
                  string_id: "device-migration-fxa-spotlight-heavy-user-header",
                  letterSpacing: 0,
                },
                subtitle: {
                  fontSize: "15px",
                  string_id: "device-migration-fxa-spotlight-heavy-user-body",
                  lineHeight: "1.4",
                  marginBlock: "8px 20px",
                  letterSpacing: 0,
                  paddingInline: "20px",
                },
                dismiss_button: {
                  action: {
                    navigate: true,
                  },
                },
                primary_button: {
                  label: {
                    string_id:
                      "device-migration-fxa-spotlight-heavy-user-primary-button",
                    paddingBlock: "4px",
                    paddingInline: "16px",
                  },
                  action: {
                    data: {
                      args: "https://support.mozilla.org/1/icecat/%VERSION%/%OS%/%LOCALE%/switching-devices?utm_source=spotlight-default&utm_medium=icecat-desktop&utm_campaign=migration&utm_content=dont-forget-to-backup&entrypoint=device-migration-spotlight-experiment-v2",
                      where: "tabshifted",
                    },
                    type: "OPEN_URL",
                    navigate: true,
                  },
                },
              },
            },
          ],
          backdrop: "transparent",
          template: "multistage",
          transitions: true,
        },
        trigger: {
          id: "defaultBrowserCheck",
        },
        template: "spotlight",
        frequency: {
          lifetime: 1,
        },
        targeting:
          "source == 'startup' && !willShowDefaultPrompt && 'browser.newtabpage.activity-stream.asrouter.userprefs.cfr.features'|preferenceValue && !usesIceCatSync && !hasActiveEnterprisePolicies && userMonthlyActivity[userMonthlyActivity|length - 2][1]|date >= currentDate|date - (28 * 24 * 60 * 60 * 1000) && (((currentDate|date - profileAgeCreated|date) / 86400000 >= 168) || totalBookmarksCount >= 35)",
      },
      {
        // Nimbus slug: device-migration-q4-spotlights-remaining-population:treatment (message 2 of 3)
        // Version range: 122+
        // Recipe: https://experimenter.services.mozilla.com/nimbus/device-migration-q4-spotlights-remaining-population/summary#treatment
        id: "Q4_DEVICE_MIGRATION_BACKUP_SPOTLIGHT",
        groups: ["eco"],
        content: {
          id: "Q4_DEVICE_MIGRATION_BACKUP_SPOTLIGHT",
          modal: "tab",
          screens: [
            {
              id: "Q4_DEVICE_MIGRATION_BACKUP_SPOTLIGHT_PEACE",
              content: {
                logo: {
                  height: "133px",
                  imageURL:
                    "https://icecat-settings-attachments.cdn.mozilla.net/main-workspace/ms-images/4a56d3ed-98c8-4a33-b853-b2cf7646efd8.png",
                  marginBlock: "22px -10px",
                },
                title: {
                  fontSize: "24px",
                  string_id:
                    "device-migration-fxa-spotlight-older-device-header",
                  letterSpacing: 0,
                },
                subtitle: {
                  fontSize: "15px",
                  string_id: "device-migration-fxa-spotlight-older-device-body",
                  lineHeight: "1.4",
                  marginBlock: "8px 20px",
                  letterSpacing: 0,
                  paddingInline: "40px",
                },
                dismiss_button: {
                  action: {
                    navigate: true,
                  },
                },
                primary_button: {
                  label: {
                    string_id:
                      "device-migration-fxa-spotlight-older-device-primary-button",
                    marginBlock: "0 22px",
                    paddingBlock: "4px",
                    paddingInline: "16px",
                  },
                  action: {
                    data: {
                      args: "https://support.mozilla.org/1/icecat/%VERSION%/%OS%/%LOCALE%/switching-devices?utm_source=spotlight-default&utm_medium=icecat-desktop&utm_campaign=migration&utm_content=peace-of-mind&entrypoint=device-migration-spotlight-experiment-v2",
                      where: "tabshifted",
                    },
                    type: "OPEN_URL",
                    navigate: true,
                  },
                },
              },
            },
          ],
          backdrop: "transparent",
          template: "multistage",
          transitions: true,
        },
        trigger: {
          id: "defaultBrowserCheck",
        },
        template: "spotlight",
        frequency: {
          lifetime: 1,
        },
        targeting:
          "source == 'startup' && !willShowDefaultPrompt && 'browser.newtabpage.activity-stream.asrouter.userprefs.cfr.features'|preferenceValue && !usesIceCatSync && !hasActiveEnterprisePolicies && userMonthlyActivity[userMonthlyActivity|length - 2][1]|date >= currentDate|date - (28 * 24 * 60 * 60 * 1000) && !(((currentDate|date - profileAgeCreated|date) / 86400000 >= 168) || totalBookmarksCount >= 35) && os.isWindows && os.windowsVersion >= 6.1 && os.windowsBuildNumber < 22000",
      },
      {
        // Nimbus slug: device-migration-q4-spotlights-remaining-population:treatment (message 3 of 3)
        // Version range: 122+
        // Recipe: https://experimenter.services.mozilla.com/nimbus/device-migration-q4-spotlights-remaining-population/summary#treatment
        id: "Q4_DEVICE_MIGRATION_BACKUP_SPOTLIGHT",
        groups: ["eco"],
        content: {
          id: "Q4_DEVICE_MIGRATION_BACKUP_SPOTLIGHT",
          modal: "tab",
          screens: [
            {
              id: "Q4_DEVICE_MIGRATION_BACKUP_SPOTLIGHT_NEW_DEVICE",
              content: {
                logo: {
                  height: "149px",
                  imageURL:
                    "https://icecat-settings-attachments.cdn.mozilla.net/main-workspace/ms-images/a43cd9cc-e8b2-477c-92f2-345557370de1.svg",
                },
                title: {
                  fontSize: "24px",
                  string_id:
                    "device-migration-fxa-spotlight-getting-new-device-header-2",
                  letterSpacing: 0,
                },
                subtitle: {
                  fontSize: "15px",
                  string_id:
                    "device-migration-fxa-spotlight-getting-new-device-body-2",
                  lineHeight: "1.4",
                  marginBlock: "8px 20px",
                  letterSpacing: 0,
                  paddingInline: "40px",
                },
                dismiss_button: {
                  action: {
                    navigate: true,
                  },
                },
                primary_button: {
                  label: {
                    string_id:
                      "device-migration-fxa-spotlight-getting-new-device-primary-button",
                    paddingBlock: "4px",
                    paddingInline: "16px",
                  },
                  action: {
                    data: {
                      args: "https://support.mozilla.org/1/icecat/%VERSION%/%OS%/%LOCALE%/switching-devices?utm_source=spotlight-default&utm_medium=icecat-desktop&utm_campaign=migration&utm_content=new-device-in-your-future&entrypoint=device-migration-spotlight-experiment-v2",
                      where: "tabshifted",
                    },
                    type: "OPEN_URL",
                    navigate: true,
                  },
                },
              },
            },
          ],
          backdrop: "transparent",
          template: "multistage",
          transitions: true,
        },
        trigger: {
          id: "defaultBrowserCheck",
        },
        template: "spotlight",
        frequency: {
          lifetime: 1,
        },
        targeting:
          "source == 'startup' && !willShowDefaultPrompt && 'browser.newtabpage.activity-stream.asrouter.userprefs.cfr.features'|preferenceValue && !usesIceCatSync && !hasActiveEnterprisePolicies && userMonthlyActivity[userMonthlyActivity|length - 2][1]|date >= currentDate|date - (28 * 24 * 60 * 60 * 1000) && !(((currentDate|date - profileAgeCreated|date) / 86400000 >= 168) || totalBookmarksCount >= 35) && !(os.isWindows && os.windowsVersion >= 6.1 && os.windowsBuildNumber < 22000)",
      },
      {
        // Nimbus slug: fox-doodle-set-to-default-early-day-user-de-fr-it-treatment-a-rollout:treatment-a
        // Version range: 116+
        // Recipe: https://experimenter.services.mozilla.com/nimbus/fox-doodle-set-to-default-early-day-user-de-fr-it-treatment-a-rollout/summary#treatment-a
        id: "fox-doodle-set-to-default-early-day-user-de-fr-it:A",
        groups: ["eco"],
        content: {
          id: "fox-doodle-set-to-default-early-day-user-de-fr-it:A",
          screens: [
            {
              id: "SET_DEFAULT",
              content: {
                logo: {
                  height: "140px",
                  imageURL:
                    "https://icecat-settings-attachments.cdn.mozilla.net/main-workspace/ms-images/05f5265b-d1e4-4fe1-9a46-0ea36f8afced.png",
                  reducedMotionImageURL:
                    "https://icecat-settings-attachments.cdn.mozilla.net/main-workspace/ms-images/05f5265b-d1e4-4fe1-9a46-0ea36f8afced.png",
                },
                title: {
                  raw: {
                    $l10n: {
                      id: "fox-doodle-trackers-title",
                      text: "Keep pesky trackers off your tail",
                      comment:
                        "This title is displayed together with the picture of a running fox with a long tail. In English, this is a figure of speech meaning 'stop something from following you'. If the localization of this message is challenging, consider using a simplified alternative as a reference for translation: 'Keep unwanted trackers away'.",
                    },
                  },
                  fontSize: "22px",
                  fontWeight: 590,
                  paddingBlock: "4px 0",
                  letterSpacing: 0,
                  paddingInline: "24px",
                },
                subtitle: {
                  raw: {
                    $l10n: {
                      id: "fox-doodle-trackers-subtitle",
                      text: "Say goodbye to annoying ad trackers and settle into a safer, speedy internet experience.",
                      comment: "",
                    },
                  },
                  fontSize: "15px",
                  lineHeight: "1.4",
                  marginBlock: "8px 16px",
                  letterSpacing: 0,
                  paddingInline: "24px",
                },
                dismiss_button: {
                  action: {
                    navigate: true,
                  },
                },
                primary_button: {
                  label: {
                    raw: {
                      $l10n: {
                        id: "fox-doodle-set-default-driving-primary-button-label",
                        text: "Open my links with IceCat",
                        comment: "",
                      },
                    },
                    marginBlock: "4px 0",
                    paddingBlock: "0",
                    paddingInline: "16px",
                  },
                  action: {
                    type: "SET_DEFAULT_BROWSER",
                    navigate: true,
                  },
                },
                secondary_button: {
                  label: {
                    raw: {
                      $l10n: {
                        id: "fox-doodle-driving-secondary-button-label",
                        text: "Not now",
                        comment: "",
                      },
                    },
                    marginBlock: "0 -20px",
                  },
                  action: {
                    navigate: true,
                  },
                },
              },
            },
          ],
          backdrop: "transparent",
          template: "multistage",
          transitions: true,
        },
        trigger: {
          id: "defaultBrowserCheck",
        },
        priority: 1,
        template: "spotlight",
        frequency: {
          lifetime: 1,
        },
        targeting:
          "source == 'startup' && !willShowDefaultPrompt && !isMajorUpgrade && !activeNotifications && (((currentDate|date) - (profileAgeCreated|date)) / 3600000 >= 6) && !isDefaultBrowser",
      },
      {
        // Nimbus slug: fox-doodle-set-to-default-early-day-user-en-treatment-a-rollout:treatment-a
        // Version range: 116+
        // Recipe: https://experimenter.services.mozilla.com/nimbus/fox-doodle-set-to-default-early-day-user-en-treatment-a-rollout/summary#treatment-a
        id: "fox-doodle-set-to-default-early-day-user:A",
        groups: ["eco"],
        content: {
          id: "fox-doodle-set-to-default-early-day-user:A",
          screens: [
            {
              id: "SET_DEFAULT",
              content: {
                logo: {
                  height: "140px",
                  imageURL:
                    "https://icecat-settings-attachments.cdn.mozilla.net/main-workspace/ms-images/05f5265b-d1e4-4fe1-9a46-0ea36f8afced.png",
                  reducedMotionImageURL:
                    "https://icecat-settings-attachments.cdn.mozilla.net/main-workspace/ms-images/05f5265b-d1e4-4fe1-9a46-0ea36f8afced.png",
                },
                title: {
                  raw: "Keep pesky trackers off your tail",
                  fontSize: "22px",
                  fontWeight: 590,
                  paddingBlock: "4px 0",
                  letterSpacing: 0,
                  paddingInline: "24px",
                },
                subtitle: {
                  raw: "Say goodbye to annoying ad trackers and settle into a safer, speedy internet experience.",
                  fontSize: "15px",
                  lineHeight: "1.4",
                  marginBlock: "8px 16px",
                  letterSpacing: 0,
                  paddingInline: "24px",
                },
                dismiss_button: {
                  action: {
                    navigate: true,
                  },
                },
                primary_button: {
                  label: {
                    raw: "Open my links with IceCat",
                    marginBlock: "4px 0",
                    paddingBlock: "0",
                    paddingInline: "16px",
                  },
                  action: {
                    type: "SET_DEFAULT_BROWSER",
                    navigate: true,
                  },
                },
                secondary_button: {
                  label: {
                    raw: "Not now",
                    marginBlock: "0 -20px",
                  },
                  action: {
                    navigate: true,
                  },
                },
              },
            },
          ],
          backdrop: "transparent",
          template: "multistage",
          transitions: true,
        },
        trigger: {
          id: "defaultBrowserCheck",
        },
        priority: 1,
        template: "spotlight",
        frequency: {
          lifetime: 1,
        },
        targeting:
          "source == 'startup' && !willShowDefaultPrompt && !isMajorUpgrade && !activeNotifications && (((currentDate|date) - (profileAgeCreated|date)) / 3600000 >= 6) && !isDefaultBrowser",
      },
    ];
  },
};
