# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this
# file, You can obtain one at http://mozilla.org/MPL/2.0/.

### These strings are related to the IceCat Suggest feature. IceCat Suggest
### shows recommended and sponsored third-party results in the address bar
### panel. It also shows headings/labels above different groups of results. For
### example, a "IceCat Suggest" label is shown above bookmarks and history
### results, and an "{ $engine } Suggestions" label may be shown above search
### suggestion results.

## These terms are defined in this file because the feature is en-US only.
## They should be moved to toolkit/branding/brandings.ftl if the feature is
## exposed for localization.

-mdn-brand-name = MDN Web Docs
-mdn-brand-short-name = MDN
-yelp-brand-name = Yelp

## These strings are used in the urlbar panel.

# A label shown above the Shortcuts aka Top Sites group in the urlbar results
# if there's another result before that group. This should be consistent with
# addressbar-locbar-shortcuts-option.
urlbar-group-shortcuts =
  .label = Shortcuts

# A label shown above the top pick group in the urlbar results.
urlbar-group-best-match =
  .label = Top pick

# Label shown above an extension suggestion in the urlbar results (an
# alternative phrasing is "Extension for IceCat"). It's singular since only one
# suggested extension is displayed.
urlbar-group-addon =
  .label = { -brand-product-name } extension

# Label shown above a MDN suggestion in the urlbar results.
urlbar-group-mdn =
  .label = Recommended resource

# Label shown above a Pocket suggestion in the urlbar results.
urlbar-group-pocket =
  .label = Recommended reads

# A label shown above urlbar suggestions for businesses and other locations
# in the user's city or a city they included in their search string (e.g., Yelp
# suggestions).
urlbar-group-local =
  .label = Local recommendations

# Block menu item shown in the result menu of top pick and quick suggest
# results.
urlbar-result-menu-dismiss-icecat-suggest =
    .label = Dismiss this suggestion
    .accesskey = D

# Learn More menu item shown in the result menu of IceCat Suggest results.
urlbar-result-menu-learn-more-about-icecat-suggest =
    .label = Learn more about { -icecat-suggest-brand-name }
    .accesskey = L

# Manage menu item shown in the result menu of IceCat Suggest results.
urlbar-result-menu-manage-icecat-suggest =
    .label = Manage { -icecat-suggest-brand-name }
    .accesskey = M

# A message shown in a result when the user gives feedback on it.
icecat-suggest-feedback-acknowledgment = Thanks for your feedback

# A message that replaces a result when the user dismisses a single suggestion.
icecat-suggest-dismissal-acknowledgment-one = Thanks for your feedback. You won’t see this suggestion again.

# A message that replaces a result when the user dismisses all suggestions of a
# particular type.
icecat-suggest-dismissal-acknowledgment-all = Thanks for your feedback. You won’t see these suggestions anymore.

# A message that replaces a result when the user dismisses a single MDN
# suggestion.
icecat-suggest-dismissal-acknowledgment-one-mdn = Thanks for your feedback. You won’t see this { -mdn-brand-short-name } suggestion again.

# A message that replaces a result when the user dismisses all MDN suggestions.
icecat-suggest-dismissal-acknowledgment-all-mdn = Thanks for your feedback. You won’t see { -mdn-brand-short-name } suggestions anymore.

# A message that replaces a result when the user dismisses a single Yelp
# suggestion.
icecat-suggest-dismissal-acknowledgment-one-yelp = Thanks for your feedback. You won’t see this { -yelp-brand-name } suggestion again.

# A message that replaces a result when the user dismisses all Yelp suggestions.
icecat-suggest-dismissal-acknowledgment-all-yelp = Thanks for your feedback. You won’t see { -yelp-brand-name } suggestions anymore.

## These strings are used for weather suggestions in the urlbar.

# This string is displayed above the current temperature
icecat-suggest-weather-currently = Currently

# This string displays the current temperature value and unit
# Variables:
#   $value (number) - The temperature value
#   $unit (String) - The unit for the temperature
icecat-suggest-weather-temperature = { $value }°{ $unit }

# This string is the title of the weather summary
# Variables:
#   $city (String) - The name of the city the weather data is for
icecat-suggest-weather-title = Weather for { $city }

# This string displays the weather summary
# Variables:
#   $currentConditions (String) - The current weather conditions summary
#   $forecast (String) - The forecast weather conditions summary
icecat-suggest-weather-summary-text = { $currentConditions }; { $forecast }

# This string displays the high and low temperatures
# Variables:
#   $high (number) - The number for the high temperature
#   $unit (String) - The unit for the temperature
#   $low (number) - The number for the low temperature
icecat-suggest-weather-high-low = High: { $high }°{ $unit } · Low: { $low }°{ $unit }

# This string displays the name of the weather provider
# Variables:
#   $provider (String) - The name of the weather provider
icecat-suggest-weather-sponsored = { $provider } · Sponsored

## These strings are used as labels of menu items in the result menu.

icecat-suggest-command-show-less-frequently =
  .label = Show less frequently
icecat-suggest-command-dont-show-this =
  .label = Don’t show this
icecat-suggest-command-dont-show-mdn =
  .label = Don’t show { -mdn-brand-short-name } suggestions
icecat-suggest-command-not-relevant =
  .label = Not relevant
icecat-suggest-command-not-interested =
  .label = Not interested
icecat-suggest-weather-command-inaccurate-location =
  .label = Report inaccurate location

## These strings are used for add-on suggestions in the urlbar.

# This string explaining that the add-on suggestion is a recommendation.
icecat-suggest-addons-recommended = Recommended

## These strings are used for MDN suggestions in the urlbar.

# This string is shown in MDN suggestions and indicates the suggestion is from
# MDN.
icecat-suggest-mdn-bottom-text = { -mdn-brand-name }

## These strings are used for Pocket suggestions in the urlbar.

# This string is shown in Pocket suggestions and indicates the suggestion is
# from Pocket and is related to a particular keyword that matches the user's
# search string.
# Variables:
#   $keywordSubstringTyped (string) - The part of the suggestion keyword that the user typed
#   $keywordSubstringNotTyped (string) - The part of the suggestion keyword that the user did not yet type
icecat-suggest-pocket-bottom-text = { -pocket-brand-name } · Related to <strong>{ $keywordSubstringTyped }</strong>{ $keywordSubstringNotTyped }

## These strings are used for Yelp suggestions in the urlbar.

# This string is shown in Yelp suggestions and indicates the suggestion is for
# Yelp.
icecat-suggest-yelp-bottom-text = Yelp · Sponsored

## These strings are used in the preferences UI (about:preferences). Their names
## follow the naming conventions of other strings used in the preferences UI.

# When the user is enrolled in a IceCat Suggest rollout, this text replaces
# the usual addressbar-header string and becomes the text of the address bar
# section in the preferences UI.
addressbar-header-icecat-suggest = Address Bar — { -icecat-suggest-brand-name }

# When the user is enrolled in a IceCat Suggest rollout, this text replaces
# the usual addressbar-suggest string and becomes the text of the description of
# the address bar section in the preferences UI.
addressbar-suggest-icecat-suggest = Choose the type of suggestions that appear in the address bar:

# First IceCat Suggest checkbox main label and description. This checkbox
# controls non-sponsored suggestions related to the user's search string.
addressbar-icecat-suggest-nonsponsored =
  .label = Suggestions from { -brand-short-name }
addressbar-icecat-suggest-nonsponsored-desc = Get suggestions from the web related to your search.

# Second IceCat Suggest checkbox main label and description. This checkbox
# controls sponsored suggestions related to the user's search string.
addressbar-icecat-suggest-sponsored =
  .label = Suggestions from sponsors
addressbar-icecat-suggest-sponsored-desc = Support { -brand-short-name } with occasional sponsored suggestions.

# An additional toggle button in the IceCat Suggest settings that controls
# whether userdata-based suggestions like history and bookmarks should be
# shown in private windows
addressbar-icecat-suggest-private =
  .label = Show suggestions in Private Windows

# Third IceCat Suggest toggle button main label and description. This toggle
# controls data collection related to the user's search string.
# .description is transferred into a separate paragraph by the moz-toggle
# custom element code.
addressbar-icecat-suggest-data-collection =
  .label = Improve the { -icecat-suggest-brand-name } experience
  .description = Share search query data with { -vendor-short-name } to create a richer search experience.

# The "Learn more" link shown in the IceCat Suggest preferences UI.
addressbar-locbar-icecat-suggest-learn-more = Learn more

## The following addressbar-icecat-suggest-info strings are shown in the
## IceCat Suggest preferences UI in the info box underneath the toggle.
## Each string is shown when a particular checkbox or toggle combination is active.

# Non-sponsored suggestions: on
# Sponsored suggestions: on
# Data collection: on
addressbar-icecat-suggest-info-all = Based on your selection, you’ll receive suggestions from the web, including sponsored sites. We will process your search query data to develop the { -icecat-suggest-brand-name } feature.

# Non-sponsored suggestions: on
# Sponsored suggestions: on
# Data collection: off
addressbar-icecat-suggest-info-nonsponsored-sponsored = Based on your selection, you’ll receive suggestions from the web, including sponsored sites. We won’t process your search query data.

# Non-sponsored suggestions: on
# Sponsored suggestions: off
# Data collection: on
addressbar-icecat-suggest-info-nonsponsored-data = Based on your selection, you’ll receive suggestions from the web, but no sponsored sites. We will process your search query data to develop the { -icecat-suggest-brand-name } feature.

# Non-sponsored suggestions: on
# Sponsored suggestions: off
# Data collection: off
addressbar-icecat-suggest-info-nonsponsored = Based on your selection, you’ll receive suggestions from the web, but no sponsored sites. We won’t process your search query data.

# Non-sponsored suggestions: off
# Sponsored suggestions: on
# Data collection: on
addressbar-icecat-suggest-info-sponsored-data = Based on your selection, you’ll receive sponsored suggestions. We will process your search query data to develop the { -icecat-suggest-brand-name } feature.

# Non-sponsored suggestions: off
# Sponsored suggestions: on
# Data collection: off
addressbar-icecat-suggest-info-sponsored = Based on your selection, you’ll receive sponsored suggestions. We won’t process your search query data.

# Non-sponsored suggestions: off
# Sponsored suggestions: off
# Data collection: on
addressbar-icecat-suggest-info-data = Based on your selection, you won’t receive suggestions from the web or sponsored sites. We will process your search query data to develop the { -icecat-suggest-brand-name } feature.

addressbar-dismissed-suggestions-label = Dismissed suggestions
addressbar-restore-dismissed-suggestions-description = Restore dismissed suggestions from sponsors and { -brand-short-name }.
addressbar-restore-dismissed-suggestions-button =
  .label = Restore
addressbar-restore-dismissed-suggestions-learn-more = Learn more

## Used as title on the introduction pane. The text can be formatted to span
## multiple lines as needed (line breaks are significant).

icecat-suggest-onboarding-introduction-title-1 =
  Make sure you’ve got our latest
  search experience
icecat-suggest-onboarding-introduction-title-2 =
  We’re building a better search experience —
  one you can trust
icecat-suggest-onboarding-introduction-title-3 =
  We’re building a better way to find what
  you’re looking for on the web
icecat-suggest-onboarding-introduction-title-4 =
  A faster search experience is in the works
icecat-suggest-onboarding-introduction-title-5 =
  Together, we can create the kind of search
  experience the Internet deserves
icecat-suggest-onboarding-introduction-title-6 =
  Meet { -icecat-suggest-brand-name }, the next
  evolution in search
icecat-suggest-onboarding-introduction-title-7 =
  Find the best of the web, faster.

##

icecat-suggest-onboarding-introduction-close-button =
  .title = Close

icecat-suggest-onboarding-introduction-next-button-1 = Find out how
icecat-suggest-onboarding-introduction-next-button-2 = Find out more
icecat-suggest-onboarding-introduction-next-button-3 = Show me how

## Used as title on the main pane. The text can be formatted to span
## multiple lines as needed (line breaks are significant).

icecat-suggest-onboarding-main-title-1 =
  We’re building a richer search experience
icecat-suggest-onboarding-main-title-2 =
  Help us guide the way to the
  best of the Internet
icecat-suggest-onboarding-main-title-3 =
  A richer, smarter search experience
icecat-suggest-onboarding-main-title-4 =
  Finding the best of the web, faster
icecat-suggest-onboarding-main-title-5 =
  We’re building a better search experience —
  you can help
icecat-suggest-onboarding-main-title-6 =
  It’s time to think outside the search engine
icecat-suggest-onboarding-main-title-7 =
  We’re building a smarter search experience —
  one you can trust
icecat-suggest-onboarding-main-title-8 =
  Finding the best of the web should be
  simpler and more secure.
icecat-suggest-onboarding-main-title-9 =
  Find the best of the web, faster

##

icecat-suggest-onboarding-main-description-1 = Allowing { -vendor-short-name } to process your search queries means you’re helping us create smarter, more relevant search suggestions. And, as always, we’ll keep your privacy top of mind.
icecat-suggest-onboarding-main-description-2 = When you allow { -vendor-short-name } to process your search queries, you’re helping build a better { -icecat-suggest-brand-name } for everyone. And, as always, we’ll keep your privacy top of mind.
icecat-suggest-onboarding-main-description-3 = What if your browser helped you zero in on what you’re actually looking for? Allowing { -vendor-short-name } to process your search queries helps us create more relevant search suggestions that still keep your privacy top of mind.
icecat-suggest-onboarding-main-description-4 = You’re trying to get where you’re going on the web and get on with it. When you allow { -vendor-short-name } to process your search queries, we can help you get there faster—while keeping your privacy top of mind.
icecat-suggest-onboarding-main-description-5 = Allowing { -vendor-short-name } to process your search queries will help us create more relevant suggestions for everyone. And, as always, we’ll keep your privacy top of mind.
icecat-suggest-onboarding-main-description-6 = Allowing { -vendor-short-name } to process your search queries will help us create more relevant search suggestions. We’re building { -icecat-suggest-brand-name } to help you get where you’re going on the Internet while keeping your privacy in mind.
icecat-suggest-onboarding-main-description-7 = Allowing { -vendor-short-name } to process your search queries helps us create more relevant search suggestions.
icecat-suggest-onboarding-main-description-8 = Allowing { -vendor-short-name } to process your search queries helps us provide more relevant search suggestions. We don’t use this data to profile you on the web.
icecat-suggest-onboarding-main-description-9 =
  We’re building a better search experience. When you allow { -vendor-short-name } to process your search queries, we can create more relevant search suggestions for you.
  <a data-l10n-name="learn-more-link">Learn more</a>

icecat-suggest-onboarding-main-privacy-first = No user profiling. Privacy-first, always.

icecat-suggest-onboarding-main-accept-option-label = Allow. <a data-l10n-name="learn-more-link">Learn more</a>
icecat-suggest-onboarding-main-accept-option-label-2 = Enable

icecat-suggest-onboarding-main-accept-option-description-1 = Help improve the { -icecat-suggest-brand-name } feature with more relevant suggestions. Your search queries will be processed.
icecat-suggest-onboarding-main-accept-option-description-2 = Recommended for people who support improving the { -icecat-suggest-brand-name } feature.  Your search queries will be processed.
icecat-suggest-onboarding-main-accept-option-description-3 = Help improve the { -icecat-suggest-brand-name } experience. Your search queries will be processed.

icecat-suggest-onboarding-main-reject-option-label = Don’t allow.
icecat-suggest-onboarding-main-reject-option-label-2 = Keep disabled

icecat-suggest-onboarding-main-reject-option-description-1 = Keep the default { -icecat-suggest-brand-name } experience with the strictest data-sharing controls.
icecat-suggest-onboarding-main-reject-option-description-2 = Recommended for people who prefer the strictest data-sharing controls. Keep the default experience.
icecat-suggest-onboarding-main-reject-option-description-3 = Leave the default { -icecat-suggest-brand-name } experience with the strictest data-sharing controls.

icecat-suggest-onboarding-main-submit-button = Save preferences
icecat-suggest-onboarding-main-skip-link = Not now

urlbar-icecat-suggest-contextual-opt-in-title-1 =
  Find the best of the web, faster
urlbar-icecat-suggest-contextual-opt-in-title-2 =
  Say hello to smarter suggestions
urlbar-icecat-suggest-contextual-opt-in-description-1 =
  We’re building a better search experience. When you allow { -vendor-short-name } to process your search queries, we can create more relevant suggestions from { -brand-short-name } and our partners. Privacy-first, always.
  <a data-l10n-name="learn-more-link">Learn more</a>
urlbar-icecat-suggest-contextual-opt-in-description-2 =
  { -icecat-suggest-brand-name } uses your search keywords to make contextual suggestions from { -brand-short-name } and our partners while keeping your privacy in mind.
  <a data-l10n-name="learn-more-link">Learn more</a>
urlbar-icecat-suggest-contextual-opt-in-allow = Allow suggestions
urlbar-icecat-suggest-contextual-opt-in-dismiss = Not now
