/* Any copyright is dedicated to the Public Domain.
 * http://creativecommons.org/publicdomain/zero/1.0/ */

"use strict";

add_task(async function test_icecat_suggest_with_policy() {
  await setupPolicyEngineWithJson({
    policies: {
      IceCatSuggest: {
        WebSuggestions: false,
        SponsoredSuggestions: true,
        ImproveSuggest: true,
        Locked: true,
      },
    },
  });

  await BrowserTestUtils.withNewTab(
    "about:preferences#search",
    async browser => {
      is(
        browser.contentDocument.getElementById("icecatSuggestNonsponsored")
          .checked,
        false,
        "Web suggestions is disabled"
      );
      is(
        browser.contentDocument.getElementById("icecatSuggestSponsored")
          .checked,
        true,
        "Sponsored suggestions is enabled"
      );
      is(
        browser.contentDocument.getElementById(
          "icecatSuggestDataCollectionSearchToggle"
        ).pressed,
        true,
        "Improve suggest is enabled"
      );
      is(
        browser.contentDocument.getElementById("icecatSuggestNonsponsored")
          .disabled,
        true,
        "Web suggestions is disabled"
      );
      is(
        browser.contentDocument.getElementById("icecatSuggestSponsored")
          .disabled,
        true,
        "Sponsored suggestions is enabled"
      );
      is(
        browser.contentDocument.getElementById(
          "icecatSuggestDataCollectionSearchToggle"
        ).disabled,
        true,
        "Improve suggest is enabled"
      );
    }
  );
});
