/*
 *  SPDX-FileCopyrightText: 2021 Felipe Kinoshita <kinofhek@gmail.com>
 *  SPDX-FileCopyrightText: 2022 Nate Graham <nate@kde.org>
 *
 *  SPDX-License-Identifier: GPL-2.0-only OR GPL-3.0-only OR LicenseRef-KDE-Accepted-GPL
 */

import QtQuick 2.15
import QtQuick.Controls 2.15 as QQC2
import QtQuick.Layouts 1.15
import org.kde.kirigami 2.15 as Kirigami
import QtGraphicalEffects 1.15

import org.kde.welcome 1.0
import org.kde.plasma.welcome 1.0

GenericPage {
    heading: i18nc("@info:window", "Welcome to Triskel | Friendly Computing")
    description: i18nc("@info:usagetip",
    '<p>You are using the Triskel® Linux distribution, an official Ubuntu® flavor.
      It is used by millions around the world who value:</p>

    <ul>
      <li>The beautiful and intuitive KDE Plasma desktop and KDE apps</li>
      <li>The breadth and compatibility of the full Ubuntu
      archive</li>
      <li>Frequent security updates</li>
      <li>Current, reliable core apps for productivity, office, email,
      graphics, and music</li>
      <li>The availability of Triskel-optimized hardware and commercial support</li>
    </ul>

    <p>Triskel is free software developed by members of the global Ubuntu®
    community. Please donate today to support its continued development. All
    proceeds fund the Triskel Developer Team!</p>
    ');

    RowLayout {
        Layout.fillWidth: true;
        anchors {
          left: parent.left
          right: parent.right
        }
        Image {
            id: features 
            source: "/usr/share/triskel-default-settings/triskel_tour.svg"
            mipmap : true
            Layout.topMargin       : 0 - Kirigami.Units.gridUnit 
            Layout.leftMargin      : Kirigami.Units.gridUnit * 3
            Layout.alignment       : Qt.AlignLeft + Qt.AlignVCenter
            Layout.preferredHeight : Kirigami.Units.gridUnit * 5
            Layout.preferredWidth  :
                ( this.implicitWidth / this.implicitHeight )
                * (Kirigami.Units.gridUnit * 5)

            HoverHandler {
                id: hoverhandler
                cursorShape: Qt.PointingHandCursor
            }
            TapHandler {
                onTapped: Qt.openUrlExternally("https://trisquel.info/feature-tour/")
            }
            QQC2.ToolTip {
                visible: hoverhandler.hovered
                text: i18nc("@action:button", "See what makes Triskel special.")
            }

            layer.enabled: true
            layer.effect: DropShadow {
                transparentBorder: true
                horizontalOffset: 0
                verticalOffset: 0
                radius: 15
                samples: 20
                color: Qt.rgba(0, 0, 0, 0.2)
            }
        }
        Image {
            id: donate
            source: "/usr/share/triskel-default-settings/triskel_donate.svg"
            mipmap : true
            Layout.topMargin       : 0 - Kirigami.Units.gridUnit 
            Layout.rightMargin     : Kirigami.Units.gridUnit * 3
            Layout.alignment       : Qt.AlignRight - Qt.AlignVCenter
            Layout.preferredHeight : Kirigami.Units.gridUnit * 5
            Layout.preferredWidth  :
                ( this.implicitWidth / this.implicitHeight )
                * (Kirigami.Units.gridUnit * 5)

            HoverHandler {
                id: donate_hoverhandler
                cursorShape: Qt.PointingHandCursor
            }
            TapHandler {
                onTapped: Qt.openUrlExternally("https://trisquel.info/donate/")
            }
            QQC2.ToolTip {
                visible: donate_hoverhandler.hovered
                text: i18nc("@action:button",
                    "Help keep Triskel wonderful and free.")
            }

            layer.enabled: true
            layer.effect: DropShadow {
                transparentBorder: true
                horizontalOffset: 0
                verticalOffset: 0
                radius: 15
                samples: 20
                color: Qt.rgba(0, 0, 0, 0.2)
            }
        }
    }
}
