#!/usr/bin/env python
# Copyright 2016 The Chromium Authors
# Use of this source code is governed by a BSD-style license that can be
# found in the LICENSE file.

from os import path as os_path


NODE_MODULES = os_path.join(os_path.dirname(__file__), 'node_modules')


def _path_in_node_modules(*args):
  return os_path.join(NODE_MODULES, *args)


def PathToEsLint():
  return _path_in_node_modules('eslint', 'bin', 'eslint')


def PathToRollup():
  return _path_in_node_modules('@rollup', 'wasm-node', 'dist', 'bin', 'rollup')


def PathToSvgo():
  return _path_in_node_modules('svgo', 'bin', 'svgo')


def PathToTerser():
  return _path_in_node_modules('terser', 'bin', 'terser')


def PathToTypescript():
  return _path_in_node_modules('typescript', 'bin', 'tsc')

def PathToTsProto():
  return _path_in_node_modules('ts-proto', 'protoc-gen-ts_proto')
